export const SureRankFullLogo = ( props ) => (
	<svg
		width="538"
		height="84"
		viewBox="0 0 538 84"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M74.7021 31.1187C74.7021 13.9953 60.8924 0.118378 43.8521 0.118378H0.670166V83.7997H7.9266C20.5234 83.7997 30.9189 74.347 32.4782 62.1087H32.4986L32.5496 49.1228H31.459C22.735 49.1228 15.6417 42.1383 15.3971 33.4332H15.3869V29.2957H19.5145C25.2829 29.2957 30.3889 32.1633 33.5076 36.5465C36.4835 25.9468 46.1859 18.1737 57.6821 18.1737V22.3112V27.8722C57.6821 39.5575 48.9275 49.0409 37.3192 49.1126V62.1087C38.8276 74.3777 49.2434 83.8816 61.8708 83.8816H74.7225V59.0056H57.3356C67.6291 53.9772 74.7225 43.3774 74.7225 31.1084L74.7021 31.1187Z"
			fill="#4338CA"
		/>
		<path
			d="M219.188 21.9015V12.4591H210.261V71.5512H219.188V29.7259C220.513 27.2987 222.786 25.1275 226.017 23.2124C229.248 21.2563 232.234 20.2834 234.996 20.2834C235.892 20.2834 237.034 20.3654 238.44 20.519V11.0765C234.71 11.0765 231.194 12.0699 227.882 14.067C224.58 16.0231 221.685 18.6243 219.188 21.8913V21.9015Z"
			fill="#1B1933"
		/>
		<path
			d="M284.874 15.2037C280.634 12.3772 275.681 10.9639 270.004 10.9639C264.327 10.9639 259.721 12.3567 255.369 15.1423C251.017 17.887 247.613 21.6353 245.167 26.377C242.752 31.0777 241.549 36.2598 241.549 41.913C241.549 51.1096 244.311 58.6062 249.835 64.3823C255.359 70.1583 262.432 73.0464 271.064 73.0464C280.237 73.0464 287.88 69.974 293.985 63.8497L289.725 57.8791C287.391 60.3063 284.65 62.1804 281.5 63.4913C278.392 64.8022 275.141 65.4678 271.757 65.4678C265.764 65.4678 260.903 63.5118 257.173 59.6098C253.484 55.7079 251.455 50.8433 251.109 45.0365H297.715V42.7015C297.715 36.7309 296.625 31.3645 294.454 26.633C292.314 21.8503 289.124 18.0508 284.884 15.2242L284.874 15.2037ZM250.976 38.1544C251.089 35.8399 251.578 33.5766 252.434 31.344C253.29 29.0704 254.452 26.9812 255.93 25.0661C257.448 23.11 259.415 21.5431 261.82 20.3449C264.226 19.1466 266.916 18.5526 269.872 18.5526C273.021 18.5526 275.844 19.1671 278.331 20.4063C280.817 21.6045 282.805 23.1714 284.283 25.1275C285.76 27.0836 286.871 29.1728 287.605 31.4054C288.38 33.638 288.798 35.8911 288.828 38.1544H250.976Z"
			fill="#1B1933"
		/>
		<path
			d="M132.336 41.913C130.277 40.6738 127.963 39.6394 125.395 38.8098C122.868 37.9701 120.32 37.2737 117.751 36.7206C115.224 36.1266 112.91 35.5019 110.811 34.867C108.752 34.191 107.06 33.2693 105.735 32.1223C104.41 30.9241 103.748 29.4698 103.748 27.7595C103.748 25.0866 104.91 22.8847 107.244 21.1232C109.578 19.331 112.666 18.4297 116.518 18.4297C120.371 18.4297 123.499 19.1262 126.496 20.519C129.523 21.8708 131.938 23.663 133.732 25.8956L137.87 19.5665C132.427 13.8314 125.313 10.9639 116.518 10.9639C109.863 10.9639 104.635 12.5922 100.823 15.8592C97.0114 19.0852 95.1055 23.1305 95.1055 27.9848C95.1055 30.9343 95.768 33.4844 97.0929 35.6351C98.4178 37.7448 100.13 39.3834 102.229 40.5304C104.329 41.6876 106.642 42.6606 109.17 43.4594C111.738 44.2582 114.286 44.9546 116.814 45.5486C119.341 46.1426 121.655 46.8083 123.754 47.5149C125.854 48.2318 127.566 49.2457 128.891 50.5668C130.216 51.8777 130.878 53.4958 130.878 55.4109C130.878 58.4423 129.655 60.89 127.199 62.7641C124.794 64.6383 121.43 65.5703 117.109 65.5703C113.338 65.5703 109.741 64.7509 106.316 63.1226C102.892 61.4942 100.15 59.4767 98.0917 57.0905L93.5972 63.7268C99.4268 69.9433 107.183 73.0464 116.865 73.0464C124.019 73.0464 129.563 71.377 133.487 68.0282C137.452 64.6383 139.439 60.3575 139.439 55.1856C139.439 52.0825 138.777 49.3891 137.452 47.1155C136.127 44.8419 134.415 43.1112 132.315 41.913H132.336Z"
			fill="#1B1933"
		/>
		<path
			d="M188.155 55.8923C186.402 58.4014 183.976 60.5111 180.868 62.2214C177.76 63.9317 174.529 64.7919 171.186 64.7919C166.946 64.7919 163.716 63.7985 161.504 61.8015C159.292 59.7737 158.182 56.2815 158.182 51.3452V12.4591H149.254V54.1615C149.254 66.748 155.379 73.0464 167.629 73.0464C171.675 73.0464 175.507 72.1144 179.125 70.2403C182.743 68.3661 185.76 66.0414 188.165 63.2455V71.5512H197.144V12.4591H188.165V55.8923H188.155Z"
			fill="#1B1933"
		/>
		<path
			d="M340.917 48.6312C344.332 46.9209 347.002 44.5552 348.948 41.534C350.946 38.4617 351.955 34.9694 351.955 31.0675C351.955 27.1656 351.017 23.6426 349.132 20.6931C347.246 17.6821 344.627 15.3164 341.274 13.5959C337.921 11.8856 334.069 11.0253 329.717 11.0253H306.775V73.1078H318.863V51.1096H328.127L340.744 73.1078H354.421L340.122 48.9897C340.387 48.877 340.652 48.7644 340.917 48.6312ZM338.094 35.6863C337.269 37.0484 336.127 38.1135 334.649 38.8815C333.233 39.6496 331.623 40.0388 329.798 40.0388H318.852V22.1269H329.177C332.183 22.1269 334.619 22.9564 336.504 24.6052C338.451 26.2643 339.419 28.415 339.419 31.0777C339.419 32.788 338.981 34.3344 338.094 35.6863Z"
			fill="#1B1933"
		/>
		<path
			d="M394.607 11.0356H382.52L358.162 73.1181H370.962L376.17 59.4562H401.772L406.98 73.1181H419.78L395.422 11.0356H394.627H394.607ZM380.247 48.7234L388.961 25.8547L397.675 48.7234H380.247Z"
			fill="#1B1933"
		/>
		<path
			d="M467.701 52.7175L437.524 11.0356H424.906V73.1078H436.994V30.6271L467.701 73.1078H479.707V11.0356H467.701V52.7175Z"
			fill="#1B1933"
		/>
		<path
			d="M510.302 39.0352L536.362 11.0356H520.738L497.878 35.6146V11.0356H485.964V73.1078H497.878V52.3898L502.434 47.4944L522.409 73.1078H537.33L510.302 39.0352Z"
			fill="#1B1933"
		/>
	</svg>
);

export const SureRankLogo = ( props ) => (
	<svg
		width="128"
		height="128"
		viewBox="0 0 128 128"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<rect width="128" height="128" fill="white" />
		<path
			d="M73.4731 0C99.6321 6.3594e-05 120.838 21.2062 120.838 47.3652C120.838 66.1146 109.944 82.3181 94.1401 89.9941H120.838V128H101.114C81.7276 128 65.7331 113.485 63.4018 94.7305H63.4008L63.4125 74.8838C81.2408 74.7673 94.685 60.2785 94.685 42.4229V33.9307H94.6879V27.6074C77.0272 27.6075 62.1389 39.4779 57.5649 55.6748C52.7868 48.9672 44.9453 44.5928 36.0825 44.5928H29.7495V50.915H29.7719C30.1453 64.2164 41.0453 74.8848 54.437 74.8848H56.1166L56.0356 94.7305H56.0073C53.6177 113.422 37.6508 127.868 18.31 127.868H7.16156V0H73.4731Z"
			fill="#4338CA"
		/>
	</svg>
);

export const SureRankMonoLogo = ( props ) => (
	<svg
		width="128"
		height="128"
		viewBox="0 0 128 128"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M73.4731 0C99.6321 6.3594e-05 120.838 21.2062 120.838 47.3652C120.838 66.1146 109.944 82.3181 94.1401 89.9941H120.838V128H101.114C81.7276 128 65.7331 113.485 63.4018 94.7305H63.4008L63.4125 74.8838C81.2408 74.7673 94.685 60.2785 94.685 42.4229V33.9307H94.6879V27.6074C77.0272 27.6075 62.1389 39.4779 57.5649 55.6748C52.7868 48.9672 44.9453 44.5928 36.0825 44.5928H29.7495V50.915H29.7719C30.1453 64.2164 41.0453 74.8848 54.437 74.8848H56.1166L56.0356 94.7305H56.0073C53.6177 113.422 37.6508 127.868 18.31 127.868H7.16156V0H73.4731Z"
			fill="currentColor"
		/>
	</svg>
);

export const SureRankMonoSmallLogo = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M13.5537 1.5C17.8453 1.5 21.3251 4.97895 21.3252 9.27051C21.3252 12.347 19.5368 15.0056 16.9434 16.2646H21.3252V22.5H18.0889C14.9086 22.5 12.2861 20.1186 11.9033 17.042H11.9014L11.9033 13.7852C14.8283 13.7661 17.0342 11.3894 17.0342 8.45996V6.0293C14.137 6.02947 11.6948 7.97682 10.9443 10.6338C10.1605 9.53345 8.87383 8.8165 7.41992 8.81641H6.38086V9.85352H6.38379C6.44515 12.0356 8.23375 13.786 10.4307 13.7861H10.7061L10.6934 17.042H10.6865C10.2943 20.1082 7.67678 22.4785 4.50391 22.4785H2.6748V1.5H13.5537Z"
			fill="currentColor"
		/>
	</svg>
);

export const SureMailIcon = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M23.25 0H0.75C0.335787 0 0 0.335787 0 0.75V23.25C0 23.6642 0.335787 24 0.75 24H23.25C23.6642 24 24 23.6642 24 23.25V0.75C24 0.335787 23.6642 0 23.25 0Z"
			fill="#0D7EE8"
		/>
		<path
			d="M6.40292 11.6635C6.61165 11.8145 6.90801 11.7649 7.04455 11.5618C7.19552 11.3531 7.14591 11.0567 6.94285 10.9202L4.93281 9.48016C4.86137 9.42507 4.8676 9.35611 4.87071 9.32164C4.87386 9.28718 4.90015 9.22703 4.98662 9.19317L18.3609 5.78333C18.4386 5.76953 18.4844 5.80148 18.5157 5.83906C18.547 5.87667 18.5784 5.91424 18.5433 5.99446L13.476 18.8162C13.4409 18.8964 13.3776 18.9045 13.3488 18.9158C13.3143 18.9127 13.2454 18.9065 13.2028 18.8401L11.6711 16.0326C11.6228 15.9518 11.5833 15.8509 11.535 15.7701C10.9355 14.4093 10.7842 13.4051 11.9093 12.416L14.806 9.73531C15.0027 9.55853 15.0221 9.26839 14.8509 9.08611C14.6742 8.88942 14.384 8.87007 14.2017 9.04118L11.1593 11.6635C9.62635 13.0119 9.88161 14.6891 10.8516 16.4865L12.3833 19.294C12.5789 19.6661 12.9769 19.8759 13.4023 19.8589C13.5145 19.8482 13.6354 19.8175 13.7363 19.778C14.0101 19.6707 14.2244 19.4538 14.3471 19.1731L19.4144 6.35138C19.5666 5.97597 19.495 5.53861 19.2242 5.22916C18.9534 4.91967 18.5405 4.79884 18.1432 4.88794L4.7545 8.30341C4.34849 8.41257 4.04151 8.73226 3.95519 9.14836C3.86882 9.56446 4.04691 9.97673 4.39289 10.2235L6.40292 11.6635Z"
			fill="white"
		/>
		<path
			d="M5.76973 15.5256C5.80738 15.5108 5.85264 15.4786 5.88538 15.4513L7.90981 13.6745C8.08107 13.5206 8.09791 13.268 7.94892 13.1093C7.79502 12.9381 7.54246 12.9212 7.38376 13.0702L5.35929 14.847C5.18806 15.0009 5.17123 15.2535 5.32018 15.4122C5.43425 15.5557 5.60664 15.5894 5.76973 15.5256Z"
			fill="white"
		/>
		<path
			d="M5.51088 18.3676C5.54857 18.353 5.59394 18.321 5.62672 18.2938L9.0673 15.2807C9.23898 15.1273 9.25653 14.8748 9.10799 14.7156C8.95458 14.544 8.70205 14.5264 8.54294 14.6749L5.10235 17.688C4.93068 17.8414 4.91313 18.0939 5.06167 18.253C5.17045 18.3843 5.36017 18.4262 5.51088 18.3676Z"
			fill="white"
		/>
	</svg>
);

export const SureFormsIcon = ( props ) => (
	<svg
		width="20"
		height="20"
		viewBox="0 0 20 20"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path d="M20 0H0V20H20V0Z" fill="#D54407" />
		<path
			d="M5.71094 4.28125H14.2824V7.13841H7.13952L5.71094 8.56697V7.13841V4.28125Z"
			fill="white"
		/>
		<path
			d="M5.71094 8.57031H12.8538V11.4274H7.13952L5.71094 12.856V11.4274V8.57031Z"
			fill="white"
		/>
		<path
			d="M5.71094 12.8516H9.99664V15.7087H5.71094V12.8516Z"
			fill="white"
		/>
	</svg>
);

export const Logo = ( props ) => (
	<svg
		width="146"
		height="28"
		viewBox="0 0 146 28"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M14.0152 28C21.7555 28 28.0303 21.732 28.0303 14C28.0303 6.26801 21.7555 0 14.0152 0C6.2748 0 0 6.26801 0 14C0 21.732 6.2748 28 14.0152 28ZM14.0755 7C12.9502 7 11.3928 7.64287 10.5971 8.4359L8.43583 10.5897H19.2083L22.8104 7H14.0755ZM17.4151 19.5641C16.6194 20.3571 15.062 21 13.9367 21H5.20182L8.80388 17.4103H19.5763L17.4151 19.5641ZM20.9162 12.3846H6.6387L5.96428 13.0577C4.36736 14.4936 4.84098 15.6154 7.0774 15.6154H21.3936L22.0682 14.9423C23.6496 13.5149 23.1526 12.3846 20.9162 12.3846Z"
			fill="#6B21A8"
		/>
		<path
			d="M34.957 18.7086L36.049 17.1966C36.945 18.2326 38.653 19.1286 40.501 19.1286C42.573 19.1286 43.693 18.2046 43.693 16.8886C43.693 15.4046 42.041 14.9286 40.221 14.4806C37.925 13.9486 35.321 13.3326 35.321 10.5326C35.321 8.43263 37.141 6.64062 40.361 6.64062C42.657 6.64062 44.281 7.50863 45.373 8.60063L44.393 10.0566C43.581 9.07663 42.097 8.34863 40.361 8.34863C38.513 8.34863 37.365 9.18863 37.365 10.3926C37.365 11.7086 38.905 12.1286 40.669 12.5486C43.021 13.0806 45.737 13.7526 45.737 16.7486C45.737 19.0166 43.917 20.8366 40.417 20.8366C38.205 20.8366 36.329 20.1646 34.957 18.7086ZM56.8766 20.5006V18.5966C55.8406 19.7726 54.0766 20.8366 52.0606 20.8366C49.2326 20.8366 47.7486 19.4646 47.7486 16.5246V6.97662H49.8486V15.8806C49.8486 18.2606 51.0526 18.9606 52.8726 18.9606C54.5246 18.9606 56.0926 18.0086 56.8766 16.9166V6.97662H58.9766V20.5006H56.8766ZM61.7705 20.5006V6.97662H63.8705V9.16062C64.9625 7.73263 66.5305 6.69663 68.3785 6.69663V8.85263C68.1265 8.79663 67.8745 8.76863 67.5385 8.76863C66.2505 8.76863 64.4865 9.83262 63.8705 10.9246V20.5006H61.7705ZM68.8287 13.7246C68.8287 9.80463 71.6287 6.64062 75.4927 6.64062C79.5807 6.64062 81.9887 9.83263 81.9887 13.8926V14.4246H71.0407C71.2087 16.9726 73.0007 19.1006 75.9127 19.1006C77.4527 19.1006 79.0207 18.4846 80.0847 17.3926L81.0927 18.7646C79.7487 20.1086 77.9287 20.8366 75.7167 20.8366C71.7127 20.8366 68.8287 17.9526 68.8287 13.7246ZM75.4647 8.37663C72.5807 8.37663 71.1527 10.8126 71.0407 12.8846H79.9167C79.8887 10.8686 78.5447 8.37663 75.4647 8.37663Z"
			fill="#334155"
		/>
		<path
			d="M93.7784 20.5002L90.8964 15.2422H88.6084V20.5002H85.4844V5.82617H92.3484C95.4064 5.82617 97.2764 7.82817 97.2764 10.5562C97.2764 13.1522 95.6484 14.5382 94.0644 14.9122L97.3644 20.5002H93.7784ZM94.0864 10.5342C94.0864 9.30217 93.1404 8.51017 91.8864 8.51017H88.6084V12.5582H91.8864C93.1404 12.5582 94.0864 11.7662 94.0864 10.5342ZM110.335 20.5002L109.411 17.9702H102.855L101.931 20.5002H98.4991L104.175 5.82617H108.091L113.745 20.5002H110.335ZM106.133 8.53217L103.691 15.2642H108.553L106.133 8.53217ZM125.66 20.5002L118.664 10.6442V20.5002H115.54V5.82617H118.752L125.55 15.3302V5.82617H128.674V20.5002H125.66ZM140.719 20.5002L136.275 14.6262L135.131 15.9902V20.5002H132.007V5.82617H135.131V12.3822L140.323 5.82617H144.173L138.343 12.7122L144.569 20.5002H140.719Z"
			fill="#334155"
		/>
	</svg>
);

export const AstraLogo = ( props ) => (
	<svg
		width="20"
		height="20"
		viewBox="0 0 20 20"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M10 20C15.5229 20 20 15.5228 20 10C20 4.47715 15.5229 0 10 0C4.47716 0 0 4.47715 0 10C0 15.5228 4.47716 20 10 20ZM9.87902 4.43553C9.03231 6.22172 8.18559 8.00991 7.33888 9.79805C6.49206 11.5865 5.64519 13.3749 4.79838 15.1613H6.97578C7.6613 13.7783 8.34678 12.3932 9.03225 11.0081C9.71773 9.62302 10.4032 8.23794 11.0887 6.85487L9.87902 4.43553ZM11.0887 11.0483C11.4374 10.3225 11.7862 9.59679 12.137 8.87103C12.649 9.91933 13.1591 10.9677 13.6691 12.016C14.1793 13.0644 14.6894 14.1129 15.2015 15.1613H12.8628C12.7298 14.8509 12.5946 14.5424 12.4596 14.2339C12.3245 13.9255 12.1894 13.617 12.0563 13.3065H10.0402H9.99989L10.0402 13.2258C10.3911 12.5 10.7399 11.7742 11.0887 11.0483Z"
			fill="url(#paint0_linear_10691_20999)"
		/>
		<defs>
			<linearGradient
				id="paint0_linear_10691_20999"
				x1="20"
				y1="-5.96046e-07"
				x2="-1.78814e-06"
				y2="20"
				gradientUnits="userSpaceOnUse"
			>
				<stop stopColor="#B147E1" />
				<stop offset="1" stopColor="#5236DD" />
			</linearGradient>
		</defs>
	</svg>
);

export const SpectraLogo = ( props ) => (
	<svg
		width="20"
		height="20"
		viewBox="0 0 20 20"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M10 20C15.5229 20 20 15.5229 20 10C20 4.47714 15.5229 0 10 0C4.47714 0 0 4.47714 0 10C0 15.5229 4.47714 20 10 20ZM13.0751 12.93C13.6533 12.5645 14 11.9529 14 11.2985C14 10.389 13.336 9.59814 12.3943 9.38589L9.57257 8.68549C9.30657 8.62554 9.24283 8.29757 9.46911 8.15323L11.6675 6.75106C12.6907 6.09837 12.9568 4.79034 12.2617 3.82949C12.1748 3.70937 12.0007 3.67814 11.8728 3.75974L6.90669 7.10954C6.33954 7.47129 6 8.07331 6 8.71709C6 9.61566 6.65603 10.397 7.58654 10.6067L10.4542 11.3175C10.7208 11.3776 10.784 11.7067 10.5566 11.8504L8.34209 13.2504C7.31594 13.8991 7.04411 15.2061 7.73494 16.1696C7.82131 16.2901 7.99529 16.322 8.12357 16.2409L13.0751 12.93Z"
			fill="#5733FF"
		/>
	</svg>
);

export const StarterTemplatesLogo = ( props ) => (
	<svg
		width="20"
		height="20"
		viewBox="0 0 20 20"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g clipPath="url(#clip0_10691_20952)">
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M15.9016 1.63934H4.09835C2.74029 1.63934 1.63934 2.74029 1.63934 4.09835V15.9016C1.63934 17.2597 2.74029 18.3606 4.09835 18.3606H15.9016C17.2597 18.3606 18.3606 17.2597 18.3606 15.9016V4.09835C18.3606 2.74029 17.2597 1.63934 15.9016 1.63934ZM4.09835 0C1.8349 0 0 1.8349 0 4.09835V15.9016C0 18.1651 1.8349 20 4.09835 20H15.9016C18.1651 20 20 18.1651 20 15.9016V4.09835C20 1.8349 18.1651 0 15.9016 0H4.09835Z"
				fill="url(#paint0_linear_10691_20952)"
			/>
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M12.0852 6.29242C12.0468 6.25805 12.0063 6.22515 11.9636 6.19371C11.5934 5.92119 11.0911 5.78492 10.4565 5.78492C10.0253 5.78492 9.66127 5.84594 9.36433 5.96796C9.06739 6.08592 8.8396 6.25067 8.68097 6.46219C8.51056 6.69538 8.22035 6.88436 7.96939 6.7414C7.77241 6.62917 7.59052 6.49073 7.42895 6.32919C7.12762 6.02786 6.90668 5.65576 6.78637 5.24694C6.73335 5.06684 6.78027 4.86998 6.92208 4.74694C7.2392 4.47176 7.60991 4.24013 8.0342 4.05209C8.75012 3.73482 9.56364 3.57617 10.4748 3.57617C11.4022 3.57617 12.2117 3.73482 12.9032 4.05209C13.5988 4.36938 14.1398 4.81071 14.5262 5.37613C14.6676 5.58294 14.7839 5.80176 14.8752 6.03253C15.1458 6.71688 14.5211 7.3408 13.7851 7.3408C13.2106 7.3408 12.7507 6.91113 12.3163 6.50521C12.2386 6.43265 12.1618 6.36086 12.0852 6.29242ZM8.30266 7.64605C8.41172 7.6034 8.52849 7.66794 8.58945 7.7679C8.6952 7.93467 8.8396 8.07909 9.02264 8.20111C9.2057 8.31907 9.41722 8.4228 9.6572 8.5123C9.8972 8.59771 10.1535 8.67092 10.426 8.73194L11.5487 9.0004C12.0937 9.12244 12.5941 9.28515 13.0496 9.48853C13.5052 9.69192 13.8998 9.94207 14.2333 10.239C14.5669 10.5359 14.8252 10.8858 15.0082 11.2885C15.1953 11.6912 15.2909 12.1529 15.295 12.6735C15.2909 13.4382 15.0957 14.1013 14.7092 14.6626C14.3269 15.2199 13.7737 15.6531 13.0496 15.9622C12.3297 16.2673 11.4612 16.4198 10.4443 16.4198C9.43552 16.4198 8.55691 16.2653 7.80845 15.9561C7.06408 15.647 6.48239 15.1894 6.06343 14.5833C5.87006 14.2989 5.71956 13.9832 5.61189 13.6361C5.39472 12.9361 6.01368 12.3196 6.74664 12.3196H6.84168C7.4752 12.3196 7.94579 12.8632 8.32708 13.3691C8.54266 13.6457 8.82943 13.8552 9.18739 13.9975C9.54941 14.1358 9.95822 14.205 10.4138 14.205C10.8612 14.205 11.2497 14.1399 11.5792 14.0097C11.9127 13.8796 12.171 13.6986 12.3541 13.4667C12.5371 13.2349 12.6286 12.9684 12.6286 12.6674C12.6286 12.3867 12.5452 12.1508 12.3785 11.9596C12.2158 11.7685 11.9758 11.6058 11.6585 11.4715C11.3453 11.3373 10.9609 11.2153 10.5053 11.1054L9.14468 10.7637C8.25214 10.5466 7.5187 10.2259 6.94439 9.80148C6.78914 9.68676 6.73185 9.4848 6.78637 9.29961C6.90664 8.89084 7.12756 8.51875 7.42885 8.21742C7.6781 7.96813 7.97581 7.77386 8.30266 7.64605ZM6.68587 5.92236L6.56629 5.51609C6.56114 5.49844 6.55041 5.48294 6.53572 5.47192C6.52102 5.4609 6.50314 5.45494 6.48477 5.45494C6.46639 5.45494 6.44852 5.4609 6.43381 5.47192C6.4191 5.48294 6.40837 5.49844 6.40322 5.51609L6.28383 5.92236C6.2036 6.19486 6.05629 6.4429 5.85539 6.64375C5.65452 6.84461 5.40645 6.99186 5.13391 7.07207L4.72762 7.19163C4.64627 7.21575 4.64627 7.3309 4.72762 7.35469L5.13391 7.47426C5.40641 7.55446 5.65443 7.70176 5.85531 7.90261C6.05616 8.10344 6.20343 8.35146 6.28366 8.62396L6.40322 9.0304C6.42718 9.11159 6.54235 9.11159 6.56629 9.0304L6.68587 8.62413C6.76606 8.35161 6.91333 8.10355 7.1142 7.90267C7.31506 7.7018 7.5631 7.55448 7.83562 7.47426L8.24208 7.35469C8.32327 7.33073 8.32327 7.21559 8.24208 7.1918L7.83579 7.07223C7.56322 6.99203 7.31516 6.84473 7.11427 6.64384C6.91337 6.44296 6.76608 6.1949 6.68587 5.92236ZM5.23652 8.32203L5.27239 8.4439C5.29645 8.52567 5.34064 8.60009 5.40091 8.66036C5.46116 8.72061 5.5356 8.7648 5.61735 8.78886L5.73924 8.82473C5.7636 8.83188 5.7636 8.86642 5.73924 8.87361L5.61731 8.90948C5.53556 8.93355 5.46114 8.97773 5.40087 9.03801C5.34062 9.09828 5.29643 9.17269 5.27239 9.25444L5.23652 9.37632C5.22933 9.40067 5.19479 9.40067 5.1876 9.37632L5.15172 9.25438C5.12766 9.17265 5.08347 9.09823 5.0232 9.03798C4.96295 8.97771 4.88854 8.93355 4.80679 8.90948L4.68491 8.87361C4.66049 8.86646 4.66049 8.83192 4.68491 8.82469L4.80679 8.78882C4.88856 8.76475 4.96297 8.72059 5.02324 8.66032C5.08352 8.60007 5.1277 8.52565 5.15177 8.4439L5.1876 8.32203C5.18914 8.31673 5.19235 8.31209 5.19677 8.30878C5.20118 8.30546 5.20654 8.30367 5.21206 8.30367C5.21756 8.30367 5.22293 8.30546 5.22733 8.30878C5.23174 8.31209 5.23497 8.31673 5.23652 8.32203ZM5.00287 5.00621L4.94708 4.81663C4.94466 4.8084 4.93966 4.80117 4.93281 4.79603C4.92593 4.79088 4.9176 4.78809 4.90902 4.78809C4.90045 4.78809 4.8921 4.79088 4.88525 4.79603C4.87839 4.80117 4.87337 4.8084 4.87097 4.81663L4.81524 5.00621C4.77781 5.1334 4.70908 5.24913 4.61533 5.34288C4.52158 5.43661 4.40581 5.50532 4.27862 5.54276L4.08902 5.59855C4.05106 5.6098 4.05106 5.66355 4.08902 5.67465L4.27862 5.73044C4.40579 5.76788 4.52154 5.83661 4.61527 5.93034C4.70902 6.02407 4.77775 6.13982 4.81518 6.26696L4.87097 6.45665C4.88216 6.49453 4.93589 6.49453 4.94708 6.45665L5.00287 6.26705C5.04029 6.13988 5.10902 6.02411 5.20277 5.93036C5.29649 5.83663 5.41224 5.76788 5.53941 5.73044L5.7291 5.67465C5.76699 5.66346 5.76699 5.60973 5.7291 5.59863L5.53949 5.54282C5.41231 5.5054 5.29654 5.43667 5.20279 5.34292C5.10904 5.24917 5.04031 5.1334 5.00287 5.00621Z"
				fill="url(#paint1_linear_10691_20952)"
			/>
		</g>
		<defs>
			<linearGradient
				id="paint0_linear_10691_20952"
				x1="1.30248"
				y1="19.7653"
				x2="7.81504"
				y2="-2.89315"
				gradientUnits="userSpaceOnUse"
			>
				<stop stopColor="#C639FF" />
				<stop offset="1" stopColor="#3662FF" />
			</linearGradient>
			<linearGradient
				id="paint1_linear_10691_20952"
				x1="4.79218"
				y1="16.2691"
				x2="9.46406"
				y2="2.05132"
				gradientUnits="userSpaceOnUse"
			>
				<stop stopColor="#C639FF" />
				<stop offset="1" stopColor="#3662FF" />
			</linearGradient>
			<clipPath id="clip0_10691_20952">
				<rect width="20" height="20" fill="white" />
			</clipPath>
		</defs>
	</svg>
);

export const OttoKitLogo = ( props ) => (
	<svg
		width="52"
		height="52"
		viewBox="0 0 52 52"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<g filter="url(#filter0_d_17130_33424)">
			<g clipPath="url(#clip0_17130_33424)">
				<rect
					x="2"
					y="2"
					width="48"
					height="48"
					rx="12.9231"
					fill="#D2F059"
				/>
				<g filter="url(#filter1_dddd_17130_33424)">
					<path
						fillRule="evenodd"
						clipRule="evenodd"
						d="M25.9963 35.6777C31.3412 35.6777 35.6733 31.3451 35.6733 26.0005C35.6733 20.6559 31.3412 16.3232 25.9963 16.3232C20.6514 16.3232 16.3193 20.6559 16.3193 26.0005C16.3193 31.3451 20.6514 35.6777 25.9963 35.6777ZM25.9963 43.078C34.1601 43.078 40.986 37.3493 42.6734 29.6924H47.2264V22.3078L42.6732 22.3078C40.9855 14.6513 34.1598 8.92297 25.9963 8.92297C17.8328 8.92297 11.0071 14.6513 9.31944 22.3078L4.76562 22.3078V29.6924H9.31928C11.0067 37.3493 17.8325 43.078 25.9963 43.078Z"
						fill="url(#paint0_linear_17130_33424)"
					/>
				</g>
			</g>
		</g>
		<defs>
			<filter
				id="filter0_d_17130_33424"
				x="0.615385"
				y="0.615385"
				width="50.7692"
				height="50.7692"
				filterUnits="userSpaceOnUse"
				colorInterpolationFilters="sRGB"
			>
				<feFlood floodOpacity="0" result="BackgroundImageFix" />
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feMorphology
					radius="1.38462"
					operator="dilate"
					in="SourceAlpha"
					result="effect1_dropShadow_17130_33424"
				/>
				<feOffset />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0.777287 0 0 0 0 0.9125 0 0 0 0 0.231927 0 0 0 1 0"
				/>
				<feBlend
					mode="normal"
					in2="BackgroundImageFix"
					result="effect1_dropShadow_17130_33424"
				/>
				<feBlend
					mode="normal"
					in="SourceGraphic"
					in2="effect1_dropShadow_17130_33424"
					result="shape"
				/>
			</filter>
			<filter
				id="filter1_dddd_17130_33424"
				x="-3.1163"
				y="6.29567"
				width="58.2245"
				height="49.9188"
				filterUnits="userSpaceOnUse"
				colorInterpolationFilters="sRGB"
			>
				<feFlood floodOpacity="0" result="BackgroundImageFix" />
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy="5.25461" />
				<feGaussianBlur stdDeviation="3.94096" />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.06 0"
				/>
				<feBlend
					mode="normal"
					in2="BackgroundImageFix"
					result="effect1_dropShadow_17130_33424"
				/>
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dx="-1.18229" dy="3.94096" />
				<feGaussianBlur stdDeviation="2.29889" />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.04 0"
				/>
				<feBlend
					mode="normal"
					in2="effect1_dropShadow_17130_33424"
					result="effect2_dropShadow_17130_33424"
				/>
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy="1.31365" />
				<feGaussianBlur stdDeviation="1.31365" />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.03 0"
				/>
				<feBlend
					mode="normal"
					in2="effect2_dropShadow_17130_33424"
					result="effect3_dropShadow_17130_33424"
				/>
				<feColorMatrix
					in="SourceAlpha"
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
					result="hardAlpha"
				/>
				<feOffset dy="1.31365" />
				<feGaussianBlur stdDeviation="0.656827" />
				<feComposite in2="hardAlpha" operator="out" />
				<feColorMatrix
					type="matrix"
					values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.08 0"
				/>
				<feBlend
					mode="normal"
					in2="effect3_dropShadow_17130_33424"
					result="effect4_dropShadow_17130_33424"
				/>
				<feBlend
					mode="normal"
					in="SourceGraphic"
					in2="effect4_dropShadow_17130_33424"
					result="shape"
				/>
			</filter>
			<linearGradient
				id="paint0_linear_17130_33424"
				x1="25.9961"
				y1="43.0779"
				x2="25.9961"
				y2="8.92297"
				gradientUnits="userSpaceOnUse"
			>
				<stop stopColor="#072F50" stopOpacity="0.95" />
				<stop offset="1" stopColor="#172A39" stopOpacity="0.75" />
			</linearGradient>
			<clipPath id="clip0_17130_33424">
				<rect
					x="2"
					y="2"
					width="48"
					height="48"
					rx="12.9231"
					fill="white"
				/>
			</clipPath>
		</defs>
	</svg>
);

export const UAE = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M12.0002 0C5.37167 0 0 5.37381 0 11.9991C0 18.6267 5.37167 24 12.0002 24C18.6279 24 24 18.6267 24 11.9991C24 5.37241 18.6269 0 12.0002 0ZM11.7686 14.1946C11.6219 14.7039 11.403 15.154 11.102 15.5402C10.809 15.9218 10.426 16.2254 9.96699 16.4447C9.5038 16.6625 8.95904 16.7716 8.32145 16.7716C7.66183 16.7716 7.10253 16.6541 6.63606 16.4218C6.17147 16.1942 5.79642 15.8835 5.50013 15.4945C5.21368 15.1083 4.9985 14.6592 4.86488 14.147C4.72752 13.6316 4.66189 13.0966 4.66189 12.5355V8.18455H6.56715V12.5355C6.56715 12.8662 6.59809 13.1796 6.65857 13.473C6.72092 13.7729 6.81796 14.0341 6.96142 14.2673C7.10253 14.4987 7.27787 14.6839 7.50337 14.8187C7.7209 14.9544 7.99328 15.023 8.32098 15.023C8.64868 15.023 8.91919 14.9544 9.14469 14.814C9.37019 14.6741 9.55584 14.4889 9.68945 14.2594C9.83056 14.0276 9.92995 13.7599 9.98902 13.4567C10.0462 13.1591 10.0767 12.8545 10.0767 12.5369V8.18875H11.9819V12.5369H11.9829C11.9824 13.1325 11.9102 13.6824 11.7686 14.1946ZM19.3376 16.7726H13.5665V14.9941H19.3376V16.7726ZM19.3376 13.3685H13.5665V11.59H19.3376V13.3685ZM19.3376 9.96587H13.5665V8.18735H19.3376V9.96587Z"
			fill="url(#paint0_linear_17897_4967)"
		/>
		<defs>
			<linearGradient
				id="paint0_linear_17897_4967"
				x1="0"
				y1="12"
				x2="24.0002"
				y2="12"
				gradientUnits="userSpaceOnUse"
			>
				<stop stopColor="#681DDD" />
				<stop offset="1" stopColor="#3A1B95" />
			</linearGradient>
		</defs>
	</svg>
);

export const XSocialIcon = ( props ) => (
	<svg
		width="16"
		height="16"
		viewBox="0 0 16 16"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M12.2149 1.26929H14.4639L9.55054 6.88495L15.3307 14.5266H10.8049L7.26009 9.89198L3.20403 14.5266H0.953684L6.20902 8.52002L0.664062 1.26929H5.3048L8.50899 5.50551L12.2149 1.26929ZM11.4256 13.1805H12.6718L4.62766 2.54471H3.29037L11.4256 13.1805Z"
			fill="#111827"
		/>
	</svg>
);

export const DotIcon = ( props ) => (
	<svg
		width="20"
		height="20"
		viewBox="0 0 20 20"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M13.1667 10C13.1667 11.7489 11.7489 13.1667 10 13.1667C8.25113 13.1667 6.83337 11.7489 6.83337 10C6.83337 8.25113 8.25113 6.83337 10 6.83337C11.7489 6.83337 13.1667 8.25113 13.1667 10Z"
			fill="#FFFFFF"
		/>
	</svg>
);

export const SparklesIcon = ( props ) => (
	<svg
		width="24"
		height="24"
		viewBox="0 0 24 24"
		fill="none"
		xmlns="http://www.w3.org/2000/svg"
		{ ...props }
	>
		<path
			d="M9.93548 15.5002C9.8462 15.1542 9.66581 14.8384 9.41309 14.5856C9.16037 14.3329 8.84455 14.1525 8.49848 14.0632L2.36348 12.4812C2.25881 12.4515 2.16668 12.3885 2.10109 12.3017C2.03549 12.2149 2 12.1091 2 12.0002C2 11.8914 2.03549 11.7856 2.10109 11.6988C2.16668 11.612 2.25881 11.549 2.36348 11.5192L8.49848 9.93625C8.84442 9.84706 9.16017 9.66682 9.41288 9.41429C9.66559 9.16175 9.84604 8.84614 9.93548 8.50025L11.5175 2.36525C11.5469 2.26017 11.6099 2.16759 11.6968 2.10164C11.7837 2.0357 11.8899 2 11.999 2C12.1081 2 12.2142 2.0357 12.3012 2.10164C12.3881 2.16759 12.4511 2.26017 12.4805 2.36525L14.0615 8.50025C14.1508 8.84632 14.3311 9.16215 14.5839 9.41487C14.8366 9.66759 15.1524 9.84797 15.4985 9.93725L21.6335 11.5182C21.739 11.5473 21.832 11.6103 21.8983 11.6973C21.9646 11.7844 22.0005 11.8908 22.0005 12.0002C22.0005 12.1097 21.9646 12.2161 21.8983 12.3032C21.832 12.3902 21.739 12.4531 21.6335 12.4822L15.4985 14.0632C15.1524 14.1525 14.8366 14.3329 14.5839 14.5856C14.3311 14.8384 14.1508 15.1542 14.0615 15.5002L12.4795 21.6353C12.4501 21.7403 12.3871 21.8329 12.3002 21.8989C12.2132 21.9648 12.1071 22.0005 11.998 22.0005C11.8889 22.0005 11.7827 21.9648 11.6958 21.8989C11.6089 21.8329 11.5459 21.7403 11.5165 21.6353L9.93548 15.5002Z"
			stroke="#111827"
			strokeWidth="1.25"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
		<path
			d="M20 3V7"
			stroke="currentColor"
			strokeWidth="1.25"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
		<path
			d="M22 5H18"
			stroke="currentColor"
			strokeWidth="1.25"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
		<path
			d="M4 17V19"
			stroke="currentColor"
			strokeWidth="1.25"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
		<path
			d="M5 18H3"
			stroke="currentColor"
			strokeWidth="1.25"
			strokeLinecap="round"
			strokeLinejoin="round"
		/>
	</svg>
);
