import{proxyCustomElement,HTMLElement,createEvent,h}from"@stencil/core/internal/client";import{i as isRtl}from"./page-align.js";import{d as defineCustomElement$3}from"./sc-icon2.js";import{d as defineCustomElement$2}from"./sc-product-line-item-note2.js";import{d as defineCustomElement$1}from"./sc-quantity-select2.js";const scProductLineItemCss=":host {\n  display: block;\n  font-family: var(--sc-font-sans);\n  --sc-product-line-item-line-gap: 6px;\n}\n\n.item {\n  box-sizing: border-box;\n  margin: 0px;\n  min-width: 0px;\n  display: flex;\n  gap: var(--sc-spacing-large);\n  justify-content: space-between;\n  align-items: stretch;\n  width: 100%;\n  border-bottom: none;\n  container-type: inline-size;\n}\n.item__text-container {\n  box-sizing: border-box;\n  margin: 0px;\n  min-width: 0px;\n  display: flex;\n  flex-direction: column;\n  gap: var(--sc-product-line-item-line-gap);\n  justify-content: space-between;\n  align-items: stretch;\n  width: 100%;\n  border-bottom: none;\n}\n.item__row {\n  display: flex;\n  gap: 18px;\n  justify-content: space-between;\n  align-items: stretch;\n  width: 100%;\n}\n.item__row.stick-bottom {\n  margin-top: auto;\n}\n.item__scratch-price {\n  text-decoration: line-through;\n  font-size: var(--sc-font-size-small);\n  line-height: 1;\n  color: var(--sc-input-help-text-color);\n  white-space: nowrap;\n}\n.item__remove-container {\n  display: flex;\n  gap: 6px;\n  align-items: center;\n  line-height: 1;\n  cursor: pointer;\n  color: var(--sc-input-help-text-color);\n  font-size: var(--sc-input-help-text-font-size-medium);\n}\n\n.item__text {\n  box-sizing: border-box;\n  margin: 0px;\n  min-width: 0px;\n  display: flex;\n  gap: 6px;\n  flex-direction: column;\n  align-items: flex-start;\n  justify-content: flex-start;\n  flex: 1 1 0%;\n}\n\n.item__text-details {\n  display: grid;\n  gap: var(--sc-product-line-item-line-gap);\n}\n\n.item__title {\n  box-sizing: border-box;\n  min-width: 0px;\n  margin: 0;\n  color: var(--sc-line-item-title-color, var(--sc-input-label-color));\n  font-size: var(--sc-font-size-medium);\n  font-weight: var(--sc-font-weight-semibold);\n  line-height: 1;\n  cursor: pointer;\n  display: -webkit-box;\n  display: -moz-box;\n  -webkit-box-orient: vertical;\n  -moz-box-orient: vertical;\n  -webkit-line-clamp: 3;\n  -moz-box-lines: 3;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.item__suffix {\n  flex: 1;\n  box-sizing: border-box;\n  margin: 0px;\n  min-width: 0px;\n  display: flex;\n  flex-direction: column;\n  -webkit-box-pack: start;\n  justify-content: space-between;\n  align-items: flex-end;\n  min-width: 100px;\n  margin-left: auto;\n  align-self: center;\n}\n\n.product-line-item__removable .item__suffix {\n  align-self: flex-start;\n}\n\n.product-line-item__editable .item__suffix {\n  align-self: flex-start;\n}\n\n.product-line-item__purchasable-status {\n  font-size: var(--sc-font-size-x-small);\n  color: var(--sc-input-error-text-color);\n}\n\n.item__price {\n  text-align: right;\n  max-width: 100%;\n  display: grid;\n  gap: var(--sc-product-line-item-line-gap);\n}\n\n.item__description {\n  color: var(--sc-price-label-color, var(--sc-input-help-text-color));\n  font-size: var(--sc-price-label-font-size, var(--sc-input-help-text-font-size-medium));\n  line-height: 1;\n  display: flex;\n  flex-wrap: wrap;\n  flex-direction: column;\n  gap: var(--sc-product-line-item-line-gap);\n  text-wrap: pretty;\n}\n.item__description:last-child {\n  align-items: flex-end;\n  text-align: right;\n}\n\n.item__image-placeholder {\n  width: var(--sc-product-line-item-image-size, 65px);\n  height: var(--sc-product-line-item-image-size, 65px);\n  background-color: var(--sc-input-border-color, var(--sc-input-border));\n  border-radius: 4px;\n  flex: 0 0 var(--sc-product-line-item-image-size, 65px);\n}\n\n.item__image,\n.attachment-thumbnail {\n  width: var(--sc-product-line-item-image-size, 65px);\n  height: var(--sc-product-line-item-image-size, 65px);\n  object-fit: cover;\n  border-radius: 4px;\n  border: solid 1px var(--sc-input-border-color, var(--sc-input-border));\n  display: block;\n  box-shadow: var(--sc-input-box-shadow);\n  align-self: flex-start;\n}\n\n@container (max-width: 380px) {\n  .item__image,\n  .item__image-placeholder {\n    display: var(--sc-product-line-item-mobile-image-display, none);\n  }\n}\n.product__description {\n  display: flex;\n  gap: 0.5em;\n  align-items: center;\n}\n\n.price {\n  font-size: var(--sc-font-size-medium);\n  font-weight: var(--sc-font-weight-semibold);\n  color: var(--sc-input-label-color);\n  line-height: 1;\n  white-space: nowrap;\n  display: flex;\n  gap: 4px;\n  align-items: baseline;\n}\n\n.price__description {\n  font-size: var(--sc-font-size-small);\n  line-height: 1;\n  color: var(--sc-input-help-text-color);\n  text-align: right;\n  white-space: nowrap;\n}\n\n.item--is-rtl.price {\n  text-align: right;\n}\n.item--is-rtl .item__price {\n  text-align: left;\n}\n\n.base {\n  display: grid;\n  gap: var(--sc-spacing-x-small);\n}\n\n.fee__description {\n  color: var(--sc-input-help-text-color);\n}\n\nsc-quantity-select::part(base) {\n  box-shadow: none;\n  background-color: transparent;\n}\n\nsc-quantity-select::part(base):not(:focus-within) {\n  border-color: transparent;\n}\n\nsc-quantity-select::part(input),\nsc-quantity-select::part(plus),\nsc-quantity-select::part(minus) {\n  background-color: transparent;\n}",ScProductLineItemStyle0=scProductLineItemCss,ScProductLineItem=proxyCustomElement(class extends HTMLElement{constructor(){super(),this.__registerHost(),this.__attachShadow(),this.scUpdateQuantity=createEvent(this,"scUpdateQuantity",3),this.scRemove=createEvent(this,"scRemove",3),this.image=void 0,this.name=void 0,this.amount=void 0,this.scratch=void 0,this.displayAmount=void 0,this.scratchDisplayAmount=void 0,this.fees=void 0,this.price=void 0,this.variant="",this.quantity=void 0,this.interval=void 0,this.trial=void 0,this.removable=void 0,this.editable=!0,this.max=void 0,this.sku="",this.purchasableStatus=void 0,this.note=void 0}render(){var e,t,i;const n="fallback"===(null===(e=this.image)||void 0===e?void 0:e.type);return h("div",{key:"acb31c652369e666ba0772323bb4a764d92f1745",class:"base",part:"base"},h("div",{key:"4200949e59f4f0c5df4410f372b8072d18865445",part:"product-line-item",class:{item:!0,"item--has-image":!!(null===(t=this.image)||void 0===t?void 0:t.src),"item--is-rtl":isRtl(),"product-line-item__editable":this.editable,"product-line-item__removable":this.removable}},(null===(i=this.image)||void 0===i?void 0:i.src)?h("img",{...this.image,part:n?"placeholder__image":"image",class:n?"item__image-placeholder":"item__image"}):h("div",{class:"item__image-placeholder",part:"placeholder__image"}),h("div",{key:"82f5eb7d59528d09f1efd683ecb2a022851a55bb",class:"item__text-container"},h("div",{key:"cf21770ddef7c26370ca4b93ae12b83d847c519c",class:"item__row"},h("div",{key:"56c046f833d636300b6d5021f24dcf141b1dcabc",class:"item__title",part:"title"},h("slot",{key:"09c60e7f51d89129df4d144a63c0216b532acbff",name:"title"},this.name)),h("div",{key:"d30573431da79fc330a6f0156c4d904f0bc1d235",class:"price",part:"price__amount"},!!this.scratch&&this.scratch!==this.amount&&h("span",{key:"c3f7ff4ac6b16179939f8dbf471b5daf6606ed3e",class:"item__scratch-price"},this.scratch),this.amount,h("div",{key:"8fe7b288da8350315cc27a54cbc03e675b781cd3",class:"price__description",part:"price__description"},this.interval))),h("div",{key:"cbb34bf3f0cc3981d285af323a4493d952e169c9",class:"item__row"},h("div",{key:"1574b717f3db4caa379df27f7c1bdac18be18045",class:"item__description",part:"description"},this.variant&&h("div",{key:"f6258615ba64013ff07d16027f0419090aafc57e"},this.variant),this.price&&h("div",{key:"a403241ba07d9c0ab96c8205368eec1e7c445f39"},this.price),this.sku&&h("div",{key:"29e252e1885cd58f5acb21371fb7f1a11cd098ca"},wp.i18n.__("SKU:","surecart")," ",this.sku),!!this.purchasableStatus&&h("div",{key:"1a57bb5329e4968a449959c98496430c6ece16bf"},this.purchasableStatus),!!this.note&&h("sc-product-line-item-note",{key:"6d7799cd8844ec43bf15f8a5c078869142f8e1cb",note:this.note})),h("div",{key:"85f5dca906ef31adea6376f0d473bf3bee83c98b",class:"item__description",part:"trial-fees"},!!this.trial&&h("div",{key:"09024d942a2b6200fa572f0d9c72159a3636c854"},this.trial),(this.fees||[]).map((e=>h("div",null,null==e?void 0:e.display_amount," ",null==e?void 0:e.description))))),h("div",{key:"59f95fadf33b9cfcc341e1bc1493618a3e1bd4da",class:"item__row stick-bottom"},this.editable?h("sc-quantity-select",{max:this.max||1/0,exportparts:"base:quantity, minus:quantity__minus, minus-icon:quantity__minus-icon, plus:quantity__plus, plus-icon:quantity__plus-icon, input:quantity__input",clickEl:this.el,quantity:this.quantity,size:"small",onScChange:e=>e.detail&&this.scUpdateQuantity.emit(e.detail),"aria-label":
/** translators: %1$s: product name, %2$s: product price name */
wp.i18n.sprintf(wp.i18n.__("Change Quantity - %1$s %2$s","surecart"),this.name,this.price)}):h("span",{class:"item__description",part:"static-quantity"},wp.i18n.__("Qty:","surecart")," ",this.quantity),!!this.removable&&h("div",{key:"53bd671f6422947b7174b5036d81aac82e38906b",class:"item__remove-container",onClick:()=>this.scRemove.emit(),onKeyDown:e=>{"Enter"===e.key&&this.scRemove.emit()},"aria-label":wp.i18n.sprintf(wp.i18n.__("Remove Item - %1$s %2$s","surecart"),this.name,this.price),tabIndex:0},h("sc-icon",{key:"8017412201ecd5ecc307269fd0183c2904eb4989",exportparts:"base:remove-icon__base",class:"item__remove",name:"x"}),h("span",{key:"6162f3401bb9ec7d77aecc813daef39e19c40ec9",class:"item__remove-text"},wp.i18n.__("Remove","surecart")))))))}get el(){return this}static get style(){return ScProductLineItemStyle0}},[1,"sc-product-line-item",{image:[16],name:[1],amount:[1],scratch:[1],displayAmount:[1,"display-amount"],scratchDisplayAmount:[1,"scratch-display-amount"],fees:[16],price:[1],variant:[1],quantity:[2],interval:[1],trial:[1],removable:[4],editable:[4],max:[2],sku:[1],purchasableStatus:[1,"purchasable-status"],note:[1]}]);function defineCustomElement(){"undefined"!=typeof customElements&&["sc-product-line-item","sc-icon","sc-product-line-item-note","sc-quantity-select"].forEach((e=>{switch(e){case"sc-product-line-item":customElements.get(e)||customElements.define(e,ScProductLineItem);break;case"sc-icon":customElements.get(e)||defineCustomElement$3();break;case"sc-product-line-item-note":customElements.get(e)||defineCustomElement$2();break;case"sc-quantity-select":customElements.get(e)||defineCustomElement$1()}}))}export{ScProductLineItem as S,defineCustomElement as d};