/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-04 13:32:21 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2994 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=116 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_activities` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `agent_id` int DEFAULT NULL,
  `booking_id` int DEFAULT NULL,
  `service_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `order_id` int DEFAULT NULL,
  `order_item_id` int DEFAULT NULL,
  `coupon_id` int DEFAULT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci,
  `initiated_by` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `initiated_by_id` int DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_agent_meta` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `object_id` mediumint NOT NULL,
  `meta_key` varchar(110) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_agents` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `avatar_image_id` int DEFAULT NULL,
  `bio_image_id` int DEFAULT NULL,
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `display_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `bio` text COLLATE utf8mb4_unicode_520_ci,
  `features` text COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(110) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `custom_hours` tinyint(1) DEFAULT NULL,
  `wp_user_id` int DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `extra_emails` text COLLATE utf8mb4_unicode_520_ci,
  `extra_phones` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_agents_services` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `agent_id` int NOT NULL,
  `service_id` int NOT NULL,
  `location_id` int DEFAULT NULL,
  `is_custom_hours` tinyint(1) DEFAULT NULL,
  `is_custom_price` tinyint(1) DEFAULT NULL,
  `is_custom_duration` tinyint(1) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `service_id_index` (`service_id`),
  KEY `location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_blocked_periods` (
  `id` int NOT NULL AUTO_INCREMENT,
  `summary` text COLLATE utf8mb4_unicode_520_ci,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `start_time` mediumint DEFAULT NULL,
  `end_time` mediumint DEFAULT NULL,
  `start_datetime_utc` datetime DEFAULT NULL,
  `end_datetime_utc` datetime DEFAULT NULL,
  `service_id` mediumint DEFAULT NULL,
  `agent_id` mediumint DEFAULT NULL,
  `location_id` mediumint DEFAULT NULL,
  `server_timezone` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `service_id_index` (`service_id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_booking_meta` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `object_id` mediumint NOT NULL,
  `meta_key` varchar(110) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_bookings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `booking_code` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `start_time` mediumint DEFAULT NULL,
  `end_time` mediumint DEFAULT NULL,
  `start_datetime_utc` datetime DEFAULT NULL,
  `end_datetime_utc` datetime DEFAULT NULL,
  `buffer_before` mediumint NOT NULL,
  `buffer_after` mediumint NOT NULL,
  `duration` mediumint DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'pending',
  `customer_id` mediumint NOT NULL,
  `service_id` mediumint NOT NULL,
  `agent_id` mediumint NOT NULL,
  `location_id` mediumint DEFAULT NULL,
  `order_item_id` mediumint DEFAULT NULL,
  `recurrence_id` mediumint DEFAULT NULL,
  `total_attendees` mediumint DEFAULT NULL,
  `customer_timezone` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `server_timezone` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `start_date_index` (`start_date`),
  KEY `end_date_index` (`end_date`),
  KEY `status_index` (`status`),
  KEY `customer_id_index` (`customer_id`),
  KEY `service_id_index` (`service_id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `location_id_index` (`location_id`),
  KEY `recurrence_id_index` (`recurrence_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_bundle_meta` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `object_id` mediumint NOT NULL,
  `meta_key` varchar(110) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_bundles` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `short_description` text COLLATE utf8mb4_unicode_520_ci,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `deposit_amount` decimal(20,4) DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `visibility` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_number` int DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_number_index` (`order_number`),
  KEY `status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_bundles_services` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `bundle_id` mediumint DEFAULT NULL,
  `service_id` mediumint DEFAULT NULL,
  `total_attendees` mediumint DEFAULT NULL,
  `duration` int DEFAULT NULL,
  `quantity` mediumint DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bundle_id_index` (`bundle_id`),
  KEY `service_id_index` (`service_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_cart_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `cart_id` int NOT NULL,
  `variant` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `item_data` text COLLATE utf8mb4_unicode_520_ci,
  `connected_cart_item_id` int DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `connected_cart_item_id_index` (`connected_cart_item_id`),
  KEY `cart_id_index` (`cart_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_cart_meta` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `object_id` mediumint NOT NULL,
  `meta_key` varchar(110) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_carts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_intent_id` int DEFAULT NULL,
  `order_id` int DEFAULT NULL,
  `coupon_code` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `uuid_index` (`uuid`),
  KEY `order_id_index` (`order_id`),
  KEY `order_intent_id_index` (`order_intent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_custom_prices` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `agent_id` int NOT NULL,
  `service_id` int NOT NULL,
  `location_id` int NOT NULL,
  `is_price_variable` tinyint(1) DEFAULT NULL,
  `price_min` decimal(20,4) DEFAULT NULL,
  `price_max` decimal(20,4) DEFAULT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `is_deposit_required` tinyint(1) DEFAULT NULL,
  `deposit_amount` decimal(20,4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `service_id_index` (`service_id`),
  KEY `location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_customer_meta` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `object_id` mediumint NOT NULL,
  `meta_key` varchar(110) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_customer_otp_codes` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `contact_value` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `contact_type` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `delivery_method` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `otp_hash` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `expires_at` datetime NOT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'active',
  `attempts` int DEFAULT '0',
  `used_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_contact_status` (`contact_value`,`status`),
  KEY `idx_expires_status` (`expires_at`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_customers` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `avatar_image_id` int DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `account_nonse` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `google_user_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `facebook_user_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `wordpress_user_id` int DEFAULT NULL,
  `is_guest` tinyint(1) DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_520_ci,
  `admin_notes` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid_index` (`uuid`),
  KEY `email_index` (`email`),
  KEY `status_index` (`status`),
  KEY `wordpress_user_id_index` (`wordpress_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_location_categories` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `short_description` text COLLATE utf8mb4_unicode_520_ci,
  `parent_id` mediumint DEFAULT NULL,
  `selection_image_id` int DEFAULT NULL,
  `order_number` int DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_number_index` (`order_number`),
  KEY `parent_id_index` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_locations` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `full_address` text COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_id` int DEFAULT NULL,
  `order_number` int DEFAULT NULL,
  `selection_image_id` int DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_order_intents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `intent_key` varchar(55) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` int NOT NULL,
  `cart_items_data` text COLLATE utf8mb4_unicode_520_ci,
  `restrictions_data` text COLLATE utf8mb4_unicode_520_ci,
  `presets_data` text COLLATE utf8mb4_unicode_520_ci,
  `payment_data` text COLLATE utf8mb4_unicode_520_ci,
  `other_data` text COLLATE utf8mb4_unicode_520_ci,
  `order_id` int DEFAULT NULL,
  `booking_form_page_url` text COLLATE utf8mb4_unicode_520_ci,
  `total` decimal(20,4) DEFAULT NULL,
  `subtotal` decimal(20,4) DEFAULT NULL,
  `coupon_code` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `coupon_discount` decimal(20,4) DEFAULT NULL,
  `tax_total` decimal(20,4) DEFAULT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `specs_charge_amount` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `price_breakdown` text COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'new',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `intent_key_index` (`intent_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_order_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int NOT NULL,
  `invoice_number` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `due_at` datetime DEFAULT NULL,
  `payment_portion` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_key` varchar(36) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoice_number_index` (`invoice_number`),
  KEY `order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_order_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int NOT NULL,
  `variant` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `item_data` text COLLATE utf8mb4_unicode_520_ci,
  `subtotal` decimal(20,4) DEFAULT NULL,
  `total` decimal(20,4) DEFAULT NULL,
  `coupon_code` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `coupon_discount` decimal(20,4) DEFAULT NULL,
  `tax_total` decimal(20,4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_order_meta` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `object_id` mediumint NOT NULL,
  `meta_key` varchar(110) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `subtotal` decimal(20,4) DEFAULT NULL,
  `total` decimal(20,4) DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `fulfillment_status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'not_fulfilled',
  `payment_status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'not_paid',
  `source_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `source_url` text COLLATE utf8mb4_unicode_520_ci,
  `ip_address` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `customer_id` int NOT NULL,
  `customer_comment` text COLLATE utf8mb4_unicode_520_ci,
  `confirmation_code` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `price_breakdown` text COLLATE utf8mb4_unicode_520_ci,
  `coupon_code` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `coupon_discount` decimal(20,4) DEFAULT NULL,
  `tax_total` decimal(20,4) DEFAULT NULL,
  `initial_payment_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id_index` (`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_payment_requests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int NOT NULL,
  `invoice_id` int NOT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `due_at` datetime DEFAULT NULL,
  `portion` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_id_index` (`invoice_id`),
  KEY `order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_process_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `process_id` int NOT NULL,
  `object_id` int NOT NULL,
  `object_model_type` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `settings` text COLLATE utf8mb4_unicode_520_ci,
  `to_run_after_utc` datetime DEFAULT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci DEFAULT 'scheduled',
  `run_result` text COLLATE utf8mb4_unicode_520_ci,
  `process_info` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_processes` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `name` varchar(110) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `event_type` varchar(110) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_json` text COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci DEFAULT 'active',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_recurrences` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `rules` text COLLATE utf8mb4_unicode_520_ci,
  `overrides` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_service_categories` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `short_description` text COLLATE utf8mb4_unicode_520_ci,
  `parent_id` mediumint DEFAULT NULL,
  `selection_image_id` int DEFAULT NULL,
  `order_number` int DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_number_index` (`order_number`),
  KEY `parent_id_index` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_service_meta` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `object_id` mediumint NOT NULL,
  `meta_key` varchar(110) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_index` (`meta_key`),
  KEY `object_id_index` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_services` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `short_description` text COLLATE utf8mb4_unicode_520_ci,
  `is_price_variable` tinyint(1) DEFAULT NULL,
  `price_min` decimal(20,4) DEFAULT NULL,
  `price_max` decimal(20,4) DEFAULT NULL,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `deposit_amount` decimal(20,4) DEFAULT NULL,
  `is_deposit_required` tinyint(1) DEFAULT NULL,
  `duration_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `override_default_booking_status` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `duration` int NOT NULL,
  `buffer_before` int DEFAULT NULL,
  `buffer_after` int DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `order_number` int DEFAULT NULL,
  `selection_image_id` int DEFAULT NULL,
  `description_image_id` int DEFAULT NULL,
  `bg_color` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `earliest_possible_booking` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `latest_possible_booking` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `timeblock_interval` int DEFAULT NULL,
  `capacity_min` int DEFAULT NULL,
  `capacity_max` int DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `visibility` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id_index` (`category_id`),
  KEY `order_number_index` (`order_number`),
  KEY `status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_sessions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` varchar(55) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `expiration` bigint unsigned NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_settings` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `name` varchar(110) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name_index` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_step_settings` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `label` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_520_ci,
  `step` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `step_index` (`step`),
  KEY `label_index` (`label`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_steps` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `before_content` text COLLATE utf8mb4_unicode_520_ci,
  `after_content` text COLLATE utf8mb4_unicode_520_ci,
  `side_title` text COLLATE utf8mb4_unicode_520_ci,
  `side_description` text COLLATE utf8mb4_unicode_520_ci,
  `use_custom_image` tinyint(1) DEFAULT NULL,
  `custom_image_id` int DEFAULT NULL,
  `code` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `parent_step_id` smallint DEFAULT NULL,
  `position` smallint DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_transaction_intents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `intent_key` varchar(55) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_id` int NOT NULL,
  `customer_id` int DEFAULT NULL,
  `invoice_id` int DEFAULT NULL,
  `transaction_id` int DEFAULT NULL,
  `payment_data` text COLLATE utf8mb4_unicode_520_ci,
  `charge_amount` decimal(20,4) DEFAULT NULL,
  `specs_charge_amount` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_form_page_url` text COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'new',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `intent_key_index` (`intent_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_transaction_refunds` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `token` text COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` int DEFAULT NULL,
  `amount` decimal(20,4) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_transactions` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `token` text COLLATE utf8mb4_unicode_520_ci,
  `invoice_id` int DEFAULT NULL,
  `order_id` int DEFAULT NULL,
  `customer_id` int DEFAULT NULL,
  `processor` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_portion` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `kind` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `amount` decimal(20,4) DEFAULT NULL,
  `receipt_number` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_key` varchar(36) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_latepoint_work_periods` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `agent_id` int NOT NULL,
  `service_id` int NOT NULL,
  `location_id` int NOT NULL,
  `start_time` smallint NOT NULL,
  `end_time` smallint NOT NULL,
  `week_day` tinyint NOT NULL,
  `custom_date` date DEFAULT NULL,
  `chain_id` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `agent_id_index` (`agent_id`),
  KEY `service_id_index` (`service_id`),
  KEY `location_id_index` (`location_id`),
  KEY `week_day_index` (`week_day`),
  KEY `custom_date_index` (`custom_date`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=7405 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pmb_external_resources` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `external_url` varchar(511) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `copy_filename` varchar(511) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `external_url` (`external_url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pmb_project_sections` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `project_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `parent_id` bigint unsigned DEFAULT '0',
  `section_order` int NOT NULL DEFAULT '0',
  `template` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `placement` varchar(15) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'main',
  `height` smallint NOT NULL DEFAULT '0',
  `depth` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `sorted` (`project_id`,`placement`,`section_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3977 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1766 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_srfm_entries` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `form_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `logs` longtext COLLATE utf8mb4_unicode_520_ci,
  `notes` longtext COLLATE utf8mb4_unicode_520_ci,
  `submission_info` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `extras` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  KEY `idx_form_id` (`form_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_form_id_created_at_status` (`form_id`,`created_at`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_surecart_incoming_webhooks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `webhook_id` varchar(155) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  `source` varchar(155) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'surecart',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `webhook_id` (`webhook_id`),
  KEY `processed_at` (`processed_at`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_surecart_integrations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `model_name` varchar(155) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `model_id` varchar(155) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `price_id` varchar(155) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `variant_id` varchar(155) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `integration_id` varchar(155) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `provider` varchar(155) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `model_id` (`model_id`),
  KEY `integration_id` (`integration_id`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_surecart_variant_option_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `value` varchar(155) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(155) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  `product_id` varchar(155) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `account_id` varchar(155) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `value` (`value`),
  KEY `name` (`name`),
  KEY `post_id` (`post_id`),
  KEY `product_id` (`product_id`),
  KEY `account_id` (`account_id`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL,
  `ancestor_id` int unsigned NOT NULL,
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `target_post_id` bigint unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("49", "srfm_daily_scheduled_action", "complete", "2025-10-31 10:42:11", "2025-10-31 10:42:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761907331;s:18:\"\0*\0first_timestamp\";i:1759449600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761907331;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-11-06 13:24:36", "2025-11-06 13:24:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("50", "srfm_daily_scheduled_action", "complete", "2025-11-07 13:24:36", "2025-11-07 13:24:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762521876;s:18:\"\0*\0first_timestamp\";i:1759449600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762521876;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-11-13 12:26:48", "2025-11-13 12:26:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("51", "srfm_daily_scheduled_action", "complete", "2025-11-14 12:26:48", "2025-11-14 12:26:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763123208;s:18:\"\0*\0first_timestamp\";i:1759449600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763123208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-11-17 09:57:01", "2025-11-17 09:57:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("52", "srfm_daily_scheduled_action", "complete", "2025-11-18 09:57:01", "2025-11-18 09:57:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763459821;s:18:\"\0*\0first_timestamp\";i:1759449600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763459821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-11-18 10:34:04", "2025-11-18 10:34:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("53", "srfm_daily_scheduled_action", "complete", "2025-11-19 10:34:04", "2025-11-19 10:34:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763548444;s:18:\"\0*\0first_timestamp\";i:1759449600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763548444;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-11-19 10:35:56", "2025-11-19 10:35:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("54", "srfm_daily_scheduled_action", "complete", "2025-11-20 10:35:56", "2025-11-20 10:35:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763634956;s:18:\"\0*\0first_timestamp\";i:1759449600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763634956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-11-20 10:51:40", "2025-11-20 10:51:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("55", "srfm_daily_scheduled_action", "complete", "2025-11-21 10:51:40", "2025-11-21 10:51:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763722300;s:18:\"\0*\0first_timestamp\";i:1759449600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763722300;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-11-21 10:53:34", "2025-11-21 10:53:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("56", "srfm_daily_scheduled_action", "complete", "2025-11-22 10:53:34", "2025-11-22 10:53:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763808814;s:18:\"\0*\0first_timestamp\";i:1759449600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763808814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-11-25 10:20:18", "2025-11-25 10:20:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("57", "srfm_daily_scheduled_action", "complete", "2025-11-26 10:20:18", "2025-11-26 10:20:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764152418;s:18:\"\0*\0first_timestamp\";i:1759449600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764152418;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-11-27 12:45:41", "2025-11-27 12:45:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("58", "srfm_daily_scheduled_action", "complete", "2025-11-28 12:45:41", "2025-11-28 12:45:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764333941;s:18:\"\0*\0first_timestamp\";i:1759449600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764333941;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-01 13:57:11", "2025-12-01 13:57:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("59", "srfm_daily_scheduled_action", "complete", "2025-12-02 13:57:11", "2025-12-02 13:57:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764683831;s:18:\"\0*\0first_timestamp\";i:1759449600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764683831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-02 14:44:18", "2025-12-02 14:44:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("60", "srfm_daily_scheduled_action", "complete", "2025-12-03 14:44:18", "2025-12-03 14:44:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764773058;s:18:\"\0*\0first_timestamp\";i:1759449600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764773058;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2025-12-04 13:10:29", "2025-12-04 13:10:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("61", "srfm_daily_scheduled_action", "pending", "2025-12-05 13:10:29", "2025-12-05 13:10:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764940229;s:18:\"\0*\0first_timestamp\";i:1759449600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764940229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "sureforms");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "surecart/sync/product-15ce18e9-6f79-4743-b353-7545acf4a356");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "surecart/sync/product-28fbb7b8-0b24-483f-be87-3f787d221e1c");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "surecart/sync/product-cd5eab7b-9288-4019-bc76-6e676cc4f743");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "surecart/sync/product-6f0dddf0-07e3-4487-b6a4-3595a1152640");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "surecart/sync/product-0876bc78-dbdd-45a2-92fb-4ccb19683800");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "surecart/sync/product-cb9e71c0-76ae-460c-97cf-a1dfd69195ec");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "surecart/sync/product-87abb08a-bf05-4062-b2fd-af676511b512");
INSERT INTO `wp_actionscheduler_groups` VALUES("10", "surecart/sync/product-d2ddf4df-d941-46ce-ab95-c647e34ffbac");
INSERT INTO `wp_actionscheduler_groups` VALUES("11", "surecart/sync/product-f6cefacf-e353-462b-8326-79b91073bc94");
INSERT INTO `wp_actionscheduler_groups` VALUES("12", "surecart/sync/product-4350f86b-4a4a-4e69-8bce-db1b2251cbc8");
INSERT INTO `wp_actionscheduler_groups` VALUES("13", "surecart/sync/product-f3d8278e-c1b0-4660-8a6b-104a94d64411");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("79", "49", "action created", "2025-10-30 10:42:11", "2025-10-30 10:42:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("80", "49", "action started via WP Cron", "2025-11-06 13:24:36", "2025-11-06 13:24:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("81", "49", "action complete via WP Cron", "2025-11-06 13:24:36", "2025-11-06 13:24:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("82", "50", "action created", "2025-11-06 13:24:36", "2025-11-06 13:24:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("83", "50", "action started via WP Cron", "2025-11-13 12:26:48", "2025-11-13 12:26:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("84", "50", "action complete via WP Cron", "2025-11-13 12:26:48", "2025-11-13 12:26:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("85", "51", "action created", "2025-11-13 12:26:48", "2025-11-13 12:26:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("86", "51", "action started via WP Cron", "2025-11-17 09:57:00", "2025-11-17 09:57:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("87", "51", "action complete via WP Cron", "2025-11-17 09:57:01", "2025-11-17 09:57:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("88", "52", "action created", "2025-11-17 09:57:01", "2025-11-17 09:57:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("89", "52", "action started via WP Cron", "2025-11-18 10:34:04", "2025-11-18 10:34:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("90", "52", "action complete via WP Cron", "2025-11-18 10:34:04", "2025-11-18 10:34:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("91", "53", "action created", "2025-11-18 10:34:04", "2025-11-18 10:34:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("92", "53", "action started via WP Cron", "2025-11-19 10:35:56", "2025-11-19 10:35:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("93", "53", "action complete via WP Cron", "2025-11-19 10:35:56", "2025-11-19 10:35:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("94", "54", "action created", "2025-11-19 10:35:56", "2025-11-19 10:35:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("95", "54", "action started via WP Cron", "2025-11-20 10:51:40", "2025-11-20 10:51:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("96", "54", "action complete via WP Cron", "2025-11-20 10:51:40", "2025-11-20 10:51:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("97", "55", "action created", "2025-11-20 10:51:40", "2025-11-20 10:51:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("98", "55", "action started via WP Cron", "2025-11-21 10:53:34", "2025-11-21 10:53:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("99", "55", "action complete via WP Cron", "2025-11-21 10:53:34", "2025-11-21 10:53:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("100", "56", "action created", "2025-11-21 10:53:34", "2025-11-21 10:53:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("101", "56", "action started via WP Cron", "2025-11-25 10:20:18", "2025-11-25 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("102", "56", "action complete via WP Cron", "2025-11-25 10:20:18", "2025-11-25 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("103", "57", "action created", "2025-11-25 10:20:18", "2025-11-25 10:20:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("104", "57", "action started via WP Cron", "2025-11-27 12:45:41", "2025-11-27 12:45:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("105", "57", "action complete via WP Cron", "2025-11-27 12:45:41", "2025-11-27 12:45:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("106", "58", "action created", "2025-11-27 12:45:41", "2025-11-27 12:45:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("107", "58", "action started via WP Cron", "2025-12-01 13:57:11", "2025-12-01 13:57:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("108", "58", "action complete via WP Cron", "2025-12-01 13:57:11", "2025-12-01 13:57:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("109", "59", "action created", "2025-12-01 13:57:11", "2025-12-01 13:57:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("110", "59", "action started via WP Cron", "2025-12-02 14:44:18", "2025-12-02 14:44:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("111", "59", "action complete via WP Cron", "2025-12-02 14:44:18", "2025-12-02 14:44:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("112", "60", "action created", "2025-12-02 14:44:18", "2025-12-02 14:44:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("113", "60", "action started via WP Cron", "2025-12-04 13:10:29", "2025-12-04 13:10:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("114", "60", "action complete via WP Cron", "2025-12-04 13:10:29", "2025-12-04 13:10:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("115", "61", "action created", "2025-12-04 13:10:29", "2025-12-04 13:10:29");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2025-10-02 09:52:54", "2025-10-02 09:52:54", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.", "0", "post-trashed", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20251127_centredetudetechniqueenviron", "96deb6d3d383ae353554_20251127135059", "100", "2025-11-27 13:51:56", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-27 13:50:59\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.27\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:1;s:4:\"Name\";s:37:\"20251127_centredetudetechniqueenviron\";s:4:\"Hash\";s:35:\"96deb6d3d383ae353554_20251127135059\";s:8:\"NameHash\";s:73:\"20251127_centredetudetechniqueenviron_96deb6d3d383ae353554_20251127135059\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:83:\"20251127_centredetudetechniqueenviron_96deb6d3d383ae353554_20251127135059_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:11:\"374.95 sec.\";s:7:\"ExeSize\";s:7:\"73.51KB\";s:7:\"ZipSize\";s:8:\"853.26MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:85:\"20251127_centredetudetechniqueenviron_96deb6d3d383ae353554_20251127135059_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:54:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public\";s:4:\"Size\";i:894712297;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:4047;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:23020;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:27066;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:63:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-admin\";i:1;s:66:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-includes\";i:2;s:75:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:54:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public\";i:1;s:54:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public\";i:2;s:65:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content\";i:3;s:73:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/uploads\";i:4;s:73:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/plugins\";i:5;s:76:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/mu-plugins\";i:6;s:72:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:86:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:91:\"20251127_centredetudetechniqueenviron_96deb6d3d383ae353554_20251127135059_installer.php.bak\";s:4:\"Size\";i:75273;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:138:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/backups-dup-lite/tmp/original_files_96deb6d-27135059/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:118:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/backups-dup-lite/tmp/original_files_96deb6d-27135059\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:54:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:68:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3486:\"<?php\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the web site, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * Database settings\n * * Secret keys\n * * Database table prefix\n * * Localized language\n * * ABSPATH\n *\n * @link https://wordpress.org/support/article/editing-wp-config-php/\n *\n * @package WordPress\n */\n\n// ** Database settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'local\' );\n\n/** Database username */\ndefine( \'DB_USER\', \'root\' );\n\n/** Database password */\ndefine( \'DB_PASSWORD\', \'root\' );\n\n/** Database hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8\' );\n\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine( \'AUTH_KEY\',          \'s=6A3>5*eO*blL#&y?-r4(R;,m&T*G9Whzm-@riql1fZ*k4o}nqBKXBsz5AjB   \' );\ndefine( \'SECURE_AUTH_KEY\',   \'5!3qub0OW-O.#Wg@OeyoamsxL}Ib$=YOP0>;kBUdj3fJI*6:$*&&Y&RZtd;TvfWL\' );\ndefine( \'LOGGED_IN_KEY\',     \'C&8I~hW5]m}$4<D,oEL1.$eu/^L|_&rr,T^`>{6Y=Mh8lgXq4CHAs+y&$`(g46v7\' );\ndefine( \'NONCE_KEY\',         \'AI<ZqX@>UX&?d;$-u>b%}[RQ[4p%|04cJ!fYC,y>Uc]dqraSa+wStxQO{7^P(!tt\' );\ndefine( \'AUTH_SALT\',         \'T8Rd3d.,4Vm&a=zNMZ$Yv]:?`&Y:[Ob{`.m%[J@~`hN(?JTy]hB+zeopg_{&Vkio\' );\ndefine( \'SECURE_AUTH_SALT\',  \'jkqGZ#gOXfe- JOe[;$@S*`yJ+blZgLLi}R!ttRbEMh|P@y:qVd%7Y<20Q%<Wbsk\' );\ndefine( \'LOGGED_IN_SALT\',    \'+0bE#P!^fpx=n]MhcaU>z.g}0z Gd/*4,F;)H,R[io0nl*9I:&_h3I^${!Q@SjN{\' );\ndefine( \'NONCE_SALT\',        \';{{,^`CxWdv@(zAB3TKMnf8 R+{8!~zyfk,JrSsA*p*>Q(V*4=9zU_3H:pd]iisN\' );\ndefine( \'WP_CACHE_KEY_SALT\', \'<kkl% N!Q:].,,r04fO4u^Q*~LMa%WON0DmW}G9TPRs}h{NSI@XXKA^~]w?)}7o&\' );\n\n\n/**#@-*/\n\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n */\n$table_prefix = \'wp_\';\n\n\n/* Add any custom values between this line and the \"stop editing\" line. */\n\n\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://wordpress.org/support/article/debugging-in-wordpress/\n */\nif ( ! defined( \'WP_DEBUG\' ) ) {\n	define( \'WP_DEBUG\', false );\n}\n\ndefine( \'WP_ENVIRONMENT_TYPE\', \'local\' );\ndefine( \'SURECART_ENCRYPTION_KEY\', \'C&8I~hW5]m}$4<D,oEL1.$eu/^L|_&rr,T^`>{6Y=Mh8lgXq4CHAs+y&$`(g46v7\' );\n/* That\'s all, stop editing! Happy publishing. */\n\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:19:{s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:29:\"define( \'DB_NAME\', \'local\' );\";s:5:\"value\";s:7:\"\'local\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:10:\", \'local\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:28:\"define( \'DB_USER\', \'root\' );\";s:5:\"value\";s:6:\"\'root\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:9:\", \'root\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:32:\"define( \'DB_PASSWORD\', \'root\' );\";s:5:\"value\";s:6:\"\'root\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:9:\", \'root\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:31:\"define( \'DB_CHARSET\', \'utf8\' );\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:9:\", \'utf8\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'AUTH_KEY\',          \'s=6A3>5*eO*blL#&y?-r4(R;,m&T*G9Whzm-@riql1fZ*k4o}nqBKXBsz5AjB   \' );\";s:5:\"value\";s:66:\"\'s=6A3>5*eO*blL#&y?-r4(R;,m&T*G9Whzm-@riql1fZ*k4o}nqBKXBsz5AjB   \'\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'AUTH_KEY\'\";i:1;s:78:\",          \'s=6A3>5*eO*blL#&y?-r4(R;,m&T*G9Whzm-@riql1fZ*k4o}nqBKXBsz5AjB   \' \";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'SECURE_AUTH_KEY\',   \'5!3qub0OW-O.#Wg@OeyoamsxL}Ib$=YOP0>;kBUdj3fJI*6:$*&&Y&RZtd;TvfWL\' );\";s:5:\"value\";s:66:\"\'5!3qub0OW-O.#Wg@OeyoamsxL}Ib$=YOP0>;kBUdj3fJI*6:$*&&Y&RZtd;TvfWL\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'SECURE_AUTH_KEY\'\";i:1;s:71:\",   \'5!3qub0OW-O.#Wg@OeyoamsxL}Ib$=YOP0>;kBUdj3fJI*6:$*&&Y&RZtd;TvfWL\' \";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'LOGGED_IN_KEY\',     \'C&8I~hW5]m}$4<D,oEL1.$eu/^L|_&rr,T^`>{6Y=Mh8lgXq4CHAs+y&$`(g46v7\' );\";s:5:\"value\";s:66:\"\'C&8I~hW5]m}$4<D,oEL1.$eu/^L|_&rr,T^`>{6Y=Mh8lgXq4CHAs+y&$`(g46v7\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define( \'LOGGED_IN_KEY\'\";i:1;s:73:\",     \'C&8I~hW5]m}$4<D,oEL1.$eu/^L|_&rr,T^`>{6Y=Mh8lgXq4CHAs+y&$`(g46v7\' \";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:98:\"define( \'NONCE_KEY\',         \'AI<ZqX@>UX&?d;$-u>b%}[RQ[4p%|04cJ!fYC,y>Uc]dqraSa+wStxQO{7^P(!tt\' );\";s:5:\"value\";s:66:\"\'AI<ZqX@>UX&?d;$-u>b%}[RQ[4p%|04cJ!fYC,y>Uc]dqraSa+wStxQO{7^P(!tt\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'NONCE_KEY\'\";i:1;s:77:\",         \'AI<ZqX@>UX&?d;$-u>b%}[RQ[4p%|04cJ!fYC,y>Uc]dqraSa+wStxQO{7^P(!tt\' \";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'AUTH_SALT\',         \'T8Rd3d.,4Vm&a=zNMZ$Yv]:?`&Y:[Ob{`.m%[J@~`hN(?JTy]hB+zeopg_{&Vkio\' );\";s:5:\"value\";s:66:\"\'T8Rd3d.,4Vm&a=zNMZ$Yv]:?`&Y:[Ob{`.m%[J@~`hN(?JTy]hB+zeopg_{&Vkio\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'AUTH_SALT\'\";i:1;s:77:\",         \'T8Rd3d.,4Vm&a=zNMZ$Yv]:?`&Y:[Ob{`.m%[J@~`hN(?JTy]hB+zeopg_{&Vkio\' \";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'SECURE_AUTH_SALT\',  \'jkqGZ#gOXfe- JOe[;$@S*`yJ+blZgLLi}R!ttRbEMh|P@y:qVd%7Y<20Q%<Wbsk\' );\";s:5:\"value\";s:66:\"\'jkqGZ#gOXfe- JOe[;$@S*`yJ+blZgLLi}R!ttRbEMh|P@y:qVd%7Y<20Q%<Wbsk\'\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'SECURE_AUTH_SALT\'\";i:1;s:70:\",  \'jkqGZ#gOXfe- JOe[;$@S*`yJ+blZgLLi}R!ttRbEMh|P@y:qVd%7Y<20Q%<Wbsk\' \";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'LOGGED_IN_SALT\',    \'+0bE#P!^fpx=n]MhcaU>z.g}0z Gd/*4,F;)H,R[io0nl*9I:&_h3I^${!Q@SjN{\' );\";s:5:\"value\";s:66:\"\'+0bE#P!^fpx=n]MhcaU>z.g}0z Gd/*4,F;)H,R[io0nl*9I:&_h3I^${!Q@SjN{\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define( \'LOGGED_IN_SALT\'\";i:1;s:72:\",    \'+0bE#P!^fpx=n]MhcaU>z.g}0z Gd/*4,F;)H,R[io0nl*9I:&_h3I^${!Q@SjN{\' \";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'NONCE_SALT\',        \';{{,^`CxWdv@(zAB3TKMnf8 R+{8!~zyfk,JrSsA*p*>Q(V*4=9zU_3H:pd]iisN\' );\";s:5:\"value\";s:66:\"\';{{,^`CxWdv@(zAB3TKMnf8 R+{8!~zyfk,JrSsA*p*>Q(V*4=9zU_3H:pd]iisN\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'NONCE_SALT\'\";i:1;s:76:\",        \';{{,^`CxWdv@(zAB3TKMnf8 R+{8!~zyfk,JrSsA*p*>Q(V*4=9zU_3H:pd]iisN\' \";i:2;s:2:\");\";}}s:17:\"WP_CACHE_KEY_SALT\";a:3:{s:3:\"src\";s:98:\"define( \'WP_CACHE_KEY_SALT\', \'<kkl% N!Q:].,,r04fO4u^Q*~LMa%WON0DmW}G9TPRs}h{NSI@XXKA^~]w?)}7o&\' );\";s:5:\"value\";s:66:\"\'<kkl% N!Q:].,,r04fO4u^Q*~LMa%WON0DmW}G9TPRs}h{NSI@XXKA^~]w?)}7o&\'\";s:5:\"parts\";a:3:{i:0;s:27:\"define( \'WP_CACHE_KEY_SALT\'\";i:1;s:69:\", \'<kkl% N!Q:].,,r04fO4u^Q*~LMa%WON0DmW}G9TPRs}h{NSI@XXKA^~]w?)}7o&\' \";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:29:\"	define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:19:\"	define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:19:\"WP_ENVIRONMENT_TYPE\";a:3:{s:3:\"src\";s:41:\"define( \'WP_ENVIRONMENT_TYPE\', \'local\' );\";s:5:\"value\";s:7:\"\'local\'\";s:5:\"parts\";a:3:{i:0;s:29:\"define( \'WP_ENVIRONMENT_TYPE\'\";i:1;s:10:\", \'local\' \";i:2;s:2:\");\";}}s:23:\"SURECART_ENCRYPTION_KEY\";a:3:{s:3:\"src\";s:104:\"define( \'SURECART_ENCRYPTION_KEY\', \'C&8I~hW5]m}$4<D,oEL1.$eu/^L|_&rr,T^`>{6Y=Mh8lgXq4CHAs+y&$`(g46v7\' );\";s:5:\"value\";s:66:\"\'C&8I~hW5]m}$4<D,oEL1.$eu/^L|_&rr,T^`>{6Y=Mh8lgXq4CHAs+y&$`(g46v7\'\";s:5:\"parts\";a:3:{i:0;s:33:\"define( \'SURECART_ENCRYPTION_KEY\'\";i:1;s:69:\", \'C&8I~hW5]m}$4<D,oEL1.$eu/^L|_&rr,T^`>{6Y=Mh8lgXq4CHAs+y&$`(g46v7\' \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:18320908;s:4:\"File\";s:86:\"20251127_centredetudetechniqueenviron_96deb6d3d383ae353554_20251127135059_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:2:{i:0;s:7:\"utf8mb4\";i:1;s:7:\"utf8mb3\";}s:13:\"collationList\";a:2:{i:0;s:18:\"utf8mb3_general_ci\";i:1;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:1:{i:0;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:5:\"local\";s:15:\"tablesBaseCount\";i:68;s:16:\"tablesFinalCount\";i:68;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:2581;s:16:\"tablesSizeOnDisk\";i:24903680;s:10:\"tablesList\";a:68:{s:26:\"wp_actionscheduler_actions\";a:3:{s:14:\"inaccurateRows\";i:13;s:12:\"insertedRows\";i:13;s:4:\"size\";i:131072;}s:25:\"wp_actionscheduler_claims\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:25:\"wp_actionscheduler_groups\";a:3:{s:14:\"inaccurateRows\";i:13;s:12:\"insertedRows\";i:13;s:4:\"size\";i:32768;}s:23:\"wp_actionscheduler_logs\";a:3:{s:14:\"inaccurateRows\";i:34;s:12:\"insertedRows\";i:37;s:4:\"size\";i:49152;}s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:98304;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:11:\"wp_e_events\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:23:\"wp_latepoint_activities\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:23:\"wp_latepoint_agent_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:19:\"wp_latepoint_agents\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:28:\"wp_latepoint_agents_services\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:28:\"wp_latepoint_blocked_periods\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:25:\"wp_latepoint_booking_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"wp_latepoint_bookings\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:147456;}s:24:\"wp_latepoint_bundle_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:20:\"wp_latepoint_bundles\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:29:\"wp_latepoint_bundles_services\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:23:\"wp_latepoint_cart_items\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:22:\"wp_latepoint_cart_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:18:\"wp_latepoint_carts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:26:\"wp_latepoint_custom_prices\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:26:\"wp_latepoint_customer_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:31:\"wp_latepoint_customer_otp_codes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:22:\"wp_latepoint_customers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:32:\"wp_latepoint_location_categories\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:22:\"wp_latepoint_locations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:26:\"wp_latepoint_order_intents\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:27:\"wp_latepoint_order_invoices\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:24:\"wp_latepoint_order_items\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:23:\"wp_latepoint_order_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:19:\"wp_latepoint_orders\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:29:\"wp_latepoint_payment_requests\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:25:\"wp_latepoint_process_jobs\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:22:\"wp_latepoint_processes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:24:\"wp_latepoint_recurrences\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:31:\"wp_latepoint_service_categories\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:25:\"wp_latepoint_service_meta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"wp_latepoint_services\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:21:\"wp_latepoint_sessions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:21:\"wp_latepoint_settings\";a:3:{s:14:\"inaccurateRows\";i:8;s:12:\"insertedRows\";i:10;s:4:\"size\";i:32768;}s:26:\"wp_latepoint_step_settings\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:18:\"wp_latepoint_steps\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:32:\"wp_latepoint_transaction_intents\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:32:\"wp_latepoint_transaction_refunds\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:25:\"wp_latepoint_transactions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:25:\"wp_latepoint_work_periods\";a:3:{s:14:\"inaccurateRows\";i:7;s:12:\"insertedRows\";i:7;s:4:\"size\";i:98304;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:356;s:12:\"insertedRows\";i:364;s:4:\"size\";i:4276224;}s:25:\"wp_pmb_external_resources\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:23:\"wp_pmb_project_sections\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:1639;s:12:\"insertedRows\";i:1738;s:4:\"size\";i:4440064;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:357;s:12:\"insertedRows\";i:463;s:4:\"size\";i:12828672;}s:15:\"wp_srfm_entries\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:29:\"wp_surecart_incoming_webhooks\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:24:\"wp_surecart_integrations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:33:\"wp_surecart_variant_option_values\";a:3:{s:14:\"inaccurateRows\";i:11;s:12:\"insertedRows\";i:11;s:4:\"size\";i:131072;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:39;s:12:\"insertedRows\";i:40;s:4:\"size\";i:32768;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:16;s:12:\"insertedRows\";i:18;s:4:\"size\";i:49152;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:15;s:12:\"insertedRows\";i:17;s:4:\"size\";i:49152;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:16;s:12:\"insertedRows\";i:18;s:4:\"size\";i:49152;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:33;s:12:\"insertedRows\";i:35;s:4:\"size\";i:49152;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:18:\"wp_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:114688;}s:28:\"wp_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:19:\"wp_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:24;s:12:\"insertedRows\";i:24;s:4:\"size\";i:32768;}s:21:\"wp_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:18:\"wp_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}}s:19:\"lowerCaseTableNames\";i:1;s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.35\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:173:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/backups-dup-lite/tmp/20251127_centredetudetechniqueenviron_96deb6d3d383ae353554_20251127135059_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-27 13:50:59\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.27\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:37:\"20251127_centredetudetechniqueenviron\";s:4:\"Hash\";s:35:\"96deb6d3d383ae353554_20251127135059\";s:8:\"NameHash\";s:73:\"20251127_centredetudetechniqueenviron_96deb6d3d383ae353554_20251127135059\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:248;s:13:\"BuildProgress\";r:564;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("2", "20251127_centredetudetechniqueenviron", "765e85aef73f48c04872_20251204133148", "20", "2025-12-04 13:32:20", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-04 13:31:48\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.27\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:2;s:4:\"Name\";s:37:\"20251127_centredetudetechniqueenviron\";s:4:\"Hash\";s:35:\"765e85aef73f48c04872_20251204133148\";s:8:\"NameHash\";s:73:\"20251127_centredetudetechniqueenviron_765e85aef73f48c04872_20251204133148\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:83:\"20251127_centredetudetechniqueenviron_765e85aef73f48c04872_20251204133148_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.9\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:85:\"20251127_centredetudetechniqueenviron_765e85aef73f48c04872_20251204133148_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:54:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:4064;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:23136;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-04 13:31:48\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:6:\"8.0.35\";s:10:\"VersionPHP\";s:6:\"8.2.27\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:37:\"20251127_centredetudetechniqueenviron\";s:4:\"Hash\";s:35:\"765e85aef73f48c04872_20251204133148\";s:8:\"NameHash\";s:73:\"20251127_centredetudetechniqueenviron_765e85aef73f48c04872_20251204133148\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:91:\"20251127_centredetudetechniqueenviron_765e85aef73f48c04872_20251204133148_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:68:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:86:\"20251127_centredetudetechniqueenviron_765e85aef73f48c04872_20251204133148_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:173:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/backups-dup-lite/tmp/20251127_centredetudetechniqueenviron_765e85aef73f48c04872_20251204133148_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:63:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-admin\";i:1;s:66:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-includes\";i:2;s:75:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:54:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public\";i:1;s:54:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public\";i:2;s:65:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content\";i:3;s:73:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/uploads\";i:4;s:73:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/plugins\";i:5;s:76:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/mu-plugins\";i:6;s:72:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:86:\"C:/Users/Secretariat/Local Sites/cetef-test/app/public/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_latepoint_locations */
INSERT INTO `wp_latepoint_locations` VALUES("1", "Main Location", NULL, "active", "0", NULL, NULL, "2025-10-02 13:43:58", "2025-10-02 13:43:58");

/* INSERT TABLE DATA: wp_latepoint_processes */
INSERT INTO `wp_latepoint_processes` VALUES("1", "New Booking Notification", "booking_created", "[{\"type\":\"group\",\"trigger_condition\":false,\"items\":[{\"type\":\"action\",\"id\":\"pa_ASD3Yj\",\"settings\":{\"status\":\"active\",\"type\":\"send_email\",\"settings\":{\"to_email\":\"{{agent_full_name}} <{{agent_email}}>\",\"subject\":\"New Appointment Received\",\"content\":\"<div style=\\\"padding: 20px; background-color: #f0f0f0; font-family: -apple-system, system-ui, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\\"Helvetica Neue\\\", Arial, sans-serif;\\\">\\n\\t<div style=\\\"background-color: #fff; padding: 30px; margin: 0px auto; max-width: 450px; box-shadow: 0px 2px 6px -1px rgba(0,0,0,0.2); border-radius: 6px;\\\">\\n\\t\\t<div style=\\\"margin: 0px auto 30px auto; border-bottom: 1px solid #eee; padding-bottom: 20px;\\\">\\n\\t\\t\\t<table style=\\\"width: 100%;\\\">\\n\\t\\t\\t\\t<tr>\\n\\t\\t\\t\\t\\t<td>{{business_logo_image}}<\\/td>\\n\\t\\t\\t\\t\\t<td style=\\\"text-align: right;\\\"><span style=\\\"color: #7b7b7b;\\\">Questions?<\\/span><br\\/><strong>{{business_phone}}<\\/strong><\\/td>\\n\\t\\t\\t\\t<\\/tr>\\n\\t\\t\\t<\\/table>\\n\\t\\t<\\/div>\\n\\t\\t<div style=\\\"font-size: 16px; line-height: 1.5;\\\">\\n\\t\\t\\t<div style=\\\"font-size: 16px; margin-bottom: 20px; line-height: 1.6;\\\">\\n\\tHi {{agent_full_name}},\\n\\t<br\\/><br\\/>\\n\\tYou have received a new appointment request from {{customer_full_name}}\\n<\\/div>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Customer Information<\\/h4>\\n<ul>\\n\\t<li>\\n\\t\\t<span>Full Name:<\\/span> <strong>{{customer_full_name}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Email Address:<\\/span> <strong>{{customer_email}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Phone:<\\/span> <strong>{{customer_phone}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Comments:<\\/span> <strong>{{customer_notes}}<\\/strong>\\n\\t<\\/li>\\n<\\/ul>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Appointment Information<\\/h4>\\n<ul>\\n\\t<li>\\n\\t\\t<span>Service:<\\/span> <strong>{{service_name}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Date, Time:<\\/span> <strong>{{start_date}}, {{start_time}} - {{end_time}}<\\/strong>\\n\\t<\\/li>\\n<\\/ul>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Order Summary<\\/h4>\\n<div style=\\\"margin-bottom: 20px;\\\">{{order_summary_breakdown}}<\\/div>\\n<div style=\\\"margin-top: 25px;\\\">\\n\\t<a href=\\\"{{manage_booking_url_agent}}\\\" style=\\\"display: block; text-decoration: none; padding: 10px; border-radius: 6px; text-align: center; font-size: 18px; color: #fff; background-color: #1e7bff; font-weight: 700;\\\">Manage This Appointment<\\/a>\\n<\\/div>\\n\\t\\t<\\/div>\\n\\t<\\/div>\\n\\t<div style=\\\"max-width: 450px; margin: 10px auto; text-align: center;\\\">{{business_address}}<\\/div>\\n<\\/div>\"}}},{\"type\":\"action\",\"id\":\"pa_juiXWp\",\"settings\":{\"status\":\"active\",\"type\":\"send_email\",\"settings\":{\"to_email\":\"{{customer_full_name}} <{{customer_email}}>\",\"subject\":\"Appointment Confirmation\",\"content\":\"<div style=\\\"padding: 20px; background-color: #f0f0f0; font-family: -apple-system, system-ui, BlinkMacSystemFont, \\\"Segoe UI\\\", Roboto, \\\"Helvetica Neue\\\", Arial, sans-serif;\\\">\\n\\t<div style=\\\"background-color: #fff; padding: 30px; margin: 0px auto; max-width: 450px; box-shadow: 0px 2px 6px -1px rgba(0,0,0,0.2); border-radius: 6px;\\\">\\n\\t\\t<div style=\\\"margin: 0px auto 30px auto; border-bottom: 1px solid #eee; padding-bottom: 20px;\\\">\\n\\t\\t\\t<table style=\\\"width: 100%;\\\">\\n\\t\\t\\t\\t<tr>\\n\\t\\t\\t\\t\\t<td>{{business_logo_image}}<\\/td>\\n\\t\\t\\t\\t\\t<td style=\\\"text-align: right;\\\"><span style=\\\"color: #7b7b7b;\\\">Questions?<\\/span><br\\/><strong>{{business_phone}}<\\/strong><\\/td>\\n\\t\\t\\t\\t<\\/tr>\\n\\t\\t\\t<\\/table>\\n\\t\\t<\\/div>\\n\\t\\t<div style=\\\"font-size: 16px; line-height: 1.5;\\\">\\n\\t\\t\\t<div style=\\\"font-size: 16px; margin-bottom: 20px; line-height: 1.6;\\\">\\n\\tHi {{customer_full_name}},\\n\\t<br>\\n\\t<br>\\n\\tYour {{service_name}} appointment with <strong>{{agent_full_name}}<\\/strong> is <strong>{{booking_status}}<\\/strong>.\\n<\\/div>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Appointment Details:<\\/h4>\\n<ul>\\n\\t<li>\\n\\t\\t<span>Agent:<\\/span> <strong>{{agent_full_name}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Service:<\\/span> <strong>{{service_name}}<\\/strong>\\n\\t<\\/li>\\n\\t<li>\\n\\t\\t<span>Date, Time:<\\/span> <strong>{{start_date}}, {{start_time}} - {{end_time}}<\\/strong>\\n\\t<\\/li>\\n<\\/ul>\\n<h4 style=\\\"margin-bottom: 10px; margin-top: 0px; font-size: 16px; font-weight: bold;\\\">Order Summary<\\/h4>\\n<div style=\\\"margin-bottom: 20px;\\\">{{order_summary_breakdown}}<\\/div>\\n<div style=\\\"margin-top: 25px;\\\">\\n\\t<a href=\\\"{{manage_booking_url_customer}}\\\" style=\\\"display: block; text-decoration: none; padding: 10px; border-radius: 6px; text-align: center; font-size: 18px; color: #fff; background-color: #1e7bff; font-weight: 700;\\\">Manage This Appointment<\\/a>\\n<\\/div>\\n\\t\\t<\\/div>\\n\\t<\\/div>\\n\\t<div style=\\\"max-width: 450px; margin: 10px auto; text-align: center;\\\">{{business_address}}<\\/div>\\n<\\/div>\"}}}],\"time_offset\":[]}]", "active", "2025-10-02 13:43:57", "2025-10-02 13:43:57");

/* INSERT TABLE DATA: wp_latepoint_settings */
INSERT INTO `wp_latepoint_settings` VALUES("1", "default_booking_status", "approved", "2025-10-02 13:43:57", "2025-10-02 13:43:57");
INSERT INTO `wp_latepoint_settings` VALUES("2", "timeslot_blocking_statuses", "approved", "2025-10-02 13:43:57", "2025-10-02 13:43:57");
INSERT INTO `wp_latepoint_settings` VALUES("3", "calendar_hidden_statuses", "cancelled", "2025-10-02 13:43:57", "2025-10-02 13:43:57");
INSERT INTO `wp_latepoint_settings` VALUES("4", "need_action_statuses", "pending,payment_pending", "2025-10-02 13:43:57", "2025-10-02 13:43:57");
INSERT INTO `wp_latepoint_settings` VALUES("5", "is_database_seeded", "1", "2025-10-02 13:43:57", "2025-10-02 13:43:57");
INSERT INTO `wp_latepoint_settings` VALUES("6", "page_url_customer_dashboard", "/customer-cabinet", "2025-10-02 13:43:58", "2025-10-02 13:43:58");
INSERT INTO `wp_latepoint_settings` VALUES("7", "page_url_customer_login", "/customer-cabinet", "2025-10-02 13:43:58", "2025-10-02 13:43:58");
INSERT INTO `wp_latepoint_settings` VALUES("8", "selected_customer_authentication_field_type", "email", "2025-10-02 13:43:58", "2025-10-02 13:43:58");
INSERT INTO `wp_latepoint_settings` VALUES("9", "step_codes_in_order", "booking__services,booking__agents,booking__datepicker,customer,verify,payment__times,payment__portions,payment__methods,payment__processors,payment__pay,confirmation", "2025-10-02 13:47:16", "2025-10-02 13:47:16");
INSERT INTO `wp_latepoint_settings` VALUES("10", "steps_settings", "a:12:{s:6:\"shared\";a:1:{s:18:\"steps_support_text\";s:54:\"<h5>Questions?</h5><p>Call (858) 939-3746 for help</p>\";}s:17:\"booking__services\";a:3:{s:18:\"side_panel_heading\";s:17:\"Service Selection\";s:22:\"side_panel_description\";s:69:\"Please select a service for which you want to schedule an appointment\";s:18:\"main_panel_heading\";s:18:\"Available Services\";}s:15:\"booking__agents\";a:3:{s:18:\"side_panel_heading\";s:15:\"Agent Selection\";s:22:\"side_panel_description\";s:59:\"Please select an agent that will be providing you a service\";s:18:\"main_panel_heading\";s:16:\"Available Agents\";}s:19:\"booking__datepicker\";a:3:{s:18:\"side_panel_heading\";s:18:\"Select Date & Time\";s:22:\"side_panel_description\";s:48:\"Please select date and time for your appointment\";s:18:\"main_panel_heading\";s:21:\"Date & Time Selection\";}s:8:\"customer\";a:3:{s:18:\"side_panel_heading\";s:22:\"Enter Your Information\";s:22:\"side_panel_description\";s:37:\"Please enter your contact information\";s:18:\"main_panel_heading\";s:20:\"Customer Information\";}s:6:\"verify\";a:3:{s:18:\"side_panel_heading\";s:20:\"Verify Order Details\";s:22:\"side_panel_description\";s:86:\"Double check your reservation details and click submit button if everything is correct\";s:18:\"main_panel_heading\";s:20:\"Verify Order Details\";}s:14:\"payment__times\";a:3:{s:18:\"side_panel_heading\";s:22:\"Payment Time Selection\";s:22:\"side_panel_description\";s:61:\"Please choose when you would like to pay for your appointment\";s:18:\"main_panel_heading\";s:27:\"When would you like to pay?\";}s:17:\"payment__portions\";a:3:{s:18:\"side_panel_heading\";s:25:\"Payment Portion Selection\";s:22:\"side_panel_description\";s:48:\"Please select how much you would like to pay now\";s:18:\"main_panel_heading\";s:35:\"How much would you like to pay now?\";}s:16:\"payment__methods\";a:3:{s:18:\"side_panel_heading\";s:24:\"Payment Method Selection\";s:22:\"side_panel_description\";s:68:\"Please select a payment method you would like to make a payment with\";s:18:\"main_panel_heading\";s:21:\"Select payment method\";}s:19:\"payment__processors\";a:3:{s:18:\"side_panel_heading\";s:27:\"Payment Processor Selection\";s:22:\"side_panel_description\";s:70:\"Please select a payment processor you want to process the payment with\";s:18:\"main_panel_heading\";s:24:\"Select payment processor\";}s:12:\"payment__pay\";a:3:{s:18:\"side_panel_heading\";s:14:\"Make a Payment\";s:22:\"side_panel_description\";s:67:\"Please enter your payment information so we can process the payment\";s:18:\"main_panel_heading\";s:30:\"Enter your payment information\";}s:12:\"confirmation\";a:3:{s:18:\"side_panel_heading\";s:12:\"Confirmation\";s:22:\"side_panel_description\";s:76:\"Your order has been placed. Please retain this confirmation for your record.\";s:18:\"main_panel_heading\";s:18:\"Order Confirmation\";}}", "2025-10-02 13:47:16", "2025-10-02 13:47:16");

/* INSERT TABLE DATA: wp_latepoint_work_periods */
INSERT INTO `wp_latepoint_work_periods` VALUES("1", "0", "0", "0", "480", "1020", "1", NULL, NULL, "2025-10-07 13:21:01", "2025-10-07 13:21:01");
INSERT INTO `wp_latepoint_work_periods` VALUES("2", "0", "0", "0", "480", "1020", "2", NULL, NULL, "2025-10-07 13:21:01", "2025-10-07 13:21:01");
INSERT INTO `wp_latepoint_work_periods` VALUES("3", "0", "0", "0", "480", "1020", "3", NULL, NULL, "2025-10-07 13:21:01", "2025-10-07 13:21:01");
INSERT INTO `wp_latepoint_work_periods` VALUES("4", "0", "0", "0", "480", "1020", "4", NULL, NULL, "2025-10-07 13:21:01", "2025-10-07 13:21:01");
INSERT INTO `wp_latepoint_work_periods` VALUES("5", "0", "0", "0", "480", "1020", "5", NULL, NULL, "2025-10-07 13:21:01", "2025-10-07 13:21:01");
INSERT INTO `wp_latepoint_work_periods` VALUES("6", "0", "0", "0", "480", "1020", "6", NULL, NULL, "2025-10-07 13:21:01", "2025-10-07 13:21:01");
INSERT INTO `wp_latepoint_work_periods` VALUES("7", "0", "0", "0", "480", "1020", "7", NULL, NULL, "2025-10-07 13:21:01", "2025-10-07 13:21:01");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:20:{i:1764855186;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1764855789;a:1:{s:30:\"surerank_generate_sitemap_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:15:\"every_six_hours\";s:4:\"args\";a:0:{}s:8:\"interval\";i:21600;}}}i:1764855817;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764855818;a:1:{s:29:\"wpseo_detect_default_seo_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764855838;a:2:{s:42:\"latepoint_check_if_addons_update_available\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:33:\"latepoint_clear_old_activity_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764856375;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1764885230;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764888774;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764890574;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764892374;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764928375;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764928430;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764928432;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764939485;a:1:{s:26:\"wpcode_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764941019;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765021135;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765202400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765447357;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765450724;a:1:{s:25:\"wpseo_llms_txt_population\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "http://cetef-test.local", "on");
INSERT INTO `wp_options` VALUES("3", "home", "http://cetef-test.local", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "Centre d&#039;Etude Technique Environnemental et Forestier", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "Le CETEF, votre partenaire de confiance pour valoriser bois et forêts", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "contact@cetefnouvelle-aquitaine.org", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:12:{i:0;s:27:\"astra-sites/astra-sites.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:23:\"elementor/elementor.php\";i:3;s:37:\"elementskit-lite/elementskit-lite.php\";i:4;s:35:\"insert-headers-and-footers/ihaf.php\";i:5;s:23:\"latepoint/latepoint.php\";i:6;s:29:\"print-my-blog/printmyblog.php\";i:7;s:21:\"surecart/surecart.php\";i:8;s:23:\"sureforms/sureforms.php\";i:9;s:21:\"surerank/surerank.php\";i:10;s:63:\"ultimate-addons-for-gutenberg/ultimate-addons-for-gutenberg.php\";i:11;s:24:\"wordpress-seo/wp-seo.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "astra", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "astra", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "60717", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:3:{s:21:\"surecart/surecart.php\";s:18:\"surecart_uninstall\";s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "1072", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "743", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "0", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1774950774", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "60421", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:13:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:286:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;s:26:\"manage_ast_block_templates\";b:1;s:20:\"view_sc_shop_reports\";b:1;s:27:\"view_sc_shop_sensitive_data\";b:1;s:22:\"export_sc_shop_reports\";b:1;s:23:\"manage_sc_shop_settings\";b:1;s:26:\"manage_sc_account_settings\";b:1;s:14:\"read_sc_coupon\";b:1;s:15:\"read_sc_coupons\";b:1;s:16:\"delete_sc_coupon\";b:1;s:14:\"edit_sc_coupon\";b:1;s:15:\"edit_sc_coupons\";b:1;s:22:\"edit_others_sc_coupons\";b:1;s:18:\"publish_sc_coupons\";b:1;s:17:\"delete_sc_coupons\";b:1;s:24:\"delete_others_sc_coupons\";b:1;s:20:\"view_sc_coupon_stats\";b:1;s:17:\"read_sc_promotion\";b:1;s:18:\"read_sc_promotions\";b:1;s:19:\"delete_sc_promotion\";b:1;s:17:\"edit_sc_promotion\";b:1;s:18:\"edit_sc_promotions\";b:1;s:25:\"edit_others_sc_promotions\";b:1;s:21:\"publish_sc_promotions\";b:1;s:20:\"delete_sc_promotions\";b:1;s:27:\"delete_others_sc_promotions\";b:1;s:23:\"view_sc_promotion_stats\";b:1;s:27:\"read_sc_balance_transaction\";b:1;s:28:\"read_sc_balance_transactions\";b:1;s:29:\"delete_sc_balance_transaction\";b:1;s:27:\"edit_sc_balance_transaction\";b:1;s:28:\"edit_sc_balance_transactions\";b:1;s:35:\"edit_others_sc_balance_transactions\";b:1;s:31:\"publish_sc_balance_transactions\";b:1;s:30:\"delete_sc_balance_transactions\";b:1;s:37:\"delete_others_sc_balance_transactions\";b:1;s:33:\"view_sc_balance_transaction_stats\";b:1;s:16:\"read_sc_checkout\";b:1;s:17:\"read_sc_checkouts\";b:1;s:18:\"delete_sc_checkout\";b:1;s:16:\"edit_sc_checkout\";b:1;s:17:\"edit_sc_checkouts\";b:1;s:24:\"edit_others_sc_checkouts\";b:1;s:20:\"publish_sc_checkouts\";b:1;s:19:\"delete_sc_checkouts\";b:1;s:26:\"delete_others_sc_checkouts\";b:1;s:22:\"view_sc_checkout_stats\";b:1;s:16:\"read_sc_purchase\";b:1;s:17:\"read_sc_purchases\";b:1;s:18:\"delete_sc_purchase\";b:1;s:16:\"edit_sc_purchase\";b:1;s:17:\"edit_sc_purchases\";b:1;s:24:\"edit_others_sc_purchases\";b:1;s:20:\"publish_sc_purchases\";b:1;s:19:\"delete_sc_purchases\";b:1;s:26:\"delete_others_sc_purchases\";b:1;s:22:\"view_sc_purchase_stats\";b:1;s:15:\"read_sc_webhook\";b:1;s:16:\"read_sc_webhooks\";b:1;s:17:\"delete_sc_webhook\";b:1;s:15:\"edit_sc_webhook\";b:1;s:16:\"edit_sc_webhooks\";b:1;s:23:\"edit_others_sc_webhooks\";b:1;s:19:\"publish_sc_webhooks\";b:1;s:18:\"delete_sc_webhooks\";b:1;s:25:\"delete_others_sc_webhooks\";b:1;s:21:\"view_sc_webhook_stats\";b:1;s:15:\"read_sc_product\";b:1;s:16:\"read_sc_products\";b:1;s:17:\"delete_sc_product\";b:1;s:15:\"edit_sc_product\";b:1;s:16:\"edit_sc_products\";b:1;s:23:\"edit_others_sc_products\";b:1;s:19:\"publish_sc_products\";b:1;s:18:\"delete_sc_products\";b:1;s:25:\"delete_others_sc_products\";b:1;s:21:\"view_sc_product_stats\";b:1;s:15:\"read_sc_license\";b:1;s:16:\"read_sc_licenses\";b:1;s:17:\"delete_sc_license\";b:1;s:15:\"edit_sc_license\";b:1;s:16:\"edit_sc_licenses\";b:1;s:23:\"edit_others_sc_licenses\";b:1;s:19:\"publish_sc_licenses\";b:1;s:18:\"delete_sc_licenses\";b:1;s:25:\"delete_others_sc_licenses\";b:1;s:21:\"view_sc_license_stats\";b:1;s:16:\"read_sc_customer\";b:1;s:17:\"read_sc_customers\";b:1;s:18:\"delete_sc_customer\";b:1;s:16:\"edit_sc_customer\";b:1;s:17:\"edit_sc_customers\";b:1;s:24:\"edit_others_sc_customers\";b:1;s:20:\"publish_sc_customers\";b:1;s:19:\"delete_sc_customers\";b:1;s:26:\"delete_others_sc_customers\";b:1;s:22:\"view_sc_customer_stats\";b:1;s:13:\"read_sc_order\";b:1;s:14:\"read_sc_orders\";b:1;s:15:\"delete_sc_order\";b:1;s:13:\"edit_sc_order\";b:1;s:14:\"edit_sc_orders\";b:1;s:21:\"edit_others_sc_orders\";b:1;s:17:\"publish_sc_orders\";b:1;s:16:\"delete_sc_orders\";b:1;s:23:\"delete_others_sc_orders\";b:1;s:19:\"view_sc_order_stats\";b:1;s:15:\"read_sc_invoice\";b:1;s:16:\"read_sc_invoices\";b:1;s:17:\"delete_sc_invoice\";b:1;s:15:\"edit_sc_invoice\";b:1;s:16:\"edit_sc_invoices\";b:1;s:23:\"edit_others_sc_invoices\";b:1;s:19:\"publish_sc_invoices\";b:1;s:18:\"delete_sc_invoices\";b:1;s:25:\"delete_others_sc_invoices\";b:1;s:21:\"view_sc_invoice_stats\";b:1;s:13:\"read_sc_price\";b:1;s:14:\"read_sc_prices\";b:1;s:15:\"delete_sc_price\";b:1;s:13:\"edit_sc_price\";b:1;s:14:\"edit_sc_prices\";b:1;s:21:\"edit_others_sc_prices\";b:1;s:17:\"publish_sc_prices\";b:1;s:16:\"delete_sc_prices\";b:1;s:23:\"delete_others_sc_prices\";b:1;s:19:\"view_sc_price_stats\";b:1;s:14:\"read_sc_refund\";b:1;s:15:\"read_sc_refunds\";b:1;s:16:\"delete_sc_refund\";b:1;s:14:\"edit_sc_refund\";b:1;s:15:\"edit_sc_refunds\";b:1;s:22:\"edit_others_sc_refunds\";b:1;s:18:\"publish_sc_refunds\";b:1;s:17:\"delete_sc_refunds\";b:1;s:24:\"delete_others_sc_refunds\";b:1;s:20:\"view_sc_refund_stats\";b:1;s:15:\"read_sc_dispute\";b:1;s:16:\"read_sc_disputes\";b:1;s:17:\"delete_sc_dispute\";b:1;s:15:\"edit_sc_dispute\";b:1;s:16:\"edit_sc_disputes\";b:1;s:23:\"edit_others_sc_disputes\";b:1;s:19:\"publish_sc_disputes\";b:1;s:18:\"delete_sc_disputes\";b:1;s:25:\"delete_others_sc_disputes\";b:1;s:21:\"view_sc_dispute_stats\";b:1;s:14:\"read_sc_charge\";b:1;s:15:\"read_sc_charges\";b:1;s:16:\"delete_sc_charge\";b:1;s:14:\"edit_sc_charge\";b:1;s:15:\"edit_sc_charges\";b:1;s:22:\"edit_others_sc_charges\";b:1;s:18:\"publish_sc_charges\";b:1;s:17:\"delete_sc_charges\";b:1;s:24:\"delete_others_sc_charges\";b:1;s:20:\"view_sc_charge_stats\";b:1;s:13:\"read_sc_media\";b:1;s:14:\"read_sc_medias\";b:1;s:15:\"delete_sc_media\";b:1;s:13:\"edit_sc_media\";b:1;s:14:\"edit_sc_medias\";b:1;s:21:\"edit_others_sc_medias\";b:1;s:17:\"publish_sc_medias\";b:1;s:16:\"delete_sc_medias\";b:1;s:23:\"delete_others_sc_medias\";b:1;s:19:\"view_sc_media_stats\";b:1;s:22:\"read_sc_payment_method\";b:1;s:23:\"read_sc_payment_methods\";b:1;s:24:\"delete_sc_payment_method\";b:1;s:22:\"edit_sc_payment_method\";b:1;s:23:\"edit_sc_payment_methods\";b:1;s:30:\"edit_others_sc_payment_methods\";b:1;s:26:\"publish_sc_payment_methods\";b:1;s:25:\"delete_sc_payment_methods\";b:1;s:32:\"delete_others_sc_payment_methods\";b:1;s:28:\"view_sc_payment_method_stats\";b:1;s:20:\"read_sc_subscription\";b:1;s:21:\"read_sc_subscriptions\";b:1;s:22:\"delete_sc_subscription\";b:1;s:20:\"edit_sc_subscription\";b:1;s:21:\"edit_sc_subscriptions\";b:1;s:28:\"edit_others_sc_subscriptions\";b:1;s:24:\"publish_sc_subscriptions\";b:1;s:23:\"delete_sc_subscriptions\";b:1;s:30:\"delete_others_sc_subscriptions\";b:1;s:26:\"view_sc_subscription_stats\";b:1;s:17:\"read_sc_affiliate\";b:1;s:18:\"read_sc_affiliates\";b:1;s:19:\"delete_sc_affiliate\";b:1;s:17:\"edit_sc_affiliate\";b:1;s:18:\"edit_sc_affiliates\";b:1;s:25:\"edit_others_sc_affiliates\";b:1;s:21:\"publish_sc_affiliates\";b:1;s:20:\"delete_sc_affiliates\";b:1;s:27:\"delete_others_sc_affiliates\";b:1;s:23:\"view_sc_affiliate_stats\";b:1;s:20:\"wpcode_edit_snippets\";b:1;s:24:\"wpcode_activate_snippets\";b:1;s:20:\"wpseo_manage_options\";b:1;s:16:\"edit_pmb_project\";b:1;s:16:\"read_pmb_project\";b:1;s:18:\"delete_pmb_project\";b:1;s:17:\"edit_pmb_projects\";b:1;s:24:\"edit_others_pmb_projects\";b:1;s:19:\"delete_pmb_projects\";b:1;s:20:\"publish_pmb_projects\";b:1;s:25:\"read_private_pmb_projects\";b:1;s:26:\"delete_others_pmb_projects\";b:1;s:15:\"edit_pmb_design\";b:1;s:15:\"read_pmb_design\";b:1;s:17:\"delete_pmb_design\";b:1;s:16:\"edit_pmb_designs\";b:1;s:23:\"edit_others_pmb_designs\";b:1;s:18:\"delete_pmb_designs\";b:1;s:19:\"publish_pmb_designs\";b:1;s:24:\"read_private_pmb_designs\";b:1;s:25:\"delete_others_pmb_designs\";b:1;s:16:\"edit_pmb_content\";b:1;s:16:\"read_pmb_content\";b:1;s:18:\"delete_pmb_content\";b:1;s:17:\"edit_pmb_contents\";b:1;s:19:\"delete_pmb_contents\";b:1;s:20:\"publish_pmb_contents\";b:1;s:25:\"read_private_pmb_contents\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:37:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:15:\"sc_shop_manager\";a:2:{s:4:\"name\";s:21:\"SureCart Shop Manager\";s:12:\"capabilities\";a:224:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:1;s:12:\"delete_posts\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:19:\"delete_others_pages\";b:1;s:19:\"delete_others_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:17:\"edit_others_posts\";b:1;s:10:\"edit_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:13:\"publish_pages\";b:1;s:13:\"publish_posts\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"view_sc_shop_reports\";b:1;s:27:\"view_sc_shop_sensitive_data\";b:1;s:22:\"export_sc_shop_reports\";b:1;s:23:\"manage_sc_shop_settings\";b:1;s:10:\"list_users\";b:1;s:9:\"edit_user\";b:1;s:14:\"read_sc_coupon\";b:1;s:15:\"read_sc_coupons\";b:1;s:16:\"delete_sc_coupon\";b:1;s:14:\"edit_sc_coupon\";b:1;s:15:\"edit_sc_coupons\";b:1;s:22:\"edit_others_sc_coupons\";b:1;s:18:\"publish_sc_coupons\";b:1;s:17:\"delete_sc_coupons\";b:1;s:24:\"delete_others_sc_coupons\";b:1;s:20:\"view_sc_coupon_stats\";b:1;s:17:\"read_sc_promotion\";b:1;s:18:\"read_sc_promotions\";b:1;s:19:\"delete_sc_promotion\";b:1;s:17:\"edit_sc_promotion\";b:1;s:18:\"edit_sc_promotions\";b:1;s:25:\"edit_others_sc_promotions\";b:1;s:21:\"publish_sc_promotions\";b:1;s:20:\"delete_sc_promotions\";b:1;s:27:\"delete_others_sc_promotions\";b:1;s:23:\"view_sc_promotion_stats\";b:1;s:27:\"read_sc_balance_transaction\";b:1;s:28:\"read_sc_balance_transactions\";b:1;s:29:\"delete_sc_balance_transaction\";b:1;s:27:\"edit_sc_balance_transaction\";b:1;s:28:\"edit_sc_balance_transactions\";b:1;s:35:\"edit_others_sc_balance_transactions\";b:1;s:31:\"publish_sc_balance_transactions\";b:1;s:30:\"delete_sc_balance_transactions\";b:1;s:37:\"delete_others_sc_balance_transactions\";b:1;s:33:\"view_sc_balance_transaction_stats\";b:1;s:16:\"read_sc_checkout\";b:1;s:17:\"read_sc_checkouts\";b:1;s:18:\"delete_sc_checkout\";b:1;s:16:\"edit_sc_checkout\";b:1;s:17:\"edit_sc_checkouts\";b:1;s:24:\"edit_others_sc_checkouts\";b:1;s:20:\"publish_sc_checkouts\";b:1;s:19:\"delete_sc_checkouts\";b:1;s:26:\"delete_others_sc_checkouts\";b:1;s:22:\"view_sc_checkout_stats\";b:1;s:16:\"read_sc_purchase\";b:1;s:17:\"read_sc_purchases\";b:1;s:18:\"delete_sc_purchase\";b:1;s:16:\"edit_sc_purchase\";b:1;s:17:\"edit_sc_purchases\";b:1;s:24:\"edit_others_sc_purchases\";b:1;s:20:\"publish_sc_purchases\";b:1;s:19:\"delete_sc_purchases\";b:1;s:26:\"delete_others_sc_purchases\";b:1;s:22:\"view_sc_purchase_stats\";b:1;s:15:\"read_sc_webhook\";b:1;s:16:\"read_sc_webhooks\";b:1;s:17:\"delete_sc_webhook\";b:1;s:15:\"edit_sc_webhook\";b:1;s:16:\"edit_sc_webhooks\";b:1;s:23:\"edit_others_sc_webhooks\";b:1;s:19:\"publish_sc_webhooks\";b:1;s:18:\"delete_sc_webhooks\";b:1;s:25:\"delete_others_sc_webhooks\";b:1;s:21:\"view_sc_webhook_stats\";b:1;s:15:\"read_sc_product\";b:1;s:16:\"read_sc_products\";b:1;s:17:\"delete_sc_product\";b:1;s:15:\"edit_sc_product\";b:1;s:16:\"edit_sc_products\";b:1;s:23:\"edit_others_sc_products\";b:1;s:19:\"publish_sc_products\";b:1;s:18:\"delete_sc_products\";b:1;s:25:\"delete_others_sc_products\";b:1;s:21:\"view_sc_product_stats\";b:1;s:15:\"read_sc_license\";b:1;s:16:\"read_sc_licenses\";b:1;s:17:\"delete_sc_license\";b:1;s:15:\"edit_sc_license\";b:1;s:16:\"edit_sc_licenses\";b:1;s:23:\"edit_others_sc_licenses\";b:1;s:19:\"publish_sc_licenses\";b:1;s:18:\"delete_sc_licenses\";b:1;s:25:\"delete_others_sc_licenses\";b:1;s:21:\"view_sc_license_stats\";b:1;s:16:\"read_sc_customer\";b:1;s:17:\"read_sc_customers\";b:1;s:18:\"delete_sc_customer\";b:1;s:16:\"edit_sc_customer\";b:1;s:17:\"edit_sc_customers\";b:1;s:24:\"edit_others_sc_customers\";b:1;s:20:\"publish_sc_customers\";b:1;s:19:\"delete_sc_customers\";b:1;s:26:\"delete_others_sc_customers\";b:1;s:22:\"view_sc_customer_stats\";b:1;s:13:\"read_sc_order\";b:1;s:14:\"read_sc_orders\";b:1;s:15:\"delete_sc_order\";b:1;s:13:\"edit_sc_order\";b:1;s:14:\"edit_sc_orders\";b:1;s:21:\"edit_others_sc_orders\";b:1;s:17:\"publish_sc_orders\";b:1;s:16:\"delete_sc_orders\";b:1;s:23:\"delete_others_sc_orders\";b:1;s:19:\"view_sc_order_stats\";b:1;s:15:\"read_sc_invoice\";b:1;s:16:\"read_sc_invoices\";b:1;s:17:\"delete_sc_invoice\";b:1;s:15:\"edit_sc_invoice\";b:1;s:16:\"edit_sc_invoices\";b:1;s:23:\"edit_others_sc_invoices\";b:1;s:19:\"publish_sc_invoices\";b:1;s:18:\"delete_sc_invoices\";b:1;s:25:\"delete_others_sc_invoices\";b:1;s:21:\"view_sc_invoice_stats\";b:1;s:13:\"read_sc_price\";b:1;s:14:\"read_sc_prices\";b:1;s:15:\"delete_sc_price\";b:1;s:13:\"edit_sc_price\";b:1;s:14:\"edit_sc_prices\";b:1;s:21:\"edit_others_sc_prices\";b:1;s:17:\"publish_sc_prices\";b:1;s:16:\"delete_sc_prices\";b:1;s:23:\"delete_others_sc_prices\";b:1;s:19:\"view_sc_price_stats\";b:1;s:14:\"read_sc_refund\";b:1;s:15:\"read_sc_refunds\";b:1;s:16:\"delete_sc_refund\";b:1;s:14:\"edit_sc_refund\";b:1;s:15:\"edit_sc_refunds\";b:1;s:22:\"edit_others_sc_refunds\";b:1;s:18:\"publish_sc_refunds\";b:1;s:17:\"delete_sc_refunds\";b:1;s:24:\"delete_others_sc_refunds\";b:1;s:20:\"view_sc_refund_stats\";b:1;s:15:\"read_sc_dispute\";b:1;s:16:\"read_sc_disputes\";b:1;s:17:\"delete_sc_dispute\";b:1;s:15:\"edit_sc_dispute\";b:1;s:16:\"edit_sc_disputes\";b:1;s:23:\"edit_others_sc_disputes\";b:1;s:19:\"publish_sc_disputes\";b:1;s:18:\"delete_sc_disputes\";b:1;s:25:\"delete_others_sc_disputes\";b:1;s:21:\"view_sc_dispute_stats\";b:1;s:14:\"read_sc_charge\";b:1;s:15:\"read_sc_charges\";b:1;s:16:\"delete_sc_charge\";b:1;s:14:\"edit_sc_charge\";b:1;s:15:\"edit_sc_charges\";b:1;s:22:\"edit_others_sc_charges\";b:1;s:18:\"publish_sc_charges\";b:1;s:17:\"delete_sc_charges\";b:1;s:24:\"delete_others_sc_charges\";b:1;s:20:\"view_sc_charge_stats\";b:1;s:13:\"read_sc_media\";b:1;s:14:\"read_sc_medias\";b:1;s:15:\"delete_sc_media\";b:1;s:13:\"edit_sc_media\";b:1;s:14:\"edit_sc_medias\";b:1;s:21:\"edit_others_sc_medias\";b:1;s:17:\"publish_sc_medias\";b:1;s:16:\"delete_sc_medias\";b:1;s:23:\"delete_others_sc_medias\";b:1;s:19:\"view_sc_media_stats\";b:1;s:22:\"read_sc_payment_method\";b:1;s:23:\"read_sc_payment_methods\";b:1;s:24:\"delete_sc_payment_method\";b:1;s:22:\"edit_sc_payment_method\";b:1;s:23:\"edit_sc_payment_methods\";b:1;s:30:\"edit_others_sc_payment_methods\";b:1;s:26:\"publish_sc_payment_methods\";b:1;s:25:\"delete_sc_payment_methods\";b:1;s:32:\"delete_others_sc_payment_methods\";b:1;s:28:\"view_sc_payment_method_stats\";b:1;s:20:\"read_sc_subscription\";b:1;s:21:\"read_sc_subscriptions\";b:1;s:22:\"delete_sc_subscription\";b:1;s:20:\"edit_sc_subscription\";b:1;s:21:\"edit_sc_subscriptions\";b:1;s:28:\"edit_others_sc_subscriptions\";b:1;s:24:\"publish_sc_subscriptions\";b:1;s:23:\"delete_sc_subscriptions\";b:1;s:30:\"delete_others_sc_subscriptions\";b:1;s:26:\"view_sc_subscription_stats\";b:1;s:17:\"read_sc_affiliate\";b:1;s:18:\"read_sc_affiliates\";b:1;s:19:\"delete_sc_affiliate\";b:1;s:17:\"edit_sc_affiliate\";b:1;s:18:\"edit_sc_affiliates\";b:1;s:25:\"edit_others_sc_affiliates\";b:1;s:21:\"publish_sc_affiliates\";b:1;s:20:\"delete_sc_affiliates\";b:1;s:27:\"delete_others_sc_affiliates\";b:1;s:23:\"view_sc_affiliate_stats\";b:1;}}s:18:\"sc_shop_accountant\";a:2:{s:4:\"name\";s:19:\"SureCart Accountant\";s:12:\"capabilities\";a:197:{s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:12:\"delete_posts\";b:0;s:14:\"read_sc_coupon\";b:1;s:15:\"read_sc_coupons\";b:1;s:16:\"delete_sc_coupon\";b:1;s:14:\"edit_sc_coupon\";b:1;s:15:\"edit_sc_coupons\";b:1;s:22:\"edit_others_sc_coupons\";b:1;s:18:\"publish_sc_coupons\";b:1;s:17:\"delete_sc_coupons\";b:1;s:24:\"delete_others_sc_coupons\";b:1;s:20:\"view_sc_coupon_stats\";b:1;s:17:\"read_sc_promotion\";b:1;s:18:\"read_sc_promotions\";b:1;s:19:\"delete_sc_promotion\";b:1;s:17:\"edit_sc_promotion\";b:1;s:18:\"edit_sc_promotions\";b:1;s:25:\"edit_others_sc_promotions\";b:1;s:21:\"publish_sc_promotions\";b:1;s:20:\"delete_sc_promotions\";b:1;s:27:\"delete_others_sc_promotions\";b:1;s:23:\"view_sc_promotion_stats\";b:1;s:27:\"read_sc_balance_transaction\";b:1;s:28:\"read_sc_balance_transactions\";b:1;s:29:\"delete_sc_balance_transaction\";b:1;s:27:\"edit_sc_balance_transaction\";b:1;s:28:\"edit_sc_balance_transactions\";b:1;s:35:\"edit_others_sc_balance_transactions\";b:1;s:31:\"publish_sc_balance_transactions\";b:1;s:30:\"delete_sc_balance_transactions\";b:1;s:37:\"delete_others_sc_balance_transactions\";b:1;s:33:\"view_sc_balance_transaction_stats\";b:1;s:16:\"read_sc_checkout\";b:1;s:17:\"read_sc_checkouts\";b:1;s:18:\"delete_sc_checkout\";b:1;s:16:\"edit_sc_checkout\";b:1;s:17:\"edit_sc_checkouts\";b:1;s:24:\"edit_others_sc_checkouts\";b:1;s:20:\"publish_sc_checkouts\";b:1;s:19:\"delete_sc_checkouts\";b:1;s:26:\"delete_others_sc_checkouts\";b:1;s:22:\"view_sc_checkout_stats\";b:1;s:16:\"read_sc_purchase\";b:1;s:17:\"read_sc_purchases\";b:1;s:18:\"delete_sc_purchase\";b:1;s:16:\"edit_sc_purchase\";b:1;s:17:\"edit_sc_purchases\";b:1;s:24:\"edit_others_sc_purchases\";b:1;s:20:\"publish_sc_purchases\";b:1;s:19:\"delete_sc_purchases\";b:1;s:26:\"delete_others_sc_purchases\";b:1;s:22:\"view_sc_purchase_stats\";b:1;s:15:\"read_sc_webhook\";b:1;s:16:\"read_sc_webhooks\";b:1;s:17:\"delete_sc_webhook\";b:1;s:15:\"edit_sc_webhook\";b:1;s:16:\"edit_sc_webhooks\";b:1;s:23:\"edit_others_sc_webhooks\";b:1;s:19:\"publish_sc_webhooks\";b:1;s:18:\"delete_sc_webhooks\";b:1;s:25:\"delete_others_sc_webhooks\";b:1;s:21:\"view_sc_webhook_stats\";b:1;s:15:\"read_sc_product\";b:1;s:16:\"read_sc_products\";b:1;s:17:\"delete_sc_product\";b:1;s:15:\"edit_sc_product\";b:1;s:16:\"edit_sc_products\";b:1;s:23:\"edit_others_sc_products\";b:1;s:19:\"publish_sc_products\";b:1;s:18:\"delete_sc_products\";b:1;s:25:\"delete_others_sc_products\";b:1;s:21:\"view_sc_product_stats\";b:1;s:15:\"read_sc_license\";b:1;s:16:\"read_sc_licenses\";b:1;s:17:\"delete_sc_license\";b:1;s:15:\"edit_sc_license\";b:1;s:16:\"edit_sc_licenses\";b:1;s:23:\"edit_others_sc_licenses\";b:1;s:19:\"publish_sc_licenses\";b:1;s:18:\"delete_sc_licenses\";b:1;s:25:\"delete_others_sc_licenses\";b:1;s:21:\"view_sc_license_stats\";b:1;s:16:\"read_sc_customer\";b:1;s:17:\"read_sc_customers\";b:1;s:18:\"delete_sc_customer\";b:1;s:16:\"edit_sc_customer\";b:1;s:17:\"edit_sc_customers\";b:1;s:24:\"edit_others_sc_customers\";b:1;s:20:\"publish_sc_customers\";b:1;s:19:\"delete_sc_customers\";b:1;s:26:\"delete_others_sc_customers\";b:1;s:22:\"view_sc_customer_stats\";b:1;s:13:\"read_sc_order\";b:1;s:14:\"read_sc_orders\";b:1;s:15:\"delete_sc_order\";b:1;s:13:\"edit_sc_order\";b:1;s:14:\"edit_sc_orders\";b:1;s:21:\"edit_others_sc_orders\";b:1;s:17:\"publish_sc_orders\";b:1;s:16:\"delete_sc_orders\";b:1;s:23:\"delete_others_sc_orders\";b:1;s:19:\"view_sc_order_stats\";b:1;s:15:\"read_sc_invoice\";b:1;s:16:\"read_sc_invoices\";b:1;s:17:\"delete_sc_invoice\";b:1;s:15:\"edit_sc_invoice\";b:1;s:16:\"edit_sc_invoices\";b:1;s:23:\"edit_others_sc_invoices\";b:1;s:19:\"publish_sc_invoices\";b:1;s:18:\"delete_sc_invoices\";b:1;s:25:\"delete_others_sc_invoices\";b:1;s:21:\"view_sc_invoice_stats\";b:1;s:13:\"read_sc_price\";b:1;s:14:\"read_sc_prices\";b:1;s:15:\"delete_sc_price\";b:1;s:13:\"edit_sc_price\";b:1;s:14:\"edit_sc_prices\";b:1;s:21:\"edit_others_sc_prices\";b:1;s:17:\"publish_sc_prices\";b:1;s:16:\"delete_sc_prices\";b:1;s:23:\"delete_others_sc_prices\";b:1;s:19:\"view_sc_price_stats\";b:1;s:14:\"read_sc_refund\";b:1;s:15:\"read_sc_refunds\";b:1;s:16:\"delete_sc_refund\";b:1;s:14:\"edit_sc_refund\";b:1;s:15:\"edit_sc_refunds\";b:1;s:22:\"edit_others_sc_refunds\";b:1;s:18:\"publish_sc_refunds\";b:1;s:17:\"delete_sc_refunds\";b:1;s:24:\"delete_others_sc_refunds\";b:1;s:20:\"view_sc_refund_stats\";b:1;s:15:\"read_sc_dispute\";b:1;s:16:\"read_sc_disputes\";b:1;s:17:\"delete_sc_dispute\";b:1;s:15:\"edit_sc_dispute\";b:1;s:16:\"edit_sc_disputes\";b:1;s:23:\"edit_others_sc_disputes\";b:1;s:19:\"publish_sc_disputes\";b:1;s:18:\"delete_sc_disputes\";b:1;s:25:\"delete_others_sc_disputes\";b:1;s:21:\"view_sc_dispute_stats\";b:1;s:14:\"read_sc_charge\";b:1;s:15:\"read_sc_charges\";b:1;s:16:\"delete_sc_charge\";b:1;s:14:\"edit_sc_charge\";b:1;s:15:\"edit_sc_charges\";b:1;s:22:\"edit_others_sc_charges\";b:1;s:18:\"publish_sc_charges\";b:1;s:17:\"delete_sc_charges\";b:1;s:24:\"delete_others_sc_charges\";b:1;s:20:\"view_sc_charge_stats\";b:1;s:13:\"read_sc_media\";b:1;s:14:\"read_sc_medias\";b:1;s:15:\"delete_sc_media\";b:1;s:13:\"edit_sc_media\";b:1;s:14:\"edit_sc_medias\";b:1;s:21:\"edit_others_sc_medias\";b:1;s:17:\"publish_sc_medias\";b:1;s:16:\"delete_sc_medias\";b:1;s:23:\"delete_others_sc_medias\";b:1;s:19:\"view_sc_media_stats\";b:1;s:22:\"read_sc_payment_method\";b:1;s:23:\"read_sc_payment_methods\";b:1;s:24:\"delete_sc_payment_method\";b:1;s:22:\"edit_sc_payment_method\";b:1;s:23:\"edit_sc_payment_methods\";b:1;s:30:\"edit_others_sc_payment_methods\";b:1;s:26:\"publish_sc_payment_methods\";b:1;s:25:\"delete_sc_payment_methods\";b:1;s:32:\"delete_others_sc_payment_methods\";b:1;s:28:\"view_sc_payment_method_stats\";b:1;s:20:\"read_sc_subscription\";b:1;s:21:\"read_sc_subscriptions\";b:1;s:22:\"delete_sc_subscription\";b:1;s:20:\"edit_sc_subscription\";b:1;s:21:\"edit_sc_subscriptions\";b:1;s:28:\"edit_others_sc_subscriptions\";b:1;s:24:\"publish_sc_subscriptions\";b:1;s:23:\"delete_sc_subscriptions\";b:1;s:30:\"delete_others_sc_subscriptions\";b:1;s:26:\"view_sc_subscription_stats\";b:1;s:17:\"read_sc_affiliate\";b:1;s:18:\"read_sc_affiliates\";b:1;s:19:\"delete_sc_affiliate\";b:1;s:17:\"edit_sc_affiliate\";b:1;s:18:\"edit_sc_affiliates\";b:1;s:25:\"edit_others_sc_affiliates\";b:1;s:21:\"publish_sc_affiliates\";b:1;s:20:\"delete_sc_affiliates\";b:1;s:27:\"delete_others_sc_affiliates\";b:1;s:23:\"view_sc_affiliate_stats\";b:1;s:20:\"view_sc_shop_reports\";b:1;s:22:\"export_sc_shop_reports\";b:1;s:20:\"edit_sc_shop_charges\";b:1;}}s:14:\"sc_shop_worker\";a:2:{s:4:\"name\";s:20:\"SureCart Shop Worker\";s:12:\"capabilities\";a:196:{s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:12:\"delete_posts\";b:0;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:14:\"read_sc_coupon\";b:1;s:15:\"read_sc_coupons\";b:1;s:16:\"delete_sc_coupon\";b:1;s:14:\"edit_sc_coupon\";b:1;s:15:\"edit_sc_coupons\";b:1;s:22:\"edit_others_sc_coupons\";b:1;s:18:\"publish_sc_coupons\";b:1;s:17:\"delete_sc_coupons\";b:1;s:24:\"delete_others_sc_coupons\";b:1;s:20:\"view_sc_coupon_stats\";b:1;s:17:\"read_sc_promotion\";b:1;s:18:\"read_sc_promotions\";b:1;s:19:\"delete_sc_promotion\";b:1;s:17:\"edit_sc_promotion\";b:1;s:18:\"edit_sc_promotions\";b:1;s:25:\"edit_others_sc_promotions\";b:1;s:21:\"publish_sc_promotions\";b:1;s:20:\"delete_sc_promotions\";b:1;s:27:\"delete_others_sc_promotions\";b:1;s:23:\"view_sc_promotion_stats\";b:1;s:27:\"read_sc_balance_transaction\";b:1;s:28:\"read_sc_balance_transactions\";b:1;s:29:\"delete_sc_balance_transaction\";b:1;s:27:\"edit_sc_balance_transaction\";b:1;s:28:\"edit_sc_balance_transactions\";b:1;s:35:\"edit_others_sc_balance_transactions\";b:1;s:31:\"publish_sc_balance_transactions\";b:1;s:30:\"delete_sc_balance_transactions\";b:1;s:37:\"delete_others_sc_balance_transactions\";b:1;s:33:\"view_sc_balance_transaction_stats\";b:1;s:16:\"read_sc_checkout\";b:1;s:17:\"read_sc_checkouts\";b:1;s:18:\"delete_sc_checkout\";b:1;s:16:\"edit_sc_checkout\";b:1;s:17:\"edit_sc_checkouts\";b:1;s:24:\"edit_others_sc_checkouts\";b:1;s:20:\"publish_sc_checkouts\";b:1;s:19:\"delete_sc_checkouts\";b:1;s:26:\"delete_others_sc_checkouts\";b:1;s:22:\"view_sc_checkout_stats\";b:1;s:16:\"read_sc_purchase\";b:1;s:17:\"read_sc_purchases\";b:1;s:18:\"delete_sc_purchase\";b:1;s:16:\"edit_sc_purchase\";b:1;s:17:\"edit_sc_purchases\";b:1;s:24:\"edit_others_sc_purchases\";b:1;s:20:\"publish_sc_purchases\";b:1;s:19:\"delete_sc_purchases\";b:1;s:26:\"delete_others_sc_purchases\";b:1;s:22:\"view_sc_purchase_stats\";b:1;s:15:\"read_sc_webhook\";b:1;s:16:\"read_sc_webhooks\";b:1;s:17:\"delete_sc_webhook\";b:1;s:15:\"edit_sc_webhook\";b:1;s:16:\"edit_sc_webhooks\";b:1;s:23:\"edit_others_sc_webhooks\";b:1;s:19:\"publish_sc_webhooks\";b:1;s:18:\"delete_sc_webhooks\";b:1;s:25:\"delete_others_sc_webhooks\";b:1;s:21:\"view_sc_webhook_stats\";b:1;s:15:\"read_sc_product\";b:1;s:16:\"read_sc_products\";b:1;s:17:\"delete_sc_product\";b:1;s:15:\"edit_sc_product\";b:1;s:16:\"edit_sc_products\";b:1;s:23:\"edit_others_sc_products\";b:1;s:19:\"publish_sc_products\";b:1;s:18:\"delete_sc_products\";b:1;s:25:\"delete_others_sc_products\";b:1;s:21:\"view_sc_product_stats\";b:1;s:15:\"read_sc_license\";b:1;s:16:\"read_sc_licenses\";b:1;s:17:\"delete_sc_license\";b:1;s:15:\"edit_sc_license\";b:1;s:16:\"edit_sc_licenses\";b:1;s:23:\"edit_others_sc_licenses\";b:1;s:19:\"publish_sc_licenses\";b:1;s:18:\"delete_sc_licenses\";b:1;s:25:\"delete_others_sc_licenses\";b:1;s:21:\"view_sc_license_stats\";b:1;s:16:\"read_sc_customer\";b:1;s:17:\"read_sc_customers\";b:1;s:18:\"delete_sc_customer\";b:1;s:16:\"edit_sc_customer\";b:1;s:17:\"edit_sc_customers\";b:1;s:24:\"edit_others_sc_customers\";b:1;s:20:\"publish_sc_customers\";b:1;s:19:\"delete_sc_customers\";b:1;s:26:\"delete_others_sc_customers\";b:1;s:22:\"view_sc_customer_stats\";b:1;s:13:\"read_sc_order\";b:1;s:14:\"read_sc_orders\";b:1;s:15:\"delete_sc_order\";b:1;s:13:\"edit_sc_order\";b:1;s:14:\"edit_sc_orders\";b:1;s:21:\"edit_others_sc_orders\";b:1;s:17:\"publish_sc_orders\";b:1;s:16:\"delete_sc_orders\";b:1;s:23:\"delete_others_sc_orders\";b:1;s:19:\"view_sc_order_stats\";b:1;s:15:\"read_sc_invoice\";b:1;s:16:\"read_sc_invoices\";b:1;s:17:\"delete_sc_invoice\";b:1;s:15:\"edit_sc_invoice\";b:1;s:16:\"edit_sc_invoices\";b:1;s:23:\"edit_others_sc_invoices\";b:1;s:19:\"publish_sc_invoices\";b:1;s:18:\"delete_sc_invoices\";b:1;s:25:\"delete_others_sc_invoices\";b:1;s:21:\"view_sc_invoice_stats\";b:1;s:13:\"read_sc_price\";b:1;s:14:\"read_sc_prices\";b:1;s:15:\"delete_sc_price\";b:1;s:13:\"edit_sc_price\";b:1;s:14:\"edit_sc_prices\";b:1;s:21:\"edit_others_sc_prices\";b:1;s:17:\"publish_sc_prices\";b:1;s:16:\"delete_sc_prices\";b:1;s:23:\"delete_others_sc_prices\";b:1;s:19:\"view_sc_price_stats\";b:1;s:14:\"read_sc_refund\";b:1;s:15:\"read_sc_refunds\";b:1;s:16:\"delete_sc_refund\";b:1;s:14:\"edit_sc_refund\";b:1;s:15:\"edit_sc_refunds\";b:1;s:22:\"edit_others_sc_refunds\";b:1;s:18:\"publish_sc_refunds\";b:1;s:17:\"delete_sc_refunds\";b:1;s:24:\"delete_others_sc_refunds\";b:1;s:20:\"view_sc_refund_stats\";b:1;s:15:\"read_sc_dispute\";b:1;s:16:\"read_sc_disputes\";b:1;s:17:\"delete_sc_dispute\";b:1;s:15:\"edit_sc_dispute\";b:1;s:16:\"edit_sc_disputes\";b:1;s:23:\"edit_others_sc_disputes\";b:1;s:19:\"publish_sc_disputes\";b:1;s:18:\"delete_sc_disputes\";b:1;s:25:\"delete_others_sc_disputes\";b:1;s:21:\"view_sc_dispute_stats\";b:1;s:14:\"read_sc_charge\";b:1;s:15:\"read_sc_charges\";b:1;s:16:\"delete_sc_charge\";b:1;s:14:\"edit_sc_charge\";b:1;s:15:\"edit_sc_charges\";b:1;s:22:\"edit_others_sc_charges\";b:1;s:18:\"publish_sc_charges\";b:1;s:17:\"delete_sc_charges\";b:1;s:24:\"delete_others_sc_charges\";b:1;s:20:\"view_sc_charge_stats\";b:1;s:13:\"read_sc_media\";b:1;s:14:\"read_sc_medias\";b:1;s:15:\"delete_sc_media\";b:1;s:13:\"edit_sc_media\";b:1;s:14:\"edit_sc_medias\";b:1;s:21:\"edit_others_sc_medias\";b:1;s:17:\"publish_sc_medias\";b:1;s:16:\"delete_sc_medias\";b:1;s:23:\"delete_others_sc_medias\";b:1;s:19:\"view_sc_media_stats\";b:1;s:22:\"read_sc_payment_method\";b:1;s:23:\"read_sc_payment_methods\";b:1;s:24:\"delete_sc_payment_method\";b:1;s:22:\"edit_sc_payment_method\";b:1;s:23:\"edit_sc_payment_methods\";b:1;s:30:\"edit_others_sc_payment_methods\";b:1;s:26:\"publish_sc_payment_methods\";b:1;s:25:\"delete_sc_payment_methods\";b:1;s:32:\"delete_others_sc_payment_methods\";b:1;s:28:\"view_sc_payment_method_stats\";b:1;s:20:\"read_sc_subscription\";b:1;s:21:\"read_sc_subscriptions\";b:1;s:22:\"delete_sc_subscription\";b:1;s:20:\"edit_sc_subscription\";b:1;s:21:\"edit_sc_subscriptions\";b:1;s:28:\"edit_others_sc_subscriptions\";b:1;s:24:\"publish_sc_subscriptions\";b:1;s:23:\"delete_sc_subscriptions\";b:1;s:30:\"delete_others_sc_subscriptions\";b:1;s:26:\"view_sc_subscription_stats\";b:1;s:17:\"read_sc_affiliate\";b:1;s:18:\"read_sc_affiliates\";b:1;s:19:\"delete_sc_affiliate\";b:1;s:17:\"edit_sc_affiliate\";b:1;s:18:\"edit_sc_affiliates\";b:1;s:25:\"edit_others_sc_affiliates\";b:1;s:21:\"publish_sc_affiliates\";b:1;s:20:\"delete_sc_affiliates\";b:1;s:27:\"delete_others_sc_affiliates\";b:1;s:23:\"view_sc_affiliate_stats\";b:1;}}s:11:\"sc_customer\";a:2:{s:4:\"name\";s:17:\"SureCart Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:15:\"latepoint_agent\";a:2:{s:4:\"name\";s:15:\"LatePoint Agent\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:13:\"edit_bookings\";b:1;}}s:18:\"latepoint_customer\";a:2:{s:4:\"name\";s:18:\"LatePoint Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("105", "widget_block", "a:11:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;i:19;a:1:{s:7:\"content\";s:1592:\"<!-- wp:uagb/buttons {\"block_id\":\"1d860d9a\",\"classMigrate\":true,\"childMigrate\":true,\"lineHeight\":null,\"topMargin\":\"\",\"rightMargin\":\"\",\"bottomMargin\":\"\",\"leftMargin\":\"\",\"marginLink\":false,\"topPadding\":\"\",\"rightPadding\":\"\",\"bottomPadding\":\"\",\"leftPadding\":\"\",\"fontLetterSpacing\":null} -->\n<div class=\"wp-block-uagb-buttons uagb-buttons__outer-wrap uagb-btn__default-btn uagb-btn-tablet__default-btn uagb-btn-mobile__default-btn uagb-block-1d860d9a\" id=\"https://www.cetefnouvelle-aquitaine.org/collect/description/479089-p-bulletin-d-adhesion-annuel-2025\"><div class=\"uagb-buttons__wrap uagb-buttons-layout-wrap \"><!-- wp:uagb/buttons-child {\"block_id\":\"ec3b6d78\",\"label\":\"adherer\",\"link\":\"https://www.cetefnouvelle-aquitaine.org/collect/description/479089-p-bulletin-d-adhesion-annuel-2025\",\"hColor\":\"\",\"noFollow\":true,\"btnBorderTopWidth\":1,\"btnBorderLeftWidth\":1,\"btnBorderRightWidth\":1,\"btnBorderBottomWidth\":1,\"btnBorderStyle\":\"solid\",\"btnBorderColor\":\"#333\",\"btnBorderHColor\":\"#333\"} -->\n<div class=\"wp-block-uagb-buttons-child uagb-buttons__outer-wrap uagb-block-ec3b6d78 wp-block-button\" id=\"https://www.cetefnouvelle-aquitaine.org/collect/description/554021-p-bulletin-d-adhesion-annuel-2026\"><div class=\"uagb-button__wrapper\"><a class=\"uagb-buttons-repeater wp-block-button__link\" aria-label=\"\" href=\"https://www.cetefnouvelle-aquitaine.org/collect/description/479089-p-bulletin-d-adhesion-annuel-2025\" rel=\"nofollow noopener\" target=\"_self\" role=\"button\"><div class=\"uagb-button__link\">adherer</div></a></div></div>\n<!-- /wp:uagb/buttons-child --></div></div>\n<!-- /wp:uagb/buttons -->\";}i:31;a:1:{s:7:\"content\";s:1228:\"<!-- wp:uagb/buttons {\"block_id\":\"a737f176\",\"classMigrate\":true,\"childMigrate\":true,\"topPadding\":19,\"rightPadding\":19,\"bottomPadding\":19,\"leftPadding\":19} -->\n<div class=\"wp-block-uagb-buttons uagb-buttons__outer-wrap uagb-btn__default-btn uagb-btn-tablet__default-btn uagb-btn-mobile__default-btn uagb-block-a737f176\" id=\"https://www.cetefnouvelle-aquitaine.org/collect/description/426658-k-bon-de-soutien-annee-2025\"><div class=\"uagb-buttons__wrap uagb-buttons-layout-wrap \"><!-- wp:uagb/buttons-child {\"block_id\":\"deffc838\",\"label\":\"don\",\"link\":\"#\",\"hColor\":\"\",\"btnBorderTopWidth\":1,\"btnBorderLeftWidth\":1,\"btnBorderRightWidth\":1,\"btnBorderBottomWidth\":1,\"btnBorderStyle\":\"solid\",\"btnBorderColor\":\"#333\",\"btnBorderHColor\":\"#333\"} -->\n<div class=\"wp-block-uagb-buttons-child uagb-buttons__outer-wrap uagb-block-deffc838 wp-block-button\" id=\"https://www.cetefnouvelle-aquitaine.org/collect/description/426658-k-bon-de-soutien-annee-2025\"><div class=\"uagb-button__wrapper\"><a class=\"uagb-buttons-repeater wp-block-button__link\" aria-label=\"\" href=\"#\" rel=\"follow noopener\" target=\"_self\" role=\"button\"><div class=\"uagb-button__link\">don</div></a></div></div>\n<!-- /wp:uagb/buttons-child --></div></div>\n<!-- /wp:uagb/buttons -->\";}i:44;a:1:{s:7:\"content\";s:961:\"<!-- wp:uagb/buttons {\"block_id\":\"05182647\",\"classMigrate\":true,\"childMigrate\":true} -->\n<div class=\"wp-block-uagb-buttons uagb-buttons__outer-wrap uagb-btn__default-btn uagb-btn-tablet__default-btn uagb-btn-mobile__default-btn uagb-block-05182647\"><div class=\"uagb-buttons__wrap uagb-buttons-layout-wrap \"><!-- wp:uagb/buttons-child {\"block_id\":\"48eeec77\",\"link\":\"#\",\"size\":\"\",\"hColor\":\"\",\"btnBorderTopWidth\":1,\"btnBorderLeftWidth\":1,\"btnBorderRightWidth\":1,\"btnBorderBottomWidth\":1,\"btnBorderStyle\":\"solid\",\"btnBorderColor\":\"#333\",\"btnBorderHColor\":\"#333\"} -->\n<div class=\"wp-block-uagb-buttons-child uagb-buttons__outer-wrap uagb-block-48eeec77 wp-block-button\"><div class=\"uagb-button__wrapper\"><a class=\"uagb-buttons-repeater wp-block-button__link\" aria-label=\"\" href=\"#\" rel=\"follow noopener\" target=\"_self\" role=\"button\"><div class=\"uagb-button__link\">Click Here</div></a></div></div>\n<!-- /wp:uagb/buttons-child --></div></div>\n<!-- /wp:uagb/buttons -->\";}i:56;a:1:{s:7:\"content\";s:1067:\"<!-- wp:uagb/buttons {\"block_id\":\"adc897e7\",\"classMigrate\":true,\"childMigrate\":true} -->\n<div class=\"wp-block-uagb-buttons uagb-buttons__outer-wrap uagb-btn__default-btn uagb-btn-tablet__default-btn uagb-btn-mobile__default-btn uagb-block-adc897e7\" id=\"https://www.cetefnouvelle-aquitaine.org/collect/description/479089-p-bulletin-d-adhesion-annuel-2025\"><div class=\"uagb-buttons__wrap uagb-buttons-layout-wrap \"><!-- wp:uagb/buttons-child {\"block_id\":\"ef74453e\",\"link\":\"#\",\"size\":\"\",\"hColor\":\"\",\"btnBorderTopWidth\":1,\"btnBorderLeftWidth\":1,\"btnBorderRightWidth\":1,\"btnBorderBottomWidth\":1,\"btnBorderStyle\":\"solid\",\"btnBorderColor\":\"#333\",\"btnBorderHColor\":\"#333\"} -->\n<div class=\"wp-block-uagb-buttons-child uagb-buttons__outer-wrap uagb-block-ef74453e wp-block-button\"><div class=\"uagb-button__wrapper\"><a class=\"uagb-buttons-repeater wp-block-button__link\" aria-label=\"\" href=\"#\" rel=\"follow noopener\" target=\"_self\" role=\"button\"><div class=\"uagb-button__link\">Click Here</div></a></div></div>\n<!-- /wp:uagb/buttons-child --></div></div>\n<!-- /wp:uagb/buttons -->\";}i:68;a:1:{s:7:\"content\";s:961:\"<!-- wp:uagb/buttons {\"block_id\":\"e347bc31\",\"classMigrate\":true,\"childMigrate\":true} -->\n<div class=\"wp-block-uagb-buttons uagb-buttons__outer-wrap uagb-btn__default-btn uagb-btn-tablet__default-btn uagb-btn-mobile__default-btn uagb-block-e347bc31\"><div class=\"uagb-buttons__wrap uagb-buttons-layout-wrap \"><!-- wp:uagb/buttons-child {\"block_id\":\"f4100202\",\"link\":\"#\",\"size\":\"\",\"hColor\":\"\",\"btnBorderTopWidth\":1,\"btnBorderLeftWidth\":1,\"btnBorderRightWidth\":1,\"btnBorderBottomWidth\":1,\"btnBorderStyle\":\"solid\",\"btnBorderColor\":\"#333\",\"btnBorderHColor\":\"#333\"} -->\n<div class=\"wp-block-uagb-buttons-child uagb-buttons__outer-wrap uagb-block-f4100202 wp-block-button\"><div class=\"uagb-button__wrapper\"><a class=\"uagb-buttons-repeater wp-block-button__link\" aria-label=\"\" href=\"#\" rel=\"follow noopener\" target=\"_self\" role=\"button\"><div class=\"uagb-button__link\">Click Here</div></a></div></div>\n<!-- /wp:uagb/buttons-child --></div></div>\n<!-- /wp:uagb/buttons -->\";}}", "on");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:11:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:15:\"footer-widget-1\";a:0:{}s:15:\"footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-1\";a:0:{}s:24:\"advanced-footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-3\";a:0:{}s:24:\"advanced-footer-widget-4\";a:0:{}s:13:\"array_version\";i:3;s:15:\"header-widget-1\";a:2:{i:0;s:8:\"block-19\";i:1;s:8:\"block-31\";}s:15:\"header-widget-2\";a:2:{i:0;s:8:\"block-56\";i:1;s:8:\"block-68\";}}", "on");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:3:\"6.9\";s:5:\"files\";a:584:{i:0;s:31:\"accordion-heading/style-rtl.css\";i:1;s:35:\"accordion-heading/style-rtl.min.css\";i:2;s:27:\"accordion-heading/style.css\";i:3;s:31:\"accordion-heading/style.min.css\";i:4;s:28:\"accordion-item/style-rtl.css\";i:5;s:32:\"accordion-item/style-rtl.min.css\";i:6;s:24:\"accordion-item/style.css\";i:7;s:28:\"accordion-item/style.min.css\";i:8;s:29:\"accordion-panel/style-rtl.css\";i:9;s:33:\"accordion-panel/style-rtl.min.css\";i:10;s:25:\"accordion-panel/style.css\";i:11;s:29:\"accordion-panel/style.min.css\";i:12;s:23:\"accordion/style-rtl.css\";i:13;s:27:\"accordion/style-rtl.min.css\";i:14;s:19:\"accordion/style.css\";i:15;s:23:\"accordion/style.min.css\";i:16;s:23:\"archives/editor-rtl.css\";i:17;s:27:\"archives/editor-rtl.min.css\";i:18;s:19:\"archives/editor.css\";i:19;s:23:\"archives/editor.min.css\";i:20;s:22:\"archives/style-rtl.css\";i:21;s:26:\"archives/style-rtl.min.css\";i:22;s:18:\"archives/style.css\";i:23;s:22:\"archives/style.min.css\";i:24;s:20:\"audio/editor-rtl.css\";i:25;s:24:\"audio/editor-rtl.min.css\";i:26;s:16:\"audio/editor.css\";i:27;s:20:\"audio/editor.min.css\";i:28;s:19:\"audio/style-rtl.css\";i:29;s:23:\"audio/style-rtl.min.css\";i:30;s:15:\"audio/style.css\";i:31;s:19:\"audio/style.min.css\";i:32;s:19:\"audio/theme-rtl.css\";i:33;s:23:\"audio/theme-rtl.min.css\";i:34;s:15:\"audio/theme.css\";i:35;s:19:\"audio/theme.min.css\";i:36;s:21:\"avatar/editor-rtl.css\";i:37;s:25:\"avatar/editor-rtl.min.css\";i:38;s:17:\"avatar/editor.css\";i:39;s:21:\"avatar/editor.min.css\";i:40;s:20:\"avatar/style-rtl.css\";i:41;s:24:\"avatar/style-rtl.min.css\";i:42;s:16:\"avatar/style.css\";i:43;s:20:\"avatar/style.min.css\";i:44;s:21:\"button/editor-rtl.css\";i:45;s:25:\"button/editor-rtl.min.css\";i:46;s:17:\"button/editor.css\";i:47;s:21:\"button/editor.min.css\";i:48;s:20:\"button/style-rtl.css\";i:49;s:24:\"button/style-rtl.min.css\";i:50;s:16:\"button/style.css\";i:51;s:20:\"button/style.min.css\";i:52;s:22:\"buttons/editor-rtl.css\";i:53;s:26:\"buttons/editor-rtl.min.css\";i:54;s:18:\"buttons/editor.css\";i:55;s:22:\"buttons/editor.min.css\";i:56;s:21:\"buttons/style-rtl.css\";i:57;s:25:\"buttons/style-rtl.min.css\";i:58;s:17:\"buttons/style.css\";i:59;s:21:\"buttons/style.min.css\";i:60;s:22:\"calendar/style-rtl.css\";i:61;s:26:\"calendar/style-rtl.min.css\";i:62;s:18:\"calendar/style.css\";i:63;s:22:\"calendar/style.min.css\";i:64;s:25:\"categories/editor-rtl.css\";i:65;s:29:\"categories/editor-rtl.min.css\";i:66;s:21:\"categories/editor.css\";i:67;s:25:\"categories/editor.min.css\";i:68;s:24:\"categories/style-rtl.css\";i:69;s:28:\"categories/style-rtl.min.css\";i:70;s:20:\"categories/style.css\";i:71;s:24:\"categories/style.min.css\";i:72;s:19:\"code/editor-rtl.css\";i:73;s:23:\"code/editor-rtl.min.css\";i:74;s:15:\"code/editor.css\";i:75;s:19:\"code/editor.min.css\";i:76;s:18:\"code/style-rtl.css\";i:77;s:22:\"code/style-rtl.min.css\";i:78;s:14:\"code/style.css\";i:79;s:18:\"code/style.min.css\";i:80;s:18:\"code/theme-rtl.css\";i:81;s:22:\"code/theme-rtl.min.css\";i:82;s:14:\"code/theme.css\";i:83;s:18:\"code/theme.min.css\";i:84;s:22:\"columns/editor-rtl.css\";i:85;s:26:\"columns/editor-rtl.min.css\";i:86;s:18:\"columns/editor.css\";i:87;s:22:\"columns/editor.min.css\";i:88;s:21:\"columns/style-rtl.css\";i:89;s:25:\"columns/style-rtl.min.css\";i:90;s:17:\"columns/style.css\";i:91;s:21:\"columns/style.min.css\";i:92;s:33:\"comment-author-name/style-rtl.css\";i:93;s:37:\"comment-author-name/style-rtl.min.css\";i:94;s:29:\"comment-author-name/style.css\";i:95;s:33:\"comment-author-name/style.min.css\";i:96;s:29:\"comment-content/style-rtl.css\";i:97;s:33:\"comment-content/style-rtl.min.css\";i:98;s:25:\"comment-content/style.css\";i:99;s:29:\"comment-content/style.min.css\";i:100;s:26:\"comment-date/style-rtl.css\";i:101;s:30:\"comment-date/style-rtl.min.css\";i:102;s:22:\"comment-date/style.css\";i:103;s:26:\"comment-date/style.min.css\";i:104;s:31:\"comment-edit-link/style-rtl.css\";i:105;s:35:\"comment-edit-link/style-rtl.min.css\";i:106;s:27:\"comment-edit-link/style.css\";i:107;s:31:\"comment-edit-link/style.min.css\";i:108;s:32:\"comment-reply-link/style-rtl.css\";i:109;s:36:\"comment-reply-link/style-rtl.min.css\";i:110;s:28:\"comment-reply-link/style.css\";i:111;s:32:\"comment-reply-link/style.min.css\";i:112;s:30:\"comment-template/style-rtl.css\";i:113;s:34:\"comment-template/style-rtl.min.css\";i:114;s:26:\"comment-template/style.css\";i:115;s:30:\"comment-template/style.min.css\";i:116;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:117;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:118;s:38:\"comments-pagination-numbers/editor.css\";i:119;s:42:\"comments-pagination-numbers/editor.min.css\";i:120;s:34:\"comments-pagination/editor-rtl.css\";i:121;s:38:\"comments-pagination/editor-rtl.min.css\";i:122;s:30:\"comments-pagination/editor.css\";i:123;s:34:\"comments-pagination/editor.min.css\";i:124;s:33:\"comments-pagination/style-rtl.css\";i:125;s:37:\"comments-pagination/style-rtl.min.css\";i:126;s:29:\"comments-pagination/style.css\";i:127;s:33:\"comments-pagination/style.min.css\";i:128;s:29:\"comments-title/editor-rtl.css\";i:129;s:33:\"comments-title/editor-rtl.min.css\";i:130;s:25:\"comments-title/editor.css\";i:131;s:29:\"comments-title/editor.min.css\";i:132;s:23:\"comments/editor-rtl.css\";i:133;s:27:\"comments/editor-rtl.min.css\";i:134;s:19:\"comments/editor.css\";i:135;s:23:\"comments/editor.min.css\";i:136;s:22:\"comments/style-rtl.css\";i:137;s:26:\"comments/style-rtl.min.css\";i:138;s:18:\"comments/style.css\";i:139;s:22:\"comments/style.min.css\";i:140;s:20:\"cover/editor-rtl.css\";i:141;s:24:\"cover/editor-rtl.min.css\";i:142;s:16:\"cover/editor.css\";i:143;s:20:\"cover/editor.min.css\";i:144;s:19:\"cover/style-rtl.css\";i:145;s:23:\"cover/style-rtl.min.css\";i:146;s:15:\"cover/style.css\";i:147;s:19:\"cover/style.min.css\";i:148;s:22:\"details/editor-rtl.css\";i:149;s:26:\"details/editor-rtl.min.css\";i:150;s:18:\"details/editor.css\";i:151;s:22:\"details/editor.min.css\";i:152;s:21:\"details/style-rtl.css\";i:153;s:25:\"details/style-rtl.min.css\";i:154;s:17:\"details/style.css\";i:155;s:21:\"details/style.min.css\";i:156;s:20:\"embed/editor-rtl.css\";i:157;s:24:\"embed/editor-rtl.min.css\";i:158;s:16:\"embed/editor.css\";i:159;s:20:\"embed/editor.min.css\";i:160;s:19:\"embed/style-rtl.css\";i:161;s:23:\"embed/style-rtl.min.css\";i:162;s:15:\"embed/style.css\";i:163;s:19:\"embed/style.min.css\";i:164;s:19:\"embed/theme-rtl.css\";i:165;s:23:\"embed/theme-rtl.min.css\";i:166;s:15:\"embed/theme.css\";i:167;s:19:\"embed/theme.min.css\";i:168;s:19:\"file/editor-rtl.css\";i:169;s:23:\"file/editor-rtl.min.css\";i:170;s:15:\"file/editor.css\";i:171;s:19:\"file/editor.min.css\";i:172;s:18:\"file/style-rtl.css\";i:173;s:22:\"file/style-rtl.min.css\";i:174;s:14:\"file/style.css\";i:175;s:18:\"file/style.min.css\";i:176;s:23:\"footnotes/style-rtl.css\";i:177;s:27:\"footnotes/style-rtl.min.css\";i:178;s:19:\"footnotes/style.css\";i:179;s:23:\"footnotes/style.min.css\";i:180;s:23:\"freeform/editor-rtl.css\";i:181;s:27:\"freeform/editor-rtl.min.css\";i:182;s:19:\"freeform/editor.css\";i:183;s:23:\"freeform/editor.min.css\";i:184;s:22:\"gallery/editor-rtl.css\";i:185;s:26:\"gallery/editor-rtl.min.css\";i:186;s:18:\"gallery/editor.css\";i:187;s:22:\"gallery/editor.min.css\";i:188;s:21:\"gallery/style-rtl.css\";i:189;s:25:\"gallery/style-rtl.min.css\";i:190;s:17:\"gallery/style.css\";i:191;s:21:\"gallery/style.min.css\";i:192;s:21:\"gallery/theme-rtl.css\";i:193;s:25:\"gallery/theme-rtl.min.css\";i:194;s:17:\"gallery/theme.css\";i:195;s:21:\"gallery/theme.min.css\";i:196;s:20:\"group/editor-rtl.css\";i:197;s:24:\"group/editor-rtl.min.css\";i:198;s:16:\"group/editor.css\";i:199;s:20:\"group/editor.min.css\";i:200;s:19:\"group/style-rtl.css\";i:201;s:23:\"group/style-rtl.min.css\";i:202;s:15:\"group/style.css\";i:203;s:19:\"group/style.min.css\";i:204;s:19:\"group/theme-rtl.css\";i:205;s:23:\"group/theme-rtl.min.css\";i:206;s:15:\"group/theme.css\";i:207;s:19:\"group/theme.min.css\";i:208;s:21:\"heading/style-rtl.css\";i:209;s:25:\"heading/style-rtl.min.css\";i:210;s:17:\"heading/style.css\";i:211;s:21:\"heading/style.min.css\";i:212;s:19:\"html/editor-rtl.css\";i:213;s:23:\"html/editor-rtl.min.css\";i:214;s:15:\"html/editor.css\";i:215;s:19:\"html/editor.min.css\";i:216;s:20:\"image/editor-rtl.css\";i:217;s:24:\"image/editor-rtl.min.css\";i:218;s:16:\"image/editor.css\";i:219;s:20:\"image/editor.min.css\";i:220;s:19:\"image/style-rtl.css\";i:221;s:23:\"image/style-rtl.min.css\";i:222;s:15:\"image/style.css\";i:223;s:19:\"image/style.min.css\";i:224;s:19:\"image/theme-rtl.css\";i:225;s:23:\"image/theme-rtl.min.css\";i:226;s:15:\"image/theme.css\";i:227;s:19:\"image/theme.min.css\";i:228;s:29:\"latest-comments/style-rtl.css\";i:229;s:33:\"latest-comments/style-rtl.min.css\";i:230;s:25:\"latest-comments/style.css\";i:231;s:29:\"latest-comments/style.min.css\";i:232;s:27:\"latest-posts/editor-rtl.css\";i:233;s:31:\"latest-posts/editor-rtl.min.css\";i:234;s:23:\"latest-posts/editor.css\";i:235;s:27:\"latest-posts/editor.min.css\";i:236;s:26:\"latest-posts/style-rtl.css\";i:237;s:30:\"latest-posts/style-rtl.min.css\";i:238;s:22:\"latest-posts/style.css\";i:239;s:26:\"latest-posts/style.min.css\";i:240;s:18:\"list/style-rtl.css\";i:241;s:22:\"list/style-rtl.min.css\";i:242;s:14:\"list/style.css\";i:243;s:18:\"list/style.min.css\";i:244;s:22:\"loginout/style-rtl.css\";i:245;s:26:\"loginout/style-rtl.min.css\";i:246;s:18:\"loginout/style.css\";i:247;s:22:\"loginout/style.min.css\";i:248;s:19:\"math/editor-rtl.css\";i:249;s:23:\"math/editor-rtl.min.css\";i:250;s:15:\"math/editor.css\";i:251;s:19:\"math/editor.min.css\";i:252;s:18:\"math/style-rtl.css\";i:253;s:22:\"math/style-rtl.min.css\";i:254;s:14:\"math/style.css\";i:255;s:18:\"math/style.min.css\";i:256;s:25:\"media-text/editor-rtl.css\";i:257;s:29:\"media-text/editor-rtl.min.css\";i:258;s:21:\"media-text/editor.css\";i:259;s:25:\"media-text/editor.min.css\";i:260;s:24:\"media-text/style-rtl.css\";i:261;s:28:\"media-text/style-rtl.min.css\";i:262;s:20:\"media-text/style.css\";i:263;s:24:\"media-text/style.min.css\";i:264;s:19:\"more/editor-rtl.css\";i:265;s:23:\"more/editor-rtl.min.css\";i:266;s:15:\"more/editor.css\";i:267;s:19:\"more/editor.min.css\";i:268;s:30:\"navigation-link/editor-rtl.css\";i:269;s:34:\"navigation-link/editor-rtl.min.css\";i:270;s:26:\"navigation-link/editor.css\";i:271;s:30:\"navigation-link/editor.min.css\";i:272;s:29:\"navigation-link/style-rtl.css\";i:273;s:33:\"navigation-link/style-rtl.min.css\";i:274;s:25:\"navigation-link/style.css\";i:275;s:29:\"navigation-link/style.min.css\";i:276;s:33:\"navigation-submenu/editor-rtl.css\";i:277;s:37:\"navigation-submenu/editor-rtl.min.css\";i:278;s:29:\"navigation-submenu/editor.css\";i:279;s:33:\"navigation-submenu/editor.min.css\";i:280;s:25:\"navigation/editor-rtl.css\";i:281;s:29:\"navigation/editor-rtl.min.css\";i:282;s:21:\"navigation/editor.css\";i:283;s:25:\"navigation/editor.min.css\";i:284;s:24:\"navigation/style-rtl.css\";i:285;s:28:\"navigation/style-rtl.min.css\";i:286;s:20:\"navigation/style.css\";i:287;s:24:\"navigation/style.min.css\";i:288;s:23:\"nextpage/editor-rtl.css\";i:289;s:27:\"nextpage/editor-rtl.min.css\";i:290;s:19:\"nextpage/editor.css\";i:291;s:23:\"nextpage/editor.min.css\";i:292;s:24:\"page-list/editor-rtl.css\";i:293;s:28:\"page-list/editor-rtl.min.css\";i:294;s:20:\"page-list/editor.css\";i:295;s:24:\"page-list/editor.min.css\";i:296;s:23:\"page-list/style-rtl.css\";i:297;s:27:\"page-list/style-rtl.min.css\";i:298;s:19:\"page-list/style.css\";i:299;s:23:\"page-list/style.min.css\";i:300;s:24:\"paragraph/editor-rtl.css\";i:301;s:28:\"paragraph/editor-rtl.min.css\";i:302;s:20:\"paragraph/editor.css\";i:303;s:24:\"paragraph/editor.min.css\";i:304;s:23:\"paragraph/style-rtl.css\";i:305;s:27:\"paragraph/style-rtl.min.css\";i:306;s:19:\"paragraph/style.css\";i:307;s:23:\"paragraph/style.min.css\";i:308;s:35:\"post-author-biography/style-rtl.css\";i:309;s:39:\"post-author-biography/style-rtl.min.css\";i:310;s:31:\"post-author-biography/style.css\";i:311;s:35:\"post-author-biography/style.min.css\";i:312;s:30:\"post-author-name/style-rtl.css\";i:313;s:34:\"post-author-name/style-rtl.min.css\";i:314;s:26:\"post-author-name/style.css\";i:315;s:30:\"post-author-name/style.min.css\";i:316;s:25:\"post-author/style-rtl.css\";i:317;s:29:\"post-author/style-rtl.min.css\";i:318;s:21:\"post-author/style.css\";i:319;s:25:\"post-author/style.min.css\";i:320;s:33:\"post-comments-count/style-rtl.css\";i:321;s:37:\"post-comments-count/style-rtl.min.css\";i:322;s:29:\"post-comments-count/style.css\";i:323;s:33:\"post-comments-count/style.min.css\";i:324;s:33:\"post-comments-form/editor-rtl.css\";i:325;s:37:\"post-comments-form/editor-rtl.min.css\";i:326;s:29:\"post-comments-form/editor.css\";i:327;s:33:\"post-comments-form/editor.min.css\";i:328;s:32:\"post-comments-form/style-rtl.css\";i:329;s:36:\"post-comments-form/style-rtl.min.css\";i:330;s:28:\"post-comments-form/style.css\";i:331;s:32:\"post-comments-form/style.min.css\";i:332;s:32:\"post-comments-link/style-rtl.css\";i:333;s:36:\"post-comments-link/style-rtl.min.css\";i:334;s:28:\"post-comments-link/style.css\";i:335;s:32:\"post-comments-link/style.min.css\";i:336;s:26:\"post-content/style-rtl.css\";i:337;s:30:\"post-content/style-rtl.min.css\";i:338;s:22:\"post-content/style.css\";i:339;s:26:\"post-content/style.min.css\";i:340;s:23:\"post-date/style-rtl.css\";i:341;s:27:\"post-date/style-rtl.min.css\";i:342;s:19:\"post-date/style.css\";i:343;s:23:\"post-date/style.min.css\";i:344;s:27:\"post-excerpt/editor-rtl.css\";i:345;s:31:\"post-excerpt/editor-rtl.min.css\";i:346;s:23:\"post-excerpt/editor.css\";i:347;s:27:\"post-excerpt/editor.min.css\";i:348;s:26:\"post-excerpt/style-rtl.css\";i:349;s:30:\"post-excerpt/style-rtl.min.css\";i:350;s:22:\"post-excerpt/style.css\";i:351;s:26:\"post-excerpt/style.min.css\";i:352;s:34:\"post-featured-image/editor-rtl.css\";i:353;s:38:\"post-featured-image/editor-rtl.min.css\";i:354;s:30:\"post-featured-image/editor.css\";i:355;s:34:\"post-featured-image/editor.min.css\";i:356;s:33:\"post-featured-image/style-rtl.css\";i:357;s:37:\"post-featured-image/style-rtl.min.css\";i:358;s:29:\"post-featured-image/style.css\";i:359;s:33:\"post-featured-image/style.min.css\";i:360;s:34:\"post-navigation-link/style-rtl.css\";i:361;s:38:\"post-navigation-link/style-rtl.min.css\";i:362;s:30:\"post-navigation-link/style.css\";i:363;s:34:\"post-navigation-link/style.min.css\";i:364;s:27:\"post-template/style-rtl.css\";i:365;s:31:\"post-template/style-rtl.min.css\";i:366;s:23:\"post-template/style.css\";i:367;s:27:\"post-template/style.min.css\";i:368;s:24:\"post-terms/style-rtl.css\";i:369;s:28:\"post-terms/style-rtl.min.css\";i:370;s:20:\"post-terms/style.css\";i:371;s:24:\"post-terms/style.min.css\";i:372;s:31:\"post-time-to-read/style-rtl.css\";i:373;s:35:\"post-time-to-read/style-rtl.min.css\";i:374;s:27:\"post-time-to-read/style.css\";i:375;s:31:\"post-time-to-read/style.min.css\";i:376;s:24:\"post-title/style-rtl.css\";i:377;s:28:\"post-title/style-rtl.min.css\";i:378;s:20:\"post-title/style.css\";i:379;s:24:\"post-title/style.min.css\";i:380;s:26:\"preformatted/style-rtl.css\";i:381;s:30:\"preformatted/style-rtl.min.css\";i:382;s:22:\"preformatted/style.css\";i:383;s:26:\"preformatted/style.min.css\";i:384;s:24:\"pullquote/editor-rtl.css\";i:385;s:28:\"pullquote/editor-rtl.min.css\";i:386;s:20:\"pullquote/editor.css\";i:387;s:24:\"pullquote/editor.min.css\";i:388;s:23:\"pullquote/style-rtl.css\";i:389;s:27:\"pullquote/style-rtl.min.css\";i:390;s:19:\"pullquote/style.css\";i:391;s:23:\"pullquote/style.min.css\";i:392;s:23:\"pullquote/theme-rtl.css\";i:393;s:27:\"pullquote/theme-rtl.min.css\";i:394;s:19:\"pullquote/theme.css\";i:395;s:23:\"pullquote/theme.min.css\";i:396;s:39:\"query-pagination-numbers/editor-rtl.css\";i:397;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:398;s:35:\"query-pagination-numbers/editor.css\";i:399;s:39:\"query-pagination-numbers/editor.min.css\";i:400;s:31:\"query-pagination/editor-rtl.css\";i:401;s:35:\"query-pagination/editor-rtl.min.css\";i:402;s:27:\"query-pagination/editor.css\";i:403;s:31:\"query-pagination/editor.min.css\";i:404;s:30:\"query-pagination/style-rtl.css\";i:405;s:34:\"query-pagination/style-rtl.min.css\";i:406;s:26:\"query-pagination/style.css\";i:407;s:30:\"query-pagination/style.min.css\";i:408;s:25:\"query-title/style-rtl.css\";i:409;s:29:\"query-title/style-rtl.min.css\";i:410;s:21:\"query-title/style.css\";i:411;s:25:\"query-title/style.min.css\";i:412;s:25:\"query-total/style-rtl.css\";i:413;s:29:\"query-total/style-rtl.min.css\";i:414;s:21:\"query-total/style.css\";i:415;s:25:\"query-total/style.min.css\";i:416;s:20:\"query/editor-rtl.css\";i:417;s:24:\"query/editor-rtl.min.css\";i:418;s:16:\"query/editor.css\";i:419;s:20:\"query/editor.min.css\";i:420;s:19:\"quote/style-rtl.css\";i:421;s:23:\"quote/style-rtl.min.css\";i:422;s:15:\"quote/style.css\";i:423;s:19:\"quote/style.min.css\";i:424;s:19:\"quote/theme-rtl.css\";i:425;s:23:\"quote/theme-rtl.min.css\";i:426;s:15:\"quote/theme.css\";i:427;s:19:\"quote/theme.min.css\";i:428;s:23:\"read-more/style-rtl.css\";i:429;s:27:\"read-more/style-rtl.min.css\";i:430;s:19:\"read-more/style.css\";i:431;s:23:\"read-more/style.min.css\";i:432;s:18:\"rss/editor-rtl.css\";i:433;s:22:\"rss/editor-rtl.min.css\";i:434;s:14:\"rss/editor.css\";i:435;s:18:\"rss/editor.min.css\";i:436;s:17:\"rss/style-rtl.css\";i:437;s:21:\"rss/style-rtl.min.css\";i:438;s:13:\"rss/style.css\";i:439;s:17:\"rss/style.min.css\";i:440;s:21:\"search/editor-rtl.css\";i:441;s:25:\"search/editor-rtl.min.css\";i:442;s:17:\"search/editor.css\";i:443;s:21:\"search/editor.min.css\";i:444;s:20:\"search/style-rtl.css\";i:445;s:24:\"search/style-rtl.min.css\";i:446;s:16:\"search/style.css\";i:447;s:20:\"search/style.min.css\";i:448;s:20:\"search/theme-rtl.css\";i:449;s:24:\"search/theme-rtl.min.css\";i:450;s:16:\"search/theme.css\";i:451;s:20:\"search/theme.min.css\";i:452;s:24:\"separator/editor-rtl.css\";i:453;s:28:\"separator/editor-rtl.min.css\";i:454;s:20:\"separator/editor.css\";i:455;s:24:\"separator/editor.min.css\";i:456;s:23:\"separator/style-rtl.css\";i:457;s:27:\"separator/style-rtl.min.css\";i:458;s:19:\"separator/style.css\";i:459;s:23:\"separator/style.min.css\";i:460;s:23:\"separator/theme-rtl.css\";i:461;s:27:\"separator/theme-rtl.min.css\";i:462;s:19:\"separator/theme.css\";i:463;s:23:\"separator/theme.min.css\";i:464;s:24:\"shortcode/editor-rtl.css\";i:465;s:28:\"shortcode/editor-rtl.min.css\";i:466;s:20:\"shortcode/editor.css\";i:467;s:24:\"shortcode/editor.min.css\";i:468;s:24:\"site-logo/editor-rtl.css\";i:469;s:28:\"site-logo/editor-rtl.min.css\";i:470;s:20:\"site-logo/editor.css\";i:471;s:24:\"site-logo/editor.min.css\";i:472;s:23:\"site-logo/style-rtl.css\";i:473;s:27:\"site-logo/style-rtl.min.css\";i:474;s:19:\"site-logo/style.css\";i:475;s:23:\"site-logo/style.min.css\";i:476;s:27:\"site-tagline/editor-rtl.css\";i:477;s:31:\"site-tagline/editor-rtl.min.css\";i:478;s:23:\"site-tagline/editor.css\";i:479;s:27:\"site-tagline/editor.min.css\";i:480;s:26:\"site-tagline/style-rtl.css\";i:481;s:30:\"site-tagline/style-rtl.min.css\";i:482;s:22:\"site-tagline/style.css\";i:483;s:26:\"site-tagline/style.min.css\";i:484;s:25:\"site-title/editor-rtl.css\";i:485;s:29:\"site-title/editor-rtl.min.css\";i:486;s:21:\"site-title/editor.css\";i:487;s:25:\"site-title/editor.min.css\";i:488;s:24:\"site-title/style-rtl.css\";i:489;s:28:\"site-title/style-rtl.min.css\";i:490;s:20:\"site-title/style.css\";i:491;s:24:\"site-title/style.min.css\";i:492;s:26:\"social-link/editor-rtl.css\";i:493;s:30:\"social-link/editor-rtl.min.css\";i:494;s:22:\"social-link/editor.css\";i:495;s:26:\"social-link/editor.min.css\";i:496;s:27:\"social-links/editor-rtl.css\";i:497;s:31:\"social-links/editor-rtl.min.css\";i:498;s:23:\"social-links/editor.css\";i:499;s:27:\"social-links/editor.min.css\";i:500;s:26:\"social-links/style-rtl.css\";i:501;s:30:\"social-links/style-rtl.min.css\";i:502;s:22:\"social-links/style.css\";i:503;s:26:\"social-links/style.min.css\";i:504;s:21:\"spacer/editor-rtl.css\";i:505;s:25:\"spacer/editor-rtl.min.css\";i:506;s:17:\"spacer/editor.css\";i:507;s:21:\"spacer/editor.min.css\";i:508;s:20:\"spacer/style-rtl.css\";i:509;s:24:\"spacer/style-rtl.min.css\";i:510;s:16:\"spacer/style.css\";i:511;s:20:\"spacer/style.min.css\";i:512;s:20:\"table/editor-rtl.css\";i:513;s:24:\"table/editor-rtl.min.css\";i:514;s:16:\"table/editor.css\";i:515;s:20:\"table/editor.min.css\";i:516;s:19:\"table/style-rtl.css\";i:517;s:23:\"table/style-rtl.min.css\";i:518;s:15:\"table/style.css\";i:519;s:19:\"table/style.min.css\";i:520;s:19:\"table/theme-rtl.css\";i:521;s:23:\"table/theme-rtl.min.css\";i:522;s:15:\"table/theme.css\";i:523;s:19:\"table/theme.min.css\";i:524;s:24:\"tag-cloud/editor-rtl.css\";i:525;s:28:\"tag-cloud/editor-rtl.min.css\";i:526;s:20:\"tag-cloud/editor.css\";i:527;s:24:\"tag-cloud/editor.min.css\";i:528;s:23:\"tag-cloud/style-rtl.css\";i:529;s:27:\"tag-cloud/style-rtl.min.css\";i:530;s:19:\"tag-cloud/style.css\";i:531;s:23:\"tag-cloud/style.min.css\";i:532;s:28:\"template-part/editor-rtl.css\";i:533;s:32:\"template-part/editor-rtl.min.css\";i:534;s:24:\"template-part/editor.css\";i:535;s:28:\"template-part/editor.min.css\";i:536;s:27:\"template-part/theme-rtl.css\";i:537;s:31:\"template-part/theme-rtl.min.css\";i:538;s:23:\"template-part/theme.css\";i:539;s:27:\"template-part/theme.min.css\";i:540;s:24:\"term-count/style-rtl.css\";i:541;s:28:\"term-count/style-rtl.min.css\";i:542;s:20:\"term-count/style.css\";i:543;s:24:\"term-count/style.min.css\";i:544;s:30:\"term-description/style-rtl.css\";i:545;s:34:\"term-description/style-rtl.min.css\";i:546;s:26:\"term-description/style.css\";i:547;s:30:\"term-description/style.min.css\";i:548;s:23:\"term-name/style-rtl.css\";i:549;s:27:\"term-name/style-rtl.min.css\";i:550;s:19:\"term-name/style.css\";i:551;s:23:\"term-name/style.min.css\";i:552;s:28:\"term-template/editor-rtl.css\";i:553;s:32:\"term-template/editor-rtl.min.css\";i:554;s:24:\"term-template/editor.css\";i:555;s:28:\"term-template/editor.min.css\";i:556;s:27:\"term-template/style-rtl.css\";i:557;s:31:\"term-template/style-rtl.min.css\";i:558;s:23:\"term-template/style.css\";i:559;s:27:\"term-template/style.min.css\";i:560;s:27:\"text-columns/editor-rtl.css\";i:561;s:31:\"text-columns/editor-rtl.min.css\";i:562;s:23:\"text-columns/editor.css\";i:563;s:27:\"text-columns/editor.min.css\";i:564;s:26:\"text-columns/style-rtl.css\";i:565;s:30:\"text-columns/style-rtl.min.css\";i:566;s:22:\"text-columns/style.css\";i:567;s:26:\"text-columns/style.min.css\";i:568;s:19:\"verse/style-rtl.css\";i:569;s:23:\"verse/style-rtl.min.css\";i:570;s:15:\"verse/style.css\";i:571;s:19:\"verse/style.min.css\";i:572;s:20:\"video/editor-rtl.css\";i:573;s:24:\"video/editor-rtl.min.css\";i:574;s:16:\"video/editor.css\";i:575;s:20:\"video/editor.min.css\";i:576;s:19:\"video/style-rtl.css\";i:577;s:23:\"video/style-rtl.min.css\";i:578;s:15:\"video/style.css\";i:579;s:19:\"video/style.min.css\";i:580;s:19:\"video/theme-rtl.css\";i:581;s:23:\"video/theme-rtl.min.css\";i:582;s:15:\"video/theme.css\";i:583;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("125", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("126", "WPLANG", "fr_FR", "auto");
INSERT INTO `wp_options` VALUES("128", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1759405676;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("129", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"5d705ffd489ec04773496ae63651db2e\";s:6:\"blocks\";a:11:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";s:34:\"surecart/slide-out-cart-line-items\";s:0:\"\";s:27:\"surecart/product-buy-button\";s:0:\"\";s:32:\"surecart/product-collection-tags\";s:0:\"\";s:25:\"surecart/product-template\";s:0:\"\";s:16:\"surecart/columns\";s:0:\"\";s:34:\"surecart/product-collection-badges\";s:0:\"\";}}", "on");
INSERT INTO `wp_options` VALUES("154", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("174", "current_theme", "Astra", "auto");
INSERT INTO `wp_options` VALUES("175", "theme_mods_astra", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:4:{s:7:\"primary\";i:7;s:14:\"secondary_menu\";i:7;s:11:\"mobile_menu\";i:7;s:11:\"footer_menu\";i:7;}s:18:\"custom_css_post_id\";i:29;s:11:\"custom_logo\";i:1586;}", "on");
INSERT INTO `wp_options` VALUES("176", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("179", "astra-settings", "a:2046:{s:17:\"blog-single-width\";s:7:\"default\";s:21:\"blog-single-max-width\";i:1200;s:17:\"page-single-width\";s:7:\"default\";s:21:\"page-single-max-width\";i:1200;s:28:\"single-content-images-shadow\";b:1;s:30:\"single-post-ast-content-layout\";s:22:\"narrow-width-container\";s:25:\"single-post-sidebar-style\";s:5:\"boxed\";s:36:\"ast-dynamic-single-post-elements-gap\";i:25;s:38:\"ast-dynamic-single-post-meta-font-size\";a:6:{s:7:\"desktop\";i:13;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:40:\"ast-dynamic-single-post-meta-font-weight\";s:3:\"600\";s:32:\"ast-dynamic-single-post-metadata\";a:2:{i:0;s:6:\"author\";i:1;s:4:\"date\";}s:35:\"section-search-page-title-structure\";a:2:{i:0;s:31:\"section-search-page-title-title\";i:1;s:36:\"section-search-page-title-breadcrumb\";}s:38:\"section-search-page-title-custom-title\";s:19:\"Search Results for:\";s:50:\"section-search-page-title-found-custom-description\";s:44:\"Here are the search results for your search.\";s:54:\"section-search-page-title-not-found-custom-description\";s:85:\"Sorry, but we could not find anything related to your search terms. Please try again.\";s:43:\"section-search-page-title-title-font-weight\";s:3:\"600\";s:41:\"section-search-page-title-title-font-size\";a:6:{s:7:\"desktop\";i:32;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"ast-search-results-per-page\";i:10;s:46:\"section-search-page-title-horizontal-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:22:\"ast-search-live-search\";b:0;s:33:\"ast-search-live-search-post-types\";a:2:{s:4:\"post\";i:1;s:4:\"page\";i:1;}s:19:\"blog-post-structure\";a:5:{i:0;s:5:\"image\";i:1;s:5:\"title\";i:2;s:10:\"title-meta\";i:3;s:7:\"excerpt\";i:4;s:9:\"read-more\";}s:18:\"blog-post-per-page\";i:10;s:17:\"blog-hover-effect\";s:7:\"zoom-in\";s:11:\"blog-layout\";s:13:\"blog-layout-4\";s:10:\"blog-width\";s:7:\"default\";s:19:\"blog-meta-date-type\";s:9:\"published\";s:21:\"blog-meta-date-format\";s:0:\"\";s:14:\"blog-max-width\";i:1200;s:17:\"blog-post-content\";s:7:\"excerpt\";s:9:\"blog-meta\";a:1:{i:0;s:4:\"date\";}s:23:\"post-card-border-radius\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:2:\"20\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:2:\"20\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"20\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:2:\"20\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"post-card-featured-overlay\";s:0:\"\";s:19:\"blog-category-style\";s:7:\"default\";s:14:\"blog-tag-style\";s:7:\"default\";s:27:\"blog-post-meta-divider-type\";s:1:\"/\";s:24:\"blog-meta-category-style\";s:7:\"default\";s:19:\"blog-meta-tag-style\";s:7:\"default\";s:21:\"blog-image-ratio-type\";s:6:\"custom\";s:26:\"blog-image-ratio-pre-scale\";s:4:\"16/9\";s:29:\"blog-image-custom-scale-width\";i:4;s:30:\"blog-image-custom-scale-height\";i:3;s:10:\"text-color\";s:25:\"var(--ast-global-color-3)\";s:10:\"link-color\";s:25:\"var(--ast-global-color-0)\";s:11:\"theme-color\";s:25:\"var(--ast-global-color-0)\";s:12:\"link-h-color\";s:25:\"var(--ast-global-color-1)\";s:18:\"heading-base-color\";s:25:\"var(--ast-global-color-2)\";s:12:\"border-color\";s:25:\"var(--ast-global-color-6)\";s:13:\"footer-bg-obj\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:12:\"footer-color\";s:0:\"\";s:17:\"footer-link-color\";s:0:\"\";s:19:\"footer-link-h-color\";s:0:\"\";s:17:\"footer-adv-bg-obj\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:21:\"footer-adv-text-color\";s:0:\"\";s:21:\"footer-adv-link-color\";s:0:\"\";s:23:\"footer-adv-link-h-color\";s:0:\"\";s:26:\"footer-adv-wgt-title-color\";s:0:\"\";s:12:\"button-color\";s:7:\"#ffffff\";s:14:\"button-h-color\";s:7:\"#ffffff\";s:15:\"button-bg-color\";s:25:\"var(--ast-global-color-0)\";s:17:\"button-bg-h-color\";s:25:\"var(--ast-global-color-1)\";s:27:\"secondary-button-bg-h-color\";s:25:\"var(--ast-global-color-1)\";s:25:\"secondary-button-bg-color\";s:0:\"\";s:22:\"secondary-button-color\";s:25:\"var(--ast-global-color-0)\";s:24:\"secondary-button-h-color\";s:7:\"#ffffff\";s:20:\"theme-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"17\";s:5:\"right\";s:2:\"34\";s:6:\"bottom\";s:2:\"17\";s:4:\"left\";s:2:\"34\";}s:6:\"tablet\";a:4:{s:3:\"top\";i:14;s:5:\"right\";i:28;s:6:\"bottom\";i:14;s:4:\"left\";i:28;}s:6:\"mobile\";a:4:{s:3:\"top\";i:12;s:5:\"right\";i:24;s:6:\"bottom\";i:12;s:4:\"left\";i:24;}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"secondary-theme-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"17\";s:5:\"right\";s:2:\"34\";s:6:\"bottom\";s:2:\"17\";s:4:\"left\";s:2:\"34\";}s:6:\"tablet\";a:4:{s:3:\"top\";i:12;s:5:\"right\";i:28;s:6:\"bottom\";i:12;s:4:\"left\";i:28;}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"12\";s:5:\"right\";i:24;s:6:\"bottom\";s:2:\"12\";s:4:\"left\";i:24;}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"button-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"50\";s:5:\"right\";s:2:\"50\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"50\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"secondary-button-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"50\";s:5:\"right\";s:2:\"50\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"50\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"theme-button-border-group-border-size\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";}s:47:\"secondary-theme-button-border-group-border-size\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";}s:17:\"footer-sml-layout\";s:19:\"footer-sml-layout-1\";s:20:\"footer-sml-section-1\";s:6:\"custom\";s:27:\"footer-sml-section-1-credit\";s:68:\"Copyright © [current_year] [site_title] | Powered by [theme_author]\";s:20:\"footer-sml-section-2\";s:0:\"\";s:27:\"footer-sml-section-2-credit\";s:68:\"Copyright © [current_year] [site_title] | Powered by [theme_author]\";s:27:\"footer-sml-dist-equal-align\";b:1;s:18:\"footer-sml-divider\";i:1;s:24:\"footer-sml-divider-color\";s:7:\"#7a7a7a\";s:19:\"footer-layout-width\";s:7:\"content\";s:22:\"ast-header-retina-logo\";s:65:\"http://cetef-test.local/wp-content/uploads/2025/10/Logo_CETEF.jpg\";s:17:\"use-logo-svg-icon\";b:0;s:13:\"logo-svg-icon\";a:2:{s:4:\"type\";s:0:\"\";s:5:\"value\";s:0:\"\";}s:23:\"logo-svg-site-title-gap\";a:3:{s:7:\"desktop\";s:1:\"5\";s:6:\"tablet\";s:1:\"5\";s:6:\"mobile\";s:1:\"5\";}s:21:\"ast-header-logo-width\";s:0:\"\";s:32:\"ast-header-responsive-logo-width\";a:3:{s:7:\"desktop\";s:3:\"139\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-color-site-title\";s:25:\"var(--ast-global-color-2)\";s:25:\"header-color-h-site-title\";s:0:\"\";s:25:\"header-color-site-tagline\";s:0:\"\";s:29:\"display-site-title-responsive\";a:3:{s:7:\"desktop\";b:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:31:\"display-site-tagline-responsive\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:17:\"logo-title-inline\";b:0;s:19:\"disable-primary-nav\";b:0;s:14:\"header-layouts\";s:20:\"header-main-layout-1\";s:22:\"header-main-rt-section\";s:4:\"none\";s:27:\"header-display-outside-menu\";b:0;s:27:\"header-main-rt-section-html\";s:27:\"<button>Contact Us</button>\";s:34:\"header-main-rt-section-button-text\";s:6:\"Button\";s:34:\"header-main-rt-section-button-link\";s:23:\"https://www.wpastra.com\";s:41:\"header-main-rt-section-button-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:35:\"header-main-rt-section-button-style\";s:12:\"theme-button\";s:40:\"header-main-rt-section-button-text-color\";s:0:\"\";s:40:\"header-main-rt-section-button-back-color\";s:0:\"\";s:42:\"header-main-rt-section-button-text-h-color\";s:0:\"\";s:42:\"header-main-rt-section-button-back-h-color\";s:0:\"\";s:37:\"header-main-rt-section-button-padding\";a:3:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}}s:41:\"header-main-rt-section-button-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:15:\"header-main-sep\";i:1;s:21:\"header-main-sep-color\";s:0:\"\";s:24:\"header-main-layout-width\";s:7:\"content\";s:22:\"primary-submenu-border\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:27:\"primary-submenu-item-border\";b:0;s:23:\"primary-submenu-b-color\";s:0:\"\";s:28:\"primary-submenu-item-b-color\";s:0:\"\";s:33:\"primary-header-button-font-family\";s:7:\"inherit\";s:33:\"primary-header-button-font-weight\";s:7:\"inherit\";s:31:\"primary-header-button-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"primary-header-button-text-transform\";s:0:\"\";s:33:\"primary-header-button-line-height\";i:1;s:36:\"primary-header-button-letter-spacing\";s:0:\"\";s:22:\"header-main-menu-label\";s:0:\"\";s:22:\"header-main-menu-align\";s:6:\"inline\";s:39:\"header-main-submenu-container-animation\";s:0:\"\";s:24:\"mobile-header-breakpoint\";s:0:\"\";s:18:\"mobile-header-logo\";s:0:\"\";s:24:\"mobile-header-logo-width\";s:0:\"\";s:11:\"site-layout\";s:21:\"ast-full-width-layout\";s:18:\"site-content-width\";i:1200;s:26:\"narrow-container-max-width\";i:750;s:37:\"site-layout-outside-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:25:\"content-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:12:\"wp-blocks-ui\";s:7:\"comfort\";s:24:\"wp-blocks-global-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:20:\"enable-comments-area\";b:1;s:22:\"comments-box-placement\";s:0:\"\";s:21:\"comment-form-position\";s:5:\"below\";s:28:\"comments-box-container-width\";s:0:\"\";s:31:\"ast-sub-section-comments-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:2;s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:32:\"ast-sub-section-comments-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";i:2;s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:30:\"single-page-ast-content-layout\";s:22:\"normal-width-container\";s:25:\"single-page-content-style\";s:7:\"unboxed\";s:25:\"single-post-content-style\";s:7:\"unboxed\";s:31:\"archive-post-ast-content-layout\";s:7:\"default\";s:23:\"ast-site-content-layout\";s:22:\"normal-width-container\";s:18:\"site-content-style\";s:5:\"boxed\";s:16:\"body-font-family\";s:21:\"\'Manrope\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:14;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:20:\"headings-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:18:\"para-margin-bottom\";s:0:\"\";s:23:\"underline-content-links\";b:1;s:25:\"site-accessibility-toggle\";b:1;s:33:\"site-accessibility-highlight-type\";s:6:\"dotted\";s:39:\"site-accessibility-highlight-input-type\";s:7:\"disable\";s:19:\"body-text-transform\";s:0:\"\";s:20:\"headings-font-family\";s:17:\"\'PT Serif\', serif\";s:20:\"headings-font-weight\";s:3:\"400\";s:20:\"font-size-site-title\";a:6:{s:7:\"desktop\";i:24;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"font-size-site-tagline\";a:6:{s:7:\"desktop\";i:17;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"single-post-outside-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:2:\"40\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"30\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"font-size-page-title\";a:6:{s:7:\"desktop\";i:22;s:6:\"tablet\";i:22;s:6:\"mobile\";i:20;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:18:\"font-size-post-tax\";a:6:{s:7:\"desktop\";i:14;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"font-size-post-meta\";a:6:{s:7:\"desktop\";i:12;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h1\";a:6:{s:7:\"desktop\";i:54;s:6:\"tablet\";i:40;s:6:\"mobile\";i:32;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h2\";a:6:{s:7:\"desktop\";i:42;s:6:\"tablet\";i:32;s:6:\"mobile\";i:26;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h3\";a:6:{s:7:\"desktop\";i:28;s:6:\"tablet\";i:24;s:6:\"mobile\";i:22;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h4\";a:6:{s:7:\"desktop\";i:24;s:6:\"tablet\";i:22;s:6:\"mobile\";i:20;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h5\";a:6:{s:7:\"desktop\";i:20;s:6:\"tablet\";i:18;s:6:\"mobile\";i:18;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h6\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:16;s:6:\"mobile\";i:16;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"site-sidebar-layout\";s:10:\"no-sidebar\";s:18:\"site-sidebar-width\";i:30;s:26:\"single-page-sidebar-layout\";s:10:\"no-sidebar\";s:26:\"single-post-sidebar-layout\";s:7:\"default\";s:27:\"archive-post-sidebar-layout\";s:7:\"default\";s:19:\"site-sticky-sidebar\";b:0;s:18:\"site-sidebar-style\";s:7:\"unboxed\";s:25:\"single-page-sidebar-style\";s:7:\"unboxed\";s:26:\"archive-post-sidebar-style\";s:7:\"default\";s:10:\"footer-adv\";s:8:\"disabled\";s:23:\"footer-adv-border-width\";s:0:\"\";s:23:\"footer-adv-border-color\";s:7:\"#7a7a7a\";s:30:\"mobile-header-toggle-btn-style\";s:7:\"outline\";s:23:\"hide-custom-menu-mobile\";i:1;s:27:\"mobile-header-toggle-target\";s:4:\"icon\";s:19:\"enable-scroll-to-id\";b:1;s:37:\"ast-dynamic-single-download-structure\";a:3:{i:0;s:33:\"ast-dynamic-single-download-title\";i:1;s:32:\"ast-dynamic-single-download-meta\";i:2;s:33:\"ast-dynamic-single-download-image\";}s:20:\"enable-related-posts\";b:1;s:19:\"related-posts-title\";s:13:\"Related Posts\";s:29:\"releted-posts-title-alignment\";s:4:\"left\";s:25:\"related-posts-total-count\";i:2;s:28:\"enable-related-posts-excerpt\";b:0;s:27:\"related-posts-box-placement\";s:7:\"default\";s:30:\"related-posts-outside-location\";s:5:\"above\";s:29:\"related-posts-container-width\";s:0:\"\";s:27:\"related-posts-excerpt-count\";i:25;s:22:\"related-posts-based-on\";s:10:\"categories\";s:22:\"related-posts-order-by\";s:4:\"date\";s:19:\"related-posts-order\";s:3:\"asc\";s:29:\"related-posts-grid-responsive\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:23:\"related-posts-structure\";a:2:{i:0;s:14:\"featured-image\";i:1;s:10:\"title-meta\";}s:23:\"related-posts-tag-style\";s:4:\"none\";s:28:\"related-posts-category-style\";s:4:\"none\";s:25:\"related-posts-date-format\";s:0:\"\";s:28:\"related-posts-meta-date-type\";s:9:\"published\";s:32:\"related-posts-author-avatar-size\";s:0:\"\";s:27:\"related-posts-author-avatar\";b:0;s:33:\"related-posts-author-prefix-label\";s:3:\"By \";s:24:\"related-posts-image-size\";s:4:\"full\";s:38:\"related-posts-image-custom-scale-width\";i:16;s:39:\"related-posts-image-custom-scale-height\";i:9;s:35:\"related-posts-image-ratio-pre-scale\";s:4:\"16/9\";s:30:\"related-posts-image-ratio-type\";s:6:\"custom\";s:28:\"related-posts-meta-structure\";a:2:{i:0;s:8:\"category\";i:1;s:4:\"date\";}s:24:\"related-posts-text-color\";s:25:\"var(--ast-global-color-2)\";s:24:\"related-posts-link-color\";s:0:\"\";s:25:\"related-posts-title-color\";s:25:\"var(--ast-global-color-2)\";s:30:\"related-posts-background-color\";s:0:\"\";s:24:\"related-posts-meta-color\";s:0:\"\";s:30:\"related-posts-link-hover-color\";s:0:\"\";s:35:\"related-posts-meta-link-hover-color\";s:0:\"\";s:39:\"related-posts-section-title-font-family\";s:7:\"inherit\";s:39:\"related-posts-section-title-font-weight\";s:7:\"inherit\";s:42:\"related-posts-section-title-text-transform\";s:0:\"\";s:39:\"related-posts-section-title-line-height\";s:4:\"1.25\";s:39:\"related-posts-section-title-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:37:\"related-posts-section-title-font-size\";a:6:{s:7:\"desktop\";s:2:\"26\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"related-posts-title-font-family\";s:7:\"inherit\";s:31:\"related-posts-title-font-weight\";s:3:\"500\";s:34:\"related-posts-title-text-transform\";s:0:\"\";s:31:\"related-posts-title-line-height\";s:1:\"1\";s:29:\"related-posts-title-font-size\";a:6:{s:7:\"desktop\";s:2:\"20\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"related-posts-title-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.5\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:30:\"related-posts-meta-font-family\";s:7:\"inherit\";s:30:\"related-posts-meta-font-weight\";s:7:\"inherit\";s:33:\"related-posts-meta-text-transform\";s:0:\"\";s:30:\"related-posts-meta-line-height\";s:0:\"\";s:28:\"related-posts-meta-font-size\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"related-posts-meta-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"related-posts-content-font-family\";s:7:\"inherit\";s:33:\"related-posts-content-font-weight\";s:7:\"inherit\";s:33:\"related-posts-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:31:\"related-posts-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"ast-sub-section-related-posts-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";d:2.5;s:5:\"right\";d:2.5;s:6:\"bottom\";d:2.5;s:4:\"left\";d:2.5;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:36:\"ast-sub-section-related-posts-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:2;s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:23:\"transparent-header-logo\";s:0:\"\";s:30:\"transparent-header-retina-logo\";s:65:\"http://cetef-test.local/wp-content/uploads/2025/10/Logo_CETEF.jpg\";s:26:\"different-transparent-logo\";i:0;s:33:\"different-transparent-retina-logo\";i:0;s:29:\"transparent-header-logo-width\";a:3:{s:7:\"desktop\";i:150;s:6:\"tablet\";i:120;s:6:\"mobile\";i:100;}s:25:\"transparent-header-enable\";i:0;s:34:\"transparent-header-disable-archive\";i:1;s:45:\"transparent-header-disable-latest-posts-index\";i:1;s:29:\"transparent-header-on-devices\";s:4:\"both\";s:27:\"transparent-header-main-sep\";i:0;s:33:\"transparent-header-main-sep-color\";s:0:\"\";s:27:\"transparent-header-bg-color\";s:0:\"\";s:35:\"transparent-header-color-site-title\";s:0:\"\";s:37:\"transparent-header-color-h-site-title\";s:0:\"\";s:25:\"transparent-menu-bg-color\";s:0:\"\";s:22:\"transparent-menu-color\";s:0:\"\";s:24:\"transparent-menu-h-color\";s:0:\"\";s:28:\"transparent-submenu-bg-color\";s:0:\"\";s:25:\"transparent-submenu-color\";s:0:\"\";s:27:\"transparent-submenu-h-color\";s:0:\"\";s:29:\"transparent-header-logo-color\";s:0:\"\";s:38:\"transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"hba-transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"hbb-transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:46:\"transparent-header-color-site-title-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:48:\"transparent-header-color-h-site-title-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-menu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"transparent-menu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"transparent-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:39:\"transparent-submenu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-submenu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"transparent-submenu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-link-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:51:\"transparent-content-section-link-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"breadcrumb-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"breadcrumb-active-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"breadcrumb-hover-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"breadcrumb-separator-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:19:\"breadcrumb-bg-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"breadcrumb-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"breadcrumb-font-family\";s:7:\"inherit\";s:22:\"breadcrumb-font-weight\";s:7:\"inherit\";s:20:\"breadcrumb-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"breadcrumb-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:29:\"breadcrumb-separator-selector\";s:5:\"\\003E\";s:20:\"breadcrumb-separator\";s:5:\"\\00bb\";s:20:\"scroll-to-top-enable\";b:1;s:23:\"scroll-to-top-icon-size\";i:15;s:27:\"scroll-to-top-icon-position\";s:5:\"right\";s:24:\"scroll-to-top-on-devices\";s:4:\"both\";s:32:\"scroll-to-top-icon-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"scroll-to-top-icon-color\";s:0:\"\";s:26:\"scroll-to-top-icon-h-color\";s:0:\"\";s:27:\"scroll-to-top-icon-bg-color\";s:0:\"\";s:29:\"scroll-to-top-icon-h-bg-color\";s:0:\"\";s:8:\"h1-color\";s:0:\"\";s:8:\"h2-color\";s:0:\"\";s:8:\"h3-color\";s:0:\"\";s:8:\"h4-color\";s:0:\"\";s:8:\"h5-color\";s:0:\"\";s:8:\"h6-color\";s:0:\"\";s:14:\"font-family-h1\";s:7:\"inherit\";s:14:\"font-weight-h1\";s:7:\"inherit\";s:14:\"font-extras-h1\";a:6:{s:11:\"line-height\";s:4:\"1.15\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:14:\"font-family-h2\";s:7:\"inherit\";s:14:\"font-weight-h2\";s:7:\"inherit\";s:14:\"font-extras-h2\";a:6:{s:11:\"line-height\";s:4:\"1.25\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:14:\"font-family-h3\";s:7:\"inherit\";s:14:\"font-weight-h3\";s:7:\"inherit\";s:14:\"font-extras-h3\";a:6:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:14:\"font-family-h4\";s:7:\"inherit\";s:14:\"font-weight-h4\";s:7:\"inherit\";s:14:\"font-extras-h4\";a:6:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:14:\"font-family-h5\";s:7:\"inherit\";s:14:\"font-weight-h5\";s:7:\"inherit\";s:14:\"font-extras-h5\";a:6:{s:11:\"line-height\";s:3:\"1.4\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:14:\"font-family-h6\";s:7:\"inherit\";s:14:\"font-weight-h6\";s:7:\"inherit\";s:14:\"font-extras-h6\";a:6:{s:11:\"line-height\";s:3:\"1.5\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:18:\"font-weight-button\";s:3:\"700\";s:28:\"secondary-font-weight-button\";s:3:\"700\";s:18:\"font-family-button\";s:7:\"inherit\";s:28:\"secondary-font-family-button\";s:7:\"inherit\";s:16:\"font-size-button\";a:6:{s:7:\"desktop\";i:14;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"secondary-font-size-button\";a:6:{s:7:\"desktop\";i:14;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:18:\"font-extras-button\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:1:\"1\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:9:\"uppercase\";s:15:\"text-decoration\";s:0:\"\";}s:28:\"secondary-font-extras-button\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:1:\"1\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:9:\"uppercase\";s:15:\"text-decoration\";s:0:\"\";}s:20:\"header-desktop-items\";a:5:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:5:{s:10:\"above_left\";a:0:{}s:17:\"above_left_center\";a:0:{}s:12:\"above_center\";a:0:{}s:18:\"above_right_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:5:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:19:\"primary_left_center\";a:0:{}s:14:\"primary_center\";a:0:{}s:20:\"primary_right_center\";a:0:{}s:13:\"primary_right\";a:2:{i:0;s:6:\"menu-1\";i:1;s:8:\"button-1\";}}s:5:\"below\";a:5:{s:10:\"below_left\";a:0:{}s:17:\"below_left_center\";a:0:{}s:12:\"below_center\";a:0:{}s:18:\"below_right_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:4:\"flag\";b:1;}s:19:\"header-mobile-items\";a:5:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:3:{s:10:\"above_left\";a:0:{}s:12:\"above_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:3:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:14:\"primary_center\";a:0:{}s:13:\"primary_right\";a:1:{i:0;s:14:\"mobile-trigger\";}}s:5:\"below\";a:3:{s:10:\"below_left\";a:0:{}s:12:\"below_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:4:\"flag\";b:0;}s:27:\"hb-header-main-layout-width\";s:7:\"content\";s:16:\"hb-header-height\";a:3:{s:7:\"desktop\";i:30;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:8:\"hb-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:18:\"hb-header-main-sep\";i:1;s:24:\"hb-header-main-sep-color\";s:25:\"var(--ast-global-color-6)\";s:25:\"hb-header-main-menu-align\";s:6:\"inline\";s:27:\"hb-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:22:\"rgba(225,238,225,0.84)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:5:\"color\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:17:\"hb-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:3:\"1.5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:3:\"1.5\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:17:\"hba-header-layout\";s:21:\"above-header-layout-1\";s:17:\"hba-header-height\";a:3:{s:7:\"desktop\";i:50;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:9:\"hba-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:20:\"hba-header-separator\";i:1;s:30:\"hba-header-bottom-border-color\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:28:\"hba-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:55:\"var( --ast-global-color-primary, --ast-global-color-4 )\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:32:\"hba-header-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"hba-header-link-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"hba-header-link-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"hba-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:3:\"0.5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"em\";}s:17:\"hbb-header-layout\";s:21:\"below-header-layout-1\";s:17:\"hbb-header-height\";a:3:{s:7:\"desktop\";i:60;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:9:\"hbb-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:20:\"hbb-header-separator\";i:1;s:30:\"hbb-header-bottom-border-color\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:28:\"hbb-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:18:\"hbb-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-footer-builder-layout-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-footer-builder-layout-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-above-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-above-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-below-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-below-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-header-mobile-trigger-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"section-primary-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"40\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"40\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"32\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"32\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"24\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-primary-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"title_tagline-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"section-header-search-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-account-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-mobile-menu-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"5\";s:5:\"right\";s:2:\"32\";s:6:\"bottom\";s:1:\"5\";s:4:\"left\";s:2:\"32\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"3\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:1:\"3\";s:4:\"left\";s:2:\"24\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:33:\"section-header-mobile-menu-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-above-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-above-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-below-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"section-footer-copyright-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-footer-menu-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"section-primary-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"25\";s:5:\"right\";s:2:\"40\";s:6:\"bottom\";s:2:\"25\";s:4:\"left\";s:2:\"40\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"32\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"32\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"20\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:2:\"24\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-primary-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"section-header-woo-cart-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"section-header-woo-cart-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button1-text\";s:14:\"Contactez-nous\";s:26:\"header-button1-link-option\";a:3:{s:3:\"url\";s:9:\"/contact/\";s:7:\"new_tab\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button1-font-family\";s:7:\"inherit\";s:26:\"header-button1-font-weight\";s:7:\"inherit\";s:26:\"header-button1-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:10:\"capitalize\";s:15:\"text-decoration\";s:7:\"initial\";}s:24:\"header-button1-font-size\";a:6:{s:7:\"desktop\";i:14;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button1-text-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-0)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button1-back-color\";a:3:{s:7:\"desktop\";s:13:\"rgba(0,0,0,0)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button1-text-h-color\";a:3:{s:7:\"desktop\";s:7:\"#fffefe\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button1-back-h-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button1-border-size\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";}s:27:\"header-button1-border-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-0)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button1-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"50\";s:5:\"right\";s:2:\"50\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"50\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button1-border-radius\";s:0:\"\";s:27:\"section-hb-button-1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"17\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:2:\"17\";s:4:\"left\";s:2:\"20\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button1-text\";s:6:\"Button\";s:26:\"footer-button1-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button1-font-family\";s:7:\"inherit\";s:26:\"footer-button1-font-weight\";s:7:\"inherit\";s:29:\"footer-button1-text-transform\";s:0:\"\";s:26:\"footer-button1-line-height\";s:0:\"\";s:24:\"footer-button1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button1-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button1-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button1-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button1-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button1-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button1-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button1-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-1\";s:22:\"Insert HTML text here.\";s:18:\"header-html-1color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-1link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-1link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-1\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-1\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-1\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-1\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-1\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-1color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-1link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-1link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-1\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-1\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-1\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-1-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-1-bg-space\";s:0:\"\";s:20:\"header-social-1-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-1-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-1-color\";s:0:\"\";s:23:\"header-social-1-h-color\";s:0:\"\";s:24:\"header-social-1-bg-color\";s:0:\"\";s:26:\"header-social-1-bg-h-color\";s:0:\"\";s:28:\"header-social-1-label-toggle\";b:0;s:26:\"header-social-1-color-type\";s:6:\"custom\";s:34:\"header-social-1-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-1\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-1-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-1-bg-space\";s:0:\"\";s:20:\"footer-social-1-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-1-radius\";s:0:\"\";s:21:\"footer-social-1-color\";s:0:\"\";s:23:\"footer-social-1-h-color\";s:0:\"\";s:24:\"footer-social-1-bg-color\";s:0:\"\";s:26:\"footer-social-1-bg-h-color\";s:0:\"\";s:28:\"footer-social-1-label-toggle\";b:0;s:26:\"footer-social-1-color-type\";s:6:\"custom\";s:27:\"footer-social-1-brand-color\";s:0:\"\";s:33:\"footer-social-1-brand-label-color\";s:0:\"\";s:34:\"footer-social-1-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-1\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-1-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-1-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-1-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-1-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-1-font-family\";s:7:\"inherit\";s:27:\"header-widget-1-font-weight\";s:7:\"inherit\";s:25:\"header-widget-1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-1-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-1-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-1-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-1-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-1-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-1-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-1-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-1-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-1-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-1-font-family\";s:7:\"inherit\";s:27:\"footer-widget-1-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-1-text-transform\";s:0:\"\";s:27:\"footer-widget-1-line-height\";s:0:\"\";s:25:\"footer-widget-1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-1-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-1-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-1-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-1-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-1\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu1-bg-color\";s:0:\"\";s:18:\"header-menu1-color\";s:0:\"\";s:23:\"header-menu1-h-bg-color\";s:0:\"\";s:20:\"header-menu1-h-color\";s:0:\"\";s:23:\"header-menu1-a-bg-color\";s:0:\"\";s:20:\"header-menu1-a-color\";s:0:\"\";s:30:\"header-menu1-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu1-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu1-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu1-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu1-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu1-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu1-menu-hover-animation\";s:0:\"\";s:40:\"header-menu1-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu1-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu1-submenu-item-border\";b:0;s:32:\"header-menu1-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu1-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu1-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu1-submenu-top-offset\";s:0:\"\";s:26:\"header-menu1-submenu-width\";s:0:\"\";s:27:\"header-menu1-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu1-menu-stack-on-mobile\";b:1;s:22:\"header-menu1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu1-font-weight\";s:7:\"inherit\";s:24:\"header-menu1-font-family\";s:7:\"inherit\";s:24:\"header-menu1-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button2-text\";s:6:\"Button\";s:26:\"header-button2-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button2-font-family\";s:7:\"inherit\";s:26:\"header-button2-font-weight\";s:7:\"inherit\";s:26:\"header-button2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button2-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button2-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button2-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button2-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button2-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button2-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button2-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button2-border-radius\";s:0:\"\";s:27:\"section-hb-button-2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button2-text\";s:6:\"Button\";s:26:\"footer-button2-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button2-font-family\";s:7:\"inherit\";s:26:\"footer-button2-font-weight\";s:7:\"inherit\";s:29:\"footer-button2-text-transform\";s:0:\"\";s:26:\"footer-button2-line-height\";s:0:\"\";s:24:\"footer-button2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button2-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button2-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button2-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button2-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button2-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button2-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button2-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-2\";s:22:\"Insert HTML text here.\";s:18:\"header-html-2color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-2link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-2link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-2\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-2\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-2\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-2\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-2\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-2color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-2link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-2link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-2\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-2\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-2\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-2-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-2-bg-space\";s:0:\"\";s:20:\"header-social-2-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-2-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-2-color\";s:0:\"\";s:23:\"header-social-2-h-color\";s:0:\"\";s:24:\"header-social-2-bg-color\";s:0:\"\";s:26:\"header-social-2-bg-h-color\";s:0:\"\";s:28:\"header-social-2-label-toggle\";b:0;s:26:\"header-social-2-color-type\";s:6:\"custom\";s:34:\"header-social-2-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-2\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-2-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-2-bg-space\";s:0:\"\";s:20:\"footer-social-2-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-2-radius\";s:0:\"\";s:21:\"footer-social-2-color\";s:0:\"\";s:23:\"footer-social-2-h-color\";s:0:\"\";s:24:\"footer-social-2-bg-color\";s:0:\"\";s:26:\"footer-social-2-bg-h-color\";s:0:\"\";s:28:\"footer-social-2-label-toggle\";b:0;s:26:\"footer-social-2-color-type\";s:6:\"custom\";s:27:\"footer-social-2-brand-color\";s:0:\"\";s:33:\"footer-social-2-brand-label-color\";s:0:\"\";s:34:\"footer-social-2-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-2\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-2-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-2-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-2-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-2-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-2-font-family\";s:7:\"inherit\";s:27:\"header-widget-2-font-weight\";s:7:\"inherit\";s:25:\"header-widget-2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-2-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-2-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-2-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-2-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-2-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-2-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-2-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-2-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-2-font-family\";s:7:\"inherit\";s:27:\"footer-widget-2-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-2-text-transform\";s:0:\"\";s:27:\"footer-widget-2-line-height\";s:0:\"\";s:25:\"footer-widget-2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-2-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-2-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-2-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-2-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-2\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu2-bg-color\";s:0:\"\";s:18:\"header-menu2-color\";s:0:\"\";s:23:\"header-menu2-h-bg-color\";s:0:\"\";s:20:\"header-menu2-h-color\";s:0:\"\";s:23:\"header-menu2-a-bg-color\";s:0:\"\";s:20:\"header-menu2-a-color\";s:0:\"\";s:30:\"header-menu2-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu2-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu2-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu2-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu2-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu2-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu2-menu-hover-animation\";s:0:\"\";s:40:\"header-menu2-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu2-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu2-submenu-item-border\";b:0;s:32:\"header-menu2-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu2-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu2-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu2-submenu-top-offset\";s:0:\"\";s:26:\"header-menu2-submenu-width\";s:0:\"\";s:27:\"header-menu2-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu2-menu-stack-on-mobile\";b:1;s:22:\"header-menu2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu2-font-weight\";s:7:\"inherit\";s:24:\"header-menu2-font-family\";s:7:\"inherit\";s:24:\"header-menu2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button3-text\";s:6:\"Button\";s:26:\"header-button3-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button3-font-family\";s:7:\"inherit\";s:26:\"header-button3-font-weight\";s:7:\"inherit\";s:26:\"header-button3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button3-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button3-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button3-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button3-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button3-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button3-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button3-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button3-border-radius\";s:0:\"\";s:27:\"section-hb-button-3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button3-text\";s:6:\"Button\";s:26:\"footer-button3-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button3-font-family\";s:7:\"inherit\";s:26:\"footer-button3-font-weight\";s:7:\"inherit\";s:29:\"footer-button3-text-transform\";s:0:\"\";s:26:\"footer-button3-line-height\";s:0:\"\";s:24:\"footer-button3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button3-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button3-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button3-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button3-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button3-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button3-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button3-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-3\";s:22:\"Insert HTML text here.\";s:18:\"header-html-3color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-3link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-3link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-3\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-3\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-3\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-3\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-3\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-3color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-3link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-3link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-3\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-3\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-3\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-3-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-3-bg-space\";s:0:\"\";s:20:\"header-social-3-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-3-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-3-color\";s:0:\"\";s:23:\"header-social-3-h-color\";s:0:\"\";s:24:\"header-social-3-bg-color\";s:0:\"\";s:26:\"header-social-3-bg-h-color\";s:0:\"\";s:28:\"header-social-3-label-toggle\";b:0;s:26:\"header-social-3-color-type\";s:6:\"custom\";s:34:\"header-social-3-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-3\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-3-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-3-bg-space\";s:0:\"\";s:20:\"footer-social-3-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-3-radius\";s:0:\"\";s:21:\"footer-social-3-color\";s:0:\"\";s:23:\"footer-social-3-h-color\";s:0:\"\";s:24:\"footer-social-3-bg-color\";s:0:\"\";s:26:\"footer-social-3-bg-h-color\";s:0:\"\";s:28:\"footer-social-3-label-toggle\";b:0;s:26:\"footer-social-3-color-type\";s:6:\"custom\";s:27:\"footer-social-3-brand-color\";s:0:\"\";s:33:\"footer-social-3-brand-label-color\";s:0:\"\";s:34:\"footer-social-3-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-3\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-3-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-3-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-3-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-3-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-3-font-family\";s:7:\"inherit\";s:27:\"header-widget-3-font-weight\";s:7:\"inherit\";s:25:\"header-widget-3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-3-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-3-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-3-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-3-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-3-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-3-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-3-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-3-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-3-font-family\";s:7:\"inherit\";s:27:\"footer-widget-3-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-3-text-transform\";s:0:\"\";s:27:\"footer-widget-3-line-height\";s:0:\"\";s:25:\"footer-widget-3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-3-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-3-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-3-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-3-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-3\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu3-bg-color\";s:0:\"\";s:18:\"header-menu3-color\";s:0:\"\";s:23:\"header-menu3-h-bg-color\";s:0:\"\";s:20:\"header-menu3-h-color\";s:0:\"\";s:23:\"header-menu3-a-bg-color\";s:0:\"\";s:20:\"header-menu3-a-color\";s:0:\"\";s:30:\"header-menu3-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu3-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu3-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu3-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu3-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu3-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu3-menu-hover-animation\";s:0:\"\";s:40:\"header-menu3-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu3-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu3-submenu-item-border\";b:0;s:32:\"header-menu3-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu3-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu3-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu3-submenu-top-offset\";s:0:\"\";s:26:\"header-menu3-submenu-width\";s:0:\"\";s:27:\"header-menu3-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu3-menu-stack-on-mobile\";b:1;s:22:\"header-menu3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu3-font-weight\";s:7:\"inherit\";s:24:\"header-menu3-font-family\";s:7:\"inherit\";s:24:\"header-menu3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button4-text\";s:6:\"Button\";s:26:\"header-button4-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button4-font-family\";s:7:\"inherit\";s:26:\"header-button4-font-weight\";s:7:\"inherit\";s:26:\"header-button4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button4-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button4-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button4-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button4-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button4-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button4-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button4-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button4-border-radius\";s:0:\"\";s:27:\"section-hb-button-4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button4-text\";s:6:\"Button\";s:26:\"footer-button4-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button4-font-family\";s:7:\"inherit\";s:26:\"footer-button4-font-weight\";s:7:\"inherit\";s:29:\"footer-button4-text-transform\";s:0:\"\";s:26:\"footer-button4-line-height\";s:0:\"\";s:24:\"footer-button4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button4-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button4-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button4-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button4-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button4-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button4-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button4-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-4\";s:22:\"Insert HTML text here.\";s:18:\"header-html-4color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-4link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-4link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-4\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-4\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-4\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-4\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-4\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-4color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-4link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-4link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-4\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-4\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-4\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-4-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-4-bg-space\";s:0:\"\";s:20:\"header-social-4-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-4-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-4-color\";s:0:\"\";s:23:\"header-social-4-h-color\";s:0:\"\";s:24:\"header-social-4-bg-color\";s:0:\"\";s:26:\"header-social-4-bg-h-color\";s:0:\"\";s:28:\"header-social-4-label-toggle\";b:0;s:26:\"header-social-4-color-type\";s:6:\"custom\";s:34:\"header-social-4-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-4\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-4-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-4-bg-space\";s:0:\"\";s:20:\"footer-social-4-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-4-radius\";s:0:\"\";s:21:\"footer-social-4-color\";s:0:\"\";s:23:\"footer-social-4-h-color\";s:0:\"\";s:24:\"footer-social-4-bg-color\";s:0:\"\";s:26:\"footer-social-4-bg-h-color\";s:0:\"\";s:28:\"footer-social-4-label-toggle\";b:0;s:26:\"footer-social-4-color-type\";s:6:\"custom\";s:27:\"footer-social-4-brand-color\";s:0:\"\";s:33:\"footer-social-4-brand-label-color\";s:0:\"\";s:34:\"footer-social-4-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-4\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-4-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-4-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-4-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-4-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-4-font-family\";s:7:\"inherit\";s:27:\"header-widget-4-font-weight\";s:7:\"inherit\";s:25:\"header-widget-4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-4-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-4-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-4-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-4-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-4-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-4-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-4-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-4-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-4-font-family\";s:7:\"inherit\";s:27:\"footer-widget-4-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-4-text-transform\";s:0:\"\";s:27:\"footer-widget-4-line-height\";s:0:\"\";s:25:\"footer-widget-4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-4-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-4-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-4-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-4-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-4\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu4-bg-color\";s:0:\"\";s:18:\"header-menu4-color\";s:0:\"\";s:23:\"header-menu4-h-bg-color\";s:0:\"\";s:20:\"header-menu4-h-color\";s:0:\"\";s:23:\"header-menu4-a-bg-color\";s:0:\"\";s:20:\"header-menu4-a-color\";s:0:\"\";s:30:\"header-menu4-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu4-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu4-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu4-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu4-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu4-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu4-menu-hover-animation\";s:0:\"\";s:40:\"header-menu4-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu4-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu4-submenu-item-border\";b:0;s:32:\"header-menu4-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu4-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu4-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu4-submenu-top-offset\";s:0:\"\";s:26:\"header-menu4-submenu-width\";s:0:\"\";s:27:\"header-menu4-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu4-menu-stack-on-mobile\";b:1;s:22:\"header-menu4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu4-font-weight\";s:7:\"inherit\";s:24:\"header-menu4-font-family\";s:7:\"inherit\";s:24:\"header-menu4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button5-text\";s:6:\"Button\";s:26:\"header-button5-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button5-font-family\";s:7:\"inherit\";s:26:\"header-button5-font-weight\";s:7:\"inherit\";s:26:\"header-button5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button5-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button5-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button5-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button5-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button5-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button5-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button5-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button5-border-radius\";s:0:\"\";s:27:\"section-hb-button-5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button5-text\";s:6:\"Button\";s:26:\"footer-button5-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button5-font-family\";s:7:\"inherit\";s:26:\"footer-button5-font-weight\";s:7:\"inherit\";s:29:\"footer-button5-text-transform\";s:0:\"\";s:26:\"footer-button5-line-height\";s:0:\"\";s:24:\"footer-button5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button5-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button5-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button5-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button5-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button5-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button5-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button5-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-5\";s:22:\"Insert HTML text here.\";s:18:\"header-html-5color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-5link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-5link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-5\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-5\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-5\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-5\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-5\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-5color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-5link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-5link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-5\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-5\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-5\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-5-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-5-bg-space\";s:0:\"\";s:20:\"header-social-5-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-5-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-5-color\";s:0:\"\";s:23:\"header-social-5-h-color\";s:0:\"\";s:24:\"header-social-5-bg-color\";s:0:\"\";s:26:\"header-social-5-bg-h-color\";s:0:\"\";s:28:\"header-social-5-label-toggle\";b:0;s:26:\"header-social-5-color-type\";s:6:\"custom\";s:34:\"header-social-5-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-5\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-5-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-5-bg-space\";s:0:\"\";s:20:\"footer-social-5-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-5-radius\";s:0:\"\";s:21:\"footer-social-5-color\";s:0:\"\";s:23:\"footer-social-5-h-color\";s:0:\"\";s:24:\"footer-social-5-bg-color\";s:0:\"\";s:26:\"footer-social-5-bg-h-color\";s:0:\"\";s:28:\"footer-social-5-label-toggle\";b:0;s:26:\"footer-social-5-color-type\";s:6:\"custom\";s:27:\"footer-social-5-brand-color\";s:0:\"\";s:33:\"footer-social-5-brand-label-color\";s:0:\"\";s:34:\"footer-social-5-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-5\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-5-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-5-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-5-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-5-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-5-font-family\";s:7:\"inherit\";s:27:\"header-widget-5-font-weight\";s:7:\"inherit\";s:25:\"header-widget-5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-5-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-5-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-5-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-5-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-5-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-5-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-5-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-5-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-5-font-family\";s:7:\"inherit\";s:27:\"footer-widget-5-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-5-text-transform\";s:0:\"\";s:27:\"footer-widget-5-line-height\";s:0:\"\";s:25:\"footer-widget-5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-5-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-5-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-5-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-5-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-5\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu5-bg-color\";s:0:\"\";s:18:\"header-menu5-color\";s:0:\"\";s:23:\"header-menu5-h-bg-color\";s:0:\"\";s:20:\"header-menu5-h-color\";s:0:\"\";s:23:\"header-menu5-a-bg-color\";s:0:\"\";s:20:\"header-menu5-a-color\";s:0:\"\";s:30:\"header-menu5-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu5-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu5-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu5-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu5-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu5-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu5-menu-hover-animation\";s:0:\"\";s:40:\"header-menu5-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu5-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu5-submenu-item-border\";b:0;s:32:\"header-menu5-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu5-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu5-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu5-submenu-top-offset\";s:0:\"\";s:26:\"header-menu5-submenu-width\";s:0:\"\";s:27:\"header-menu5-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu5-menu-stack-on-mobile\";b:1;s:22:\"header-menu5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu5-font-weight\";s:7:\"inherit\";s:24:\"header-menu5-font-family\";s:7:\"inherit\";s:24:\"header-menu5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button6-text\";s:6:\"Button\";s:26:\"header-button6-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button6-font-family\";s:7:\"inherit\";s:26:\"header-button6-font-weight\";s:7:\"inherit\";s:26:\"header-button6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button6-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button6-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button6-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button6-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button6-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button6-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button6-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button6-border-radius\";s:0:\"\";s:27:\"section-hb-button-6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button6-text\";s:6:\"Button\";s:26:\"footer-button6-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button6-font-family\";s:7:\"inherit\";s:26:\"footer-button6-font-weight\";s:7:\"inherit\";s:29:\"footer-button6-text-transform\";s:0:\"\";s:26:\"footer-button6-line-height\";s:0:\"\";s:24:\"footer-button6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button6-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button6-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button6-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button6-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button6-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button6-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button6-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-6\";s:22:\"Insert HTML text here.\";s:18:\"header-html-6color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-6link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-6link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-6\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-6\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-6\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-6\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-6\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-6color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-6link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-6link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-6\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-6\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-6\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-6-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-6-bg-space\";s:0:\"\";s:20:\"header-social-6-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-6-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-6-color\";s:0:\"\";s:23:\"header-social-6-h-color\";s:0:\"\";s:24:\"header-social-6-bg-color\";s:0:\"\";s:26:\"header-social-6-bg-h-color\";s:0:\"\";s:28:\"header-social-6-label-toggle\";b:0;s:26:\"header-social-6-color-type\";s:6:\"custom\";s:34:\"header-social-6-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-6\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-6-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-6-bg-space\";s:0:\"\";s:20:\"footer-social-6-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-6-radius\";s:0:\"\";s:21:\"footer-social-6-color\";s:0:\"\";s:23:\"footer-social-6-h-color\";s:0:\"\";s:24:\"footer-social-6-bg-color\";s:0:\"\";s:26:\"footer-social-6-bg-h-color\";s:0:\"\";s:28:\"footer-social-6-label-toggle\";b:0;s:26:\"footer-social-6-color-type\";s:6:\"custom\";s:27:\"footer-social-6-brand-color\";s:0:\"\";s:33:\"footer-social-6-brand-label-color\";s:0:\"\";s:34:\"footer-social-6-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-6\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-6-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-6-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-6-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-6-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-6-font-family\";s:7:\"inherit\";s:27:\"header-widget-6-font-weight\";s:7:\"inherit\";s:25:\"header-widget-6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-6-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-6-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-6-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-6-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-6-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-6-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-6-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-6-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-6-font-family\";s:7:\"inherit\";s:27:\"footer-widget-6-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-6-text-transform\";s:0:\"\";s:27:\"footer-widget-6-line-height\";s:0:\"\";s:25:\"footer-widget-6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-6-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-6-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-6-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-6-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-6\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu6-bg-color\";s:0:\"\";s:18:\"header-menu6-color\";s:0:\"\";s:23:\"header-menu6-h-bg-color\";s:0:\"\";s:20:\"header-menu6-h-color\";s:0:\"\";s:23:\"header-menu6-a-bg-color\";s:0:\"\";s:20:\"header-menu6-a-color\";s:0:\"\";s:30:\"header-menu6-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu6-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu6-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu6-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu6-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu6-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu6-menu-hover-animation\";s:0:\"\";s:40:\"header-menu6-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu6-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu6-submenu-item-border\";b:0;s:32:\"header-menu6-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu6-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu6-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu6-submenu-top-offset\";s:0:\"\";s:26:\"header-menu6-submenu-width\";s:0:\"\";s:27:\"header-menu6-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu6-menu-stack-on-mobile\";b:1;s:22:\"header-menu6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu6-font-weight\";s:7:\"inherit\";s:24:\"header-menu6-font-family\";s:7:\"inherit\";s:24:\"header-menu6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button7-text\";s:6:\"Button\";s:26:\"header-button7-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button7-font-family\";s:7:\"inherit\";s:26:\"header-button7-font-weight\";s:7:\"inherit\";s:26:\"header-button7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button7-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button7-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button7-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button7-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button7-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button7-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button7-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button7-border-radius\";s:0:\"\";s:27:\"section-hb-button-7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button7-text\";s:6:\"Button\";s:26:\"footer-button7-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button7-font-family\";s:7:\"inherit\";s:26:\"footer-button7-font-weight\";s:7:\"inherit\";s:29:\"footer-button7-text-transform\";s:0:\"\";s:26:\"footer-button7-line-height\";s:0:\"\";s:24:\"footer-button7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button7-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button7-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button7-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button7-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button7-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button7-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button7-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-7\";s:22:\"Insert HTML text here.\";s:18:\"header-html-7color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-7link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-7link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-7\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-7\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-7\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-7\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-7\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-7color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-7link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-7link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-7\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-7\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-7\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-7-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-7-bg-space\";s:0:\"\";s:20:\"header-social-7-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-7-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-7-color\";s:0:\"\";s:23:\"header-social-7-h-color\";s:0:\"\";s:24:\"header-social-7-bg-color\";s:0:\"\";s:26:\"header-social-7-bg-h-color\";s:0:\"\";s:28:\"header-social-7-label-toggle\";b:0;s:26:\"header-social-7-color-type\";s:6:\"custom\";s:34:\"header-social-7-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-7\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-7-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-7-bg-space\";s:0:\"\";s:20:\"footer-social-7-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-7-radius\";s:0:\"\";s:21:\"footer-social-7-color\";s:0:\"\";s:23:\"footer-social-7-h-color\";s:0:\"\";s:24:\"footer-social-7-bg-color\";s:0:\"\";s:26:\"footer-social-7-bg-h-color\";s:0:\"\";s:28:\"footer-social-7-label-toggle\";b:0;s:26:\"footer-social-7-color-type\";s:6:\"custom\";s:27:\"footer-social-7-brand-color\";s:0:\"\";s:33:\"footer-social-7-brand-label-color\";s:0:\"\";s:34:\"footer-social-7-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-7\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-7-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-7-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-7-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-7-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-7-font-family\";s:7:\"inherit\";s:27:\"header-widget-7-font-weight\";s:7:\"inherit\";s:25:\"header-widget-7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-7-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-7-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-7-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-7-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-7-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-7-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-7-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-7-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-7-font-family\";s:7:\"inherit\";s:27:\"footer-widget-7-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-7-text-transform\";s:0:\"\";s:27:\"footer-widget-7-line-height\";s:0:\"\";s:25:\"footer-widget-7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-7-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-7-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-7-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-7-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-7\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu7-bg-color\";s:0:\"\";s:18:\"header-menu7-color\";s:0:\"\";s:23:\"header-menu7-h-bg-color\";s:0:\"\";s:20:\"header-menu7-h-color\";s:0:\"\";s:23:\"header-menu7-a-bg-color\";s:0:\"\";s:20:\"header-menu7-a-color\";s:0:\"\";s:30:\"header-menu7-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu7-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu7-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu7-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu7-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu7-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu7-menu-hover-animation\";s:0:\"\";s:40:\"header-menu7-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu7-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu7-submenu-item-border\";b:0;s:32:\"header-menu7-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu7-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu7-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu7-submenu-top-offset\";s:0:\"\";s:26:\"header-menu7-submenu-width\";s:0:\"\";s:27:\"header-menu7-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu7-menu-stack-on-mobile\";b:1;s:22:\"header-menu7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu7-font-weight\";s:7:\"inherit\";s:24:\"header-menu7-font-family\";s:7:\"inherit\";s:24:\"header-menu7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button8-text\";s:6:\"Button\";s:26:\"header-button8-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button8-font-family\";s:7:\"inherit\";s:26:\"header-button8-font-weight\";s:7:\"inherit\";s:26:\"header-button8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button8-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button8-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button8-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button8-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button8-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button8-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button8-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button8-border-radius\";s:0:\"\";s:27:\"section-hb-button-8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button8-text\";s:6:\"Button\";s:26:\"footer-button8-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button8-font-family\";s:7:\"inherit\";s:26:\"footer-button8-font-weight\";s:7:\"inherit\";s:29:\"footer-button8-text-transform\";s:0:\"\";s:26:\"footer-button8-line-height\";s:0:\"\";s:24:\"footer-button8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button8-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button8-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button8-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button8-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button8-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button8-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button8-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-8\";s:22:\"Insert HTML text here.\";s:18:\"header-html-8color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-8link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-8link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-8\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-8\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-8\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-8\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-8\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-8color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-8link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-8link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-8\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-8\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-8\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-8-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-8-bg-space\";s:0:\"\";s:20:\"header-social-8-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-8-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-8-color\";s:0:\"\";s:23:\"header-social-8-h-color\";s:0:\"\";s:24:\"header-social-8-bg-color\";s:0:\"\";s:26:\"header-social-8-bg-h-color\";s:0:\"\";s:28:\"header-social-8-label-toggle\";b:0;s:26:\"header-social-8-color-type\";s:6:\"custom\";s:34:\"header-social-8-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-8\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-8-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-8-bg-space\";s:0:\"\";s:20:\"footer-social-8-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-8-radius\";s:0:\"\";s:21:\"footer-social-8-color\";s:0:\"\";s:23:\"footer-social-8-h-color\";s:0:\"\";s:24:\"footer-social-8-bg-color\";s:0:\"\";s:26:\"footer-social-8-bg-h-color\";s:0:\"\";s:28:\"footer-social-8-label-toggle\";b:0;s:26:\"footer-social-8-color-type\";s:6:\"custom\";s:27:\"footer-social-8-brand-color\";s:0:\"\";s:33:\"footer-social-8-brand-label-color\";s:0:\"\";s:34:\"footer-social-8-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-8\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-8-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-8-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-8-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-8-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-8-font-family\";s:7:\"inherit\";s:27:\"header-widget-8-font-weight\";s:7:\"inherit\";s:25:\"header-widget-8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-8-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-8-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-8-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-8-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-8-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-8-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-8-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-8-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-8-font-family\";s:7:\"inherit\";s:27:\"footer-widget-8-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-8-text-transform\";s:0:\"\";s:27:\"footer-widget-8-line-height\";s:0:\"\";s:25:\"footer-widget-8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-8-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-8-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-8-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-8-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-8\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu8-bg-color\";s:0:\"\";s:18:\"header-menu8-color\";s:0:\"\";s:23:\"header-menu8-h-bg-color\";s:0:\"\";s:20:\"header-menu8-h-color\";s:0:\"\";s:23:\"header-menu8-a-bg-color\";s:0:\"\";s:20:\"header-menu8-a-color\";s:0:\"\";s:30:\"header-menu8-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu8-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu8-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu8-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu8-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu8-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu8-menu-hover-animation\";s:0:\"\";s:40:\"header-menu8-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu8-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu8-submenu-item-border\";b:0;s:32:\"header-menu8-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu8-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu8-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu8-submenu-top-offset\";s:0:\"\";s:26:\"header-menu8-submenu-width\";s:0:\"\";s:27:\"header-menu8-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu8-menu-stack-on-mobile\";b:1;s:22:\"header-menu8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu8-font-weight\";s:7:\"inherit\";s:24:\"header-menu8-font-family\";s:7:\"inherit\";s:24:\"header-menu8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button9-text\";s:6:\"Button\";s:26:\"header-button9-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button9-font-family\";s:7:\"inherit\";s:26:\"header-button9-font-weight\";s:7:\"inherit\";s:26:\"header-button9-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button9-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button9-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button9-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button9-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button9-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button9-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button9-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button9-border-radius\";s:0:\"\";s:27:\"section-hb-button-9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button9-text\";s:6:\"Button\";s:26:\"footer-button9-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button9-font-family\";s:7:\"inherit\";s:26:\"footer-button9-font-weight\";s:7:\"inherit\";s:29:\"footer-button9-text-transform\";s:0:\"\";s:26:\"footer-button9-line-height\";s:0:\"\";s:24:\"footer-button9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button9-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button9-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button9-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button9-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button9-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button9-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button9-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-9\";s:22:\"Insert HTML text here.\";s:18:\"header-html-9color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-9link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-9link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-9\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-9\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-9\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-9\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-9\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-9color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-9link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-9link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-9\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-9\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-9\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-9-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-9-bg-space\";s:0:\"\";s:20:\"header-social-9-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-9-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-9-color\";s:0:\"\";s:23:\"header-social-9-h-color\";s:0:\"\";s:24:\"header-social-9-bg-color\";s:0:\"\";s:26:\"header-social-9-bg-h-color\";s:0:\"\";s:28:\"header-social-9-label-toggle\";b:0;s:26:\"header-social-9-color-type\";s:6:\"custom\";s:34:\"header-social-9-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-9\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-9-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-9-bg-space\";s:0:\"\";s:20:\"footer-social-9-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-9-radius\";s:0:\"\";s:21:\"footer-social-9-color\";s:0:\"\";s:23:\"footer-social-9-h-color\";s:0:\"\";s:24:\"footer-social-9-bg-color\";s:0:\"\";s:26:\"footer-social-9-bg-h-color\";s:0:\"\";s:28:\"footer-social-9-label-toggle\";b:0;s:26:\"footer-social-9-color-type\";s:6:\"custom\";s:27:\"footer-social-9-brand-color\";s:0:\"\";s:33:\"footer-social-9-brand-label-color\";s:0:\"\";s:34:\"footer-social-9-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-9\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-9-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-9-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-9-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-9-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-9-font-family\";s:7:\"inherit\";s:27:\"header-widget-9-font-weight\";s:7:\"inherit\";s:25:\"header-widget-9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-9-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-9-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-9-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-9-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-9-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-9-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-9-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-9-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-9-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-9-font-family\";s:7:\"inherit\";s:27:\"footer-widget-9-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-9-text-transform\";s:0:\"\";s:27:\"footer-widget-9-line-height\";s:0:\"\";s:25:\"footer-widget-9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-9-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-9-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-9-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-9-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-9\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu9-bg-color\";s:0:\"\";s:18:\"header-menu9-color\";s:0:\"\";s:23:\"header-menu9-h-bg-color\";s:0:\"\";s:20:\"header-menu9-h-color\";s:0:\"\";s:23:\"header-menu9-a-bg-color\";s:0:\"\";s:20:\"header-menu9-a-color\";s:0:\"\";s:30:\"header-menu9-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu9-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu9-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu9-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu9-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu9-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu9-menu-hover-animation\";s:0:\"\";s:40:\"header-menu9-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu9-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu9-submenu-item-border\";b:0;s:32:\"header-menu9-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu9-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu9-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu9-submenu-top-offset\";s:0:\"\";s:26:\"header-menu9-submenu-width\";s:0:\"\";s:27:\"header-menu9-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu9-menu-stack-on-mobile\";b:1;s:22:\"header-menu9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu9-font-weight\";s:7:\"inherit\";s:24:\"header-menu9-font-family\";s:7:\"inherit\";s:24:\"header-menu9-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"header-button10-text\";s:6:\"Button\";s:27:\"header-button10-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:27:\"header-button10-font-family\";s:7:\"inherit\";s:27:\"header-button10-font-weight\";s:7:\"inherit\";s:27:\"header-button10-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:25:\"header-button10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button10-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-button10-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button10-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button10-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-button10-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:28:\"header-button10-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"header-button10-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"header-button10-border-radius\";s:0:\"\";s:28:\"section-hb-button-10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-hb-button-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"sticky-header-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"footer-button10-text\";s:6:\"Button\";s:27:\"footer-button10-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:27:\"footer-button10-font-family\";s:7:\"inherit\";s:27:\"footer-button10-font-weight\";s:7:\"inherit\";s:30:\"footer-button10-text-transform\";s:0:\"\";s:27:\"footer-button10-line-height\";s:0:\"\";s:25:\"footer-button10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button10-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-button10-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button10-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button10-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-button10-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:28:\"footer-button10-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"footer-button10-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:28:\"section-fb-button-10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-button-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:14:\"header-html-10\";s:22:\"Insert HTML text here.\";s:19:\"header-html-10color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-html-10link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-html-10link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"font-size-section-hb-html-10\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"font-weight-section-hb-html-10\";s:7:\"inherit\";s:30:\"font-family-section-hb-html-10\";s:7:\"inherit\";s:30:\"font-extras-section-hb-html-10\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:25:\"section-hb-html-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:14:\"footer-html-10\";s:22:\"Insert HTML text here.\";s:19:\"footer-html-10color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-html-10link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-html-10link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"font-size-section-fb-html-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"footer-html-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:30:\"font-weight-section-fb-html-10\";s:7:\"inherit\";s:30:\"font-family-section-fb-html-10\";s:7:\"inherit\";s:30:\"font-extras-section-fb-html-10\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:25:\"section-fb-html-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-10-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-social-10-bg-space\";s:0:\"\";s:21:\"header-social-10-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:30:\"header-social-10-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-10-color\";s:0:\"\";s:24:\"header-social-10-h-color\";s:0:\"\";s:25:\"header-social-10-bg-color\";s:0:\"\";s:27:\"header-social-10-bg-h-color\";s:0:\"\";s:29:\"header-social-10-label-toggle\";b:0;s:27:\"header-social-10-color-type\";s:6:\"custom\";s:35:\"header-social-10-brand-hover-toggle\";b:0;s:36:\"font-size-section-hb-social-icons-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-icons-10\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:33:\"section-hb-social-icons-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"footer-social-10-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-social-10-bg-space\";s:0:\"\";s:21:\"footer-social-10-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-social-10-radius\";s:0:\"\";s:22:\"footer-social-10-color\";s:0:\"\";s:24:\"footer-social-10-h-color\";s:0:\"\";s:25:\"footer-social-10-bg-color\";s:0:\"\";s:27:\"footer-social-10-bg-h-color\";s:0:\"\";s:29:\"footer-social-10-label-toggle\";b:0;s:27:\"footer-social-10-color-type\";s:6:\"custom\";s:28:\"footer-social-10-brand-color\";s:0:\"\";s:34:\"footer-social-10-brand-label-color\";s:0:\"\";s:35:\"footer-social-10-brand-hover-toggle\";b:0;s:36:\"font-size-section-fb-social-icons-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"footer-social-icons-10\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:26:\"footer-social-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:33:\"section-fb-social-icons-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-widget-10-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-widget-10-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-10-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-widget-10-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-10-font-family\";s:7:\"inherit\";s:28:\"header-widget-10-font-weight\";s:7:\"inherit\";s:26:\"header-widget-10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-widget-10-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:36:\"header-widget-10-content-font-family\";s:7:\"inherit\";s:36:\"header-widget-10-content-font-weight\";s:7:\"inherit\";s:34:\"header-widget-10-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"header-widget-10-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:39:\"sidebar-widgets-header-widget-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"footer-widget-10-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-widget-10-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-10-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"footer-widget-10-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-10-font-family\";s:7:\"inherit\";s:28:\"footer-widget-10-font-weight\";s:7:\"inherit\";s:31:\"footer-widget-10-text-transform\";s:0:\"\";s:28:\"footer-widget-10-line-height\";s:0:\"\";s:26:\"footer-widget-10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"footer-widget-10-content-font-family\";s:7:\"inherit\";s:36:\"footer-widget-10-content-font-weight\";s:7:\"inherit\";s:36:\"footer-widget-10-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:34:\"footer-widget-10-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-widget-alignment-10\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:39:\"sidebar-widgets-footer-widget-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-menu10-bg-color\";s:0:\"\";s:19:\"header-menu10-color\";s:0:\"\";s:24:\"header-menu10-h-bg-color\";s:0:\"\";s:21:\"header-menu10-h-color\";s:0:\"\";s:24:\"header-menu10-a-bg-color\";s:0:\"\";s:21:\"header-menu10-a-color\";s:0:\"\";s:31:\"header-menu10-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:30:\"header-menu10-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-menu10-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"header-menu10-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-menu10-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"header-menu10-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu10-menu-hover-animation\";s:0:\"\";s:41:\"header-menu10-submenu-container-animation\";s:0:\"\";s:25:\"section-hb-menu-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-menu10-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:33:\"header-menu10-submenu-item-border\";b:0;s:33:\"header-menu10-submenu-item-b-size\";s:1:\"1\";s:34:\"header-menu10-submenu-item-b-color\";s:7:\"#eaeaea\";s:42:\"header-menu10-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu10-submenu-top-offset\";s:0:\"\";s:27:\"header-menu10-submenu-width\";s:0:\"\";s:28:\"header-menu10-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:34:\"header-menu10-menu-stack-on-mobile\";b:1;s:23:\"header-menu10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu10-font-weight\";s:7:\"inherit\";s:25:\"header-menu10-font-family\";s:7:\"inherit\";s:25:\"header-menu10-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:28:\"section-hb-divider-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"section-fb-divider-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"sticky-header-on-devices\";s:7:\"desktop\";s:19:\"sticky-header-style\";s:4:\"none\";s:20:\"footer-desktop-items\";a:3:{s:5:\"above\";a:5:{s:7:\"above_1\";a:0:{}s:7:\"above_2\";a:0:{}s:7:\"above_3\";a:0:{}s:7:\"above_4\";a:0:{}s:7:\"above_5\";a:0:{}}s:7:\"primary\";a:5:{s:9:\"primary_1\";a:0:{}s:9:\"primary_2\";a:0:{}s:9:\"primary_3\";a:0:{}s:9:\"primary_4\";a:0:{}s:9:\"primary_5\";a:0:{}}s:5:\"below\";a:5:{s:7:\"below_1\";a:1:{i:0;s:9:\"copyright\";}s:7:\"below_2\";a:0:{}s:7:\"below_3\";a:0:{}s:7:\"below_4\";a:0:{}s:7:\"below_5\";a:0:{}}}s:17:\"hba-footer-height\";i:60;s:17:\"hba-footer-column\";s:1:\"2\";s:17:\"hba-footer-layout\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:28:\"hba-footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:28:\"hbb-footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:5:\"color\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:27:\"hb-footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:7:\"#f9f9f9\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:5:\"color\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:27:\"hbb-footer-top-border-color\";s:25:\"var(--ast-global-color-6)\";s:20:\"hbb-footer-separator\";i:1;s:36:\"section-header-builder-layout-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:17:\"hbb-footer-height\";i:30;s:17:\"hbb-footer-column\";s:1:\"1\";s:17:\"hbb-footer-layout\";a:3:{s:7:\"desktop\";s:4:\"full\";s:6:\"tablet\";s:4:\"full\";s:6:\"mobile\";s:4:\"full\";}s:24:\"hb-primary-footer-height\";i:30;s:23:\"hba-footer-layout-width\";s:7:\"content\";s:22:\"hb-footer-layout-width\";s:7:\"content\";s:23:\"hbb-footer-layout-width\";s:7:\"content\";s:29:\"hba-footer-vertical-alignment\";s:10:\"flex-start\";s:28:\"hb-footer-vertical-alignment\";s:10:\"flex-start\";s:29:\"hbb-footer-vertical-alignment\";s:6:\"center\";s:24:\"footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:16:\"hb-footer-column\";s:1:\"3\";s:19:\"hb-footer-separator\";i:1;s:29:\"hb-footer-bottom-border-color\";s:7:\"#e6e6e6\";s:16:\"hb-footer-layout\";a:3:{s:7:\"desktop\";s:7:\"3-equal\";s:6:\"tablet\";s:7:\"3-equal\";s:6:\"mobile\";s:4:\"full\";}s:18:\"hb-footer-main-sep\";i:1;s:24:\"hb-footer-main-sep-color\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:24:\"live-search-result-count\";i:5;s:23:\"footer-copyright-editor\";s:59:\"{{Droits d\'auteur}} [copyright] [current_year] [site_title]\";s:22:\"footer-copyright-color\";s:25:\"var(--ast-global-color-3)\";s:36:\"line-height-section-footer-copyright\";i:2;s:26:\"footer-copyright-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:34:\"font-size-section-footer-copyright\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"font-weight-section-footer-copyright\";s:7:\"inherit\";s:36:\"font-family-section-footer-copyright\";s:7:\"inherit\";s:36:\"font-extras-section-footer-copyright\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:21:\"footer-menu-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:36:\"section-below-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"25\";s:5:\"right\";s:2:\"40\";s:6:\"bottom\";s:2:\"25\";s:4:\"left\";s:2:\"40\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"32\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"32\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"20\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:2:\"24\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-search-icon-space\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";i:18;s:6:\"mobile\";i:18;}s:24:\"header-search-icon-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:19:\"header-search-width\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:11:\"live-search\";b:0;s:22:\"live-search-post-types\";a:2:{s:4:\"post\";i:1;s:4:\"page\";i:1;}s:37:\"transparent-header-social-icons-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:39:\"transparent-header-social-icons-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:40:\"transparent-header-social-icons-bg-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"transparent-header-social-icons-bg-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"transparent-header-html-text-color\";s:0:\"\";s:34:\"transparent-header-html-link-color\";s:0:\"\";s:36:\"transparent-header-html-link-h-color\";s:0:\"\";s:37:\"transparent-header-widget-title-color\";s:0:\"\";s:39:\"transparent-header-widget-content-color\";s:0:\"\";s:36:\"transparent-header-widget-link-color\";s:0:\"\";s:38:\"transparent-header-widget-link-h-color\";s:0:\"\";s:36:\"transparent-header-button-text-color\";s:0:\"\";s:38:\"transparent-header-button-text-h-color\";s:0:\"\";s:34:\"transparent-header-button-bg-color\";s:0:\"\";s:36:\"transparent-header-button-bg-h-color\";s:0:\"\";s:17:\"off-canvas-layout\";s:10:\"side-panel\";s:16:\"off-canvas-slide\";s:5:\"right\";s:33:\"header-builder-menu-toggle-target\";s:4:\"icon\";s:34:\"header-offcanvas-content-alignment\";s:10:\"flex-start\";s:21:\"off-canvas-background\";a:10:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:22:\"off-canvas-close-color\";s:7:\"#3a3a3a\";s:18:\"mobile-header-type\";s:8:\"dropdown\";s:20:\"off-canvas-move-body\";b:1;s:24:\"off-canvas-inner-spacing\";s:0:\"\";s:18:\"footer-menu-layout\";a:3:{s:7:\"desktop\";s:10:\"horizontal\";s:6:\"tablet\";s:8:\"vertical\";s:6:\"mobile\";s:8:\"vertical\";}s:29:\"footer-menu-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:28:\"footer-menu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"footer-menu-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:30:\"footer-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"footer-menu-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:30:\"footer-menu-a-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-menu-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-menu-font-weight\";s:7:\"inherit\";s:23:\"footer-menu-font-family\";s:7:\"inherit\";s:23:\"footer-menu-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"footer-main-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"20\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-trigger-icon\";s:5:\"menu2\";s:30:\"mobile-header-toggle-icon-size\";i:18;s:36:\"mobile-header-toggle-btn-border-size\";a:4:{s:3:\"top\";i:1;s:5:\"right\";i:1;s:6:\"bottom\";i:1;s:4:\"left\";i:1;}s:34:\"mobile-header-toggle-border-radius\";i:2;s:41:\"mobile-header-toggle-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:3:\"100\";s:5:\"right\";s:3:\"100\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:3:\"100\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"mobile-header-label-font-family\";s:7:\"inherit\";s:31:\"mobile-header-label-font-weight\";s:7:\"inherit\";s:34:\"mobile-header-label-text-transform\";s:0:\"\";s:31:\"mobile-header-label-line-height\";s:0:\"\";s:29:\"mobile-header-label-font-size\";s:0:\"\";s:20:\"global-color-palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#377A00\";i:1;s:7:\"#2f6a00\";i:2;s:7:\"#151716\";i:3;s:7:\"#012104\";i:4;s:7:\"#EAF7EB\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#D0EBCF\";i:7;s:7:\"#011502\";i:8;s:7:\"#222222\";}s:4:\"flag\";b:1;}s:17:\"header-logo-color\";s:0:\"\";s:27:\"header-mobile-menu-bg-color\";s:0:\"\";s:24:\"header-mobile-menu-color\";s:0:\"\";s:29:\"header-mobile-menu-h-bg-color\";s:0:\"\";s:26:\"header-mobile-menu-h-color\";s:0:\"\";s:29:\"header-mobile-menu-a-bg-color\";s:0:\"\";s:26:\"header-mobile-menu-a-color\";s:0:\"\";s:36:\"header-mobile-menu-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:5:\"color\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:35:\"header-mobile-menu-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-3)\";s:6:\"mobile\";s:0:\"\";}s:37:\"header-mobile-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-1)\";s:6:\"mobile\";s:0:\"\";}s:37:\"header-mobile-menu-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:25:\"var(--ast-global-color-1)\";s:6:\"mobile\";s:0:\"\";}s:40:\"header-mobile-menu-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:25:\"var(--ast-global-color-5)\";s:6:\"mobile\";s:0:\"\";}s:40:\"header-mobile-menu-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:25:\"var(--ast-global-color-5)\";s:6:\"mobile\";s:0:\"\";}s:46:\"header-mobile-menu-submenu-container-animation\";s:4:\"fade\";s:38:\"header-mobile-menu-submenu-item-border\";b:1;s:38:\"header-mobile-menu-submenu-item-b-size\";s:1:\"1\";s:39:\"header-mobile-menu-submenu-item-b-color\";s:25:\"var(--ast-global-color-6)\";s:33:\"header-mobile-menu-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:28:\"header-mobile-menu-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"font-extras-header-mobile-menu\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:28:\"woo-header-cart-click-action\";s:7:\"default\";s:28:\"responsive-cart-click-action\";s:6:\"flyout\";s:23:\"woo-slide-in-cart-width\";a:6:{s:7:\"desktop\";i:35;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:1:\"%\";s:11:\"tablet-unit\";s:1:\"%\";s:11:\"mobile-unit\";s:1:\"%\";}s:41:\"woo-header-cart-icon-total-label-position\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-woo-cart-icon-size\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:20:\"woo-header-cart-icon\";s:7:\"default\";s:26:\"woo-header-cart-icon-style\";s:7:\"outline\";s:41:\"woo-header-cart-product-count-color-group\";s:57:\"var( --ast-global-color-secondary, --ast-global-color-5 )\";s:33:\"woo-desktop-cart-flyout-direction\";s:5:\"right\";s:26:\"header-woo-cart-icon-color\";s:0:\"\";s:38:\"transparent-header-woo-cart-icon-color\";s:0:\"\";s:32:\"header-woo-cart-icon-hover-color\";s:0:\"\";s:28:\"woo-header-cart-border-width\";i:2;s:34:\"woo-header-cart-icon-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"woo-header-cart-badge-display\";b:1;s:29:\"woo-header-cart-label-display\";s:0:\"\";s:26:\"header-woo-cart-text-color\";s:0:\"\";s:26:\"header-woo-cart-link-color\";s:0:\"\";s:32:\"header-woo-cart-background-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"header-woo-cart-background-hover-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-woo-cart-separator-color\";s:0:\"\";s:32:\"header-woo-cart-link-hover-color\";s:0:\"\";s:30:\"header-woo-cart-btn-text-color\";s:0:\"\";s:36:\"header-woo-cart-btn-background-color\";s:0:\"\";s:36:\"header-woo-cart-btn-text-hover-color\";s:0:\"\";s:34:\"header-woo-cart-btn-bg-hover-color\";s:0:\"\";s:34:\"header-woo-checkout-btn-text-color\";s:0:\"\";s:40:\"header-woo-checkout-btn-background-color\";s:0:\"\";s:40:\"header-woo-checkout-btn-text-hover-color\";s:0:\"\";s:38:\"header-woo-checkout-btn-bg-hover-color\";s:0:\"\";s:26:\"edd-header-cart-icon-style\";s:7:\"outline\";s:26:\"edd-header-cart-icon-color\";s:0:\"\";s:27:\"edd-header-cart-icon-radius\";i:3;s:38:\"transparent-header-edd-cart-icon-color\";s:0:\"\";s:29:\"edd-header-cart-total-display\";b:1;s:29:\"edd-header-cart-title-display\";b:1;s:26:\"header-edd-cart-text-color\";s:0:\"\";s:26:\"header-edd-cart-link-color\";s:0:\"\";s:32:\"header-edd-cart-background-color\";s:0:\"\";s:31:\"header-edd-cart-separator-color\";s:0:\"\";s:34:\"header-edd-checkout-btn-text-color\";s:0:\"\";s:40:\"header-edd-checkout-btn-background-color\";s:0:\"\";s:40:\"header-edd-checkout-btn-text-hover-color\";s:0:\"\";s:38:\"header-edd-checkout-btn-bg-hover-color\";s:0:\"\";s:19:\"header-account-type\";s:7:\"default\";s:26:\"header-account-login-style\";s:4:\"icon\";s:51:\"header-account-login-style-extend-text-profile-type\";s:7:\"default\";s:26:\"header-account-action-type\";s:4:\"link\";s:24:\"header-account-link-type\";s:7:\"default\";s:27:\"header-account-logout-style\";s:4:\"icon\";s:52:\"header-account-logout-style-extend-text-profile-type\";s:7:\"default\";s:30:\"header-account-logged-out-text\";s:6:\"Log In\";s:29:\"header-account-logged-in-text\";s:10:\"My Account\";s:28:\"header-account-logout-action\";s:4:\"link\";s:26:\"header-account-image-width\";a:3:{s:7:\"desktop\";s:2:\"40\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-account-icon-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";i:18;s:6:\"mobile\";i:18;}s:25:\"header-account-icon-color\";s:25:\"var(--ast-global-color-2)\";s:25:\"header-account-login-link\";a:3:{s:3:\"url\";s:0:\"\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-account-logout-link\";a:3:{s:3:\"url\";s:53:\"https://movers-packers2.ziptemplates.top/wp-login.php\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:32:\"font-size-section-header-account\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"header-account-type-text-color\";s:0:\"\";s:23:\"header-account-woo-menu\";b:0;s:22:\"cloned-component-track\";a:12:{s:13:\"header-button\";i:2;s:13:\"footer-button\";i:2;s:11:\"header-html\";i:2;s:11:\"footer-html\";i:2;s:11:\"header-menu\";i:2;s:13:\"header-widget\";i:4;s:13:\"footer-widget\";i:4;s:19:\"header-social-icons\";i:1;s:19:\"footer-social-icons\";i:1;s:14:\"header-divider\";i:0;s:14:\"footer-divider\";i:0;s:13:\"removed-items\";a:0:{}}s:18:\"theme-auto-version\";s:7:\"4.11.12\";s:22:\"is_theme_queue_running\";b:0;s:38:\"theme-button-border-group-border-color\";s:25:\"var(--ast-global-color-0)\";s:40:\"theme-button-border-group-border-h-color\";s:25:\"var(--ast-global-color-1)\";s:48:\"secondary-theme-button-border-group-border-color\";s:25:\"var(--ast-global-color-0)\";s:50:\"secondary-theme-button-border-group-border-h-color\";s:25:\"var(--ast-global-color-1)\";s:29:\"header-button1-border-h-color\";a:1:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";}s:30:\"mobile-header-toggle-btn-color\";s:25:\"var(--ast-global-color-0)\";s:17:\"hbb-inner-spacing\";a:1:{s:6:\"mobile\";i:50;}s:31:\"ast-dynamic-archive-post-layout\";s:8:\"layout-2\";s:34:\"ast-dynamic-archive-post-structure\";a:1:{i:0;s:30:\"ast-dynamic-archive-post-title\";}s:37:\"ast-dynamic-archive-post-custom-title\";s:43:\"Actualités et Informations Réglementaires\";s:43:\"ast-dynamic-archive-post-banner-title-color\";s:25:\"var(--ast-global-color-2)\";s:40:\"ast-dynamic-archive-post-title-font-size\";a:6:{s:7:\"desktop\";i:56;s:6:\"tablet\";i:46;s:6:\"mobile\";i:36;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:42:\"ast-dynamic-archive-post-banner-image-type\";s:6:\"custom\";s:41:\"ast-dynamic-archive-post-banner-custom-bg\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:84:\"http://cetef-test.local/wp-content/uploads/2025/10/Fotolia_220866980_XL-1-scaled.jpg\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";i:19;}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";}}s:42:\"ast-dynamic-archive-post-title-font-weight\";s:7:\"inherit\";s:39:\"ast-dynamic-archive-post-banner-on-blog\";b:1;s:38:\"ast-dynamic-archive-post-banner-height\";a:3:{s:7:\"desktop\";i:250;s:6:\"tablet\";i:200;s:6:\"mobile\";s:0:\"\";}s:15:\"blog-image-size\";s:4:\"full\";s:42:\"ast-dynamic-archive-post-banner-text-color\";s:25:\"var(--ast-global-color-2)\";s:42:\"ast-dynamic-archive-post-banner-link-color\";s:25:\"var(--ast-global-color-0)\";s:48:\"ast-dynamic-archive-post-banner-link-hover-color\";s:25:\"var(--ast-global-color-1)\";s:39:\"ast-dynamic-archive-post-banner-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:3;s:5:\"right\";i:3;s:6:\"bottom\";i:3;s:4:\"left\";i:3;}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"2\";s:6:\"bottom\";s:1:\"2\";s:4:\"left\";s:1:\"2\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"2\";s:6:\"bottom\";s:1:\"2\";s:4:\"left\";s:1:\"2\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:33:\"ast-dynamic-single-post-structure\";a:3:{i:0;s:29:\"ast-dynamic-single-post-title\";i:1;s:28:\"ast-dynamic-single-post-meta\";i:2;s:29:\"ast-dynamic-single-post-image\";}s:64:\"ast-dynamic-single-post-article-featured-image-position-layout-1\";s:4:\"none\";s:57:\"ast-dynamic-single-post-article-featured-image-ratio-type\";s:6:\"custom\";s:47:\"ast-dynamic-single-post-remove-featured-padding\";b:0;s:46:\"ast-dynamic-single-post-taxonomy-clone-tracker\";i:0;s:37:\"ast-dynamic-single-post-author-avatar\";b:1;s:42:\"ast-dynamic-single-post-author-avatar-size\";i:40;s:26:\"single-post-inside-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"40\";s:5:\"right\";s:2:\"40\";s:6:\"bottom\";s:2:\"40\";s:4:\"left\";s:2:\"40\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:2:\"32\";s:5:\"right\";s:2:\"32\";s:6:\"bottom\";s:2:\"32\";s:4:\"left\";s:2:\"32\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"24\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"24\";s:4:\"left\";s:2:\"24\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:39:\"ast-dynamic-single-post-title-font-size\";a:6:{s:7:\"desktop\";s:2:\"32\";s:6:\"tablet\";i:28;s:6:\"mobile\";i:24;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:42:\"ast-dynamic-single-post-banner-title-color\";s:25:\"var(--ast-global-color-2)\";s:41:\"ast-dynamic-single-post-banner-text-color\";s:25:\"var(--ast-global-color-3)\";s:41:\"ast-dynamic-single-post-banner-link-color\";s:25:\"var(--ast-global-color-0)\";s:47:\"ast-dynamic-single-post-banner-link-hover-color\";s:25:\"var(--ast-global-color-1)\";s:45:\"ast-dynamic-archive-post-horizontal-alignment\";a:1:{s:7:\"desktop\";s:4:\"left\";}s:22:\"v4-8-2-backward-option\";b:0;s:26:\"enable-4-8-4-compatibility\";b:0;s:37:\"astra-heading-font-size-compatibility\";b:0;s:26:\"enable-4-8-9-compatibility\";b:0;s:16:\"star-rating-comp\";b:0;s:22:\"v4-9-0-backward-option\";b:0;s:16:\"btn-consist-comp\";b:0;s:28:\"enable-4-11-12-compatibility\";b:0;s:18:\"display-site-title\";b:1;}", "on");
INSERT INTO `wp_options` VALUES("180", "allowed_astra_notices", "a:3:{i:0;s:21:\"astra-sites-on-active\";i:1;s:26:\"astra-sites-welcome-notice\";i:2;s:22:\"sureforms-optin-notice\";}", "auto");
INSERT INTO `wp_options` VALUES("181", "astra_analytics_installed_time", "1759405677", "off");
INSERT INTO `wp_options` VALUES("191", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("194", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("202", "astra-sites-last-export-checksums-latest", "t&A8d3gecPDU", "off");
INSERT INTO `wp_options` VALUES("203", "astra-sites-fresh-site", "no", "off");
INSERT INTO `wp_options` VALUES("204", "ai_builder_recent_import_log_file", "C:\\Users\\Secretariat\\Local Sites\\cetef-test\\app\\public/wp-content/uploads/ai-builder/import-02-Oct-2025-12-01-42-f8a47203ec3900fd815d599e79a8d69c.log", "off");
INSERT INTO `wp_options` VALUES("205", "bsf_analytics_installed_time", "1759406502", "off");
INSERT INTO `wp_options` VALUES("206", "ast-block-templates-version", "2.4.10", "auto");
INSERT INTO `wp_options` VALUES("207", "astra-sites-batch-status-string", "Sync Process Complete.", "off");
INSERT INTO `wp_options` VALUES("208", "astra-blocks-batch-status-string", "Complete storing data for page 4", "off");
INSERT INTO `wp_options` VALUES("210", "astra-sites-last-export-checksums", "t&A8d3gecPDU", "off");
INSERT INTO `wp_options` VALUES("211", "astra-sites-batch-is-complete", "yes", "off");
INSERT INTO `wp_options` VALUES("215", "astra_sites_settings", "a:2:{s:12:\"page_builder\";s:10:\"ai-builder\";s:16:\"required_plugins\";a:5:{s:29:\"ultimate-addons-for-gutenberg\";s:9:\"activated\";s:9:\"sureforms\";s:9:\"activated\";s:8:\"surerank\";s:9:\"activated\";s:8:\"surecart\";s:9:\"activated\";s:9:\"latepoint\";s:9:\"activated\";}}", "off");
INSERT INTO `wp_options` VALUES("223", "zipwp_user_business_details", "a:12:{s:20:\"business_description\";s:898:\"Le Centre d’Étude Technique Environnemental et Forestier (CETEF) est une association loi 1901 de propriétaires privés et de sylviculteurs créée en 1977. Organisme technique de terrain et de proximité, le CETEF associe la gestion forestière aux enjeux environnementaux, paysagers et sociétaux. Il est reconnu comme « Organisme d’intérêt général » depuis le 8 avril 2019. Le CETEF est composé de quatre salariés :  1 Assistante administrative  1 Technicien Forestier et Gestionnaire Forestier Professionnel  1 Ecologue Forestier et Gestionnaire Forestier Professionnel  1 Directeur Ils sont placés sous l’autorité d’un conseil d’administration qui fixe les orientations et représente la structure dans les différentes instances.  Le CETEF accompagne ses adhérents (propriétaires forestiers, sylviculteurs, collectivités…) dans la gestion de leur forêt.\";s:13:\"business_name\";s:53:\"Centre d\'Etude Technique Environnemental et Forestier\";s:14:\"business_email\";s:35:\"contact@cetefnouvelle-aquitaine.org\";s:16:\"business_address\";s:40:\"20 Rue Léonard Jarraud 16000 Angoulême\";s:14:\"business_phone\";s:10:\"0545692327\";s:17:\"business_category\";s:10:\"Non-profit\";s:22:\"business_category_name\";s:10:\"Non-profit\";s:13:\"image_keyword\";a:5:{i:0;s:17:\"forest management\";i:1;s:28:\"environmental sustainability\";i:2;s:17:\"technical support\";i:3;s:14:\"forest ecology\";i:4;s:20:\"community engagement\";}s:6:\"images\";a:1:{i:0;a:8:{s:2:\"id\";s:2:\"19\";s:3:\"url\";s:77:\"http://cetef-test.local/wp-content/uploads/2025/10/Fotolia_220866980_XL-1.jpg\";s:13:\"optimized_url\";s:86:\"http://cetef-test.local/wp-content/uploads/2025/10/Fotolia_220866980_XL-1-1024x768.jpg\";s:6:\"engine\";s:0:\"\";s:11:\"description\";s:0:\"\";s:11:\"orientation\";s:9:\"landscape\";s:11:\"author_name\";s:0:\"\";s:10:\"author_url\";s:0:\"\";}}s:15:\"social_profiles\";a:2:{i:0;a:3:{s:4:\"type\";s:9:\"instagram\";s:2:\"id\";s:9:\"instagram\";s:3:\"url\";s:35:\"https://www.instagram.com/cetef_na/\";}i:1;a:3:{s:4:\"type\";s:8:\"facebook\";s:2:\"id\";s:8:\"facebook\";s:3:\"url\";s:25:\"https://www.facebook.com/\";}}s:8:\"language\";s:2:\"fr\";s:9:\"templates\";a:3:{i:0;a:2:{s:5:\"match\";s:11:\"exact_match\";s:7:\"designs\";a:0:{}}i:1;a:2:{s:5:\"match\";s:13:\"partial_match\";s:7:\"designs\";a:10:{i:0;a:11:{s:4:\"uuid\";s:36:\"1142a4ff-e76e-4c14-94a8-d8f9e1e9fa7c\";s:4:\"name\";s:7:\"Stellar\";s:6:\"domain\";s:31:\"multipurpose46.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:282;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:292;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:294;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:807;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:296;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#4e9d4c\";i:1;s:7:\"#3d933b\";i:2;s:7:\"#001d4a\";i:3;s:7:\"#697a96\";i:4;s:7:\"#f1f4f9\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#d9e3f3\";i:7;s:7:\"#001d4a\";i:8;s:7:\"#b52765\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Cabin\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:14;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:19:\"\'Cabin\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:1;a:11:{s:4:\"uuid\";s:36:\"32541247-4478-4e20-9529-8587fdbab5fd\";s:4:\"name\";s:6:\"Almond\";s:6:\"domain\";s:32:\"multipurpose-32.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:19;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:21;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:22;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:30;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:31;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#223035\";i:1;s:7:\"#f47a55\";i:2;s:7:\"#223035\";i:3;s:7:\"#4c575b\";i:4;s:7:\"#f1f3f1\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#f1f3f1\";i:7;s:7:\"#223035\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Heebo\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:17;s:6:\"tablet\";i:15;s:6:\"mobile\";i:15;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:19:\"\'Inter\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"600\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:2;a:11:{s:4:\"uuid\";s:36:\"e8c47be3-5503-4102-8260-5d543dd7bfb5\";s:4:\"name\";s:8:\"Foxglove\";s:6:\"domain\";s:31:\"multipurpose43.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:296;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:298;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:299;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:300;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:301;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#ff6464\";i:1;s:7:\"#f14e4e\";i:2;s:7:\"#071f1b\";i:3;s:7:\"#393939\";i:4;s:7:\"#faf6f6\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#e4dede\";i:7;s:7:\"#000000\";i:8;s:7:\"#111111\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:23:\"\'Work Sans\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:21:\"\'Belleza\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"400\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:3;a:11:{s:4:\"uuid\";s:36:\"ee04ba64-4b1f-4613-b8b1-c89986d83784\";s:4:\"name\";s:4:\"Reef\";s:6:\"domain\";s:32:\"multipurpose-33.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:41;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:42;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:43;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:44;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:45;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#1b9156\";i:1;s:7:\"#2ac578\";i:2;s:7:\"#013839\";i:3;s:7:\"#494d4d\";i:4;s:7:\"#f2f7f5\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#b6c4bd\";i:7;s:7:\"#000f0f\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Inter\', sans-serif\";s:17:\"body-font-variant\";s:3:\"500\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:21:\"\'DM Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"700\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:4;a:11:{s:4:\"uuid\";s:36:\"07aabb7a-677d-4163-aad3-79dd3000a471\";s:4:\"name\";s:6:\"Meteor\";s:6:\"domain\";s:31:\"multipurpose28.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:306;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:307;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:308;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:309;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:310;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#26a96c\";i:1;s:7:\"#19975c\";i:2;s:7:\"#0b160b\";i:3;s:7:\"#586a62\";i:4;s:7:\"#eaf8f1\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#d0dfd8\";i:7;s:7:\"#0b160b\";i:8;s:7:\"#111111\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:23:\"\'Quicksand\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:23:\"\'Quicksand\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"600\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:5;a:11:{s:4:\"uuid\";s:36:\"8af201d0-f647-43a8-9bdb-10f2707106d0\";s:4:\"name\";s:6:\"Sprout\";s:6:\"domain\";s:32:\"multipurpose-34.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:28;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:29;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:30;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:31;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:32;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#ee5959\";i:1;s:7:\"#d84545\";i:2;s:7:\"#001f3f\";i:3;s:7:\"#494d4d\";i:4;s:7:\"#f9f3f3\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#d5c9c9\";i:7;s:7:\"#080000\";i:8;s:7:\"#292020\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Inter\', sans-serif\";s:17:\"body-font-variant\";s:3:\"500\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:31:\"\'Plus Jakarta Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"700\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:6;a:11:{s:4:\"uuid\";s:36:\"e68380fb-aa65-41f7-add6-9ee219003924\";s:4:\"name\";s:5:\"Hosta\";s:6:\"domain\";s:31:\"multipurpose44.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:38;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:39;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:40;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:41;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:42;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#ffb650\";i:1;s:7:\"#ffc26d\";i:2;s:7:\"#000000\";i:3;s:7:\"#4e4e4e\";i:4;s:7:\"#f6f5f2\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#dadada\";i:7;s:7:\"#000000\";i:8;s:7:\"#111111\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:20:\"\'Roboto Slab\', serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:15:\"\'Besley\', serif\";s:20:\"headings-font-weight\";s:3:\"500\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"400\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:7;a:11:{s:4:\"uuid\";s:36:\"528664a1-403b-484b-a558-8a7bd38b6309\";s:4:\"name\";s:9:\"Supernova\";s:6:\"domain\";s:31:\"multipurpose45.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:289;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:290;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:291;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:292;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:293;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#0067FF\";i:1;s:7:\"#005EE9\";i:2;s:7:\"#0f172a\";i:3;s:7:\"#364151\";i:4;s:7:\"#E7F6FF\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#D1DAE5\";i:7;s:7:\"#070614\";i:8;s:7:\"#222222\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:26:\"\'Josefin Sans\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:15;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:26:\"\'Josefin Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:8;a:11:{s:4:\"uuid\";s:36:\"d9dcc64e-a34c-4ab9-a5b7-e0fe366dfad9\";s:4:\"name\";s:9:\"Celestial\";s:6:\"domain\";s:31:\"multipurpose27.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:14;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:15;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:17;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:18;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:19;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#00a7a7\";i:1;s:7:\"#008686\";i:2;s:7:\"#020202\";i:3;s:7:\"#353535\";i:4;s:7:\"#e7f2f3\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#c0c0c0\";i:7;s:7:\"#011114\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Rubik\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:17;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:19:\"\'Rubik\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"400\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"400\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:9;a:11:{s:4:\"uuid\";s:36:\"85d9d03f-a115-4fe7-ba98-69f3c5227faf\";s:4:\"name\";s:5:\"Acorn\";s:6:\"domain\";s:32:\"multipurpose-31.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:17;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:18;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:20;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:22;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:23;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#008f9e\";i:1;s:7:\"#047b86\";i:2;s:7:\"#0c0c0c\";i:3;s:7:\"#353131\";i:4;s:7:\"#e4efed\";i:5;s:7:\"#f4f9fa\";i:6;s:7:\"#8a8a8a\";i:7;s:7:\"#011213\";i:8;s:7:\"#302523\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:21:\"\'DM Sans\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:17:\"\'Fraunces\', serif\";s:20:\"headings-font-weight\";s:3:\"400\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"400\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}}}i:2;a:2:{s:5:\"match\";s:13:\"generic_match\";s:7:\"designs\";a:35:{i:0;a:11:{s:4:\"uuid\";s:36:\"cfebab1e-46ba-4880-887c-4fa0b789ec0a\";s:4:\"name\";s:7:\"Blossom\";s:6:\"domain\";s:30:\"multipurpose1.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:8;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:118;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:9:\"Offerings\";s:7:\"post_id\";i:167;s:9:\"post_slug\";s:9:\"offerings\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:1259;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:228;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#086afe\";i:1;s:7:\"#257af8\";i:2;s:7:\"#031530\";i:3;s:7:\"#374c6c\";i:4;s:7:\"#ebf5ff\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#e2e8f0\";i:7;s:7:\"#000000\";i:8;s:7:\"#94a3b8\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Inter\', sans-serif\";s:17:\"body-font-variant\";s:7:\"400,500\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:20:\"\'Outfit\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"500\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"500\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:1;a:11:{s:4:\"uuid\";s:36:\"ccccd71e-5867-4742-8983-ae8ab070f93d\";s:4:\"name\";s:5:\"Daisy\";s:6:\"domain\";s:30:\"multipurpose4.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:32;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:34;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:9:\"Offerings\";s:7:\"post_id\";i:35;s:9:\"post_slug\";s:9:\"offerings\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:774;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:36;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#2a9d8f\";i:1;s:7:\"#097c6e\";i:2;s:7:\"#000000\";i:3;s:16:\"rgba(0,0,0,0.65)\";i:4;s:7:\"#ecf4f3\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#d1d1d1\";i:7;s:7:\"#000000\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:20:\"\'Mulish\', sans-serif\";s:17:\"body-font-variant\";s:3:\"600\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:14;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:21:\"\'DM Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"500\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:2;a:11:{s:4:\"uuid\";s:36:\"34ffc4ec-e098-4372-81e8-1a4a6edb4c9c\";s:4:\"name\";s:5:\"Tulip\";s:6:\"domain\";s:30:\"multipurpose7.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:42;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:44;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:9:\"Offerings\";s:7:\"post_id\";i:45;s:9:\"post_slug\";s:9:\"offerings\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:939;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:46;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#4039fb\";i:1;s:7:\"#4f49fd\";i:2;s:7:\"#0f172a\";i:3;s:7:\"#454f5e\";i:4;s:7:\"#f1f5f9\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#ced4e0\";i:7;s:7:\"#0f172a\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Inter\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:16;s:6:\"mobile\";i:16;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:21:\"\'DM Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"600\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:3;a:11:{s:4:\"uuid\";s:36:\"185c2582-da7a-474e-87f0-18c53e7f7c14\";s:4:\"name\";s:6:\"Orchid\";s:6:\"domain\";s:30:\"multipurpose8.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:9;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:12;s:9:\"post_slug\";s:8:\"about-us\";}i:2;a:3:{s:10:\"post_title\";s:9:\"Offerings\";s:7:\"post_id\";i:14;s:9:\"post_slug\";s:9:\"offerings\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:1329;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:16;s:9:\"post_slug\";s:10:\"contact-us\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#0d8359\";i:1;s:7:\"#069966\";i:2;s:7:\"#171e30\";i:3;s:7:\"#161820\";i:4;s:7:\"#f5f5de\";i:5;s:7:\"#ffffff\";i:6;s:7:\"#e2e8f0\";i:7;s:7:\"#171e30\";i:8;s:7:\"#94a3b8\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:18:\"\'Jost\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:18:\"\'Jost\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"500\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:4;a:11:{s:4:\"uuid\";s:36:\"d7c83b9c-b1c1-4a26-8234-4f56d1350ff1\";s:4:\"name\";s:5:\"Lotus\";s:6:\"domain\";s:30:\"multipurpose9.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:31;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:32;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:9:\"Offerings\";s:7:\"post_id\";i:33;s:9:\"post_slug\";s:9:\"offerings\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:452;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:34;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#6000cd\";i:1;s:7:\"#8b26ff\";i:2;s:7:\"#0f172a\";i:3;s:7:\"#454f5e\";i:4;s:7:\"#f1f5f9\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#c6cbd2\";i:7;s:7:\"#0f172a\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:28:\"\'Libre Franklin\', sans-serif\";s:17:\"body-font-variant\";s:7:\"400,500\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:16;s:6:\"mobile\";i:16;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:28:\"\'Libre Franklin\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"600\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"700\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:5;a:11:{s:4:\"uuid\";s:36:\"6d5b7b24-0dac-4cd7-8d73-7804765d101b\";s:4:\"name\";s:7:\"Stellar\";s:6:\"domain\";s:32:\"multipurpose-10.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:9;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:12;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:14;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:1847;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:16;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#ba1849\";i:1;s:7:\"#cb1b4f\";i:2;s:7:\"#000000\";i:3;s:16:\"rgba(0,0,0,0.65)\";i:4;s:7:\"#f6f6f6\";i:5;s:7:\"#ffffff\";i:6;s:15:\"rgba(0,0,0,0.1)\";i:7;s:7:\"#000000\";i:8;s:7:\"#111111\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:21:\"\'Manrope\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:21:\"\'Manrope\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"600\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"700\";}s:12:\"color_scheme\";s:5:\"light\";}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:6;a:11:{s:4:\"uuid\";s:36:\"12ba44a0-fc79-4fb0-ac20-7c2eeede6854\";s:4:\"name\";s:4:\"Leaf\";s:6:\"domain\";s:32:\"multipurpose-11.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:32;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:33;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:34;s:9:\"post_slug\";s:7:\"service\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:522;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:35;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#f18200\";i:1;s:7:\"#ff9c27\";i:2;s:7:\"#000000\";i:3;s:7:\"#5b5b5b\";i:4;s:7:\"#f7f7f7\";i:5;s:7:\"#ffffff\";i:6;s:7:\"#d7d7d7\";i:7;s:7:\"#0c0e0a\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Inter\', sans-serif\";s:17:\"body-font-variant\";s:3:\"500\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:15;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:27:\"\'Space Grotesk\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"700\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:7;a:11:{s:4:\"uuid\";s:36:\"ce672de3-9c1b-4f9a-b2f4-be5c2d4fe175\";s:4:\"name\";s:4:\"Fern\";s:6:\"domain\";s:31:\"multipurpose12.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:33;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:35;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:36;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:298;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:37;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#ffde2f\";i:1;s:7:\"#ebc500\";i:2;s:7:\"#ffffff\";i:3;s:7:\"#ffffff\";i:4;s:7:\"#0b2329\";i:5;s:7:\"#091d22\";i:6;s:7:\"#585858\";i:7;s:7:\"#030c0e\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:25:\"\'Inter Tight\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:15;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:21:\"\'Archivo\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"600\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"400\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:8;a:11:{s:4:\"uuid\";s:36:\"beadd1ca-7ced-4ae8-870f-b78985538ae5\";s:4:\"name\";s:4:\"Vine\";s:6:\"domain\";s:31:\"multipurpose13.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:9;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:12;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:14;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:1239;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:16;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#eb3e6c\";i:1;s:7:\"#e63059\";i:2;s:7:\"#22413a\";i:3;s:7:\"#59716b\";i:4;s:7:\"#fff6ec\";i:5;s:7:\"#ffffff\";i:6;s:18:\"rgba(34,65,58,0.1)\";i:7;s:7:\"#000000\";i:8;s:7:\"#111111\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:23:\"\'Open Sans\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:26:\"\'Libre Baskerville\', serif\";s:20:\"headings-font-weight\";s:7:\"inherit\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"400\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:9;a:11:{s:4:\"uuid\";s:36:\"aa69c22d-9bdf-4633-9015-33796bbdb64b\";s:4:\"name\";s:5:\"Poppy\";s:6:\"domain\";s:31:\"multipurpose15.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:79;s:9:\"post_slug\";s:4:\"79-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:57;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:59;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:899;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:61;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#f36a1d\";i:1;s:7:\"#bf4a00\";i:2;s:7:\"#000000\";i:3;s:7:\"#2b2b2b\";i:4;s:7:\"#f5f5f5\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#cacaca\";i:7;s:7:\"#080b00\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:21:\"\'DM Sans\', sans-serif\";s:17:\"body-font-variant\";s:3:\"600\";s:16:\"body-font-weight\";s:7:\"inherit\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:21:\"\'Manrope\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:10;a:11:{s:4:\"uuid\";s:36:\"7fbee9d1-7960-4294-8a6b-1476f5ad860d\";s:4:\"name\";s:5:\"Peony\";s:6:\"domain\";s:31:\"multipurpose17.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:56;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:57;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:58;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:60;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:59;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#e76f51\";i:1;s:7:\"#d66244\";i:2;s:7:\"#210f0b\";i:3;s:7:\"#665a57\";i:4;s:7:\"#f6f6f6\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#dddddd\";i:7;s:7:\"#210f0b\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Inter\', sans-serif\";s:17:\"body-font-variant\";s:3:\"600\";s:16:\"body-font-weight\";s:7:\"inherit\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";i:14;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:25:\"\'Playfair Display\', serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:11;a:11:{s:4:\"uuid\";s:36:\"c6fe2a6a-d9e7-4acb-a5ae-208a03764271\";s:4:\"name\";s:8:\"Daffodil\";s:6:\"domain\";s:31:\"multipurpose18.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:23;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:25;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:27;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:118;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:29;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#fe7239\";i:1;s:7:\"#f25617\";i:2;s:7:\"#000000\";i:3;s:7:\"#3c3c3c\";i:4;s:7:\"#f6f6f6\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#cdcdcd\";i:7;s:7:\"#170a06\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:21:\"\'Poppins\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:16;s:6:\"mobile\";i:16;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:27:\"\'Source Sans 3\', sans-serif\";s:20:\"headings-font-weight\";s:7:\"inherit\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:12;a:11:{s:4:\"uuid\";s:36:\"5c62352f-beb2-44cb-9439-19dd8914e8ae\";s:4:\"name\";s:6:\"Zinnia\";s:6:\"domain\";s:31:\"multipurpose19.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:255;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:256;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:257;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:258;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:259;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#38a3a5\";i:1;s:7:\"#2a9294\";i:2;s:7:\"#081d1e\";i:3;s:7:\"#545f5f\";i:4;s:7:\"#f2f7f7\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#d7e1e1\";i:7;s:7:\"#081d1e\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:23:\"\'Quicksand\', sans-serif\";s:17:\"body-font-variant\";s:3:\"600\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";i:14;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:23:\"\'Quicksand\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"500\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:7:\"500,600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:13;a:11:{s:4:\"uuid\";s:36:\"2bd12ae1-6783-476a-bdb5-e4ce84a046b4\";s:4:\"name\";s:5:\"Pansy\";s:6:\"domain\";s:31:\"multipurpose20.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:281;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:282;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:283;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:284;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:285;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#117256\";i:1;s:7:\"#0d654b\";i:2;s:7:\"#16251e\";i:3;s:7:\"#4e5753\";i:4;s:7:\"#eff2f1\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#d3d8d5\";i:7;s:7:\"#16251e\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:24:\"\'Montserrat\', sans-serif\";s:17:\"body-font-variant\";s:3:\"600\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";i:14;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:25:\"\'Reddit Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"600\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:14;a:11:{s:4:\"uuid\";s:36:\"268d69d8-11ba-4260-8b2e-599071703331\";s:4:\"name\";s:5:\"Orion\";s:6:\"domain\";s:31:\"multipurpose22.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:259;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:260;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:261;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:262;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:263;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#fe5b2c\";i:1;s:7:\"#f25617\";i:2;s:7:\"#1b3942\";i:3;s:7:\"#475f66\";i:4;s:7:\"#f7f7f7\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#475f66\";i:7;s:7:\"#1b3942\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:25:\"\'Nunito Sans\', sans-serif\";s:17:\"body-font-variant\";s:3:\"600\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:17;s:6:\"tablet\";i:16;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:15:\"\'Domine\', serif\";s:20:\"headings-font-weight\";s:7:\"inherit\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:15;a:11:{s:4:\"uuid\";s:36:\"43fb0bf6-ab93-4b85-a4dc-c57208d14a94\";s:4:\"name\";s:6:\"Cactus\";s:6:\"domain\";s:31:\"multipurpose23.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:50;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:52;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:53;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:91;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:54;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#0197af\";i:1;s:7:\"#00afcb\";i:2;s:7:\"#090909\";i:3;s:7:\"#545454\";i:4;s:7:\"#eff6f7\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#cdcdcd\";i:7;s:7:\"#011114\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:23:\"\'Quicksand\', sans-serif\";s:17:\"body-font-variant\";s:3:\"500\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:23:\"\'Source Serif 4\', serif\";s:20:\"headings-font-weight\";s:3:\"400\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"400\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:16;a:11:{s:4:\"uuid\";s:36:\"da5c6773-639a-4500-82ef-079421bcc1e7\";s:4:\"name\";s:4:\"Pine\";s:6:\"domain\";s:31:\"multipurpose24.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:278;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:279;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:280;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:281;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:282;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#ff624d\";i:1;s:7:\"#ea4e49\";i:2;s:7:\"#090909\";i:3;s:7:\"#545454\";i:4;s:7:\"#f9f3f3\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#bbbbbb\";i:7;s:7:\"#090909\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Inter\', sans-serif\";s:17:\"body-font-variant\";s:3:\"600\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:19:\"\'Inter\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:17;a:11:{s:4:\"uuid\";s:36:\"3fd95987-f946-45a5-98d7-31a0bcd3ea18\";s:4:\"name\";s:5:\"Cedar\";s:6:\"domain\";s:31:\"multipurpose25.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:35;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:36;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:37;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:38;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:39;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#4eb215\";i:1;s:7:\"#71c144\";i:2;s:7:\"#071f1b\";i:3;s:7:\"#3c4040\";i:4;s:7:\"#ebebe0\";i:5;s:7:\"#fafafa\";i:6;s:7:\"#d1d1d1\";i:7;s:7:\"#000000\";i:8;s:7:\"#03211b\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:21:\"\'DM Sans\', sans-serif\";s:17:\"body-font-variant\";s:3:\"500\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:20:\"\'Lexend\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"500\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:7:\"500,600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:18;a:11:{s:4:\"uuid\";s:36:\"cce4d1c6-2c0b-42fd-92b1-babdd89f16d4\";s:4:\"name\";s:6:\"Galaxy\";s:6:\"domain\";s:31:\"multipurpose21.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:19;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:20;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:21;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:261;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:22;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#0a749f\";i:1;s:7:\"#05668d\";i:2;s:7:\"#2a383e\";i:3;s:7:\"#59686e\";i:4;s:7:\"#ebf1f3\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#d3d9dc\";i:7;s:7:\"#000000\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:18:\"\'Lato\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:14;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:22:\"\'Urbanist\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"600\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"300\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:19;a:11:{s:4:\"uuid\";s:36:\"bbb26b94-bde3-4acd-b7b2-5bb644a86658\";s:4:\"name\";s:6:\"Nebula\";s:6:\"domain\";s:31:\"multipurpose26.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:15;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:16;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:18;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:19;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:20;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#00989f\";i:1;s:7:\"#03777d\";i:2;s:7:\"#071f1b\";i:3;s:7:\"#3c4040\";i:4;s:7:\"#f0f6f7\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#c0c0c0\";i:7;s:7:\"#021315\";i:8;s:7:\"#03211b\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:21:\"\'Manrope\', sans-serif\";s:17:\"body-font-variant\";s:3:\"500\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:21:\"\'Manrope\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"800\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:20;a:11:{s:4:\"uuid\";s:36:\"07aabb7a-677d-4163-aad3-79dd3000a471\";s:4:\"name\";s:6:\"Meteor\";s:6:\"domain\";s:31:\"multipurpose28.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:306;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:307;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:308;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:309;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:310;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#26a96c\";i:1;s:7:\"#19975c\";i:2;s:7:\"#0b160b\";i:3;s:7:\"#586a62\";i:4;s:7:\"#eaf8f1\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#d0dfd8\";i:7;s:7:\"#0b160b\";i:8;s:7:\"#111111\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:23:\"\'Quicksand\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:23:\"\'Quicksand\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"600\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:21;a:11:{s:4:\"uuid\";s:36:\"d9dcc64e-a34c-4ab9-a5b7-e0fe366dfad9\";s:4:\"name\";s:9:\"Celestial\";s:6:\"domain\";s:31:\"multipurpose27.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:14;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:15;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:17;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:18;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:19;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#00a7a7\";i:1;s:7:\"#008686\";i:2;s:7:\"#020202\";i:3;s:7:\"#353535\";i:4;s:7:\"#e7f2f3\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#c0c0c0\";i:7;s:7:\"#011114\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Rubik\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:17;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:19:\"\'Rubik\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"400\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"400\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:22;a:11:{s:4:\"uuid\";s:36:\"534c28c0-7422-4839-baf9-ec35e3810321\";s:4:\"name\";s:5:\"Cedar\";s:6:\"domain\";s:31:\"multipurpose29.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:23;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:24;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:26;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:27;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:28;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#ffc03d\";i:1;s:7:\"#ffae00\";i:2;s:7:\"#212d45\";i:3;s:7:\"#4b4f58\";i:4;s:7:\"#f7f7f7\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#f7f7f7\";i:7;s:7:\"#212d45\";i:8;s:7:\"#212d45\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Inter\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";i:16;s:6:\"mobile\";i:15;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:19:\"\'Inter\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"500\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:23;a:11:{s:4:\"uuid\";s:36:\"876ae376-d570-4d79-be84-19e5383855ed\";s:4:\"name\";s:6:\"Bonsai\";s:6:\"domain\";s:31:\"multipurpose30.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:36;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:37;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:38;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:39;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:40;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#ff6d59\";i:1;s:7:\"#e24c37\";i:2;s:7:\"#000000\";i:3;s:7:\"#5b5b5b\";i:4;s:7:\"#f8f1f1\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#b7b7b7\";i:7;s:7:\"#292020\";i:8;s:7:\"#292020\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:21:\"\'Manrope\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:21:\"\'Manrope\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"600\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:24;a:11:{s:4:\"uuid\";s:36:\"85d9d03f-a115-4fe7-ba98-69f3c5227faf\";s:4:\"name\";s:5:\"Acorn\";s:6:\"domain\";s:32:\"multipurpose-31.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:17;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:18;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:20;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:22;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:23;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#008f9e\";i:1;s:7:\"#047b86\";i:2;s:7:\"#0c0c0c\";i:3;s:7:\"#353131\";i:4;s:7:\"#e4efed\";i:5;s:7:\"#f4f9fa\";i:6;s:7:\"#8a8a8a\";i:7;s:7:\"#011213\";i:8;s:7:\"#302523\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:21:\"\'DM Sans\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:17:\"\'Fraunces\', serif\";s:20:\"headings-font-weight\";s:3:\"400\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"400\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:25;a:11:{s:4:\"uuid\";s:36:\"32541247-4478-4e20-9529-8587fdbab5fd\";s:4:\"name\";s:6:\"Almond\";s:6:\"domain\";s:32:\"multipurpose-32.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:19;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:21;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:22;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:30;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:31;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#223035\";i:1;s:7:\"#f47a55\";i:2;s:7:\"#223035\";i:3;s:7:\"#4c575b\";i:4;s:7:\"#f1f3f1\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#f1f3f1\";i:7;s:7:\"#223035\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Heebo\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:17;s:6:\"tablet\";i:15;s:6:\"mobile\";i:15;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:19:\"\'Inter\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"600\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:26;a:11:{s:4:\"uuid\";s:36:\"ee04ba64-4b1f-4613-b8b1-c89986d83784\";s:4:\"name\";s:4:\"Reef\";s:6:\"domain\";s:32:\"multipurpose-33.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:41;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:42;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:43;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:44;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:45;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#1b9156\";i:1;s:7:\"#2ac578\";i:2;s:7:\"#013839\";i:3;s:7:\"#494d4d\";i:4;s:7:\"#f2f7f5\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#b6c4bd\";i:7;s:7:\"#000f0f\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Inter\', sans-serif\";s:17:\"body-font-variant\";s:3:\"500\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:21:\"\'DM Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"700\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:27;a:11:{s:4:\"uuid\";s:36:\"8af201d0-f647-43a8-9bdb-10f2707106d0\";s:4:\"name\";s:6:\"Sprout\";s:6:\"domain\";s:32:\"multipurpose-34.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:28;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:29;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:30;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:31;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:32;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#ee5959\";i:1;s:7:\"#d84545\";i:2;s:7:\"#001f3f\";i:3;s:7:\"#494d4d\";i:4;s:7:\"#f9f3f3\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#d5c9c9\";i:7;s:7:\"#080000\";i:8;s:7:\"#292020\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Inter\', sans-serif\";s:17:\"body-font-variant\";s:3:\"500\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:31:\"\'Plus Jakarta Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"700\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:28;a:11:{s:4:\"uuid\";s:36:\"4c9fc948-0b55-4673-a6ee-4e9effdb3f6d\";s:4:\"name\";s:4:\"Sage\";s:6:\"domain\";s:31:\"multipurpose37.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:31;s:9:\"post_slug\";s:6:\"home-2\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:32;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:33;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:34;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:36;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#446c43\";i:1;s:7:\"#729370\";i:2;s:7:\"#19231c\";i:3;s:7:\"#434844\";i:4;s:7:\"#faf6ee\";i:5;s:7:\"#fdfdfd\";i:6;s:7:\"#cccccc\";i:7;s:7:\"#00080a\";i:8;s:7:\"#446c43\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:21:\"\'Poppins\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:21:\"\'Poppins\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"500\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"400\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:29;a:11:{s:4:\"uuid\";s:36:\"3c9a5eed-760a-4fc5-b70d-fa10269b9343\";s:4:\"name\";s:7:\"Petunia\";s:6:\"domain\";s:31:\"multipurpose36.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:23;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:24;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:25;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:26;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:27;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#002e24\";i:1;s:7:\"#007e60\";i:2;s:7:\"#0b141f\";i:3;s:7:\"#3a414a\";i:4;s:7:\"#f0f9f5\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#f0f9f5\";i:7;s:7:\"#002e24\";i:8;s:7:\"#111111\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:27:\"\'Source Sans 3\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:18;s:6:\"tablet\";i:17;s:6:\"mobile\";i:16;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:25:\"\'Nunito Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"600\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:7:\"600,700\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:30;a:11:{s:4:\"uuid\";s:36:\"e8c47be3-5503-4102-8260-5d543dd7bfb5\";s:4:\"name\";s:8:\"Foxglove\";s:6:\"domain\";s:31:\"multipurpose43.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:296;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:298;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:299;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:300;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:301;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#ff6464\";i:1;s:7:\"#f14e4e\";i:2;s:7:\"#071f1b\";i:3;s:7:\"#393939\";i:4;s:7:\"#faf6f6\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#e4dede\";i:7;s:7:\"#000000\";i:8;s:7:\"#111111\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:23:\"\'Work Sans\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:21:\"\'Belleza\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"400\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:31;a:11:{s:4:\"uuid\";s:36:\"e68380fb-aa65-41f7-add6-9ee219003924\";s:4:\"name\";s:5:\"Hosta\";s:6:\"domain\";s:31:\"multipurpose44.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:38;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:39;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:40;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:41;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:42;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#ffb650\";i:1;s:7:\"#ffc26d\";i:2;s:7:\"#000000\";i:3;s:7:\"#4e4e4e\";i:4;s:7:\"#f6f5f2\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#dadada\";i:7;s:7:\"#000000\";i:8;s:7:\"#111111\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:20:\"\'Roboto Slab\', serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:15:\"\'Besley\', serif\";s:20:\"headings-font-weight\";s:3:\"500\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"400\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:32;a:11:{s:4:\"uuid\";s:36:\"528664a1-403b-484b-a558-8a7bd38b6309\";s:4:\"name\";s:9:\"Supernova\";s:6:\"domain\";s:31:\"multipurpose45.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:289;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:290;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:291;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:292;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:293;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#0067FF\";i:1;s:7:\"#005EE9\";i:2;s:7:\"#0f172a\";i:3;s:7:\"#364151\";i:4;s:7:\"#E7F6FF\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#D1DAE5\";i:7;s:7:\"#070614\";i:8;s:7:\"#222222\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:26:\"\'Josefin Sans\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:15;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:26:\"\'Josefin Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:33;a:11:{s:4:\"uuid\";s:36:\"1142a4ff-e76e-4c14-94a8-d8f9e1e9fa7c\";s:4:\"name\";s:7:\"Stellar\";s:6:\"domain\";s:31:\"multipurpose46.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:282;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:292;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:294;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:807;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:296;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#4e9d4c\";i:1;s:7:\"#3d933b\";i:2;s:7:\"#001d4a\";i:3;s:7:\"#697a96\";i:4;s:7:\"#f1f4f9\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#d9e3f3\";i:7;s:7:\"#001d4a\";i:8;s:7:\"#b52765\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Cabin\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:14;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:19:\"\'Cabin\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}i:34;a:11:{s:4:\"uuid\";s:36:\"25db608a-d521-4679-8062-f0231fbaa3a5\";s:4:\"name\";s:7:\"Sparkle\";s:6:\"domain\";s:31:\"multipurpose47.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:9;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:11;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:12;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:13;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:14;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#ff5635\";i:1;s:7:\"#ff3108\";i:2;s:7:\"#27061e\";i:3;s:7:\"#786473\";i:4;s:7:\"#f9f6f3\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#cbcbcb\";i:7;s:7:\"#190203\";i:8;s:7:\"#5a0f10\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:23:\"\'Quicksand\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:27:\"\'IBM Plex Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"600\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:1;}}}}}", "auto");
INSERT INTO `wp_options` VALUES("224", "zipwp_selection_templates", "a:2:{s:6:\"result\";a:1:{i:0;a:2:{s:5:\"match\";s:13:\"generic_match\";s:7:\"designs\";a:9:{i:0;a:11:{s:4:\"uuid\";s:36:\"086dd06a-b9fc-4b04-8872-a72397d92203\";s:4:\"name\";s:8:\"Petaluxe\";s:6:\"domain\";s:28:\"restaurant3.websitedemos.top\";s:11:\"pages_count\";i:6;s:5:\"pages\";a:6:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:67;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:68;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:4:\"Menu\";s:7:\"post_id\";i:69;s:9:\"post_slug\";s:4:\"menu\";}i:3;a:3:{s:10:\"post_title\";s:7:\"Gallery\";s:7:\"post_id\";i:70;s:9:\"post_slug\";s:7:\"gallery\";}i:4;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:83;s:9:\"post_slug\";s:4:\"blog\";}i:5;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:71;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#d18000\";i:1;s:7:\"#f69700\";i:2;s:7:\"#fff3dc\";i:3;s:7:\"#b5aea0\";i:4;s:7:\"#001513\";i:5;s:7:\"#000e0c\";i:6;s:7:\"#4a4843\";i:7;s:7:\"#000e0c\";i:8;s:7:\"#111111\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:19:\"\'Basic\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:16;s:6:\"mobile\";i:15;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:24:\"\'Bebas Neue\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"400\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"400\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:1;a:11:{s:4:\"uuid\";s:36:\"d3b50a87-e399-41c3-b737-1b58fd868807\";s:4:\"name\";s:8:\"Marigola\";s:6:\"domain\";s:32:\"movers-packers2.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:9;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:11;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:12;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:14;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:13;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#ff4121\";i:1;s:7:\"#e04024\";i:2;s:7:\"#610135\";i:3;s:7:\"#724b60\";i:4;s:7:\"#f0e7d0\";i:5;s:7:\"#fffdf3\";i:6;s:7:\"#dfc8c6\";i:7;s:7:\"#620035\";i:8;s:7:\"#111111\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:21:\"\'Manrope\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:14;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:17:\"\'PT Serif\', serif\";s:20:\"headings-font-weight\";s:3:\"400\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:2;a:11:{s:4:\"uuid\";s:36:\"2c4f652c-2d63-4487-9a59-26f4646a2c9e\";s:4:\"name\";s:7:\"Budrose\";s:6:\"domain\";s:41:\"commercial-photographer2.websitedemos.top\";s:11:\"pages_count\";i:6;s:5:\"pages\";a:6:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:9;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:12;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:13;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:9:\"Portfolio\";s:7:\"post_id\";i:15;s:9:\"post_slug\";s:9:\"portfolio\";}i:4;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:21;s:9:\"post_slug\";s:4:\"blog\";}i:5;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:14;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#258e6f\";i:1;s:7:\"#158160\";i:2;s:7:\"#1a1818\";i:3;s:7:\"#4a4a4d\";i:4;s:7:\"#ecf3f1\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#cad5d2\";i:7;s:7:\"#01110c\";i:8;s:7:\"#111111\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:22:\"\'Urbanist\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:27:\"\'Cormorant Garamond\', serif\";s:20:\"headings-font-weight\";s:3:\"500\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:3;a:11:{s:4:\"uuid\";s:36:\"5283e406-9da7-4cc3-8f56-716bd9ab688a\";s:4:\"name\";s:5:\"Pluto\";s:6:\"domain\";s:30:\"entrepreneur4.websitedemos.top\";s:11:\"pages_count\";i:4;s:5:\"pages\";a:4:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:32;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:34;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:35;s:9:\"post_slug\";s:4:\"blog\";}i:3;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:36;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#be844d\";i:1;s:7:\"#077884\";i:2;s:7:\"#19253d\";i:3;s:7:\"#233454\";i:4;s:7:\"#eef0ec\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#f2f5f8\";i:7;s:7:\"#19253d\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:21:\"\'Poppins\', sans-serif\";s:17:\"body-font-variant\";s:3:\"400\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:14;s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:26:\"\'Libre Baskerville\', serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"700\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:4;a:11:{s:4:\"uuid\";s:36:\"553d9416-63b7-4545-8150-2fddb37230d3\";s:4:\"name\";s:7:\"Daisyfy\";s:6:\"domain\";s:24:\"agency6.websitedemos.top\";s:11:\"pages_count\";i:6;s:5:\"pages\";a:6:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:331;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:334;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:336;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:8:\"Projects\";s:7:\"post_id\";i:338;s:9:\"post_slug\";s:8:\"projects\";}i:4;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:1165;s:9:\"post_slug\";s:4:\"blog\";}i:5;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:340;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#b8346b\";i:1;s:7:\"#843e84\";i:2;s:7:\"#000000\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#f6f6f6\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#dddddd\";i:7;s:7:\"#010101\";i:8;s:7:\"#505050\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:23:\"\'Work Sans\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:14;s:6:\"tablet\";i:14;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:23:\"\'Work Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"300\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:5;a:11:{s:4:\"uuid\";s:36:\"e97096f8-62bf-4ede-a34a-64c817c2db33\";s:4:\"name\";s:9:\"Sunfloria\";s:6:\"domain\";s:40:\"real-estate-consultant2.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:275;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:278;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:280;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:282;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:284;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#119da4\";i:1;s:7:\"#0e898f\";i:2;s:7:\"#1f2041\";i:3;s:7:\"#686a9c\";i:4;s:7:\"#f5f5fa\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#e2e3f2\";i:7;s:7:\"#1f2041\";i:8;s:7:\"#19647e\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:24:\"\'Montserrat\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:14;s:6:\"tablet\";i:14;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:20:\"\'Bodoni Moda\', serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:6;a:11:{s:4:\"uuid\";s:36:\"a8a26a3b-f6fc-4427-bed7-3e7aabc009c8\";s:4:\"name\";s:6:\"Zenith\";s:6:\"domain\";s:26:\"gardening.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:9;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:12;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:13;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:275;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:14;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#104d31\";i:1;s:7:\"#0c3824\";i:2;s:7:\"#22332b\";i:3;s:7:\"#505a56\";i:4;s:7:\"#f2f6f0\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#dfe9db\";i:7;s:7:\"#0d3824\";i:8;s:7:\"#dfe9db\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:31:\"\'Plus Jakarta Sans\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:31:\"\'Plus Jakarta Sans\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:7;a:11:{s:4:\"uuid\";s:36:\"349cc650-0eb0-41cf-8679-dd58f189d6b9\";s:4:\"name\";s:10:\"Eucalyptus\";s:6:\"domain\";s:30:\"entrepreneur5.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:10;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:30;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:34;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:38;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:32;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#4732ca\";i:1;s:7:\"#251589\";i:2;s:7:\"#0e0e0f\";i:3;s:7:\"#515151\";i:4;s:7:\"#f9f9fa\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#e0e0e0\";i:7;s:7:\"#08041f\";i:8;s:7:\"#000000\";}s:4:\"flag\";b:1;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:21:\"\'Manrope\', sans-serif\";s:17:\"body-font-variant\";s:3:\"600\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:15;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:4:\"1.65\";s:20:\"headings-font-family\";s:21:\"\'Manrope\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"800\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:3:\"600\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}i:8;a:11:{s:4:\"uuid\";s:36:\"2532a49c-6273-4f7f-8e48-6fe38f3a1d89\";s:4:\"name\";s:7:\"Rosalia\";s:6:\"domain\";s:25:\"charity2.websitedemos.top\";s:11:\"pages_count\";i:5;s:5:\"pages\";a:5:{i:0;a:3:{s:10:\"post_title\";s:4:\"Home\";s:7:\"post_id\";i:275;s:9:\"post_slug\";s:4:\"home\";}i:1;a:3:{s:10:\"post_title\";s:5:\"About\";s:7:\"post_id\";i:278;s:9:\"post_slug\";s:5:\"about\";}i:2;a:3:{s:10:\"post_title\";s:8:\"Services\";s:7:\"post_id\";i:280;s:9:\"post_slug\";s:8:\"services\";}i:3;a:3:{s:10:\"post_title\";s:4:\"Blog\";s:7:\"post_id\";i:284;s:9:\"post_slug\";s:4:\"blog\";}i:4;a:3:{s:10:\"post_title\";s:7:\"Contact\";s:7:\"post_id\";i:286;s:9:\"post_slug\";s:7:\"contact\";}}s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"name\";s:29:\"ultimate-addons-for-gutenberg\";s:5:\"title\";s:7:\"Spectra\";}i:1;a:2:{s:4:\"name\";s:9:\"sureforms\";s:5:\"title\";s:9:\"SureForms\";}}s:7:\"content\";a:0:{}s:15:\"design_defaults\";a:3:{s:13:\"color_palette\";a:2:{s:7:\"palette\";a:9:{i:0;s:7:\"#028090\";i:1;s:7:\"#05668d\";i:2;s:7:\"#002d40\";i:3;s:7:\"#5f7b86\";i:4;s:7:\"#f1f8e4\";i:5;s:7:\"#FFFFFF\";i:6;s:7:\"#d3e3e4\";i:7;s:7:\"#000000\";i:8;s:7:\"#383838\";}s:4:\"flag\";b:0;}s:10:\"typography\";a:10:{s:7:\"default\";b:1;s:16:\"body-font-family\";s:7:\"inherit\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:20:\"headings-font-family\";s:20:\"\'Outfit\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"700\";s:20:\"headings-line-height\";s:0:\"\";s:21:\"headings-font-variant\";s:0:\"\";}s:12:\"color_scheme\";a:0:{}}s:8:\"features\";a:5:{s:4:\"blog\";s:3:\"yes\";s:12:\"page-builder\";s:3:\"yes\";s:12:\"contact-form\";s:3:\"yes\";s:9:\"ecommerce\";s:2:\"no\";s:9:\"donations\";s:2:\"no\";}s:13:\"features_data\";a:2:{s:14:\"ecommerce_type\";s:8:\"surecart\";s:19:\"ecommerce_supported\";a:2:{i:0;s:8:\"surecart\";i:1;s:11:\"woocommerce\";}}s:10:\"is_premium\";i:0;}}}}s:8:\"lastPage\";i:12;}", "auto");
INSERT INTO `wp_options` VALUES("227", "zip_ai_settings", "a:3:{s:10:\"auth_token\";s:75:\"MTM3NjMzNHxzcWJPNHVWQzV1STdPQ2luYWV1ZUJPb2JReDdSUDlKdlF2RGQ5S3QxM2I4NjgwNTg\";s:9:\"zip_token\";s:75:\"MjQ5MTg4OHxhSlNnZFgzbUZEc1ZVWUlneVZPUUt2Y29oM3JhUjZPVU16RmI4UGVBM2MzYTBkZmQ\";s:5:\"email\";s:20:\"cetefcetef@gmail.com\";}", "auto");
INSERT INTO `wp_options` VALUES("232", "zipwp_import_site_details", "a:28:{s:2:\"id\";i:1242891;s:4:\"uuid\";s:36:\"ad0e245e-d9b9-4af9-9abb-02406e3b209c\";s:4:\"slug\";s:23:\"blissful-burgoyne-r734m\";s:4:\"type\";s:2:\"ai\";s:12:\"businessName\";s:53:\"Centre d\'Etude Technique Environnemental et Forestier\";s:12:\"businessDesc\";s:906:\"Le Centre d’Étude Technique Environnemental et Forestier (CETEF) est une association loi 1901 de propriétaires privés et de sylviculteurs créée en 1977. Organisme technique de terrain et de proximité, le CETEF associe la gestion forestière aux enjeux environnementaux, paysagers et sociétaux. \nIl est reconnu comme « Organisme d’intérêt général » depuis le 8 avril 2019.\nLe CETEF est composé de quatre salariés :  \n1 Assistante administrative  \n1 Technicien Forestier et Gestionnaire Forestier Professionnel  \n1 Ecologue Forestier et Gestionnaire Forestier Professionnel  \n1 Directeur  \nIls sont placés sous l’autorité d’un conseil d’administration qui fixe les orientations et représente la structure dans les différentes instances.  \nLe CETEF accompagne ses adhérents (propriétaires forestiers, sylviculteurs, collectivités…) dans la gestion de leur forêt.\";s:4:\"name\";s:23:\"blissful-burgoyne-r734m\";s:5:\"title\";s:53:\"Centre d\'Etude Technique Environnemental et Forestier\";s:6:\"domain\";s:35:\"blissful-burgoyne-r734m.example.com\";s:3:\"url\";s:43:\"https://blissful-burgoyne-r734m.example.com\";s:8:\"reserved\";b:0;s:6:\"status\";s:11:\"in-progress\";s:7:\"created\";s:19:\"2025-10-02 13:43:18\";s:7:\"expires\";s:19:\"2025-11-01 13:43:18\";s:7:\"deletes\";s:19:\"2025-11-04 13:43:18\";s:10:\"is_expired\";b:0;s:10:\"is_deleted\";b:0;s:10:\"expires_in\";s:40:\"Expires in 29 days, 23 hours, 59 minutes\";s:7:\"wp_user\";s:12:\"kfwessxipasv\";s:11:\"wp_password\";s:16:\"R69FPXchJftWPQBl\";s:10:\"created_by\";a:5:{s:2:\"id\";i:1068133;s:5:\"email\";s:20:\"cetefcetef@gmail.com\";s:4:\"name\";s:11:\"CETEF CETEF\";s:10:\"first_name\";s:5:\"CETEF\";s:9:\"last_name\";s:5:\"CETEF\";}s:4:\"fast\";b:0;s:7:\"project\";N;s:12:\"is_blueprint\";N;s:14:\"structure_type\";s:4:\"site\";s:14:\"collected_data\";a:0:{}s:6:\"source\";s:17:\"starter-templates\";s:9:\"step_data\";a:18:{s:8:\"template\";s:36:\"d3b50a87-e399-41c3-b737-1b58fd868807\";s:14:\"business_email\";s:35:\"contact@cetefnouvelle-aquitaine.org\";s:5:\"email\";s:20:\"cetefcetef@gmail.com\";s:13:\"business_desc\";s:906:\"Le Centre d’Étude Technique Environnemental et Forestier (CETEF) est une association loi 1901 de propriétaires privés et de sylviculteurs créée en 1977. Organisme technique de terrain et de proximité, le CETEF associe la gestion forestière aux enjeux environnementaux, paysagers et sociétaux. \nIl est reconnu comme « Organisme d’intérêt général » depuis le 8 avril 2019.\nLe CETEF est composé de quatre salariés :  \n1 Assistante administrative  \n1 Technicien Forestier et Gestionnaire Forestier Professionnel  \n1 Ecologue Forestier et Gestionnaire Forestier Professionnel  \n1 Directeur  \nIls sont placés sous l’autorité d’un conseil d’administration qui fixe les orientations et représente la structure dans les différentes instances.  \nLe CETEF accompagne ses adhérents (propriétaires forestiers, sylviculteurs, collectivités…) dans la gestion de leur forêt.\";s:13:\"business_name\";s:53:\"Centre d\'Etude Technique Environnemental et Forestier\";s:5:\"title\";s:53:\"Centre d\'Etude Technique Environnemental et Forestier\";s:14:\"business_phone\";s:10:\"0545692327\";s:16:\"business_address\";s:40:\"20 Rue Léonard Jarraud 16000 Angoulême\";s:17:\"business_category\";s:10:\"Non-profit\";s:22:\"business_category_name\";s:10:\"Non-profit\";s:13:\"image_keyword\";a:5:{i:0;s:17:\"forest management\";i:1;s:28:\"environmental sustainability\";i:2;s:17:\"technical support\";i:3;s:14:\"forest ecology\";i:4;s:20:\"community engagement\";}s:15:\"social_profiles\";a:2:{i:0;a:3:{s:4:\"type\";s:9:\"instagram\";s:2:\"id\";s:9:\"instagram\";s:3:\"url\";s:35:\"https://www.instagram.com/cetef_na/\";}i:1;a:3:{s:4:\"type\";s:8:\"facebook\";s:2:\"id\";s:8:\"facebook\";s:3:\"url\";s:25:\"https://www.facebook.com/\";}}s:6:\"images\";a:1:{i:0;a:8:{s:2:\"id\";s:2:\"19\";s:3:\"url\";s:77:\"http://cetef-test.local/wp-content/uploads/2025/10/Fotolia_220866980_XL-1.jpg\";s:13:\"optimized_url\";s:86:\"http://cetef-test.local/wp-content/uploads/2025/10/Fotolia_220866980_XL-1-1024x768.jpg\";s:6:\"engine\";s:0:\"\";s:11:\"description\";s:0:\"\";s:11:\"orientation\";s:9:\"landscape\";s:11:\"author_name\";s:0:\"\";s:10:\"author_url\";s:0:\"\";}}s:8:\"language\";s:2:\"fr\";s:9:\"site_type\";s:2:\"ai\";s:11:\"site_source\";s:17:\"starter-templates\";s:13:\"site_features\";a:6:{i:0;s:4:\"blog\";i:1;s:12:\"page-builder\";i:2;s:12:\"contact-form\";i:3;s:9:\"sure-rank\";i:4;s:9:\"ecommerce\";i:5;s:20:\"appointment-bookings\";}s:18:\"site_features_data\";a:1:{s:14:\"ecommerce_type\";s:8:\"surecart\";}}}", "auto");
INSERT INTO `wp_options` VALUES("233", "astra_sites_current_import_template_type", "ai", "auto");
INSERT INTO `wp_options` VALUES("234", "astra_sites_batch_process_complete", "yes", "auto");
INSERT INTO `wp_options` VALUES("242", "__uagb_do_redirect", "", "auto");
INSERT INTO `wp_options` VALUES("243", "__uagb_activated_before", "1", "auto");
INSERT INTO `wp_options` VALUES("244", "__uagb_asset_version", "1764853969", "auto");
INSERT INTO `wp_options` VALUES("245", "bsf_product_referers", "a:5:{s:29:\"ultimate-addons-for-gutenberg\";s:5:\"zipwp\";s:9:\"sureforms\";s:5:\"zipwp\";s:8:\"surerank\";s:5:\"zipwp\";s:8:\"surecart\";s:5:\"zipwp\";s:9:\"latepoint\";s:5:\"zipwp\";}", "auto");
INSERT INTO `wp_options` VALUES("247", "uagb_site_url", "cetef-test-local", "auto");
INSERT INTO `wp_options` VALUES("249", "uagb_block_analytics_status", "a:4:{s:13:\"is_processing\";b:0;s:19:\"collection_complete\";b:1;s:15:\"first_run_check\";b:1;s:14:\"last_collected\";i:1759412587;}", "auto");
INSERT INTO `wp_options` VALUES("252", "_uagb_allow_file_generation", "enabled", "auto");
INSERT INTO `wp_options` VALUES("253", "uagb_block_analytics_data", "a:1:{s:17:\"block_usage_stats\";a:90:{s:21:\"uagb/advanced-heading\";i:0;s:15:\"uagb/blockquote\";i:0;s:12:\"uagb/buttons\";i:0;s:18:\"uagb/buttons-child\";i:0;s:19:\"uagb/call-to-action\";i:0;s:15:\"uagb/cf7-styler\";i:0;s:11:\"uagb/column\";i:0;s:12:\"uagb/columns\";i:0;s:14:\"uagb/container\";i:0;s:21:\"uagb/content-timeline\";i:0;s:27:\"uagb/content-timeline-child\";i:0;s:14:\"uagb/countdown\";i:0;s:12:\"uagb/counter\";i:0;s:8:\"uagb/faq\";i:0;s:14:\"uagb/faq-child\";i:0;s:10:\"uagb/forms\";i:0;s:17:\"uagb/forms-accept\";i:0;s:19:\"uagb/forms-checkbox\";i:0;s:15:\"uagb/forms-date\";i:0;s:16:\"uagb/forms-email\";i:0;s:17:\"uagb/forms-hidden\";i:0;s:15:\"uagb/forms-name\";i:0;s:16:\"uagb/forms-phone\";i:0;s:16:\"uagb/forms-radio\";i:0;s:17:\"uagb/forms-select\";i:0;s:19:\"uagb/forms-textarea\";i:0;s:17:\"uagb/forms-toggle\";i:0;s:14:\"uagb/forms-url\";i:0;s:14:\"uagb/gf-styler\";i:0;s:15:\"uagb/google-map\";i:0;s:11:\"uagb/how-to\";i:0;s:16:\"uagb/how-to-step\";i:0;s:9:\"uagb/icon\";i:0;s:14:\"uagb/icon-list\";i:0;s:20:\"uagb/icon-list-child\";i:0;s:10:\"uagb/image\";i:0;s:18:\"uagb/image-gallery\";i:0;s:13:\"uagb/info-box\";i:0;s:18:\"uagb/inline-notice\";i:0;s:11:\"uagb/lottie\";i:0;s:21:\"uagb/marketing-button\";i:0;s:10:\"uagb/modal\";i:0;s:18:\"uagb/popup-builder\";i:0;s:16:\"uagb/post-button\";i:0;s:18:\"uagb/post-carousel\";i:0;s:17:\"uagb/post-excerpt\";i:0;s:14:\"uagb/post-grid\";i:0;s:15:\"uagb/post-image\";i:0;s:17:\"uagb/post-masonry\";i:0;s:14:\"uagb/post-meta\";i:0;s:18:\"uagb/post-taxonomy\";i:0;s:18:\"uagb/post-timeline\";i:0;s:15:\"uagb/post-title\";i:0;s:20:\"uagb/restaurant-menu\";i:0;s:26:\"uagb/restaurant-menu-child\";i:0;s:11:\"uagb/review\";i:0;s:12:\"uagb/section\";i:0;s:14:\"uagb/separator\";i:0;s:11:\"uagb/slider\";i:0;s:17:\"uagb/slider-child\";i:0;s:17:\"uagb/social-share\";i:0;s:23:\"uagb/social-share-child\";i:0;s:16:\"uagb/star-rating\";i:0;s:23:\"uagb/sure-cart-checkout\";i:0;s:22:\"uagb/sure-cart-product\";i:0;s:15:\"uagb/sure-forms\";i:0;s:22:\"uagb/table-of-contents\";i:0;s:9:\"uagb/tabs\";i:0;s:15:\"uagb/tabs-child\";i:0;s:18:\"uagb/taxonomy-list\";i:0;s:9:\"uagb/team\";i:0;s:16:\"uagb/testimonial\";i:0;s:14:\"uagb/wp-search\";i:0;s:19:\"uagb/instagram-feed\";i:0;s:10:\"uagb/login\";i:0;s:17:\"uagb/loop-builder\";i:0;s:18:\"uagb/loop-category\";i:0;s:20:\"uagb/loop-pagination\";i:0;s:15:\"uagb/loop-reset\";i:0;s:16:\"uagb/loop-search\";i:0;s:14:\"uagb/loop-sort\";i:0;s:17:\"uagb/loop-wrapper\";i:0;s:13:\"uagb/register\";i:0;s:19:\"uagb/register-email\";i:0;s:24:\"uagb/register-first-name\";i:0;s:23:\"uagb/register-last-name\";i:0;s:22:\"uagb/register-password\";i:0;s:30:\"uagb/register-reenter-password\";i:0;s:19:\"uagb/register-terms\";i:0;s:22:\"uagb/register-username\";i:0;}}", "auto");
INSERT INTO `wp_options` VALUES("254", "uagb-version", "2.19.14", "auto");
INSERT INTO `wp_options` VALUES("256", "spectra_analytics_installed_time", "1759412583", "off");
INSERT INTO `wp_options` VALUES("258", "action_scheduler_hybrid_store_demarkation", "22", "auto");
INSERT INTO `wp_options` VALUES("259", "schema-ActionScheduler_StoreSchema", "7.0.1759412586", "auto");
INSERT INTO `wp_options` VALUES("260", "schema-ActionScheduler_LoggerSchema", "3.0.1759412586", "auto");
INSERT INTO `wp_options` VALUES("261", "__srfm_do_redirect", "", "auto");
INSERT INTO `wp_options` VALUES("262", "action_scheduler_lock_async-request-runner", "69318d634a1f79.69896876|1764855199", "no");
INSERT INTO `wp_options` VALUES("263", "srfm_database_table_versions", "a:1:{s:7:\"entries\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("266", "srfm-version", "1.12.3", "auto");
INSERT INTO `wp_options` VALUES("270", "sureforms_analytics_installed_time", "1759412589", "off");
INSERT INTO `wp_options` VALUES("274", "rewrite_rules", "a:279:{s:19:\"^sitemap_index.xml$\";s:28:\"index.php?surerank_sitemap=1\";s:26:\"^([a-z]+)-stylesheet\\.xsl$\";s:43:\"index.php?surerank_sitemap_type=$matches[1]\";s:64:\"^(post-type|taxonomy-type)-([a-z0-9_-]+)-sitemap-([0-9]+)?\\.xml$\";s:100:\"index.php?surerank_sitemap=$matches[2]&surerank_prefix=$matches[1]&surerank_sitemap_page=$matches[3]\";s:89:\"^(post|page|attachment|post-tag|author|category|product-category)-sitemap-([0-9]+)?\\.xml$\";s:72:\"index.php?surerank_sitemap=$matches[1]&surerank_sitemap_page=$matches[2]\";s:38:\"^([a-z0-9_-]+)-sitemap-([0-9]+)?\\.xml$\";s:72:\"index.php?surerank_sitemap=$matches[1]&surerank_sitemap_page=$matches[2]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:20:\"^products/([^/]+)/?$\";s:32:\"index.php?sc_product=$matches[1]\";s:26:\"products/([a-z0-9-]+)[/]?$\";s:32:\"index.php?sc_product=$matches[1]\";s:21:\"buy/([a-z0-9-]+)[/]?$\";s:44:\"index.php?sc_checkout_product_id=$matches[1]\";s:23:\"offer/([a-z0-9-]+)[/]?$\";s:34:\"index.php?sc_upsell_id=$matches[1]\";s:29:\"surecart/change-checkout-mode\";s:54:\"index.php?sc_checkout_change_mode=1&sc_checkout_post=1\";s:17:\"surecart/redirect\";s:23:\"index.php?sc_redirect=1\";s:6:\"pmb/?$\";s:31:\"index.php?post_type=pmb_content\";s:36:\"pmb/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=pmb_content&feed=$matches[1]\";s:31:\"pmb/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=pmb_content&feed=$matches[1]\";s:23:\"pmb/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=pmb_content&paged=$matches[1]\";s:7:\"form/?$\";s:34:\"index.php?post_type=sureforms_form\";s:37:\"form/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=sureforms_form&feed=$matches[1]\";s:32:\"form/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=sureforms_form&feed=$matches[1]\";s:24:\"form/page/([0-9]{1,})/?$\";s:52:\"index.php?post_type=sureforms_form&paged=$matches[1]\";s:34:\"wpcode/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"wpcode/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"wpcode/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"wpcode/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"wpcode/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"wpcode/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"wpcode/([^/]+)/embed/?$\";s:39:\"index.php?wpcode=$matches[1]&embed=true\";s:27:\"wpcode/([^/]+)/trackback/?$\";s:33:\"index.php?wpcode=$matches[1]&tb=1\";s:35:\"wpcode/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?wpcode=$matches[1]&paged=$matches[2]\";s:42:\"wpcode/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?wpcode=$matches[1]&cpage=$matches[2]\";s:31:\"wpcode/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?wpcode=$matches[1]&page=$matches[2]\";s:23:\"wpcode/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"wpcode/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"wpcode/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"wpcode/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"wpcode/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"wpcode/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"wpcode_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wpcode_type=$matches[1]&feed=$matches[2]\";s:47:\"wpcode_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wpcode_type=$matches[1]&feed=$matches[2]\";s:28:\"wpcode_type/([^/]+)/embed/?$\";s:44:\"index.php?wpcode_type=$matches[1]&embed=true\";s:40:\"wpcode_type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?wpcode_type=$matches[1]&paged=$matches[2]\";s:22:\"wpcode_type/([^/]+)/?$\";s:33:\"index.php?wpcode_type=$matches[1]\";s:56:\"wpcode_location/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?wpcode_location=$matches[1]&feed=$matches[2]\";s:51:\"wpcode_location/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?wpcode_location=$matches[1]&feed=$matches[2]\";s:32:\"wpcode_location/([^/]+)/embed/?$\";s:48:\"index.php?wpcode_location=$matches[1]&embed=true\";s:44:\"wpcode_location/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?wpcode_location=$matches[1]&paged=$matches[2]\";s:26:\"wpcode_location/([^/]+)/?$\";s:37:\"index.php?wpcode_location=$matches[1]\";s:52:\"wpcode_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wpcode_tags=$matches[1]&feed=$matches[2]\";s:47:\"wpcode_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wpcode_tags=$matches[1]&feed=$matches[2]\";s:28:\"wpcode_tags/([^/]+)/embed/?$\";s:44:\"index.php?wpcode_tags=$matches[1]&embed=true\";s:40:\"wpcode_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?wpcode_tags=$matches[1]&paged=$matches[2]\";s:22:\"wpcode_tags/([^/]+)/?$\";s:33:\"index.php?wpcode_tags=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"elementskit-content/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"elementskit-content/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"elementskit-content/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"elementskit-content/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"elementskit-content/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"elementskit-content/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"elementskit-content/(.+?)/embed/?$\";s:52:\"index.php?elementskit_content=$matches[1]&embed=true\";s:38:\"elementskit-content/(.+?)/trackback/?$\";s:46:\"index.php?elementskit_content=$matches[1]&tb=1\";s:46:\"elementskit-content/(.+?)/page/?([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&paged=$matches[2]\";s:53:\"elementskit-content/(.+?)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?elementskit_content=$matches[1]&cpage=$matches[2]\";s:42:\"elementskit-content/(.+?)(?:/([0-9]+))?/?$\";s:58:\"index.php?elementskit_content=$matches[1]&page=$matches[2]\";s:34:\"products/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"products/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"products/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"products/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"products/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"products/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"products/(.+?)/embed/?$\";s:43:\"index.php?sc_product=$matches[1]&embed=true\";s:27:\"products/(.+?)/trackback/?$\";s:37:\"index.php?sc_product=$matches[1]&tb=1\";s:35:\"products/(.+?)/page/?([0-9]{1,})/?$\";s:50:\"index.php?sc_product=$matches[1]&paged=$matches[2]\";s:42:\"products/(.+?)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?sc_product=$matches[1]&cpage=$matches[2]\";s:31:\"products/(.+?)(?:/([0-9]+))?/?$\";s:49:\"index.php?sc_product=$matches[1]&page=$matches[2]\";s:52:\"collections/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?sc_collection=$matches[1]&feed=$matches[2]\";s:47:\"collections/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?sc_collection=$matches[1]&feed=$matches[2]\";s:28:\"collections/([^/]+)/embed/?$\";s:46:\"index.php?sc_collection=$matches[1]&embed=true\";s:40:\"collections/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?sc_collection=$matches[1]&paged=$matches[2]\";s:22:\"collections/([^/]+)/?$\";s:35:\"index.php?sc_collection=$matches[1]\";s:39:\"pmb_project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"pmb_project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"pmb_project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"pmb_project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"pmb_project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"pmb_project/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"pmb_project/([^/]+)/embed/?$\";s:44:\"index.php?pmb_project=$matches[1]&embed=true\";s:32:\"pmb_project/([^/]+)/trackback/?$\";s:38:\"index.php?pmb_project=$matches[1]&tb=1\";s:40:\"pmb_project/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?pmb_project=$matches[1]&paged=$matches[2]\";s:47:\"pmb_project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?pmb_project=$matches[1]&cpage=$matches[2]\";s:36:\"pmb_project/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?pmb_project=$matches[1]&page=$matches[2]\";s:28:\"pmb_project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"pmb_project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"pmb_project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"pmb_project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"pmb_project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"pmb_project/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"pmb_design/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"pmb_design/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"pmb_design/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"pmb_design/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"pmb_design/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"pmb_design/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"pmb_design/([^/]+)/embed/?$\";s:43:\"index.php?pmb_design=$matches[1]&embed=true\";s:31:\"pmb_design/([^/]+)/trackback/?$\";s:37:\"index.php?pmb_design=$matches[1]&tb=1\";s:39:\"pmb_design/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?pmb_design=$matches[1]&paged=$matches[2]\";s:46:\"pmb_design/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?pmb_design=$matches[1]&cpage=$matches[2]\";s:35:\"pmb_design/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?pmb_design=$matches[1]&page=$matches[2]\";s:27:\"pmb_design/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"pmb_design/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"pmb_design/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"pmb_design/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"pmb_design/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"pmb_design/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"pmb/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"pmb/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"pmb/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"pmb/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"pmb/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"pmb/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:20:\"pmb/([^/]+)/embed/?$\";s:44:\"index.php?pmb_content=$matches[1]&embed=true\";s:24:\"pmb/([^/]+)/trackback/?$\";s:38:\"index.php?pmb_content=$matches[1]&tb=1\";s:44:\"pmb/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?pmb_content=$matches[1]&feed=$matches[2]\";s:39:\"pmb/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?pmb_content=$matches[1]&feed=$matches[2]\";s:32:\"pmb/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?pmb_content=$matches[1]&paged=$matches[2]\";s:39:\"pmb/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?pmb_content=$matches[1]&cpage=$matches[2]\";s:28:\"pmb/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?pmb_content=$matches[1]&page=$matches[2]\";s:20:\"pmb/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:30:\"pmb/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:50:\"pmb/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\"pmb/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\"pmb/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\"pmb/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"spectra-popup/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"spectra-popup/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"spectra-popup/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"spectra-popup/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"spectra-popup/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"spectra-popup/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"spectra-popup/([^/]+)/embed/?$\";s:46:\"index.php?spectra-popup=$matches[1]&embed=true\";s:34:\"spectra-popup/([^/]+)/trackback/?$\";s:40:\"index.php?spectra-popup=$matches[1]&tb=1\";s:42:\"spectra-popup/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?spectra-popup=$matches[1]&paged=$matches[2]\";s:49:\"spectra-popup/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?spectra-popup=$matches[1]&cpage=$matches[2]\";s:38:\"spectra-popup/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?spectra-popup=$matches[1]&page=$matches[2]\";s:30:\"spectra-popup/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"spectra-popup/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"spectra-popup/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"spectra-popup/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"spectra-popup/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"spectra-popup/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"form/([^/]+)/embed/?$\";s:47:\"index.php?sureforms_form=$matches[1]&embed=true\";s:25:\"form/([^/]+)/trackback/?$\";s:41:\"index.php?sureforms_form=$matches[1]&tb=1\";s:45:\"form/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?sureforms_form=$matches[1]&feed=$matches[2]\";s:40:\"form/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?sureforms_form=$matches[1]&feed=$matches[2]\";s:33:\"form/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?sureforms_form=$matches[1]&paged=$matches[2]\";s:40:\"form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?sureforms_form=$matches[1]&cpage=$matches[2]\";s:29:\"form/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?sureforms_form=$matches[1]&page=$matches[2]\";s:21:\"form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=743&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "off");
INSERT INTO `wp_options` VALUES("276", "surerank_analytics_installed_time", "1759412626", "off");
INSERT INTO `wp_options` VALUES("277", "surecart_integrations_database_version", "2", "auto");
INSERT INTO `wp_options` VALUES("278", "surecart_incoming_webhooks_database_version", "1", "auto");
INSERT INTO `wp_options` VALUES("279", "surecart_variant_option_values_database_version", "2", "auto");
INSERT INTO `wp_options` VALUES("280", "surecart_checkout_sc_form_id", "22", "auto");
INSERT INTO `wp_options` VALUES("281", "surerank_sitemap_cache_checksum", "bae7853379ee14ddf69237e4c7b0cdb19671a73fbd95e10f508bd9fe6540f064", "auto");
INSERT INTO `wp_options` VALUES("282", "surecart_checkout_page_id", "23", "auto");
INSERT INTO `wp_options` VALUES("283", "surecart_dashboard_page_id", "24", "auto");
INSERT INTO `wp_options` VALUES("284", "surecart_cart_sc_cart_id", "25", "auto");
INSERT INTO `wp_options` VALUES("285", "surecart_shop_page_id", "26", "auto");
INSERT INTO `wp_options` VALUES("286", "surecart_source", "starter_templates", "off");
INSERT INTO `wp_options` VALUES("288", "processors_updating", "updating", "off");
INSERT INTO `wp_options` VALUES("289", "manual_payment_methods_updating", "updating", "off");
INSERT INTO `wp_options` VALUES("290", "surecart_migration_version", "3.15.1", "auto");
INSERT INTO `wp_options` VALUES("291", "surecart_webhook_migration_version", "3.15.1", "off");
INSERT INTO `wp_options` VALUES("292", "surecart_rewrites_migration_version", "3.15.1", "off");
INSERT INTO `wp_options` VALUES("293", "surecart_product_page_migration_version", "3.15.1", "off");
INSERT INTO `wp_options` VALUES("294", "latepoint_db_version", "2.3.0", "auto");
INSERT INTO `wp_options` VALUES("295", "latepoint_redirect_to_wizard", "", "auto");
INSERT INTO `wp_options` VALUES("296", "latepoint_page_customer-cabinet", "28", "auto");
INSERT INTO `wp_options` VALUES("298", "_astra_sites_old_customizer_data", "a:2:{s:14:\"astra-settings\";a:2043:{s:17:\"blog-single-width\";s:7:\"default\";s:21:\"blog-single-max-width\";i:1200;s:17:\"page-single-width\";s:7:\"default\";s:21:\"page-single-max-width\";i:1200;s:28:\"single-content-images-shadow\";b:1;s:30:\"single-post-ast-content-layout\";s:22:\"narrow-width-container\";s:25:\"single-post-sidebar-style\";s:5:\"boxed\";s:36:\"ast-dynamic-single-post-elements-gap\";i:25;s:38:\"ast-dynamic-single-post-meta-font-size\";a:6:{s:7:\"desktop\";i:13;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:40:\"ast-dynamic-single-post-meta-font-weight\";s:3:\"600\";s:32:\"ast-dynamic-single-post-metadata\";a:2:{i:0;s:6:\"author\";i:1;s:4:\"date\";}s:35:\"section-search-page-title-structure\";a:2:{i:0;s:31:\"section-search-page-title-title\";i:1;s:36:\"section-search-page-title-breadcrumb\";}s:38:\"section-search-page-title-custom-title\";s:19:\"Search Results for:\";s:50:\"section-search-page-title-found-custom-description\";s:44:\"Here are the search results for your search.\";s:54:\"section-search-page-title-not-found-custom-description\";s:85:\"Sorry, but we could not find anything related to your search terms. Please try again.\";s:43:\"section-search-page-title-title-font-weight\";s:3:\"600\";s:41:\"section-search-page-title-title-font-size\";a:6:{s:7:\"desktop\";i:32;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"ast-search-results-per-page\";i:10;s:46:\"section-search-page-title-horizontal-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:22:\"ast-search-live-search\";b:0;s:33:\"ast-search-live-search-post-types\";a:2:{s:4:\"post\";i:1;s:4:\"page\";i:1;}s:19:\"blog-post-structure\";a:5:{i:0;s:5:\"image\";i:1;s:5:\"title\";i:2;s:10:\"title-meta\";i:3;s:7:\"excerpt\";i:4;s:9:\"read-more\";}s:18:\"blog-post-per-page\";i:10;s:17:\"blog-hover-effect\";s:7:\"zoom-in\";s:11:\"blog-layout\";s:13:\"blog-layout-4\";s:10:\"blog-width\";s:7:\"default\";s:19:\"blog-meta-date-type\";s:9:\"published\";s:21:\"blog-meta-date-format\";s:0:\"\";s:14:\"blog-max-width\";i:1200;s:17:\"blog-post-content\";s:7:\"excerpt\";s:9:\"blog-meta\";a:1:{i:0;s:4:\"date\";}s:23:\"post-card-border-radius\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:2:\"20\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:2:\"20\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"20\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:2:\"20\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"post-card-featured-overlay\";s:0:\"\";s:19:\"blog-category-style\";s:7:\"default\";s:14:\"blog-tag-style\";s:7:\"default\";s:27:\"blog-post-meta-divider-type\";s:1:\"/\";s:24:\"blog-meta-category-style\";s:7:\"default\";s:19:\"blog-meta-tag-style\";s:7:\"default\";s:21:\"blog-image-ratio-type\";s:6:\"custom\";s:26:\"blog-image-ratio-pre-scale\";s:4:\"16/9\";s:29:\"blog-image-custom-scale-width\";i:4;s:30:\"blog-image-custom-scale-height\";i:3;s:10:\"text-color\";s:25:\"var(--ast-global-color-3)\";s:10:\"link-color\";s:25:\"var(--ast-global-color-0)\";s:11:\"theme-color\";s:25:\"var(--ast-global-color-0)\";s:12:\"link-h-color\";s:25:\"var(--ast-global-color-1)\";s:18:\"heading-base-color\";s:25:\"var(--ast-global-color-2)\";s:12:\"border-color\";s:25:\"var(--ast-global-color-6)\";s:13:\"footer-bg-obj\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:12:\"footer-color\";s:0:\"\";s:17:\"footer-link-color\";s:0:\"\";s:19:\"footer-link-h-color\";s:0:\"\";s:17:\"footer-adv-bg-obj\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:21:\"footer-adv-text-color\";s:0:\"\";s:21:\"footer-adv-link-color\";s:0:\"\";s:23:\"footer-adv-link-h-color\";s:0:\"\";s:26:\"footer-adv-wgt-title-color\";s:0:\"\";s:12:\"button-color\";s:7:\"#ffffff\";s:14:\"button-h-color\";s:7:\"#ffffff\";s:15:\"button-bg-color\";s:25:\"var(--ast-global-color-0)\";s:17:\"button-bg-h-color\";s:25:\"var(--ast-global-color-1)\";s:27:\"secondary-button-bg-h-color\";s:25:\"var(--ast-global-color-1)\";s:25:\"secondary-button-bg-color\";s:0:\"\";s:22:\"secondary-button-color\";s:25:\"var(--ast-global-color-0)\";s:24:\"secondary-button-h-color\";s:7:\"#ffffff\";s:20:\"theme-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"17\";s:5:\"right\";s:2:\"34\";s:6:\"bottom\";s:2:\"17\";s:4:\"left\";s:2:\"34\";}s:6:\"tablet\";a:4:{s:3:\"top\";i:14;s:5:\"right\";i:28;s:6:\"bottom\";i:14;s:4:\"left\";i:28;}s:6:\"mobile\";a:4:{s:3:\"top\";i:12;s:5:\"right\";i:24;s:6:\"bottom\";i:12;s:4:\"left\";i:24;}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"secondary-theme-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"17\";s:5:\"right\";s:2:\"34\";s:6:\"bottom\";s:2:\"17\";s:4:\"left\";s:2:\"34\";}s:6:\"tablet\";a:4:{s:3:\"top\";i:12;s:5:\"right\";i:28;s:6:\"bottom\";i:12;s:4:\"left\";i:28;}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"12\";s:5:\"right\";i:24;s:6:\"bottom\";s:2:\"12\";s:4:\"left\";i:24;}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"button-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"50\";s:5:\"right\";s:2:\"50\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"50\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"secondary-button-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"50\";s:5:\"right\";s:2:\"50\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"50\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"theme-button-border-group-border-size\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";}s:47:\"secondary-theme-button-border-group-border-size\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";}s:17:\"footer-sml-layout\";s:19:\"footer-sml-layout-1\";s:20:\"footer-sml-section-1\";s:6:\"custom\";s:27:\"footer-sml-section-1-credit\";s:68:\"Copyright © [current_year] [site_title] | Powered by [theme_author]\";s:20:\"footer-sml-section-2\";s:0:\"\";s:27:\"footer-sml-section-2-credit\";s:68:\"Copyright © [current_year] [site_title] | Powered by [theme_author]\";s:27:\"footer-sml-dist-equal-align\";b:1;s:18:\"footer-sml-divider\";i:1;s:24:\"footer-sml-divider-color\";s:7:\"#7a7a7a\";s:19:\"footer-layout-width\";s:7:\"content\";s:22:\"ast-header-retina-logo\";s:0:\"\";s:17:\"use-logo-svg-icon\";b:0;s:13:\"logo-svg-icon\";a:2:{s:4:\"type\";s:0:\"\";s:5:\"value\";s:0:\"\";}s:23:\"logo-svg-site-title-gap\";a:3:{s:7:\"desktop\";s:1:\"5\";s:6:\"tablet\";s:1:\"5\";s:6:\"mobile\";s:1:\"5\";}s:21:\"ast-header-logo-width\";s:0:\"\";s:32:\"ast-header-responsive-logo-width\";a:3:{s:7:\"desktop\";i:222;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-color-site-title\";s:25:\"var(--ast-global-color-2)\";s:25:\"header-color-h-site-title\";s:0:\"\";s:25:\"header-color-site-tagline\";s:0:\"\";s:29:\"display-site-title-responsive\";a:3:{s:7:\"desktop\";i:1;s:6:\"tablet\";i:1;s:6:\"mobile\";i:1;}s:31:\"display-site-tagline-responsive\";a:3:{s:7:\"desktop\";i:0;s:6:\"tablet\";i:0;s:6:\"mobile\";i:0;}s:17:\"logo-title-inline\";i:1;s:19:\"disable-primary-nav\";b:0;s:14:\"header-layouts\";s:20:\"header-main-layout-1\";s:22:\"header-main-rt-section\";s:4:\"none\";s:27:\"header-display-outside-menu\";b:0;s:27:\"header-main-rt-section-html\";s:27:\"<button>Contact Us</button>\";s:34:\"header-main-rt-section-button-text\";s:6:\"Button\";s:34:\"header-main-rt-section-button-link\";s:23:\"https://www.wpastra.com\";s:41:\"header-main-rt-section-button-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:35:\"header-main-rt-section-button-style\";s:12:\"theme-button\";s:40:\"header-main-rt-section-button-text-color\";s:0:\"\";s:40:\"header-main-rt-section-button-back-color\";s:0:\"\";s:42:\"header-main-rt-section-button-text-h-color\";s:0:\"\";s:42:\"header-main-rt-section-button-back-h-color\";s:0:\"\";s:37:\"header-main-rt-section-button-padding\";a:3:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}}s:41:\"header-main-rt-section-button-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:15:\"header-main-sep\";i:1;s:21:\"header-main-sep-color\";s:0:\"\";s:24:\"header-main-layout-width\";s:7:\"content\";s:22:\"primary-submenu-border\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:27:\"primary-submenu-item-border\";b:0;s:23:\"primary-submenu-b-color\";s:0:\"\";s:28:\"primary-submenu-item-b-color\";s:0:\"\";s:33:\"primary-header-button-font-family\";s:7:\"inherit\";s:33:\"primary-header-button-font-weight\";s:7:\"inherit\";s:31:\"primary-header-button-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"primary-header-button-text-transform\";s:0:\"\";s:33:\"primary-header-button-line-height\";i:1;s:36:\"primary-header-button-letter-spacing\";s:0:\"\";s:22:\"header-main-menu-label\";s:0:\"\";s:22:\"header-main-menu-align\";s:6:\"inline\";s:39:\"header-main-submenu-container-animation\";s:0:\"\";s:24:\"mobile-header-breakpoint\";s:0:\"\";s:18:\"mobile-header-logo\";s:0:\"\";s:24:\"mobile-header-logo-width\";s:0:\"\";s:11:\"site-layout\";s:21:\"ast-full-width-layout\";s:18:\"site-content-width\";i:1200;s:26:\"narrow-container-max-width\";i:750;s:37:\"site-layout-outside-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-4)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:25:\"content-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:12:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:5:\"color\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:12:\"wp-blocks-ui\";s:7:\"comfort\";s:24:\"wp-blocks-global-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:20:\"enable-comments-area\";b:1;s:22:\"comments-box-placement\";s:0:\"\";s:21:\"comment-form-position\";s:5:\"below\";s:28:\"comments-box-container-width\";s:0:\"\";s:31:\"ast-sub-section-comments-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:2;s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:32:\"ast-sub-section-comments-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";i:2;s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:30:\"single-page-ast-content-layout\";s:22:\"normal-width-container\";s:25:\"single-page-content-style\";s:7:\"unboxed\";s:25:\"single-post-content-style\";s:7:\"unboxed\";s:31:\"archive-post-ast-content-layout\";s:7:\"default\";s:23:\"ast-site-content-layout\";s:22:\"normal-width-container\";s:18:\"site-content-style\";s:5:\"boxed\";s:16:\"body-font-family\";s:21:\"\'Manrope\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"500\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:14;s:6:\"mobile\";i:14;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:20:\"headings-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:18:\"para-margin-bottom\";s:0:\"\";s:23:\"underline-content-links\";b:1;s:25:\"site-accessibility-toggle\";b:1;s:33:\"site-accessibility-highlight-type\";s:6:\"dotted\";s:39:\"site-accessibility-highlight-input-type\";s:7:\"disable\";s:19:\"body-text-transform\";s:0:\"\";s:20:\"headings-font-family\";s:17:\"\'PT Serif\', serif\";s:20:\"headings-font-weight\";s:3:\"400\";s:20:\"font-size-site-title\";a:6:{s:7:\"desktop\";i:24;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"font-size-site-tagline\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"single-post-outside-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:2:\"40\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"30\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"font-size-page-title\";a:6:{s:7:\"desktop\";i:22;s:6:\"tablet\";i:22;s:6:\"mobile\";i:20;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:18:\"font-size-post-tax\";a:6:{s:7:\"desktop\";i:14;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"font-size-post-meta\";a:6:{s:7:\"desktop\";i:12;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h1\";a:6:{s:7:\"desktop\";i:54;s:6:\"tablet\";i:40;s:6:\"mobile\";i:32;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h2\";a:6:{s:7:\"desktop\";i:42;s:6:\"tablet\";i:32;s:6:\"mobile\";i:26;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h3\";a:6:{s:7:\"desktop\";i:28;s:6:\"tablet\";i:24;s:6:\"mobile\";i:22;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h4\";a:6:{s:7:\"desktop\";i:24;s:6:\"tablet\";i:22;s:6:\"mobile\";i:20;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h5\";a:6:{s:7:\"desktop\";i:20;s:6:\"tablet\";i:18;s:6:\"mobile\";i:18;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h6\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";i:16;s:6:\"mobile\";i:16;s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"site-sidebar-layout\";s:10:\"no-sidebar\";s:18:\"site-sidebar-width\";i:30;s:26:\"single-page-sidebar-layout\";s:10:\"no-sidebar\";s:26:\"single-post-sidebar-layout\";s:7:\"default\";s:27:\"archive-post-sidebar-layout\";s:7:\"default\";s:19:\"site-sticky-sidebar\";b:0;s:18:\"site-sidebar-style\";s:7:\"unboxed\";s:25:\"single-page-sidebar-style\";s:7:\"unboxed\";s:26:\"archive-post-sidebar-style\";s:7:\"default\";s:10:\"footer-adv\";s:8:\"disabled\";s:23:\"footer-adv-border-width\";s:0:\"\";s:23:\"footer-adv-border-color\";s:7:\"#7a7a7a\";s:30:\"mobile-header-toggle-btn-style\";s:7:\"outline\";s:23:\"hide-custom-menu-mobile\";i:1;s:27:\"mobile-header-toggle-target\";s:4:\"icon\";s:19:\"enable-scroll-to-id\";b:1;s:37:\"ast-dynamic-single-download-structure\";a:3:{i:0;s:33:\"ast-dynamic-single-download-title\";i:1;s:32:\"ast-dynamic-single-download-meta\";i:2;s:33:\"ast-dynamic-single-download-image\";}s:20:\"enable-related-posts\";b:1;s:19:\"related-posts-title\";s:13:\"Related Posts\";s:29:\"releted-posts-title-alignment\";s:4:\"left\";s:25:\"related-posts-total-count\";i:2;s:28:\"enable-related-posts-excerpt\";b:0;s:27:\"related-posts-box-placement\";s:7:\"default\";s:30:\"related-posts-outside-location\";s:5:\"above\";s:29:\"related-posts-container-width\";s:0:\"\";s:27:\"related-posts-excerpt-count\";i:25;s:22:\"related-posts-based-on\";s:10:\"categories\";s:22:\"related-posts-order-by\";s:4:\"date\";s:19:\"related-posts-order\";s:3:\"asc\";s:29:\"related-posts-grid-responsive\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:23:\"related-posts-structure\";a:2:{i:0;s:14:\"featured-image\";i:1;s:10:\"title-meta\";}s:23:\"related-posts-tag-style\";s:4:\"none\";s:28:\"related-posts-category-style\";s:4:\"none\";s:25:\"related-posts-date-format\";s:0:\"\";s:28:\"related-posts-meta-date-type\";s:9:\"published\";s:32:\"related-posts-author-avatar-size\";s:0:\"\";s:27:\"related-posts-author-avatar\";b:0;s:33:\"related-posts-author-prefix-label\";s:3:\"By \";s:24:\"related-posts-image-size\";s:4:\"full\";s:38:\"related-posts-image-custom-scale-width\";i:16;s:39:\"related-posts-image-custom-scale-height\";i:9;s:35:\"related-posts-image-ratio-pre-scale\";s:4:\"16/9\";s:30:\"related-posts-image-ratio-type\";s:6:\"custom\";s:28:\"related-posts-meta-structure\";a:2:{i:0;s:8:\"category\";i:1;s:4:\"date\";}s:24:\"related-posts-text-color\";s:25:\"var(--ast-global-color-2)\";s:24:\"related-posts-link-color\";s:0:\"\";s:25:\"related-posts-title-color\";s:25:\"var(--ast-global-color-2)\";s:30:\"related-posts-background-color\";s:0:\"\";s:24:\"related-posts-meta-color\";s:0:\"\";s:30:\"related-posts-link-hover-color\";s:0:\"\";s:35:\"related-posts-meta-link-hover-color\";s:0:\"\";s:39:\"related-posts-section-title-font-family\";s:7:\"inherit\";s:39:\"related-posts-section-title-font-weight\";s:7:\"inherit\";s:42:\"related-posts-section-title-text-transform\";s:0:\"\";s:39:\"related-posts-section-title-line-height\";s:4:\"1.25\";s:39:\"related-posts-section-title-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:37:\"related-posts-section-title-font-size\";a:6:{s:7:\"desktop\";s:2:\"26\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"related-posts-title-font-family\";s:7:\"inherit\";s:31:\"related-posts-title-font-weight\";s:3:\"500\";s:34:\"related-posts-title-text-transform\";s:0:\"\";s:31:\"related-posts-title-line-height\";s:1:\"1\";s:29:\"related-posts-title-font-size\";a:6:{s:7:\"desktop\";s:2:\"20\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"related-posts-title-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.5\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:30:\"related-posts-meta-font-family\";s:7:\"inherit\";s:30:\"related-posts-meta-font-weight\";s:7:\"inherit\";s:33:\"related-posts-meta-text-transform\";s:0:\"\";s:30:\"related-posts-meta-line-height\";s:0:\"\";s:28:\"related-posts-meta-font-size\";a:6:{s:7:\"desktop\";s:2:\"14\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"related-posts-meta-font-extras\";a:6:{s:11:\"line-height\";s:3:\"1.6\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"related-posts-content-font-family\";s:7:\"inherit\";s:33:\"related-posts-content-font-weight\";s:7:\"inherit\";s:33:\"related-posts-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:31:\"related-posts-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"ast-sub-section-related-posts-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";d:2.5;s:5:\"right\";d:2.5;s:6:\"bottom\";d:2.5;s:4:\"left\";d:2.5;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:36:\"ast-sub-section-related-posts-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:2;s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"em\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:23:\"transparent-header-logo\";s:0:\"\";s:30:\"transparent-header-retina-logo\";s:0:\"\";s:26:\"different-transparent-logo\";i:0;s:33:\"different-transparent-retina-logo\";i:0;s:29:\"transparent-header-logo-width\";a:3:{s:7:\"desktop\";i:150;s:6:\"tablet\";i:120;s:6:\"mobile\";i:100;}s:25:\"transparent-header-enable\";i:0;s:34:\"transparent-header-disable-archive\";i:1;s:45:\"transparent-header-disable-latest-posts-index\";i:1;s:29:\"transparent-header-on-devices\";s:4:\"both\";s:27:\"transparent-header-main-sep\";i:0;s:33:\"transparent-header-main-sep-color\";s:0:\"\";s:27:\"transparent-header-bg-color\";s:0:\"\";s:35:\"transparent-header-color-site-title\";s:0:\"\";s:37:\"transparent-header-color-h-site-title\";s:0:\"\";s:25:\"transparent-menu-bg-color\";s:0:\"\";s:22:\"transparent-menu-color\";s:0:\"\";s:24:\"transparent-menu-h-color\";s:0:\"\";s:28:\"transparent-submenu-bg-color\";s:0:\"\";s:25:\"transparent-submenu-color\";s:0:\"\";s:27:\"transparent-submenu-h-color\";s:0:\"\";s:29:\"transparent-header-logo-color\";s:0:\"\";s:38:\"transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"hba-transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"hbb-transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:46:\"transparent-header-color-site-title-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:48:\"transparent-header-color-h-site-title-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-menu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"transparent-menu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"transparent-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:39:\"transparent-submenu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-submenu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"transparent-submenu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-link-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:51:\"transparent-content-section-link-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"breadcrumb-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"breadcrumb-active-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"breadcrumb-hover-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"breadcrumb-separator-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:19:\"breadcrumb-bg-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"breadcrumb-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"breadcrumb-font-family\";s:7:\"inherit\";s:22:\"breadcrumb-font-weight\";s:7:\"inherit\";s:20:\"breadcrumb-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"breadcrumb-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:29:\"breadcrumb-separator-selector\";s:5:\"\\003E\";s:20:\"breadcrumb-separator\";s:5:\"\\00bb\";s:20:\"scroll-to-top-enable\";b:1;s:23:\"scroll-to-top-icon-size\";i:15;s:27:\"scroll-to-top-icon-position\";s:5:\"right\";s:24:\"scroll-to-top-on-devices\";s:4:\"both\";s:32:\"scroll-to-top-icon-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"scroll-to-top-icon-color\";s:0:\"\";s:26:\"scroll-to-top-icon-h-color\";s:0:\"\";s:27:\"scroll-to-top-icon-bg-color\";s:0:\"\";s:29:\"scroll-to-top-icon-h-bg-color\";s:0:\"\";s:8:\"h1-color\";s:0:\"\";s:8:\"h2-color\";s:0:\"\";s:8:\"h3-color\";s:0:\"\";s:8:\"h4-color\";s:0:\"\";s:8:\"h5-color\";s:0:\"\";s:8:\"h6-color\";s:0:\"\";s:14:\"font-family-h1\";s:7:\"inherit\";s:14:\"font-weight-h1\";s:7:\"inherit\";s:14:\"font-extras-h1\";a:6:{s:11:\"line-height\";s:4:\"1.15\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:14:\"font-family-h2\";s:7:\"inherit\";s:14:\"font-weight-h2\";s:7:\"inherit\";s:14:\"font-extras-h2\";a:6:{s:11:\"line-height\";s:4:\"1.25\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:14:\"font-family-h3\";s:7:\"inherit\";s:14:\"font-weight-h3\";s:7:\"inherit\";s:14:\"font-extras-h3\";a:6:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:14:\"font-family-h4\";s:7:\"inherit\";s:14:\"font-weight-h4\";s:7:\"inherit\";s:14:\"font-extras-h4\";a:6:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:14:\"font-family-h5\";s:7:\"inherit\";s:14:\"font-weight-h5\";s:7:\"inherit\";s:14:\"font-extras-h5\";a:6:{s:11:\"line-height\";s:3:\"1.4\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:14:\"font-family-h6\";s:7:\"inherit\";s:14:\"font-weight-h6\";s:7:\"inherit\";s:14:\"font-extras-h6\";a:6:{s:11:\"line-height\";s:3:\"1.5\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:18:\"font-weight-button\";s:3:\"700\";s:28:\"secondary-font-weight-button\";s:3:\"700\";s:18:\"font-family-button\";s:7:\"inherit\";s:28:\"secondary-font-family-button\";s:7:\"inherit\";s:16:\"font-size-button\";a:6:{s:7:\"desktop\";i:14;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"secondary-font-size-button\";a:6:{s:7:\"desktop\";i:14;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:18:\"font-extras-button\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:1:\"1\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:9:\"uppercase\";s:15:\"text-decoration\";s:0:\"\";}s:28:\"secondary-font-extras-button\";a:6:{s:11:\"line-height\";i:1;s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:1:\"1\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:9:\"uppercase\";s:15:\"text-decoration\";s:0:\"\";}s:20:\"header-desktop-items\";a:5:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:5:{s:10:\"above_left\";a:0:{}s:17:\"above_left_center\";a:0:{}s:12:\"above_center\";a:0:{}s:18:\"above_right_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:5:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:19:\"primary_left_center\";a:0:{}s:14:\"primary_center\";a:0:{}s:20:\"primary_right_center\";a:0:{}s:13:\"primary_right\";a:2:{i:0;s:6:\"menu-1\";i:1;s:8:\"button-1\";}}s:5:\"below\";a:5:{s:10:\"below_left\";a:0:{}s:17:\"below_left_center\";a:0:{}s:12:\"below_center\";a:0:{}s:18:\"below_right_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:4:\"flag\";b:1;}s:19:\"header-mobile-items\";a:5:{s:5:\"popup\";a:1:{s:13:\"popup_content\";a:1:{i:0;s:11:\"mobile-menu\";}}s:5:\"above\";a:3:{s:10:\"above_left\";a:0:{}s:12:\"above_center\";a:0:{}s:11:\"above_right\";a:0:{}}s:7:\"primary\";a:3:{s:12:\"primary_left\";a:1:{i:0;s:4:\"logo\";}s:14:\"primary_center\";a:0:{}s:13:\"primary_right\";a:1:{i:0;s:14:\"mobile-trigger\";}}s:5:\"below\";a:3:{s:10:\"below_left\";a:0:{}s:12:\"below_center\";a:0:{}s:11:\"below_right\";a:0:{}}s:4:\"flag\";b:0;}s:27:\"hb-header-main-layout-width\";s:7:\"content\";s:16:\"hb-header-height\";a:3:{s:7:\"desktop\";i:80;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:8:\"hb-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:18:\"hb-header-main-sep\";i:1;s:24:\"hb-header-main-sep-color\";s:25:\"var(--ast-global-color-6)\";s:25:\"hb-header-main-menu-align\";s:6:\"inline\";s:27:\"hb-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:5:\"color\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:17:\"hb-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:3:\"1.5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:3:\"1.5\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:17:\"hba-header-layout\";s:21:\"above-header-layout-1\";s:17:\"hba-header-height\";a:3:{s:7:\"desktop\";i:50;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:9:\"hba-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:20:\"hba-header-separator\";i:1;s:30:\"hba-header-bottom-border-color\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:28:\"hba-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:55:\"var( --ast-global-color-primary, --ast-global-color-4 )\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:32:\"hba-header-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"hba-header-link-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"hba-header-link-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"hba-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:3:\"0.5\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"em\";}s:17:\"hbb-header-layout\";s:21:\"below-header-layout-1\";s:17:\"hbb-header-height\";a:3:{s:7:\"desktop\";i:60;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:9:\"hbb-stack\";a:3:{s:7:\"desktop\";s:5:\"stack\";s:6:\"tablet\";s:5:\"stack\";s:6:\"mobile\";s:5:\"stack\";}s:20:\"hbb-header-separator\";i:1;s:30:\"hbb-header-bottom-border-color\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:28:\"hbb-header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:18:\"hbb-header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-footer-builder-layout-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-footer-builder-layout-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-above-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-above-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-below-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-below-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-header-mobile-trigger-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"section-primary-header-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"40\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"40\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"32\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"32\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"24\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-primary-header-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"title_tagline-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"section-header-search-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-account-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-mobile-menu-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"5\";s:5:\"right\";s:2:\"32\";s:6:\"bottom\";s:1:\"5\";s:4:\"left\";s:2:\"32\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"3\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:1:\"3\";s:4:\"left\";s:2:\"24\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:33:\"section-header-mobile-menu-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"section-above-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-above-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"section-below-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"section-footer-copyright-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-footer-menu-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:38:\"section-primary-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"25\";s:5:\"right\";s:2:\"40\";s:6:\"bottom\";s:2:\"25\";s:4:\"left\";s:2:\"40\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"32\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"32\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"20\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:2:\"24\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:37:\"section-primary-footer-builder-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"section-header-woo-cart-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"section-header-woo-cart-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button1-text\";s:14:\"Contactez-nous\";s:26:\"header-button1-link-option\";a:3:{s:3:\"url\";s:9:\"/contact/\";s:7:\"new_tab\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button1-font-family\";s:7:\"inherit\";s:26:\"header-button1-font-weight\";s:7:\"inherit\";s:26:\"header-button1-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button1-text-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-0)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button1-back-color\";a:3:{s:7:\"desktop\";s:13:\"rgba(0,0,0,0)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button1-text-h-color\";a:3:{s:7:\"desktop\";s:7:\"#fffefe\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button1-back-h-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button1-border-size\";a:4:{s:3:\"top\";s:1:\"1\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:1:\"1\";s:4:\"left\";s:1:\"1\";}s:27:\"header-button1-border-color\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-0)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button1-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"50\";s:5:\"right\";s:2:\"50\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:2:\"50\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button1-border-radius\";s:0:\"\";s:27:\"section-hb-button-1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"17\";s:5:\"right\";s:2:\"34\";s:6:\"bottom\";s:2:\"17\";s:4:\"left\";s:2:\"34\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button1-text\";s:6:\"Button\";s:26:\"footer-button1-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button1-font-family\";s:7:\"inherit\";s:26:\"footer-button1-font-weight\";s:7:\"inherit\";s:29:\"footer-button1-text-transform\";s:0:\"\";s:26:\"footer-button1-line-height\";s:0:\"\";s:24:\"footer-button1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button1-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button1-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button1-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button1-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button1-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button1-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button1-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-1-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-1\";s:22:\"Insert HTML text here.\";s:18:\"header-html-1color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-1link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-1link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-1\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-1\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-1\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-1\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-1\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-1color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-1link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-1link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-1\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-1\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-1\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-1-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-1-bg-space\";s:0:\"\";s:20:\"header-social-1-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-1-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-1-color\";s:0:\"\";s:23:\"header-social-1-h-color\";s:0:\"\";s:24:\"header-social-1-bg-color\";s:0:\"\";s:26:\"header-social-1-bg-h-color\";s:0:\"\";s:28:\"header-social-1-label-toggle\";b:0;s:26:\"header-social-1-color-type\";s:6:\"custom\";s:34:\"header-social-1-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-1\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-1-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-1-bg-space\";s:0:\"\";s:20:\"footer-social-1-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-1-radius\";s:0:\"\";s:21:\"footer-social-1-color\";s:0:\"\";s:23:\"footer-social-1-h-color\";s:0:\"\";s:24:\"footer-social-1-bg-color\";s:0:\"\";s:26:\"footer-social-1-bg-h-color\";s:0:\"\";s:28:\"footer-social-1-label-toggle\";b:0;s:26:\"footer-social-1-color-type\";s:6:\"custom\";s:27:\"footer-social-1-brand-color\";s:0:\"\";s:33:\"footer-social-1-brand-label-color\";s:0:\"\";s:34:\"footer-social-1-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-1\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-1\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-1-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-1-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-1-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-1-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-1-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-1-font-family\";s:7:\"inherit\";s:27:\"header-widget-1-font-weight\";s:7:\"inherit\";s:25:\"header-widget-1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-1-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-1-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-1-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-1-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-1-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-1-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-1-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-1-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-1-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-1-font-family\";s:7:\"inherit\";s:27:\"footer-widget-1-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-1-text-transform\";s:0:\"\";s:27:\"footer-widget-1-line-height\";s:0:\"\";s:25:\"footer-widget-1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-1-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-1-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-1-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-1-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-1\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu1-bg-color\";s:0:\"\";s:18:\"header-menu1-color\";s:0:\"\";s:23:\"header-menu1-h-bg-color\";s:0:\"\";s:20:\"header-menu1-h-color\";s:0:\"\";s:23:\"header-menu1-a-bg-color\";s:0:\"\";s:20:\"header-menu1-a-color\";s:0:\"\";s:30:\"header-menu1-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu1-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu1-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu1-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu1-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu1-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu1-menu-hover-animation\";s:0:\"\";s:40:\"header-menu1-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu1-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu1-submenu-item-border\";b:0;s:32:\"header-menu1-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu1-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu1-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu1-submenu-top-offset\";s:0:\"\";s:26:\"header-menu1-submenu-width\";s:0:\"\";s:27:\"header-menu1-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu1-menu-stack-on-mobile\";b:1;s:22:\"header-menu1-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu1-font-weight\";s:7:\"inherit\";s:24:\"header-menu1-font-family\";s:7:\"inherit\";s:24:\"header-menu1-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-1-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button2-text\";s:6:\"Button\";s:26:\"header-button2-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button2-font-family\";s:7:\"inherit\";s:26:\"header-button2-font-weight\";s:7:\"inherit\";s:26:\"header-button2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button2-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button2-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button2-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button2-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button2-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button2-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button2-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button2-border-radius\";s:0:\"\";s:27:\"section-hb-button-2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button2-text\";s:6:\"Button\";s:26:\"footer-button2-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button2-font-family\";s:7:\"inherit\";s:26:\"footer-button2-font-weight\";s:7:\"inherit\";s:29:\"footer-button2-text-transform\";s:0:\"\";s:26:\"footer-button2-line-height\";s:0:\"\";s:24:\"footer-button2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button2-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button2-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button2-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button2-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button2-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button2-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button2-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-2-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-2\";s:22:\"Insert HTML text here.\";s:18:\"header-html-2color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-2link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-2link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-2\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-2\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-2\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-2\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-2\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-2color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-2link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-2link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-2\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-2\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-2\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-2-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-2-bg-space\";s:0:\"\";s:20:\"header-social-2-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-2-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-2-color\";s:0:\"\";s:23:\"header-social-2-h-color\";s:0:\"\";s:24:\"header-social-2-bg-color\";s:0:\"\";s:26:\"header-social-2-bg-h-color\";s:0:\"\";s:28:\"header-social-2-label-toggle\";b:0;s:26:\"header-social-2-color-type\";s:6:\"custom\";s:34:\"header-social-2-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-2\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-2-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-2-bg-space\";s:0:\"\";s:20:\"footer-social-2-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-2-radius\";s:0:\"\";s:21:\"footer-social-2-color\";s:0:\"\";s:23:\"footer-social-2-h-color\";s:0:\"\";s:24:\"footer-social-2-bg-color\";s:0:\"\";s:26:\"footer-social-2-bg-h-color\";s:0:\"\";s:28:\"footer-social-2-label-toggle\";b:0;s:26:\"footer-social-2-color-type\";s:6:\"custom\";s:27:\"footer-social-2-brand-color\";s:0:\"\";s:33:\"footer-social-2-brand-label-color\";s:0:\"\";s:34:\"footer-social-2-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-2\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-2\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-2-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-2-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-2-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-2-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-2-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-2-font-family\";s:7:\"inherit\";s:27:\"header-widget-2-font-weight\";s:7:\"inherit\";s:25:\"header-widget-2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-2-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-2-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-2-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-2-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-2-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-2-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-2-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-2-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-2-font-family\";s:7:\"inherit\";s:27:\"footer-widget-2-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-2-text-transform\";s:0:\"\";s:27:\"footer-widget-2-line-height\";s:0:\"\";s:25:\"footer-widget-2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-2-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-2-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-2-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-2-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-2\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu2-bg-color\";s:0:\"\";s:18:\"header-menu2-color\";s:0:\"\";s:23:\"header-menu2-h-bg-color\";s:0:\"\";s:20:\"header-menu2-h-color\";s:0:\"\";s:23:\"header-menu2-a-bg-color\";s:0:\"\";s:20:\"header-menu2-a-color\";s:0:\"\";s:30:\"header-menu2-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu2-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu2-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu2-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu2-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu2-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu2-menu-hover-animation\";s:0:\"\";s:40:\"header-menu2-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu2-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu2-submenu-item-border\";b:0;s:32:\"header-menu2-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu2-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu2-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu2-submenu-top-offset\";s:0:\"\";s:26:\"header-menu2-submenu-width\";s:0:\"\";s:27:\"header-menu2-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu2-menu-stack-on-mobile\";b:1;s:22:\"header-menu2-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu2-font-weight\";s:7:\"inherit\";s:24:\"header-menu2-font-family\";s:7:\"inherit\";s:24:\"header-menu2-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-2-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button3-text\";s:6:\"Button\";s:26:\"header-button3-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button3-font-family\";s:7:\"inherit\";s:26:\"header-button3-font-weight\";s:7:\"inherit\";s:26:\"header-button3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button3-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button3-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button3-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button3-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button3-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button3-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button3-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button3-border-radius\";s:0:\"\";s:27:\"section-hb-button-3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button3-text\";s:6:\"Button\";s:26:\"footer-button3-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button3-font-family\";s:7:\"inherit\";s:26:\"footer-button3-font-weight\";s:7:\"inherit\";s:29:\"footer-button3-text-transform\";s:0:\"\";s:26:\"footer-button3-line-height\";s:0:\"\";s:24:\"footer-button3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button3-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button3-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button3-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button3-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button3-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button3-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button3-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-3-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-3\";s:22:\"Insert HTML text here.\";s:18:\"header-html-3color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-3link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-3link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-3\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-3\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-3\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-3\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-3\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-3color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-3link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-3link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-3\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-3\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-3\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-3-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-3-bg-space\";s:0:\"\";s:20:\"header-social-3-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-3-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-3-color\";s:0:\"\";s:23:\"header-social-3-h-color\";s:0:\"\";s:24:\"header-social-3-bg-color\";s:0:\"\";s:26:\"header-social-3-bg-h-color\";s:0:\"\";s:28:\"header-social-3-label-toggle\";b:0;s:26:\"header-social-3-color-type\";s:6:\"custom\";s:34:\"header-social-3-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-3\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-3-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-3-bg-space\";s:0:\"\";s:20:\"footer-social-3-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-3-radius\";s:0:\"\";s:21:\"footer-social-3-color\";s:0:\"\";s:23:\"footer-social-3-h-color\";s:0:\"\";s:24:\"footer-social-3-bg-color\";s:0:\"\";s:26:\"footer-social-3-bg-h-color\";s:0:\"\";s:28:\"footer-social-3-label-toggle\";b:0;s:26:\"footer-social-3-color-type\";s:6:\"custom\";s:27:\"footer-social-3-brand-color\";s:0:\"\";s:33:\"footer-social-3-brand-label-color\";s:0:\"\";s:34:\"footer-social-3-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-3\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-3\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-3-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-3-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-3-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-3-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-3-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-3-font-family\";s:7:\"inherit\";s:27:\"header-widget-3-font-weight\";s:7:\"inherit\";s:25:\"header-widget-3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-3-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-3-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-3-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-3-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-3-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-3-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-3-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-3-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-3-font-family\";s:7:\"inherit\";s:27:\"footer-widget-3-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-3-text-transform\";s:0:\"\";s:27:\"footer-widget-3-line-height\";s:0:\"\";s:25:\"footer-widget-3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-3-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-3-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-3-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-3-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-3\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu3-bg-color\";s:0:\"\";s:18:\"header-menu3-color\";s:0:\"\";s:23:\"header-menu3-h-bg-color\";s:0:\"\";s:20:\"header-menu3-h-color\";s:0:\"\";s:23:\"header-menu3-a-bg-color\";s:0:\"\";s:20:\"header-menu3-a-color\";s:0:\"\";s:30:\"header-menu3-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu3-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu3-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu3-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu3-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu3-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu3-menu-hover-animation\";s:0:\"\";s:40:\"header-menu3-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu3-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu3-submenu-item-border\";b:0;s:32:\"header-menu3-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu3-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu3-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu3-submenu-top-offset\";s:0:\"\";s:26:\"header-menu3-submenu-width\";s:0:\"\";s:27:\"header-menu3-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu3-menu-stack-on-mobile\";b:1;s:22:\"header-menu3-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu3-font-weight\";s:7:\"inherit\";s:24:\"header-menu3-font-family\";s:7:\"inherit\";s:24:\"header-menu3-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-3-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button4-text\";s:6:\"Button\";s:26:\"header-button4-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button4-font-family\";s:7:\"inherit\";s:26:\"header-button4-font-weight\";s:7:\"inherit\";s:26:\"header-button4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button4-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button4-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button4-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button4-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button4-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button4-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button4-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button4-border-radius\";s:0:\"\";s:27:\"section-hb-button-4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button4-text\";s:6:\"Button\";s:26:\"footer-button4-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button4-font-family\";s:7:\"inherit\";s:26:\"footer-button4-font-weight\";s:7:\"inherit\";s:29:\"footer-button4-text-transform\";s:0:\"\";s:26:\"footer-button4-line-height\";s:0:\"\";s:24:\"footer-button4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button4-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button4-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button4-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button4-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button4-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button4-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button4-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-4-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-4\";s:22:\"Insert HTML text here.\";s:18:\"header-html-4color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-4link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-4link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-4\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-4\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-4\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-4\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-4\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-4color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-4link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-4link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-4\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-4\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-4\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-4-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-4-bg-space\";s:0:\"\";s:20:\"header-social-4-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-4-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-4-color\";s:0:\"\";s:23:\"header-social-4-h-color\";s:0:\"\";s:24:\"header-social-4-bg-color\";s:0:\"\";s:26:\"header-social-4-bg-h-color\";s:0:\"\";s:28:\"header-social-4-label-toggle\";b:0;s:26:\"header-social-4-color-type\";s:6:\"custom\";s:34:\"header-social-4-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-4\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-4-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-4-bg-space\";s:0:\"\";s:20:\"footer-social-4-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-4-radius\";s:0:\"\";s:21:\"footer-social-4-color\";s:0:\"\";s:23:\"footer-social-4-h-color\";s:0:\"\";s:24:\"footer-social-4-bg-color\";s:0:\"\";s:26:\"footer-social-4-bg-h-color\";s:0:\"\";s:28:\"footer-social-4-label-toggle\";b:0;s:26:\"footer-social-4-color-type\";s:6:\"custom\";s:27:\"footer-social-4-brand-color\";s:0:\"\";s:33:\"footer-social-4-brand-label-color\";s:0:\"\";s:34:\"footer-social-4-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-4\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-4\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-4-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-4-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-4-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-4-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-4-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-4-font-family\";s:7:\"inherit\";s:27:\"header-widget-4-font-weight\";s:7:\"inherit\";s:25:\"header-widget-4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-4-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-4-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-4-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-4-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-4-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-4-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-4-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-4-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-4-font-family\";s:7:\"inherit\";s:27:\"footer-widget-4-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-4-text-transform\";s:0:\"\";s:27:\"footer-widget-4-line-height\";s:0:\"\";s:25:\"footer-widget-4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-4-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-4-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-4-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-4-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-4\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu4-bg-color\";s:0:\"\";s:18:\"header-menu4-color\";s:0:\"\";s:23:\"header-menu4-h-bg-color\";s:0:\"\";s:20:\"header-menu4-h-color\";s:0:\"\";s:23:\"header-menu4-a-bg-color\";s:0:\"\";s:20:\"header-menu4-a-color\";s:0:\"\";s:30:\"header-menu4-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu4-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu4-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu4-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu4-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu4-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu4-menu-hover-animation\";s:0:\"\";s:40:\"header-menu4-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu4-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu4-submenu-item-border\";b:0;s:32:\"header-menu4-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu4-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu4-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu4-submenu-top-offset\";s:0:\"\";s:26:\"header-menu4-submenu-width\";s:0:\"\";s:27:\"header-menu4-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu4-menu-stack-on-mobile\";b:1;s:22:\"header-menu4-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu4-font-weight\";s:7:\"inherit\";s:24:\"header-menu4-font-family\";s:7:\"inherit\";s:24:\"header-menu4-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-4-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button5-text\";s:6:\"Button\";s:26:\"header-button5-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button5-font-family\";s:7:\"inherit\";s:26:\"header-button5-font-weight\";s:7:\"inherit\";s:26:\"header-button5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button5-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button5-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button5-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button5-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button5-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button5-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button5-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button5-border-radius\";s:0:\"\";s:27:\"section-hb-button-5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button5-text\";s:6:\"Button\";s:26:\"footer-button5-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button5-font-family\";s:7:\"inherit\";s:26:\"footer-button5-font-weight\";s:7:\"inherit\";s:29:\"footer-button5-text-transform\";s:0:\"\";s:26:\"footer-button5-line-height\";s:0:\"\";s:24:\"footer-button5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button5-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button5-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button5-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button5-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button5-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button5-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button5-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-5-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-5\";s:22:\"Insert HTML text here.\";s:18:\"header-html-5color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-5link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-5link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-5\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-5\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-5\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-5\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-5\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-5color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-5link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-5link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-5\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-5\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-5\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-5-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-5-bg-space\";s:0:\"\";s:20:\"header-social-5-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-5-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-5-color\";s:0:\"\";s:23:\"header-social-5-h-color\";s:0:\"\";s:24:\"header-social-5-bg-color\";s:0:\"\";s:26:\"header-social-5-bg-h-color\";s:0:\"\";s:28:\"header-social-5-label-toggle\";b:0;s:26:\"header-social-5-color-type\";s:6:\"custom\";s:34:\"header-social-5-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-5\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-5-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-5-bg-space\";s:0:\"\";s:20:\"footer-social-5-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-5-radius\";s:0:\"\";s:21:\"footer-social-5-color\";s:0:\"\";s:23:\"footer-social-5-h-color\";s:0:\"\";s:24:\"footer-social-5-bg-color\";s:0:\"\";s:26:\"footer-social-5-bg-h-color\";s:0:\"\";s:28:\"footer-social-5-label-toggle\";b:0;s:26:\"footer-social-5-color-type\";s:6:\"custom\";s:27:\"footer-social-5-brand-color\";s:0:\"\";s:33:\"footer-social-5-brand-label-color\";s:0:\"\";s:34:\"footer-social-5-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-5\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-5\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-5-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-5-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-5-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-5-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-5-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-5-font-family\";s:7:\"inherit\";s:27:\"header-widget-5-font-weight\";s:7:\"inherit\";s:25:\"header-widget-5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-5-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-5-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-5-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-5-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-5-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-5-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-5-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-5-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-5-font-family\";s:7:\"inherit\";s:27:\"footer-widget-5-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-5-text-transform\";s:0:\"\";s:27:\"footer-widget-5-line-height\";s:0:\"\";s:25:\"footer-widget-5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-5-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-5-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-5-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-5-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-5\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu5-bg-color\";s:0:\"\";s:18:\"header-menu5-color\";s:0:\"\";s:23:\"header-menu5-h-bg-color\";s:0:\"\";s:20:\"header-menu5-h-color\";s:0:\"\";s:23:\"header-menu5-a-bg-color\";s:0:\"\";s:20:\"header-menu5-a-color\";s:0:\"\";s:30:\"header-menu5-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu5-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu5-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu5-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu5-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu5-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu5-menu-hover-animation\";s:0:\"\";s:40:\"header-menu5-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu5-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu5-submenu-item-border\";b:0;s:32:\"header-menu5-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu5-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu5-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu5-submenu-top-offset\";s:0:\"\";s:26:\"header-menu5-submenu-width\";s:0:\"\";s:27:\"header-menu5-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu5-menu-stack-on-mobile\";b:1;s:22:\"header-menu5-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu5-font-weight\";s:7:\"inherit\";s:24:\"header-menu5-font-family\";s:7:\"inherit\";s:24:\"header-menu5-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-5-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button6-text\";s:6:\"Button\";s:26:\"header-button6-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button6-font-family\";s:7:\"inherit\";s:26:\"header-button6-font-weight\";s:7:\"inherit\";s:26:\"header-button6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button6-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button6-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button6-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button6-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button6-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button6-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button6-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button6-border-radius\";s:0:\"\";s:27:\"section-hb-button-6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button6-text\";s:6:\"Button\";s:26:\"footer-button6-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button6-font-family\";s:7:\"inherit\";s:26:\"footer-button6-font-weight\";s:7:\"inherit\";s:29:\"footer-button6-text-transform\";s:0:\"\";s:26:\"footer-button6-line-height\";s:0:\"\";s:24:\"footer-button6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button6-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button6-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button6-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button6-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button6-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button6-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button6-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-6-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-6\";s:22:\"Insert HTML text here.\";s:18:\"header-html-6color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-6link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-6link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-6\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-6\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-6\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-6\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-6\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-6color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-6link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-6link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-6\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-6\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-6\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-6-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-6-bg-space\";s:0:\"\";s:20:\"header-social-6-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-6-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-6-color\";s:0:\"\";s:23:\"header-social-6-h-color\";s:0:\"\";s:24:\"header-social-6-bg-color\";s:0:\"\";s:26:\"header-social-6-bg-h-color\";s:0:\"\";s:28:\"header-social-6-label-toggle\";b:0;s:26:\"header-social-6-color-type\";s:6:\"custom\";s:34:\"header-social-6-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-6\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-6-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-6-bg-space\";s:0:\"\";s:20:\"footer-social-6-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-6-radius\";s:0:\"\";s:21:\"footer-social-6-color\";s:0:\"\";s:23:\"footer-social-6-h-color\";s:0:\"\";s:24:\"footer-social-6-bg-color\";s:0:\"\";s:26:\"footer-social-6-bg-h-color\";s:0:\"\";s:28:\"footer-social-6-label-toggle\";b:0;s:26:\"footer-social-6-color-type\";s:6:\"custom\";s:27:\"footer-social-6-brand-color\";s:0:\"\";s:33:\"footer-social-6-brand-label-color\";s:0:\"\";s:34:\"footer-social-6-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-6\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-6\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-6-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-6-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-6-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-6-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-6-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-6-font-family\";s:7:\"inherit\";s:27:\"header-widget-6-font-weight\";s:7:\"inherit\";s:25:\"header-widget-6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-6-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-6-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-6-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-6-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-6-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-6-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-6-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-6-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-6-font-family\";s:7:\"inherit\";s:27:\"footer-widget-6-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-6-text-transform\";s:0:\"\";s:27:\"footer-widget-6-line-height\";s:0:\"\";s:25:\"footer-widget-6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-6-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-6-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-6-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-6-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-6\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu6-bg-color\";s:0:\"\";s:18:\"header-menu6-color\";s:0:\"\";s:23:\"header-menu6-h-bg-color\";s:0:\"\";s:20:\"header-menu6-h-color\";s:0:\"\";s:23:\"header-menu6-a-bg-color\";s:0:\"\";s:20:\"header-menu6-a-color\";s:0:\"\";s:30:\"header-menu6-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu6-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu6-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu6-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu6-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu6-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu6-menu-hover-animation\";s:0:\"\";s:40:\"header-menu6-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu6-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu6-submenu-item-border\";b:0;s:32:\"header-menu6-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu6-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu6-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu6-submenu-top-offset\";s:0:\"\";s:26:\"header-menu6-submenu-width\";s:0:\"\";s:27:\"header-menu6-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu6-menu-stack-on-mobile\";b:1;s:22:\"header-menu6-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu6-font-weight\";s:7:\"inherit\";s:24:\"header-menu6-font-family\";s:7:\"inherit\";s:24:\"header-menu6-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-6-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button7-text\";s:6:\"Button\";s:26:\"header-button7-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button7-font-family\";s:7:\"inherit\";s:26:\"header-button7-font-weight\";s:7:\"inherit\";s:26:\"header-button7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button7-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button7-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button7-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button7-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button7-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button7-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button7-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button7-border-radius\";s:0:\"\";s:27:\"section-hb-button-7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button7-text\";s:6:\"Button\";s:26:\"footer-button7-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button7-font-family\";s:7:\"inherit\";s:26:\"footer-button7-font-weight\";s:7:\"inherit\";s:29:\"footer-button7-text-transform\";s:0:\"\";s:26:\"footer-button7-line-height\";s:0:\"\";s:24:\"footer-button7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button7-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button7-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button7-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button7-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button7-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button7-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button7-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-7-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-7\";s:22:\"Insert HTML text here.\";s:18:\"header-html-7color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-7link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-7link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-7\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-7\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-7\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-7\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-7\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-7color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-7link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-7link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-7\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-7\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-7\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-7-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-7-bg-space\";s:0:\"\";s:20:\"header-social-7-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-7-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-7-color\";s:0:\"\";s:23:\"header-social-7-h-color\";s:0:\"\";s:24:\"header-social-7-bg-color\";s:0:\"\";s:26:\"header-social-7-bg-h-color\";s:0:\"\";s:28:\"header-social-7-label-toggle\";b:0;s:26:\"header-social-7-color-type\";s:6:\"custom\";s:34:\"header-social-7-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-7\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-7-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-7-bg-space\";s:0:\"\";s:20:\"footer-social-7-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-7-radius\";s:0:\"\";s:21:\"footer-social-7-color\";s:0:\"\";s:23:\"footer-social-7-h-color\";s:0:\"\";s:24:\"footer-social-7-bg-color\";s:0:\"\";s:26:\"footer-social-7-bg-h-color\";s:0:\"\";s:28:\"footer-social-7-label-toggle\";b:0;s:26:\"footer-social-7-color-type\";s:6:\"custom\";s:27:\"footer-social-7-brand-color\";s:0:\"\";s:33:\"footer-social-7-brand-label-color\";s:0:\"\";s:34:\"footer-social-7-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-7\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-7\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-7-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-7-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-7-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-7-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-7-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-7-font-family\";s:7:\"inherit\";s:27:\"header-widget-7-font-weight\";s:7:\"inherit\";s:25:\"header-widget-7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-7-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-7-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-7-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-7-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-7-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-7-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-7-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-7-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-7-font-family\";s:7:\"inherit\";s:27:\"footer-widget-7-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-7-text-transform\";s:0:\"\";s:27:\"footer-widget-7-line-height\";s:0:\"\";s:25:\"footer-widget-7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-7-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-7-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-7-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-7-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-7\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu7-bg-color\";s:0:\"\";s:18:\"header-menu7-color\";s:0:\"\";s:23:\"header-menu7-h-bg-color\";s:0:\"\";s:20:\"header-menu7-h-color\";s:0:\"\";s:23:\"header-menu7-a-bg-color\";s:0:\"\";s:20:\"header-menu7-a-color\";s:0:\"\";s:30:\"header-menu7-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu7-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu7-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu7-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu7-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu7-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu7-menu-hover-animation\";s:0:\"\";s:40:\"header-menu7-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu7-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu7-submenu-item-border\";b:0;s:32:\"header-menu7-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu7-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu7-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu7-submenu-top-offset\";s:0:\"\";s:26:\"header-menu7-submenu-width\";s:0:\"\";s:27:\"header-menu7-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu7-menu-stack-on-mobile\";b:1;s:22:\"header-menu7-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu7-font-weight\";s:7:\"inherit\";s:24:\"header-menu7-font-family\";s:7:\"inherit\";s:24:\"header-menu7-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-7-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button8-text\";s:6:\"Button\";s:26:\"header-button8-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button8-font-family\";s:7:\"inherit\";s:26:\"header-button8-font-weight\";s:7:\"inherit\";s:26:\"header-button8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button8-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button8-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button8-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button8-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button8-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button8-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button8-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button8-border-radius\";s:0:\"\";s:27:\"section-hb-button-8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button8-text\";s:6:\"Button\";s:26:\"footer-button8-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button8-font-family\";s:7:\"inherit\";s:26:\"footer-button8-font-weight\";s:7:\"inherit\";s:29:\"footer-button8-text-transform\";s:0:\"\";s:26:\"footer-button8-line-height\";s:0:\"\";s:24:\"footer-button8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button8-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button8-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button8-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button8-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button8-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button8-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button8-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-8-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-8\";s:22:\"Insert HTML text here.\";s:18:\"header-html-8color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-8link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-8link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-8\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-8\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-8\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-8\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-8\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-8color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-8link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-8link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-8\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-8\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-8\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-8-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-8-bg-space\";s:0:\"\";s:20:\"header-social-8-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-8-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-8-color\";s:0:\"\";s:23:\"header-social-8-h-color\";s:0:\"\";s:24:\"header-social-8-bg-color\";s:0:\"\";s:26:\"header-social-8-bg-h-color\";s:0:\"\";s:28:\"header-social-8-label-toggle\";b:0;s:26:\"header-social-8-color-type\";s:6:\"custom\";s:34:\"header-social-8-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-8\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-8-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-8-bg-space\";s:0:\"\";s:20:\"footer-social-8-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-8-radius\";s:0:\"\";s:21:\"footer-social-8-color\";s:0:\"\";s:23:\"footer-social-8-h-color\";s:0:\"\";s:24:\"footer-social-8-bg-color\";s:0:\"\";s:26:\"footer-social-8-bg-h-color\";s:0:\"\";s:28:\"footer-social-8-label-toggle\";b:0;s:26:\"footer-social-8-color-type\";s:6:\"custom\";s:27:\"footer-social-8-brand-color\";s:0:\"\";s:33:\"footer-social-8-brand-label-color\";s:0:\"\";s:34:\"footer-social-8-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-8\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-8\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-8-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-8-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-8-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-8-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-8-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-8-font-family\";s:7:\"inherit\";s:27:\"header-widget-8-font-weight\";s:7:\"inherit\";s:25:\"header-widget-8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-8-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-8-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-8-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-8-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-8-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-8-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-8-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-8-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-8-font-family\";s:7:\"inherit\";s:27:\"footer-widget-8-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-8-text-transform\";s:0:\"\";s:27:\"footer-widget-8-line-height\";s:0:\"\";s:25:\"footer-widget-8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-8-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-8-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-8-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-8-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-8\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu8-bg-color\";s:0:\"\";s:18:\"header-menu8-color\";s:0:\"\";s:23:\"header-menu8-h-bg-color\";s:0:\"\";s:20:\"header-menu8-h-color\";s:0:\"\";s:23:\"header-menu8-a-bg-color\";s:0:\"\";s:20:\"header-menu8-a-color\";s:0:\"\";s:30:\"header-menu8-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu8-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu8-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu8-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu8-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu8-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu8-menu-hover-animation\";s:0:\"\";s:40:\"header-menu8-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu8-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu8-submenu-item-border\";b:0;s:32:\"header-menu8-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu8-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu8-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu8-submenu-top-offset\";s:0:\"\";s:26:\"header-menu8-submenu-width\";s:0:\"\";s:27:\"header-menu8-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu8-menu-stack-on-mobile\";b:1;s:22:\"header-menu8-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu8-font-weight\";s:7:\"inherit\";s:24:\"header-menu8-font-family\";s:7:\"inherit\";s:24:\"header-menu8-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-8-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"header-button9-text\";s:6:\"Button\";s:26:\"header-button9-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"header-button9-font-family\";s:7:\"inherit\";s:26:\"header-button9-font-weight\";s:7:\"inherit\";s:26:\"header-button9-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"header-button9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-button9-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-button9-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button9-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-button9-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button9-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"header-button9-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-button9-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-button9-border-radius\";s:0:\"\";s:27:\"section-hb-button-9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-hb-button-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"sticky-header-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"footer-button9-text\";s:6:\"Button\";s:26:\"footer-button9-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:26:\"footer-button9-font-family\";s:7:\"inherit\";s:26:\"footer-button9-font-weight\";s:7:\"inherit\";s:29:\"footer-button9-text-transform\";s:0:\"\";s:26:\"footer-button9-line-height\";s:0:\"\";s:24:\"footer-button9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button9-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-button9-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button9-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-button9-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-button9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button9-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:27:\"footer-button9-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"footer-button9-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-button-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:27:\"section-fb-button-9-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"section-fb-button-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"header-html-9\";s:22:\"Insert HTML text here.\";s:18:\"header-html-9color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-html-9link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-html-9link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-hb-html-9\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"font-weight-section-hb-html-9\";s:7:\"inherit\";s:29:\"font-family-section-hb-html-9\";s:7:\"inherit\";s:29:\"font-extras-section-hb-html-9\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-hb-html-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"footer-html-9\";s:22:\"Insert HTML text here.\";s:18:\"footer-html-9color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-html-9link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-html-9link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"font-size-section-fb-html-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:23:\"footer-html-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:29:\"font-weight-section-fb-html-9\";s:7:\"inherit\";s:29:\"font-family-section-fb-html-9\";s:7:\"inherit\";s:29:\"font-extras-section-fb-html-9\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:24:\"section-fb-html-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-9-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-social-9-bg-space\";s:0:\"\";s:20:\"header-social-9-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-social-9-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-9-color\";s:0:\"\";s:23:\"header-social-9-h-color\";s:0:\"\";s:24:\"header-social-9-bg-color\";s:0:\"\";s:26:\"header-social-9-bg-h-color\";s:0:\"\";s:28:\"header-social-9-label-toggle\";b:0;s:26:\"header-social-9-color-type\";s:6:\"custom\";s:34:\"header-social-9-brand-hover-toggle\";b:0;s:35:\"font-size-section-hb-social-icons-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-social-icons-9\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:32:\"section-hb-social-icons-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-9-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-social-9-bg-space\";s:0:\"\";s:20:\"footer-social-9-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-social-9-radius\";s:0:\"\";s:21:\"footer-social-9-color\";s:0:\"\";s:23:\"footer-social-9-h-color\";s:0:\"\";s:24:\"footer-social-9-bg-color\";s:0:\"\";s:26:\"footer-social-9-bg-h-color\";s:0:\"\";s:28:\"footer-social-9-label-toggle\";b:0;s:26:\"footer-social-9-color-type\";s:6:\"custom\";s:27:\"footer-social-9-brand-color\";s:0:\"\";s:33:\"footer-social-9-brand-label-color\";s:0:\"\";s:34:\"footer-social-9-brand-hover-toggle\";b:0;s:35:\"font-size-section-fb-social-icons-9\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"footer-social-icons-9\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:25:\"footer-social-9-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:32:\"section-fb-social-icons-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-9-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"header-widget-9-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-widget-9-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-9-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-9-font-family\";s:7:\"inherit\";s:27:\"header-widget-9-font-weight\";s:7:\"inherit\";s:25:\"header-widget-9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-widget-9-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:35:\"header-widget-9-content-font-family\";s:7:\"inherit\";s:35:\"header-widget-9-content-font-weight\";s:7:\"inherit\";s:33:\"header-widget-9-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"header-widget-9-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:38:\"sidebar-widgets-header-widget-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-widget-9-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:21:\"footer-widget-9-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-widget-9-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-9-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-9-font-family\";s:7:\"inherit\";s:27:\"footer-widget-9-font-weight\";s:7:\"inherit\";s:30:\"footer-widget-9-text-transform\";s:0:\"\";s:27:\"footer-widget-9-line-height\";s:0:\"\";s:25:\"footer-widget-9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:35:\"footer-widget-9-content-font-family\";s:7:\"inherit\";s:35:\"footer-widget-9-content-font-weight\";s:7:\"inherit\";s:35:\"footer-widget-9-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"footer-widget-9-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"footer-widget-alignment-9\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"sidebar-widgets-footer-widget-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"header-menu9-bg-color\";s:0:\"\";s:18:\"header-menu9-color\";s:0:\"\";s:23:\"header-menu9-h-bg-color\";s:0:\"\";s:20:\"header-menu9-h-color\";s:0:\"\";s:23:\"header-menu9-a-bg-color\";s:0:\"\";s:20:\"header-menu9-a-color\";s:0:\"\";s:30:\"header-menu9-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:29:\"header-menu9-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu9-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu9-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu9-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"header-menu9-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"header-menu9-menu-hover-animation\";s:0:\"\";s:40:\"header-menu9-submenu-container-animation\";s:0:\"\";s:24:\"section-hb-menu-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu9-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu9-submenu-item-border\";b:0;s:32:\"header-menu9-submenu-item-b-size\";s:1:\"1\";s:33:\"header-menu9-submenu-item-b-color\";s:7:\"#eaeaea\";s:41:\"header-menu9-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"header-menu9-submenu-top-offset\";s:0:\"\";s:26:\"header-menu9-submenu-width\";s:0:\"\";s:27:\"header-menu9-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:33:\"header-menu9-menu-stack-on-mobile\";b:1;s:22:\"header-menu9-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-menu9-font-weight\";s:7:\"inherit\";s:24:\"header-menu9-font-family\";s:7:\"inherit\";s:24:\"header-menu9-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:27:\"section-hb-divider-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-divider-9-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"header-button10-text\";s:6:\"Button\";s:27:\"header-button10-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:27:\"header-button10-font-family\";s:7:\"inherit\";s:27:\"header-button10-font-weight\";s:7:\"inherit\";s:27:\"header-button10-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:25:\"header-button10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-button10-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-button10-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button10-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-button10-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"header-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"header-button10-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:28:\"header-button10-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"header-button10-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"header-button10-border-radius\";s:0:\"\";s:28:\"section-hb-button-10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-hb-button-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"sticky-header-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"footer-button10-text\";s:6:\"Button\";s:27:\"footer-button10-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:27:\"footer-button10-font-family\";s:7:\"inherit\";s:27:\"footer-button10-font-weight\";s:7:\"inherit\";s:30:\"footer-button10-text-transform\";s:0:\"\";s:27:\"footer-button10-line-height\";s:0:\"\";s:25:\"footer-button10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button10-text-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-button10-back-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button10-text-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-button10-back-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-button10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"footer-button10-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:28:\"footer-button10-border-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"footer-button10-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:40;s:5:\"right\";i:40;s:6:\"bottom\";i:40;s:4:\"left\";i:40;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-button-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:28:\"section-fb-button-10-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";i:15;s:5:\"right\";i:30;s:6:\"bottom\";i:15;s:4:\"left\";i:30;}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"section-fb-button-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:14:\"header-html-10\";s:22:\"Insert HTML text here.\";s:19:\"header-html-10color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"header-html-10link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"header-html-10link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"font-size-section-hb-html-10\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:30:\"font-weight-section-hb-html-10\";s:7:\"inherit\";s:30:\"font-family-section-hb-html-10\";s:7:\"inherit\";s:30:\"font-extras-section-hb-html-10\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:25:\"section-hb-html-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:14:\"footer-html-10\";s:22:\"Insert HTML text here.\";s:19:\"footer-html-10color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"footer-html-10link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"footer-html-10link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"font-size-section-fb-html-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"footer-html-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:30:\"font-weight-section-fb-html-10\";s:7:\"inherit\";s:30:\"font-family-section-fb-html-10\";s:7:\"inherit\";s:30:\"font-extras-section-fb-html-10\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:25:\"section-fb-html-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-10-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"header-social-10-bg-space\";s:0:\"\";s:21:\"header-social-10-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:30:\"header-social-10-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-10-color\";s:0:\"\";s:24:\"header-social-10-h-color\";s:0:\"\";s:25:\"header-social-10-bg-color\";s:0:\"\";s:27:\"header-social-10-bg-h-color\";s:0:\"\";s:29:\"header-social-10-label-toggle\";b:0;s:27:\"header-social-10-color-type\";s:6:\"custom\";s:35:\"header-social-10-brand-hover-toggle\";b:0;s:36:\"font-size-section-hb-social-icons-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-social-icons-10\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:33:\"section-hb-social-icons-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"footer-social-10-space\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"footer-social-10-bg-space\";s:0:\"\";s:21:\"footer-social-10-size\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:23:\"footer-social-10-radius\";s:0:\"\";s:22:\"footer-social-10-color\";s:0:\"\";s:24:\"footer-social-10-h-color\";s:0:\"\";s:25:\"footer-social-10-bg-color\";s:0:\"\";s:27:\"footer-social-10-bg-h-color\";s:0:\"\";s:29:\"footer-social-10-label-toggle\";b:0;s:27:\"footer-social-10-color-type\";s:6:\"custom\";s:28:\"footer-social-10-brand-color\";s:0:\"\";s:34:\"footer-social-10-brand-label-color\";s:0:\"\";s:35:\"footer-social-10-brand-hover-toggle\";b:0;s:36:\"font-size-section-fb-social-icons-10\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"footer-social-icons-10\";a:1:{s:5:\"items\";a:3:{i:0;a:8:{s:2:\"id\";s:8:\"facebook\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#557dbc\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:8:\"facebook\";s:5:\"label\";s:8:\"Facebook\";}i:1;a:8:{s:2:\"id\";s:7:\"twitter\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#7acdee\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:7:\"twitter\";s:5:\"label\";s:7:\"Twitter\";}i:2;a:8:{s:2:\"id\";s:9:\"instagram\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:3:\"url\";s:0:\"\";s:5:\"color\";s:7:\"#8a3ab9\";s:10:\"background\";s:11:\"transparent\";s:4:\"icon\";s:9:\"instagram\";s:5:\"label\";s:9:\"Instagram\";}}}s:26:\"footer-social-10-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:33:\"section-fb-social-icons-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-widget-10-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"header-widget-10-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"header-widget-10-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"header-widget-10-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"header-widget-10-font-family\";s:7:\"inherit\";s:28:\"header-widget-10-font-weight\";s:7:\"inherit\";s:26:\"header-widget-10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"header-widget-10-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:36:\"header-widget-10-content-font-family\";s:7:\"inherit\";s:36:\"header-widget-10-content-font-weight\";s:7:\"inherit\";s:34:\"header-widget-10-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"header-widget-10-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:39:\"sidebar-widgets-header-widget-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"footer-widget-10-title-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"footer-widget-10-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:27:\"footer-widget-10-link-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:29:\"footer-widget-10-link-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:28:\"footer-widget-10-font-family\";s:7:\"inherit\";s:28:\"footer-widget-10-font-weight\";s:7:\"inherit\";s:31:\"footer-widget-10-text-transform\";s:0:\"\";s:28:\"footer-widget-10-line-height\";s:0:\"\";s:26:\"footer-widget-10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"footer-widget-10-content-font-family\";s:7:\"inherit\";s:36:\"footer-widget-10-content-font-weight\";s:7:\"inherit\";s:36:\"footer-widget-10-content-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:34:\"footer-widget-10-content-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"footer-widget-alignment-10\";a:3:{s:7:\"desktop\";s:4:\"left\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:39:\"sidebar-widgets-footer-widget-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"header-menu10-bg-color\";s:0:\"\";s:19:\"header-menu10-color\";s:0:\"\";s:24:\"header-menu10-h-bg-color\";s:0:\"\";s:21:\"header-menu10-h-color\";s:0:\"\";s:24:\"header-menu10-a-bg-color\";s:0:\"\";s:21:\"header-menu10-a-color\";s:0:\"\";s:31:\"header-menu10-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:30:\"header-menu10-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-3)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-menu10-h-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"header-menu10-h-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"header-menu10-a-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:32:\"header-menu10-a-color-responsive\";a:3:{s:7:\"desktop\";s:25:\"var(--ast-global-color-1)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"header-menu10-menu-hover-animation\";s:0:\"\";s:41:\"header-menu10-submenu-container-animation\";s:0:\"\";s:25:\"section-hb-menu-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"header-menu10-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:33:\"header-menu10-submenu-item-border\";b:0;s:33:\"header-menu10-submenu-item-b-size\";s:1:\"1\";s:34:\"header-menu10-submenu-item-b-color\";s:7:\"#eaeaea\";s:42:\"header-menu10-submenu-border-radius-fields\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:32:\"header-menu10-submenu-top-offset\";s:0:\"\";s:27:\"header-menu10-submenu-width\";s:0:\"\";s:28:\"header-menu10-submenu-border\";a:4:{s:3:\"top\";i:2;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:5:\"right\";i:0;}s:34:\"header-menu10-menu-stack-on-mobile\";b:1;s:23:\"header-menu10-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"header-menu10-font-weight\";s:7:\"inherit\";s:25:\"header-menu10-font-family\";s:7:\"inherit\";s:25:\"header-menu10-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:28:\"section-hb-divider-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:28:\"section-fb-divider-10-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"sticky-header-on-devices\";s:7:\"desktop\";s:19:\"sticky-header-style\";s:4:\"none\";s:20:\"footer-desktop-items\";a:3:{s:5:\"above\";a:5:{s:7:\"above_1\";a:0:{}s:7:\"above_2\";a:0:{}s:7:\"above_3\";a:0:{}s:7:\"above_4\";a:0:{}s:7:\"above_5\";a:0:{}}s:7:\"primary\";a:5:{s:9:\"primary_1\";a:0:{}s:9:\"primary_2\";a:0:{}s:9:\"primary_3\";a:0:{}s:9:\"primary_4\";a:0:{}s:9:\"primary_5\";a:0:{}}s:5:\"below\";a:5:{s:7:\"below_1\";a:1:{i:0;s:9:\"copyright\";}s:7:\"below_2\";a:0:{}s:7:\"below_3\";a:0:{}s:7:\"below_4\";a:0:{}s:7:\"below_5\";a:0:{}}}s:17:\"hba-footer-height\";i:60;s:17:\"hba-footer-column\";s:1:\"2\";s:17:\"hba-footer-layout\";a:3:{s:7:\"desktop\";s:7:\"2-equal\";s:6:\"tablet\";s:7:\"2-equal\";s:6:\"mobile\";s:4:\"full\";}s:28:\"hba-footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:7:\"#eeeeee\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:28:\"hbb-footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:25:\"var(--ast-global-color-5)\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:5:\"color\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:27:\"hb-footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:7:\"#f9f9f9\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";s:15:\"background-type\";s:5:\"color\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:27:\"hbb-footer-top-border-color\";s:25:\"var(--ast-global-color-6)\";s:20:\"hbb-footer-separator\";i:1;s:36:\"section-header-builder-layout-margin\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:17:\"hbb-footer-height\";i:30;s:17:\"hbb-footer-column\";s:1:\"1\";s:17:\"hbb-footer-layout\";a:3:{s:7:\"desktop\";s:4:\"full\";s:6:\"tablet\";s:4:\"full\";s:6:\"mobile\";s:4:\"full\";}s:24:\"hb-primary-footer-height\";i:30;s:23:\"hba-footer-layout-width\";s:7:\"content\";s:22:\"hb-footer-layout-width\";s:7:\"content\";s:23:\"hbb-footer-layout-width\";s:7:\"content\";s:29:\"hba-footer-vertical-alignment\";s:10:\"flex-start\";s:28:\"hb-footer-vertical-alignment\";s:10:\"flex-start\";s:29:\"hbb-footer-vertical-alignment\";s:6:\"center\";s:24:\"footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:16:\"hb-footer-column\";s:1:\"3\";s:19:\"hb-footer-separator\";i:1;s:29:\"hb-footer-bottom-border-color\";s:7:\"#e6e6e6\";s:16:\"hb-footer-layout\";a:3:{s:7:\"desktop\";s:7:\"3-equal\";s:6:\"tablet\";s:7:\"3-equal\";s:6:\"mobile\";s:4:\"full\";}s:18:\"hb-footer-main-sep\";i:1;s:24:\"hb-footer-main-sep-color\";s:65:\"var( --ast-global-color-subtle-background, --ast-global-color-7 )\";s:24:\"live-search-result-count\";i:5;s:23:\"footer-copyright-editor\";s:59:\"{{Droits d\'auteur}} [copyright] [current_year] [site_title]\";s:22:\"footer-copyright-color\";s:25:\"var(--ast-global-color-3)\";s:36:\"line-height-section-footer-copyright\";i:2;s:26:\"footer-copyright-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:34:\"font-size-section-footer-copyright\";a:6:{s:7:\"desktop\";i:16;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"font-weight-section-footer-copyright\";s:7:\"inherit\";s:36:\"font-family-section-footer-copyright\";s:7:\"inherit\";s:36:\"font-extras-section-footer-copyright\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:21:\"footer-menu-alignment\";a:3:{s:7:\"desktop\";s:6:\"center\";s:6:\"tablet\";s:6:\"center\";s:6:\"mobile\";s:6:\"center\";}s:36:\"section-below-footer-builder-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"25\";s:5:\"right\";s:2:\"40\";s:6:\"bottom\";s:2:\"25\";s:4:\"left\";s:2:\"40\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"32\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"32\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"20\";s:5:\"right\";s:2:\"24\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:2:\"24\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"header-search-icon-space\";a:3:{s:7:\"desktop\";i:18;s:6:\"tablet\";i:18;s:6:\"mobile\";i:18;}s:24:\"header-search-icon-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:19:\"header-search-width\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:11:\"live-search\";b:0;s:22:\"live-search-post-types\";a:2:{s:4:\"post\";i:1;s:4:\"page\";i:1;}s:37:\"transparent-header-social-icons-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:39:\"transparent-header-social-icons-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:40:\"transparent-header-social-icons-bg-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:42:\"transparent-header-social-icons-bg-h-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"transparent-header-html-text-color\";s:0:\"\";s:34:\"transparent-header-html-link-color\";s:0:\"\";s:36:\"transparent-header-html-link-h-color\";s:0:\"\";s:37:\"transparent-header-widget-title-color\";s:0:\"\";s:39:\"transparent-header-widget-content-color\";s:0:\"\";s:36:\"transparent-header-widget-link-color\";s:0:\"\";s:38:\"transparent-header-widget-link-h-color\";s:0:\"\";s:36:\"transparent-header-button-text-color\";s:0:\"\";s:38:\"transparent-header-button-text-h-color\";s:0:\"\";s:34:\"transparent-header-button-bg-color\";s:0:\"\";s:36:\"transparent-header-button-bg-h-color\";s:0:\"\";s:17:\"off-canvas-layout\";s:10:\"side-panel\";s:16:\"off-canvas-slide\";s:5:\"right\";s:33:\"header-builder-menu-toggle-target\";s:4:\"icon\";s:34:\"header-offcanvas-content-alignment\";s:10:\"flex-start\";s:21:\"off-canvas-background\";a:10:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:22:\"off-canvas-close-color\";s:7:\"#3a3a3a\";s:18:\"mobile-header-type\";s:8:\"dropdown\";s:20:\"off-canvas-move-body\";b:1;s:24:\"off-canvas-inner-spacing\";s:0:\"\";s:18:\"footer-menu-layout\";a:3:{s:7:\"desktop\";s:10:\"horizontal\";s:6:\"tablet\";s:8:\"vertical\";s:6:\"mobile\";s:8:\"vertical\";}s:29:\"footer-menu-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:15:\"overlay-opacity\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:10:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15